/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartTypeFormat;
import com.klg.jclass.chart.PercentageOfAvailableWidth;
import java.io.Serializable;

public class JCCandleChartFormat
implements JCChartTypeFormat,
PercentageOfAvailableWidth,
Serializable {
    public static final int RISING_CANDLE_INDEX = 1;
    public static final int FALLING_CANDLE_INDEX = 2;
    public static final int CANDLE_OUTLINE_INDEX = 3;
    protected boolean complex = false;
    protected ChartDataView parent = null;
    protected int candleWidthMode = 1;
    protected int percentageWidth = 40;

    public JCCandleChartFormat() {
    }

    public JCCandleChartFormat(ChartDataView chartDataView) {
        this.parent = chartDataView;
    }

    public void setParent(ChartDataView chartDataView) {
        this.parent = chartDataView;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public void setComplex(boolean bl) {
        if (this.complex == bl) {
            return;
        }
        this.complex = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public JCChartStyle getHiloStyle(int n2) {
        JCChartStyle jCChartStyle = null;
        if (this.parent != null) {
            jCChartStyle = this.parent.getChartStyle(n2 * this.parent.getNumSeriesPerData());
        }
        return jCChartStyle;
    }

    public void setHiloStyle(int n2, JCChartStyle jCChartStyle) {
        if (this.parent != null) {
            this.parent.setChartStyle(n2 * this.parent.getNumSeriesPerData(), jCChartStyle);
        }
    }

    public JCChartStyle getRisingCandleStyle(int n2) {
        JCChartStyle jCChartStyle = null;
        if (this.parent != null) {
            jCChartStyle = this.parent.getChartStyle(n2 * this.parent.getNumSeriesPerData() + 1);
        }
        return jCChartStyle;
    }

    public void setRisingCandleStyle(int n2, JCChartStyle jCChartStyle) {
        if (this.parent != null) {
            this.parent.setChartStyle(n2 * this.parent.getNumSeriesPerData() + 1, jCChartStyle);
        }
    }

    public JCChartStyle getFallingCandleStyle(int n2) {
        JCChartStyle jCChartStyle = null;
        if (this.parent != null) {
            jCChartStyle = this.parent.getChartStyle(n2 * this.parent.getNumSeriesPerData() + 2);
        }
        return jCChartStyle;
    }

    public void setFallingCandleStyle(int n2, JCChartStyle jCChartStyle) {
        if (this.parent != null) {
            this.parent.setChartStyle(n2 * this.parent.getNumSeriesPerData() + 2, jCChartStyle);
        }
    }

    public JCChartStyle getCandleOutlineStyle(int n2) {
        JCChartStyle jCChartStyle = null;
        if (this.parent != null) {
            jCChartStyle = this.parent.getChartStyle(n2 * this.parent.getNumSeriesPerData() + 3);
        }
        return jCChartStyle;
    }

    public void setCandleOutlineStyle(int n2, JCChartStyle jCChartStyle) {
        if (this.parent != null) {
            this.parent.setChartStyle(n2 * this.parent.getNumSeriesPerData() + 3, jCChartStyle);
        }
    }

    public int getCandleWidthMode() {
        return this.candleWidthMode;
    }

    public void setCandleWidthMode(int n2) {
        if (n2 < 1 || n2 > 2) {
            throw new IllegalArgumentException("CandleWidth mode must be one of WIDTH_MODE_PIXEL or WIDTH_MODE_PERCENTAGE");
        }
        this.candleWidthMode = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public int getPercentageWidth() {
        return this.percentageWidth;
    }

    public void setPercentageWidth(int n2) {
        if (n2 < 0 || n2 > 100) {
            throw new IllegalArgumentException("PercentageWidth must be between 0 and 100");
        }
        if (this.percentageWidth == n2) {
            return;
        }
        this.percentageWidth = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public ChartDataView getParent() {
        return this.parent;
    }
}

