/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartTypeFormat;
import com.klg.jclass.chart.OutlineConfigurable;
import java.io.Serializable;

public class JCAreaChartFormat
implements JCChartTypeFormat,
OutlineConfigurable,
Serializable {
    public static final int ABSENT_VALUE = 0;
    public static final int INTERPOLATE_VALUE = 1;
    public static final int PREVIOUS_VALUE = 2;
    protected boolean is100Percent = false;
    protected int outlineStyle = 0;
    protected int holeInterpretation = 0;
    protected boolean connectedAcrossOrigin = false;
    protected Changeable parent = null;

    public JCAreaChartFormat() {
    }

    public JCAreaChartFormat(Changeable changeable) {
        this.parent = changeable;
    }

    public void setParent(ChartDataView chartDataView) {
        this.parent = chartDataView;
    }

    public ChartDataView getParent() {
        if (this.parent instanceof ChartDataView) {
            return (ChartDataView)this.parent;
        }
        return null;
    }

    public boolean is100Percent() {
        return this.is100Percent;
    }

    public void set100Percent(boolean bl) {
        if (this.is100Percent == bl) {
            return;
        }
        this.is100Percent = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public int getOutlineStyle() {
        return this.outlineStyle;
    }

    public void setOutlineStyle(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("OutlineStyle must be one of OUTLINE_STYLE, SERIES_LINE_STYLE, or CHART_AREA_FOREGROUND.");
        }
        this.outlineStyle = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public int getHoleInterpretation() {
        return this.holeInterpretation;
    }

    public void setHoleInterpretation(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("HoleInterpretation must be one of ABSENT_VALUE, INTERPOLATE_VALUE, or PREVIOUS_VALUE.");
        }
        this.holeInterpretation = n2;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public boolean isConnectedAcrossOrigin() {
        return this.connectedAcrossOrigin;
    }

    public void setConnectedAcrossOrigin(boolean bl) {
        if (this.connectedAcrossOrigin == bl) {
            return;
        }
        this.connectedAcrossOrigin = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    protected double[] getCalculatedYValues(ChartDataViewSeries chartDataViewSeries, JCAxis jCAxis, JCAxis jCAxis2, double d2) {
        int n2;
        if (chartDataViewSeries == null || jCAxis == null || jCAxis2 == null) {
            return null;
        }
        double[] dArray = chartDataViewSeries.getX();
        double[] dArray2 = chartDataViewSeries.getNormalizedYValues(jCAxis2.isLogarithmic(), true);
        if (dArray == null || dArray2 == null) {
            return null;
        }
        double d3 = jCAxis2.origin.value;
        boolean bl = false;
        int n3 = -1;
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            if (n2 >= dArray.length || jCAxis.skipValue(dArray[n2], d2)) continue;
            if (dArray2[n2] == Double.MAX_VALUE) {
                switch (this.holeInterpretation) {
                    case 0: {
                        dArray2[n2] = jCAxis2.origin.value;
                        break;
                    }
                    case 1: {
                        bl = true;
                        if (n2 != 0) break;
                        dArray2[n2] = jCAxis2.origin.value;
                        break;
                    }
                    case 2: {
                        dArray2[n2] = d3;
                    }
                }
            } else if (this.holeInterpretation == 1) {
                if (bl) {
                    bl = false;
                    this.interpolate(dArray, dArray2, jCAxis, n3, n2, d2);
                }
                n3 = n2;
            }
            d3 = dArray2[n2];
        }
        if (bl) {
            n2 = dArray2.length - 1;
            dArray2[n2] = jCAxis2.origin.value;
            if (n3 < n2 - 1) {
                this.interpolate(dArray, dArray2, jCAxis, n3, n2, d2);
            }
        }
        return dArray2;
    }

    private void interpolate(double[] dArray, double[] dArray2, JCAxis jCAxis, int n2, int n3, double d2) {
        if (n2 < 0) {
            n2 = 0;
        }
        double d3 = dArray[n2];
        double d4 = dArray2[n2];
        double d5 = dArray[n3];
        double d6 = dArray2[n3];
        double d7 = d5 - d3;
        double d8 = d6 - d4;
        for (int i2 = n2 + 1; i2 < n3; ++i2) {
            double d9 = dArray[i2];
            if (i2 >= dArray.length || jCAxis.skipValue(d9, d2)) continue;
            dArray2[i2] = d4;
            if (d7 == 0.0) continue;
            int n4 = i2;
            dArray2[n4] = dArray2[n4] + d8 * ((d9 - d3) / d7);
        }
    }
}

