/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.DerivedDouble;
import com.klg.jclass.chart.DerivedInt;
import com.klg.jclass.chart.JCAxis;
import java.awt.Color;
import java.io.Serializable;

public class JCAnno
implements Serializable {
    public static final int DEFAULT_LABELS = 10;
    public static final int DEFAULT_TICKS = 20;
    public static final int USER_DEFINED = 30;
    public static final int DEFAULT_INNER_EXTENT = 2;
    public static final int DEFAULT_OUTER_EXTENT = 2;
    public static final int DEFAULT_LABEL_EXTENT = 3;
    protected JCAxis parent = null;
    protected String name = null;
    protected DerivedDouble startValue = new DerivedDouble(0.0, true);
    protected DerivedDouble stopValue = new DerivedDouble(100.0, true);
    protected DerivedDouble incrementValue = new DerivedDouble(10.0, true);
    protected int defPrecision = 0;
    protected DerivedInt precision = new DerivedInt(this.defPrecision, true);
    protected boolean drawLabels = true;
    protected boolean drawTicks = true;
    protected int defLabelExtent = 3;
    protected DerivedInt labelExtent = new DerivedInt(this.defLabelExtent, true);
    protected int defInnerExtent = 2;
    protected DerivedInt innerExtent = new DerivedInt(this.defInnerExtent, true);
    protected int defOuterExtent = 2;
    protected DerivedInt outerExtent = new DerivedInt(this.defOuterExtent, true);
    protected Color tickColor = null;
    protected Color labelColor = null;
    protected int type = 30;

    public JCAnno() {
    }

    public JCAnno(int n2, JCAxis jCAxis, Color color) {
        this.type = n2;
        this.parent = jCAxis;
        if (jCAxis != null) {
            this.startValue.value = jCAxis.min.value;
            this.stopValue.value = jCAxis.max.value;
            this.incrementValue.value = n2 == 10 ? jCAxis.numSpacing.value : jCAxis.tickSpacing.value;
            Color color2 = this.tickColor = color != null ? color : jCAxis.getForeground();
            if (!jCAxis.getPrecisionIsDefault()) {
                this.precision = new DerivedInt(jCAxis.getPrecision(), false);
            }
        }
        this.drawLabels = n2 == 10;
        this.drawTicks = n2 != 10;
    }

    public JCAnno(int n2, JCAxis jCAxis, double d2, double d3, double d4, int n3, boolean bl, boolean bl2, int n4, int n5, int n6, Color color, Color color2) {
        this.type = n2;
        this.parent = jCAxis;
        this.startValue = new DerivedDouble(d2, false);
        this.stopValue = new DerivedDouble(d3, false);
        this.incrementValue = new DerivedDouble(d4, false);
        this.precision = new DerivedInt(n3, false);
        this.drawLabels = bl;
        this.drawTicks = bl2;
        this.labelExtent = new DerivedInt(n4, false);
        this.innerExtent = new DerivedInt(n5, false);
        this.outerExtent = new DerivedInt(n6, false);
        this.tickColor = color;
        this.labelColor = color2;
    }

    public JCAxis getParent() {
        return this.parent;
    }

    public void setParent(JCAxis jCAxis) {
        this.parent = jCAxis;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean getDrawLabels() {
        return this.drawLabels;
    }

    public boolean getDrawLabelsIsDefault() {
        return this.type == 10 ? this.drawLabels : !this.drawLabels;
    }

    public boolean getDrawTicksIsDefault() {
        return this.type == 10 ? !this.drawTicks : this.drawTicks;
    }

    public boolean getDrawTicks() {
        return this.drawTicks;
    }

    public double getIncrementValue() {
        return this.incrementValue.value;
    }

    public boolean getIncrementIsDefault() {
        return this.incrementValue.isDefault;
    }

    public int getInnerExtent() {
        return this.innerExtent.value;
    }

    public boolean getInnerExtentIsDefault() {
        return this.innerExtent.isDefault;
    }

    public int getDefaultInnerExtent() {
        return this.defInnerExtent;
    }

    public int getLabelExtent() {
        return this.labelExtent.value;
    }

    public boolean getLabelExtentIsDefault() {
        return this.labelExtent.isDefault;
    }

    public int getDefaultLabelExtent() {
        return this.defLabelExtent;
    }

    public int getOuterExtent() {
        return this.outerExtent.value;
    }

    public boolean getOuterExtentIsDefault() {
        return this.outerExtent.isDefault;
    }

    public int getDefaultOuterExtent() {
        return this.defOuterExtent;
    }

    public int getPrecision() {
        return this.precision.value;
    }

    public boolean getPrecisionIsDefault() {
        return this.precision.isDefault;
    }

    public int getDefaultPrecision() {
        return this.defPrecision;
    }

    public double getStartValue() {
        return this.startValue.value;
    }

    public boolean getStartValueIsDefault() {
        return this.startValue.isDefault;
    }

    public double getStopValue() {
        return this.stopValue.value;
    }

    public boolean getStopValueIsDefault() {
        return this.stopValue.isDefault;
    }

    public Color getTickColor() {
        Color color = Color.black;
        if (this.tickColor != null) {
            color = this.tickColor;
        } else if (this.parent != null && this.parent.getForeground() != null) {
            color = this.parent.getForeground();
        }
        return color;
    }

    public Color getLabelColor() {
        Color color = Color.black;
        if (this.labelColor != null) {
            color = this.labelColor;
        } else if (this.parent != null && this.parent.getForeground() != null) {
            color = this.parent.getForeground();
        }
        return color;
    }

    public void setDrawLabels(boolean bl) {
        this.drawLabels = bl;
        this.setChanged(true, 2);
    }

    public void setDrawTicks(boolean bl) {
        this.drawTicks = bl;
        this.setChanged(true, 2);
    }

    public void setIncrementValue(double d2) {
        this.incrementValue.value = d2;
        this.incrementValue.isDefault = false;
        if (this.parent != null) {
            if (this.type == 10) {
                this.parent.numSpacing.value = d2;
                this.parent.numSpacing.isDefault = false;
            } else if (this.type == 20) {
                this.parent.tickSpacing.value = d2;
                this.parent.tickSpacing.isDefault = false;
            }
        }
    }

    public void setIncrementIsDefault(boolean bl) {
        this.incrementValue.isDefault = bl;
        if (this.parent != null) {
            if (this.type == 10) {
                this.parent.numSpacing.isDefault = bl;
            } else if (this.type == 20) {
                this.parent.tickSpacing.isDefault = bl;
            }
        }
        this.setChanged(true, 2);
    }

    public void setInnerExtent(int n2) {
        this.innerExtent.value = n2;
        this.innerExtent.isDefault = false;
        this.setChanged(true, 2);
    }

    public void setInnerExtentIsDefault(boolean bl) {
        this.innerExtent.isDefault = bl;
        if (bl) {
            this.innerExtent.value = this.defInnerExtent;
        }
        this.setChanged(true, 2);
    }

    public void setDefaultInnerExtent(int n2) {
        this.defInnerExtent = n2;
    }

    public void setLabelExtent(int n2) {
        this.labelExtent.value = n2;
        this.labelExtent.isDefault = false;
        this.setChanged(true, 2);
    }

    public void setLabelExtentIsDefault(boolean bl) {
        this.labelExtent.isDefault = bl;
        if (bl) {
            this.labelExtent.value = this.defLabelExtent;
        }
        this.setChanged(true, 2);
    }

    public void setDefaultLabelExtent(int n2) {
        this.defLabelExtent = n2;
    }

    public void setOuterExtent(int n2) {
        this.outerExtent.value = n2;
        this.outerExtent.isDefault = false;
        this.setChanged(true, 2);
    }

    public void setOuterExtentIsDefault(boolean bl) {
        this.outerExtent.isDefault = bl;
        if (bl) {
            this.outerExtent.value = this.defOuterExtent;
        }
        this.setChanged(true, 2);
    }

    public void setDefaultOuterExtent(int n2) {
        this.defOuterExtent = n2;
    }

    public void setPrecision(int n2) {
        this.precision.value = n2;
        this.precision.isDefault = false;
        if (this.type == 10 && this.parent != null) {
            this.parent.precision.value = n2;
            this.parent.precision.isDefault = false;
        }
        this.setChanged(true, 2);
    }

    public void setPrecisionIsDefault(boolean bl) {
        this.precision.isDefault = bl;
        if (bl) {
            this.precision.value = this.defPrecision;
        }
        this.setChanged(true, 2);
    }

    public void setDefaultPrecision(int n2) {
        this.defPrecision = n2;
    }

    public void setStartValue(double d2) {
        this.startValue.value = d2;
        this.startValue.isDefault = false;
    }

    public void setStartValueIsDefault(boolean bl) {
        this.startValue.isDefault = bl;
    }

    public void setStopValue(double d2) {
        this.stopValue.value = d2;
        this.stopValue.isDefault = false;
    }

    public void setStopValueIsDefault(boolean bl) {
        this.stopValue.isDefault = bl;
    }

    public void setTickColor(Color color) {
        this.tickColor = color;
        this.setChanged(true, 2);
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
        this.setChanged(true, 2);
    }

    public void setType(int n2) {
        this.type = n2;
        this.drawLabels = n2 == 10;
        this.drawTicks = n2 != 10;
    }

    public int getType() {
        return this.type;
    }

    protected void setChanged(boolean bl, int n2) {
        if (this.parent != null) {
            this.parent.setChanged(bl, n2);
        }
    }

    public String toString() {
        String string = super.toString();
        string = string + ", name=" + this.name + ", startValue=" + this.startValue.value + ", stopValue=" + this.stopValue.value + ", incrementValue=" + this.incrementValue.value + ", precision=" + this.precision.value + ", innerExtent=" + this.innerExtent.value + ", outerExtent=" + this.outerExtent.value + ", labelExtent=" + this.labelExtent.value + ", drawTicks=" + this.drawTicks + ", drawLabels=" + this.drawLabels + ", color=" + this.tickColor;
        return string;
    }
}

