/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AreaChartDraw;
import com.klg.jclass.chart.AreaPolygon;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ImageMapShape;
import com.klg.jclass.chart.JCAreaDataIndex;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.Mapper;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;

public class ImageMapShapeArea
extends ImageMapShape {
    protected AreaPolygon areaPolygon = null;
    protected double[] xvals = null;
    protected double[] yvals = null;
    protected JCAxis xaxis = null;
    protected JCAxis yaxis = null;
    protected double holeValue;
    protected ChartDataView chartDataView = null;
    protected ChartDataViewSeries chartDataViewSeries = null;
    protected AreaChartDraw drawable = null;

    public ImageMapShapeArea(Mapper mapper, Point point, boolean bl, int n2, AreaChartDraw areaChartDraw) {
        super(mapper, point, bl, n2);
        this.drawable = areaChartDraw;
    }

    public ImageMapShapeArea(Mapper mapper, Point point, boolean bl, int n2, int n3, AreaChartDraw areaChartDraw) {
        super(mapper, point, bl, n2, n3);
        this.drawable = areaChartDraw;
    }

    public ImageMapShapeArea(Mapper mapper, Point point, boolean bl, int n2, int n3, int n4, AreaChartDraw areaChartDraw) {
        this(mapper, point, bl, n2, n4, areaChartDraw);
        this.mapMethod = n3;
    }

    public void setAreaChartInfo(AreaPolygon areaPolygon, ChartDataView chartDataView, ChartDataViewSeries chartDataViewSeries, double[] dArray, double[] dArray2, double d2, JCAxis jCAxis, JCAxis jCAxis2) {
        this.areaPolygon = areaPolygon;
        this.chartDataView = chartDataView;
        this.chartDataViewSeries = chartDataViewSeries;
        this.xvals = dArray;
        this.yvals = dArray2;
        this.holeValue = d2;
        this.xaxis = jCAxis;
        this.yaxis = jCAxis2;
    }

    public void fillPolygon(Shape shape) {
        if (this.mapper != null && !this.fillStyleNull) {
            int n2 = this.xaxis.toPixel(this.xaxis.getMin());
            int n3 = this.xaxis.toPixel(this.xaxis.getMax());
            int n4 = this.yaxis.toPixel(this.yaxis.getMin());
            int n5 = this.yaxis.toPixel(this.yaxis.getMax());
            Point point = new Point(Math.min(n2, n3), Math.min(n4, n5));
            Point point2 = new Point(Math.max(n2, n3), Math.max(n4, n5));
            this.processValidDataRegion(point, point2);
        }
    }

    public void fillOutlinePolygon(Shape shape) {
        this.fillPolygon(shape);
    }

    public void fillOutlinePartialPolygon(Shape shape) {
        this.fillPolygon(shape);
    }

    protected void processValidDataRegion(Point point, Point point2) {
        if (this.areaPolygon.poly.npoints == 2) {
            int n2;
            int n3;
            int n4;
            Polygon[] polygonArray = new Polygon[1];
            int n5 = this.areaPolygon.poly.xpoints[0];
            int n6 = this.areaPolygon.poly.ypoints[0];
            int n7 = this.areaPolygon.poly.xpoints[1];
            int n8 = this.areaPolygon.poly.ypoints[1];
            if (this.inverted) {
                if (n8 < point.y || n8 > point2.y) {
                    return;
                }
                n4 = Math.min(point.x, point2.x);
                n3 = Math.max(point.x, point2.x);
                if (Math.max(n5, n7) < n4 || Math.min(n5, n7) > n3) {
                    return;
                }
                n2 = JCNumberUtil.clamp(n5, n4, n3);
                n7 = JCNumberUtil.clamp(n7, n4, n3);
            } else {
                if (n7 < point.x || n7 > point2.x) {
                    return;
                }
                n4 = Math.min(point.y, point2.y);
                n3 = Math.max(point.y, point2.y);
                if (Math.max(n6, n8) < n4 || Math.min(n6, n8) > n3) {
                    return;
                }
                n2 = JCNumberUtil.clamp(n6, n4, n3);
                n8 = JCNumberUtil.clamp(n8, n4, n3);
            }
            polygonArray[0] = this.createTrapezoid(n7, n8, n7, n8, this.inverted, n2);
            n4 = this.drawable.getPointIndex(this.areaPolygon.startPoint);
            JCAreaDataIndex jCAreaDataIndex = new JCAreaDataIndex(this.chartDataView, this.chartDataViewSeries, this.areaPolygon.series, n4, this.areaPolygon.hole);
            this.translateAndAddToHash(polygonArray, jCAreaDataIndex);
            return;
        }
        int n9 = -1;
        int n10 = this.areaPolygon.isLeading ? 0 : 1;
        int n11 = n10 + 1;
        for (int i2 = this.areaPolygon.startPoint; i2 <= this.areaPolygon.endPoint; ++i2) {
            if (this.xaxis.skipValue(this.xvals[i2], this.holeValue)) {
                ++n11;
                continue;
            }
            Polygon[] polygonArray = this.getAreaBoundingPolygons(n9, n10, n11, point, point2, this.chartType, this.inverted);
            if (polygonArray != null) {
                int n12 = this.drawable.getPointIndex(i2);
                JCAreaDataIndex jCAreaDataIndex = new JCAreaDataIndex(this.chartDataView, this.chartDataViewSeries, this.areaPolygon.series, n12, this.areaPolygon.hole);
                this.translateAndAddToHash(polygonArray, jCAreaDataIndex);
            }
            n9 = n10;
            n10 = n11++;
        }
    }

    protected void translateAndAddToHash(Polygon[] polygonArray, JCDataIndex jCDataIndex) {
        for (Polygon polygon : polygonArray) {
            if (polygon == null) continue;
            Polygon polygon2 = this.translatePolygonToChartCoords(polygon);
            this.mapper.setDataIndex(jCDataIndex);
            this.mapper.addToHash(polygon2);
            this.mapper.addShape(polygon2);
        }
    }

    protected Polygon translatePolygonToChartCoords(Polygon polygon) {
        if (polygon == null) {
            return null;
        }
        Polygon polygon2 = new Polygon();
        for (int i2 = 0; i2 < polygon.npoints; ++i2) {
            polygon2.addPoint(polygon.xpoints[i2] + this.offset.x, polygon.ypoints[i2] + this.offset.y);
        }
        return polygon2;
    }

    protected Polygon[] getAreaBoundingPolygons(int n2, int n3, int n4, Point point, Point point2, int n5, boolean bl) {
        Polygon[] polygonArray;
        int n6 = bl ? this.areaPolygon.poly.xpoints[0] : this.areaPolygon.poly.ypoints[0];
        int n7 = this.areaPolygon.getMaxTopIndex();
        if (this.mapMethod == 1) {
            Polygon polygon;
            int n8;
            int n9;
            polygonArray = n4 >= 0 && n4 <= n7 ? new Polygon[2] : new Polygon[1];
            int n10 = this.areaPolygon.poly.xpoints[n3];
            int n11 = this.areaPolygon.poly.ypoints[n3];
            if (n2 >= 0) {
                n9 = this.areaPolygon.poly.xpoints[n2];
                n8 = this.areaPolygon.poly.ypoints[n2];
                n9 += (int)((double)(n10 - n9) / 2.0);
                n8 += (int)((double)(n11 - n8) / 2.0);
                polygon = this.createTrapezoid(n9, n8, n10, n11, bl, n6);
                polygonArray[0] = polygon = this.clipTrapezoid(polygon, point, point2, bl);
            }
            if (n4 >= 0 && n4 <= n7) {
                n9 = this.areaPolygon.poly.xpoints[n4];
                n8 = this.areaPolygon.poly.ypoints[n4];
                n9 -= (int)((double)(n9 - n10) / 2.0);
                n8 -= (int)((double)(n8 - n11) / 2.0);
                polygon = this.createTrapezoid(n10, n11, n9, n8, bl, n6);
                polygonArray[1] = polygon = this.clipTrapezoid(polygon, point, point2, bl);
            }
        } else {
            polygonArray = new Polygon[1];
            if (n4 >= 0 && n4 <= n7) {
                Polygon polygon = this.createTrapezoid(this.areaPolygon.poly.xpoints[n3], this.areaPolygon.poly.ypoints[n3], this.areaPolygon.poly.xpoints[n4], this.areaPolygon.poly.ypoints[n4], bl, n6);
                polygonArray[0] = polygon = this.clipTrapezoid(polygon, point, point2, bl);
            }
        }
        return polygonArray;
    }

    protected Polygon createTrapezoid(int n2, int n3, int n4, int n5, boolean bl, int n6) {
        Polygon polygon = new Polygon();
        if (!bl) {
            polygon.addPoint(n2, n6);
            polygon.addPoint(n2, n3);
            polygon.addPoint(n4, n5);
            polygon.addPoint(n4, n6);
        } else {
            polygon.addPoint(n6, n3);
            polygon.addPoint(n2, n3);
            polygon.addPoint(n4, n5);
            polygon.addPoint(n6, n5);
        }
        return polygon;
    }
}

