/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCSymbolStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PickShape;
import com.klg.jclass.chart.Picker;
import com.klg.jclass.chart.PlotPoint;
import com.klg.jclass.chart.ProcessShape;
import com.klg.jclass.chart.RenderShape;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.io.Serializable;

public class FastPlotChartDraw
extends ChartDraw {
    public static final int TOP_EDGE = 8;
    public static final int BOTTOM_EDGE = 4;
    public static final int RIGHT_EDGE = 2;
    public static final int LEFT_EDGE = 1;
    protected MinMax xlim = new MinMax();
    protected MinMax ylim = new MinMax();
    Point prev = null;
    Point next = null;
    Point last = null;
    Rectangle r = null;

    public void recalc() {
        this.recalc(-1, -1, -1);
    }

    public void recalc(int n2, int n3) {
        this.recalc(n2, n3, -1);
    }

    public void recalc(int n2, int n3, int n4) {
        super.recalc();
        boolean bl = false;
        if (n2 >= 0 && n3 >= 0 && n3 >= n2) {
            bl = true;
        }
        if (n4 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        if (this.xaxis == null || this.yaxis == null) {
            return;
        }
        this.inverted = this.xaxis.i_vertical;
        this.holeValue = this.dataObject.getHoleValue();
        if (bl) {
            int n5 = 0;
            int n6 = this.seriesList.size();
            for (int i2 = n5; i2 < n6; ++i2) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(i2);
                if (!chartDataViewSeries.isVisible() || chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) continue;
                double[] dArray = chartDataViewSeries.getX();
                double[] dArray2 = chartDataViewSeries.getY();
                for (int i3 = n2; i3 <= n3; ++i3) {
                    this.xlim.setMinMax(dArray[i3], this.holeValue, this.xaxis.isLogarithmic());
                    this.ylim.setMinMax(dArray2[i3], this.holeValue, this.yaxis.isLogarithmic());
                }
            }
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        } else if (n4 == -1 || n4 == 0) {
            if (this.dataObject.getXLimits() == null) {
                return;
            }
            if (this.dataObject.getYLimits() == null) {
                return;
            }
            this.xlim = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
            this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    public void draw(Graphics graphics) {
        this.draw(graphics, -1, -1);
    }

    public void draw(Graphics graphics, int n2, int n3) {
        Serializable serializable;
        if (this.seriesList == null) {
            return;
        }
        DefineShape defineShape = null;
        Graphics graphics2 = null;
        if (graphics != null) {
            serializable = graphics.getClipBounds();
            if (serializable.width == 0 || serializable.height == 0) {
                return;
            }
            graphics2 = graphics.create();
            if (graphics2 instanceof DefineShape) {
                defineShape = (DefineShape)((Object)graphics);
            }
        }
        serializable = new RenderShape(graphics, graphics2, this.usingDoublePixels);
        this.processPlotData((ProcessShape)((Object)serializable), defineShape, n2, n3);
        if (graphics2 != null) {
            graphics2.dispose();
        }
    }

    protected void processPlotData(ProcessShape processShape, DefineShape defineShape, int n2, int n3) {
        if (processShape == null) {
            return;
        }
        if (this.seriesList == null || this.xaxis == null || this.yaxis == null) {
            return;
        }
        boolean bl = processShape.getShapeType() == 1;
        boolean bl2 = false;
        if (n2 >= 0 && n3 >= 0 && n3 >= n2) {
            bl2 = true;
        }
        MinMax minMax = new MinMax(this.xaxis.getMin(), this.xaxis.getMax());
        MinMax minMax2 = new MinMax(this.yaxis.getMin(), this.yaxis.getMax());
        boolean bl3 = this.xaxis.isLogarithmic();
        boolean bl4 = this.yaxis.isLogarithmic();
        int n4 = 0;
        int n5 = this.seriesList.size();
        for (int i2 = n4; i2 < n5; ++i2) {
            JCChartStyle jCChartStyle;
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(i2);
            if (!chartDataViewSeries.isVisible() || chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) continue;
            if (!bl2) {
                n2 = chartDataViewSeries.getFirstPoint();
                n3 = chartDataViewSeries.getLastPoint();
            } else {
                int n6 = chartDataViewSeries.getLastPoint();
                if (n2 < n6) {
                    n2 = n6;
                }
            }
            double[] dArray = chartDataViewSeries.getX();
            double[] dArray2 = chartDataViewSeries.getY();
            double d2 = 0.0;
            double d3 = this.holeValue;
            boolean bl5 = false;
            if (bl2 && n2 > 0) {
                d2 = dArray[n2 - 1];
                d3 = dArray2[n2 - 1];
            }
            if ((jCChartStyle = chartDataViewSeries.getStyle()) == null) continue;
            JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
            processShape.setLineStyle(jCLineStyle);
            boolean bl6 = false;
            JCSymbolStyle jCSymbolStyle = jCChartStyle.getSymbolStyle();
            boolean bl7 = !bl;
            JCLineStyle jCLineStyle2 = null;
            JCChartStyle jCChartStyle2 = chartDataViewSeries.getHoleStyle();
            if (jCChartStyle2 != null && !bl2 && (jCLineStyle2 = jCChartStyle2.getLineStyle()) != null && jCLineStyle2.getPattern() != 0 && jCLineStyle2.getWidth() > 0) {
                bl7 = false;
            }
            boolean bl8 = false;
            if (!(bl || jCLineStyle.getPattern() != 0 && jCLineStyle.getWidth() > 0)) {
                bl8 = true;
            }
            boolean bl9 = !bl && jCSymbolStyle.getShape() == 0;
            PlotPoint plotPoint = new PlotPoint();
            plotPoint.valid = false;
            PlotPoint[] plotPointArray = new PlotPoint[]{new PlotPoint(), new PlotPoint()};
            boolean bl10 = false;
            boolean bl11 = false;
            int n7 = -1;
            double d4 = 0.0;
            double d5 = this.holeValue;
            Line2D.Double double_ = new Line2D.Double();
            for (int i3 = n2; i3 <= n3; ++i3) {
                double d6 = dArray[i3];
                if (bl3 && d6 <= 0.0) {
                    d6 = this.holeValue;
                }
                double d7 = dArray2[i3];
                if (bl4 && d7 <= 0.0) {
                    d7 = this.holeValue;
                }
                if (!(d6 != this.holeValue && d7 != this.holeValue || bl7 || i3 >= n3)) {
                    bl10 = true;
                    continue;
                }
                if (this.xaxis.isValueExcluded(d6)) continue;
                plotPointArray[0].valid = false;
                plotPointArray[1].valid = false;
                bl5 = this.plotClip(d2, d3, d6, d7, minMax, minMax2, plotPointArray, bl5, this.inverted);
                for (int i4 = 0; i4 < plotPointArray.length; ++i4) {
                    boolean bl12;
                    boolean bl13 = bl10 ? !bl7 : (bl12 = !bl8);
                    if (bl12 && (plotPointArray[i4].valid || bl && !bl11 && i3 == n3)) {
                        if (bl10) {
                            if (!bl6) {
                                processShape.setLineStyle(jCLineStyle2);
                                bl6 = true;
                            }
                        } else if (bl6) {
                            processShape.setLineStyle(jCLineStyle);
                            bl6 = false;
                        }
                        if (plotPoint.valid && this.chartType == 0) {
                            this.processLine(processShape, i2, n7, i3, chartDataViewSeries, plotPoint, plotPointArray[i4], double_, this.getLineColor(d4, d5, d6, d7, jCLineStyle));
                            bl11 = true;
                        }
                    }
                    if (i4 != 0 && !plotPointArray[i4].valid) continue;
                    if (plotPoint.valid && plotPoint.drawPoint && !bl9) {
                        this.processSymbol(processShape, defineShape, i2, n7, chartDataViewSeries, jCSymbolStyle, this.getSymbolColor(d4, d5), plotPoint);
                    }
                    plotPoint.px = plotPointArray[i4].px;
                    plotPoint.py = plotPointArray[i4].py;
                    plotPoint.drawPoint = plotPointArray[i4].drawPoint;
                    plotPoint.valid = plotPointArray[i4].valid;
                    n7 = i3;
                    d4 = d6;
                    d5 = d7;
                }
                bl10 = false;
                if (!bl5) {
                    plotPoint.valid = false;
                }
                d2 = d6;
                d3 = d7;
            }
            if (!plotPoint.valid || !plotPoint.drawPoint || bl9) continue;
            this.processSymbol(processShape, defineShape, i2, n7, chartDataViewSeries, jCSymbolStyle, this.getSymbolColor(d2, d3), plotPoint);
        }
    }

    protected void processLine(ProcessShape processShape, int n2, int n3, int n4, ChartDataViewSeries chartDataViewSeries, PlotPoint plotPoint, PlotPoint plotPoint2, Line2D.Double double_, Color color) {
        if (this.xaxis.hasTimeExclusions() && (this.invalidPixelCoord(this.xaxis, plotPoint.px) || this.invalidPixelCoord(this.xaxis, plotPoint2.px))) {
            return;
        }
        double_.setLine(plotPoint.px, plotPoint.py, plotPoint2.px, plotPoint2.py);
        processShape.tagDataLine(n3, n4, chartDataViewSeries, n2);
        processShape.drawLine(double_, color);
    }

    protected boolean invalidPixelCoord(JCAxis jCAxis, double d2) {
        if (jCAxis.usingDoublePixels) {
            return d2 == Double.MAX_VALUE;
        }
        return d2 == 2.147483647E9;
    }

    protected void processSymbol(ProcessShape processShape, DefineShape defineShape, int n2, int n3, ChartDataViewSeries chartDataViewSeries, JCSymbolStyle jCSymbolStyle, Color color, PlotPoint plotPoint) {
        JCDataIndex jCDataIndex = null;
        if (defineShape != null) {
            jCDataIndex = new JCDataIndex(n3, chartDataViewSeries, n2);
            defineShape.markShape(jCDataIndex);
        }
        if (jCDataIndex != null) {
            processShape.tagData(jCDataIndex);
        } else {
            processShape.tagData(n3, chartDataViewSeries, n2);
        }
        processShape.setSymbolStyle(jCSymbolStyle);
        processShape.drawSymbol(plotPoint.px, plotPoint.py, color);
        if (defineShape != null) {
            defineShape.unmarkShape();
        }
    }

    protected JCDataIndex pickInternal(Point point, int n2, boolean bl) {
        if (this.seriesList == null) {
            return null;
        }
        Rectangle rectangle = this.chartArea.getDrawingArea();
        int n3 = point.x - rectangle.x;
        int n4 = point.y - rectangle.y;
        Picker picker = new Picker(n3, n4, n2);
        PickShape pickShape = new PickShape(picker, bl, this.inverted);
        this.processPlotData(pickShape, null, -1, -1);
        JCDataIndex jCDataIndex = null;
        if (picker.series >= 0 && picker.point >= 0) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(picker.series);
            jCDataIndex = new JCDataIndex(picker.point, chartDataViewSeries, picker.series);
            jCDataIndex.distance = picker.distance;
        }
        return jCDataIndex;
    }

    public JCDataIndex pick(Point point, int n2) {
        return this.pickInternal(point, n2, false);
    }

    public JCDataIndex pickSeries(Point point, int n2) {
        if (n2 != 0) {
            throw new UnsupportedOperationException("Only PICK_FOCUS_XY is supported for pickSeries");
        }
        return this.pickInternal(point, n2, this.chartType == 0);
    }

    public Point unpick(int n2, int n3) {
        if (this.seriesList == null) {
            return null;
        }
        if (n3 < 0 || n3 >= this.seriesList.size()) {
            return null;
        }
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
        double d2 = chartDataViewSeries.getY(n2);
        double d3 = chartDataViewSeries.getX(n2);
        if (d2 != this.holeValue && d3 != this.holeValue) {
            int n4;
            int n5;
            if (this.inverted) {
                n5 = this.yaxis.toPixel(d2, this.drawFront);
                n4 = this.xaxis.toPixel(d3, this.drawFront);
            } else {
                n5 = this.xaxis.toPixel(d3, this.drawFront);
                n4 = this.yaxis.toPixel(d2, this.drawFront);
            }
            return new Point(n5, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        double d2;
        double d3;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject || jCDataIndex.series == null) {
            return;
        }
        this.r = this.chartArea.getDrawingArea();
        this.last = null;
        this.next = null;
        this.prev = null;
        double d4 = this.dataObject.getHoleValue();
        ChartDataViewSeries chartDataViewSeries = jCDataIndex.series;
        JCChartStyle jCChartStyle = chartDataViewSeries.getHoleStyle();
        int n2 = jCDataIndex.point - 1;
        while (this.prev == null && n2 >= chartDataViewSeries.getFirstPoint()) {
            d3 = chartDataViewSeries.getX(n2);
            d2 = chartDataViewSeries.getY(n2);
            if (d3 != Double.MAX_VALUE && d2 != Double.MAX_VALUE && d3 != d4 && d2 != d4 && JCChartUtil.locateXY(d3, d2, this.xaxis.getMin(), this.xaxis.getMax(), this.yaxis.getMin(), this.yaxis.getMax()) == 0) {
                this.prev = this.inverted ? new Point(this.yaxis.toPixel(d2) + this.r.x, this.xaxis.toPixel(d3) + this.r.y) : new Point(this.xaxis.toPixel(d3) + this.r.x, this.yaxis.toPixel(d2) + this.r.y);
            }
            n2 = jCChartStyle != null ? n2 - 1 : -1;
        }
        n2 = jCDataIndex.point + 1;
        while (this.next == null && n2 <= chartDataViewSeries.getLastPoint()) {
            d3 = chartDataViewSeries.getX(n2);
            d2 = chartDataViewSeries.getY(n2);
            if (d3 != Double.MAX_VALUE && d2 != Double.MAX_VALUE && d3 != d4 && d2 != d4 && JCChartUtil.locateXY(d3, d2, this.xaxis.getMin(), this.xaxis.getMax(), this.yaxis.getMin(), this.yaxis.getMax()) == 0) {
                this.next = this.inverted ? new Point(this.yaxis.toPixel(d2) + this.r.x, this.xaxis.toPixel(d3) + this.r.y) : new Point(this.xaxis.toPixel(d3) + this.r.x, this.yaxis.toPixel(d2) + this.r.y);
            }
            n2 = jCChartStyle != null ? n2 + 1 : Integer.MAX_VALUE;
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        JCAxis jCAxis = jCDataIndex.dataView.getXAxis();
        boolean bl = jCAxis.i_vertical;
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        if (this.last == null) {
            int n4 = jCAxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront);
            this.last = bl ? new Point(n2, n4 + this.r.y) : new Point(n4 + this.r.x, n3);
        } else if (bl) {
            this.last.x = n2;
        } else {
            this.last.y = n3;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
    }

    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        return jCDataIndex.dataView.getXAxis().i_vertical ? n2 - this.r.x : n3 - this.r.y;
    }

    protected boolean plotClip(double d2, double d3, double d4, double d5, MinMax minMax, MinMax minMax2, PlotPoint[] plotPointArray, boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4;
        double d6 = minMax.min;
        double d7 = minMax.max;
        double d8 = minMax2.min;
        double d9 = minMax2.max;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = false;
        boolean bl6 = true;
        if (!(bl || d3 != this.holeValue && d2 != this.holeValue)) {
            n4 = 1;
            bl6 = false;
            bl5 = true;
        } else {
            n4 = JCChartUtil.locateXY(d2, d3, d6, d7, d8, d9);
        }
        if (d5 == this.holeValue || d4 == this.holeValue) {
            n3 = 1;
            bl6 = false;
            bl5 = true;
        } else {
            n3 = JCChartUtil.locateXY(d4, d5, d6, d7, d8, d9);
        }
        int n5 = n4;
        int n6 = n3;
        int n7 = 0;
        while (bl6 && (n5 | n6) != 0 && (n5 & n6) == 0) {
            double d10;
            double d11;
            int n8 = n2 = n5 != 0 ? n5 : n6;
            if ((n2 & 1) != 0) {
                d11 = d6;
                d10 = d3 + (d5 - d3) * (d6 - d2) / (d4 - d2);
                n2 = JCChartUtil.locateY(d10, d8, d9);
            } else if ((n2 & 2) != 0) {
                d10 = d3 + (d5 - d3) * (d7 - d2) / (d4 - d2);
                d11 = d7;
                n2 = JCChartUtil.locateY(d10, d8, d9);
            } else if ((n2 & 4) != 0) {
                d11 = d2 + (d4 - d2) * (d8 - d3) / (d5 - d3);
                d10 = d8;
                n2 = JCChartUtil.locateX(d11, d6, d7);
            } else {
                d11 = d2 + (d4 - d2) * (d9 - d3) / (d5 - d3);
                d10 = d9;
                n2 = JCChartUtil.locateX(d11, d6, d7);
            }
            if (n5 != 0) {
                n5 = n2;
                d2 = d11;
                d3 = d10;
                bl3 = false;
                if (n7 > 4) {
                    n5 = 0;
                }
                n7 = n5 == 0 ? 0 : n7 + 1;
                continue;
            }
            n6 = n2;
            d4 = d11;
            d5 = d10;
            bl4 = false;
            if (n7 > 4) {
                n6 = 0;
            }
            n7 = n6 == 0 ? 0 : n7 + 1;
        }
        int n9 = n2 = !bl && bl5 && (n4 == 0 || n3 == 0) ? 1 : 0;
        if ((n5 | n6) == 0 || n2 != 0) {
            if (bl) {
                if (!bl5) {
                    this.addClippedPoint(plotPointArray, 0, d4, d5, this.xaxis, this.yaxis, bl2, bl4);
                    bl = n3 == 0;
                } else {
                    bl = false;
                }
            } else {
                if (n2 != 0 && n3 == 0) {
                    d2 = d4;
                    d3 = d5;
                    bl3 = bl4;
                }
                this.addClippedPoint(plotPointArray, 0, d2, d3, this.xaxis, this.yaxis, bl2, bl3);
                if (n2 == 0) {
                    this.addClippedPoint(plotPointArray, 1, d4, d5, this.xaxis, this.yaxis, bl2, bl4);
                }
                bl = n3 == 0;
            }
        } else {
            bl = false;
        }
        return bl;
    }
}

