/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotPoint;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class FastHiloChartDraw
extends ChartDraw {
    public static final int NUM_SERIES_PER_DATA = 2;
    public static final int HI_SERIES_INDEX = 0;
    public static final int LO_SERIES_INDEX = 1;
    protected MinMax xlim = new MinMax();
    protected MinMax ylim = new MinMax();
    Point start = null;
    Point end = null;
    Rectangle r = null;

    public void recalc() {
        this.recalc(-1);
    }

    public void recalc(int n2) {
        super.recalc();
        if (n2 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.xaxis = this.dataObject.getXAxis();
        if (this.xaxis == null) {
            return;
        }
        this.yaxis = this.dataObject.getYAxis();
        this.holeValue = this.dataObject.getHoleValue();
        this.inverted = this.xaxis.i_vertical;
        if (n2 == -1 || n2 == 0) {
            MinMax minMax = this.dataObject.getXLimits();
            if (minMax == null) {
                return;
            }
            MinMax minMax2 = this.dataObject.getYLimits();
            if (minMax2 == null) {
                return;
            }
            this.xlim = new MinMax(minMax.min, minMax.max);
            this.ylim = new MinMax(minMax2.min, minMax2.max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    public void draw(Graphics graphics) {
        block14: {
            Graphics2D graphics2D = (Graphics2D)graphics;
            try {
                if (this.seriesList == null || this.xaxis == null || this.yaxis == null) {
                    return;
                }
                Rectangle rectangle = graphics2D.getClipBounds();
                if (rectangle.width == 0 || rectangle.height == 0) {
                    return;
                }
                DefineShape defineShape = null;
                if (graphics2D instanceof DefineShape) {
                    defineShape = (DefineShape)((Object)graphics2D);
                }
                int n2 = this.seriesList.size() / 2;
                int n3 = 0;
                int n4 = n2;
                boolean bl = this.xaxis.isLogarithmic();
                boolean bl2 = this.yaxis.isLogarithmic();
                for (int i2 = n3; i2 < n4; ++i2) {
                    JCLineStyle jCLineStyle;
                    JCChartStyle jCChartStyle;
                    Serializable serializable;
                    boolean bl3 = true;
                    boolean bl4 = true;
                    int n5 = Integer.MAX_VALUE;
                    int n6 = Integer.MAX_VALUE;
                    int n7 = 2 * i2;
                    int n8 = 0;
                    while (n8 < 2) {
                        serializable = (ChartDataViewSeries)this.seriesList.get(n7);
                        if (!((ChartDataViewSeries)serializable).isVisible()) {
                            bl3 = false;
                            break;
                        }
                        if (((ChartDataViewSeries)serializable).maxXIndex() == 0 || ((ChartDataViewSeries)serializable).maxYIndex() == 0) {
                            bl4 = false;
                            break;
                        }
                        n5 = Math.min(n5, ((ChartDataViewSeries)serializable).getFirstPoint());
                        n6 = Math.min(n6, ((ChartDataViewSeries)serializable).getLastPoint());
                        ++n8;
                        ++n7;
                    }
                    if (!bl4 || !bl3 || (jCChartStyle = ((ChartDataViewSeries)this.seriesList.get(2 * i2)).getStyle()) == null || !(jCLineStyle = jCChartStyle.getLineStyle()).updateGraphics(graphics2D)) continue;
                    serializable = new Line2D.Double();
                    PlotPoint[] plotPointArray = new PlotPoint[]{new PlotPoint(), new PlotPoint()};
                    for (int i3 = n5; i3 <= n6; ++i3) {
                        ChartDataViewSeries chartDataViewSeries;
                        double d2;
                        int n9 = 2 * i2;
                        if (this.xaxis.isValueExcluded(d2 = (chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n9++)).getX(i3))) continue;
                        if (bl && d2 <= 0.0) {
                            d2 = this.holeValue;
                        }
                        double d3 = chartDataViewSeries.getY(i3);
                        if (bl2 && d3 <= 0.0) {
                            d3 = this.holeValue;
                        }
                        ChartDataViewSeries chartDataViewSeries2 = (ChartDataViewSeries)this.seriesList.get(n9);
                        double d4 = chartDataViewSeries2.getX(i3);
                        if (bl && d4 <= 0.0) {
                            d4 = this.holeValue;
                        }
                        double d5 = chartDataViewSeries2.getY(i3);
                        if (bl2 && d5 <= 0.0) {
                            d5 = this.holeValue;
                        }
                        plotPointArray[0].valid = false;
                        plotPointArray[1].valid = false;
                        this.financialClip(d2, d3, d4, d5, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                        if (!plotPointArray[0].valid || !plotPointArray[1].valid) continue;
                        ((Line2D.Double)serializable).setLine(Math.floor(plotPointArray[0].px), Math.floor(plotPointArray[0].py), Math.floor(plotPointArray[1].px), Math.floor(plotPointArray[1].py));
                        graphics2D.draw((Shape)((Object)serializable));
                        if (defineShape == null) continue;
                        this.defineHiloShapes(defineShape, graphics2D, this.inverted, i3, chartDataViewSeries, chartDataViewSeries2, plotPointArray);
                    }
                    jCLineStyle.resetGraphics(graphics2D);
                }
            }
            catch (Exception exception) {
                JCChart jCChart = (JCChart)this.chartArea.getParent();
                if (jCChart == null) break block14;
                jCChart.getErrorLog().logErrorMessage("drawing", exception);
            }
        }
    }

    protected void defineHiloShapes(DefineShape defineShape, Graphics2D graphics2D, boolean bl, int n2, ChartDataViewSeries chartDataViewSeries, ChartDataViewSeries chartDataViewSeries2, PlotPoint[] plotPointArray) {
        if (plotPointArray[0].drawPoint && plotPointArray[1].drawPoint) {
            int n3;
            defineShape.beginShape(new JCDataIndex(n2, chartDataViewSeries));
            if (!bl) {
                n3 = ((int)plotPointArray[1].py - (int)plotPointArray[0].py) / 2;
                graphics2D.fillRect((int)plotPointArray[0].px - 5, (int)plotPointArray[0].py, 11, n3);
            } else {
                n3 = ((int)plotPointArray[1].px - (int)plotPointArray[0].px) / 2;
                graphics2D.fillRect((int)plotPointArray[0].px, (int)plotPointArray[0].py - 5, n3, 11);
            }
            defineShape.endShape(false);
            defineShape.beginShape(new JCDataIndex(n2, chartDataViewSeries2));
            if (!bl) {
                graphics2D.fillRect((int)plotPointArray[0].px - 5, (int)plotPointArray[0].py + n3, 11, (int)plotPointArray[1].py - (int)plotPointArray[0].py - n3);
            } else {
                graphics2D.fillRect((int)plotPointArray[0].px + n3, (int)plotPointArray[0].py - 5, (int)plotPointArray[1].px - (int)plotPointArray[0].px - n3, 11);
            }
            defineShape.endShape(false);
        } else {
            if (plotPointArray[0].drawPoint) {
                defineShape.beginShape(new JCDataIndex(n2, chartDataViewSeries));
            } else {
                defineShape.beginShape(new JCDataIndex(n2, chartDataViewSeries2));
            }
            if (!bl) {
                graphics2D.fillRect((int)plotPointArray[0].px - 5, (int)plotPointArray[0].py, 11, (int)plotPointArray[1].py - (int)plotPointArray[0].py);
            } else {
                graphics2D.fillRect((int)plotPointArray[0].px, (int)plotPointArray[0].py - 5, (int)plotPointArray[1].px - (int)plotPointArray[0].px, 11);
            }
            defineShape.endShape(false);
        }
    }

    public JCDataIndex pick(Point point, int n2) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        int n3 = point.x - rectangle.x;
        int n4 = point.y - rectangle.y;
        Point2D.Double double_ = new Point2D.Double(n3, n4);
        int n5 = -1;
        int n6 = -1;
        JCDataIndex jCDataIndex = null;
        double d2 = Double.MAX_VALUE;
        Object object = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        if (this.seriesList == null || this.xaxis == null || this.yaxis == null) {
            return jCDataIndex;
        }
        boolean bl = this.xaxis.isLogarithmic();
        boolean bl2 = this.yaxis.isLogarithmic();
        boolean bl3 = n2 == 1;
        int n7 = this.seriesList.size() / 2;
        int n8 = 0;
        int n9 = n7;
        try {
            for (int i2 = n8; i2 < n9; ++i2) {
                Object object2;
                int n10;
                Object object3;
                boolean bl4 = true;
                boolean bl5 = true;
                int n11 = Integer.MAX_VALUE;
                int n12 = Integer.MAX_VALUE;
                int n13 = 2 * i2;
                int n14 = 0;
                while (n14 < 2) {
                    object3 = (ChartDataViewSeries)this.seriesList.get(n13);
                    if (!((ChartDataViewSeries)object3).isVisible()) {
                        bl5 = false;
                        break;
                    }
                    if (((ChartDataViewSeries)object3).maxXIndex() == 0 || ((ChartDataViewSeries)object3).maxYIndex() == 0) {
                        bl4 = false;
                        break;
                    }
                    n11 = Math.min(n11, ((ChartDataViewSeries)object3).getFirstPoint());
                    n12 = Math.min(n12, ((ChartDataViewSeries)object3).getLastPoint());
                    ++n14;
                    ++n13;
                }
                if (!bl4 || !bl5) continue;
                n13 = 2 * i2;
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n13 + 0);
                object3 = chartDataViewSeries.getX();
                double[] dArray = chartDataViewSeries.getY();
                ChartDataViewSeries chartDataViewSeries2 = (ChartDataViewSeries)this.seriesList.get(n13 + 1);
                double[] dArray2 = chartDataViewSeries2.getX();
                double[] dArray3 = chartDataViewSeries2.getY();
                Object object4 = Double.MAX_VALUE;
                double d4 = Double.MAX_VALUE;
                double d5 = Double.MAX_VALUE;
                double d6 = Double.MAX_VALUE;
                boolean bl6 = false;
                double d7 = 0.0;
                double d8 = 0.0;
                for (n10 = n11; n10 <= n12; ++n10) {
                    object2 = object3[n10];
                    double d9 = dArray[n10];
                    double d10 = dArray2[n10];
                    double d11 = dArray3[n10];
                    int n15 = this.xaxis.toPixel((double)object2, this.drawFront);
                    if (n15 == Integer.MAX_VALUE) continue;
                    int n16 = this.yaxis.toPixel(d9, this.drawFront);
                    int n17 = this.yaxis.toPixel(d11, this.drawFront);
                    double d12 = this.calcDistanceToLine(double_, n15, n16, n15, n17, n2);
                    double d13 = Double.MAX_VALUE;
                    if (bl3) {
                        d13 = this.calcDistanceToLine(double_, n15, n16, n15, n17, 0);
                    }
                    if (!(d12 < d2) && (d12 != d2 || bl3 && !(d13 <= d3))) continue;
                    object4 = object2;
                    d4 = d9;
                    d5 = d10;
                    d6 = d11;
                    n6 = n10;
                    d2 = d12;
                    bl6 = true;
                    if (!bl3 || !(d13 < d3)) continue;
                    d3 = d13;
                }
                if (!bl6) continue;
                for (n10 = 0; n10 < 2; ++n10) {
                    switch (n10) {
                        case 0: {
                            d7 = object4;
                            d8 = d4;
                            break;
                        }
                        case 1: {
                            d7 = d5;
                            d8 = d6;
                        }
                    }
                    if (this.isHoleValue(d7, bl) || this.isHoleValue(d8, bl2) || d7 > this.xlim.max || this.xlim.min > d7 || d8 > this.ylim.max || this.ylim.min > d8) continue;
                    switch (n2) {
                        default: 
                    }
                    int n18 = this.xaxis.toPixel(d7, this.drawFront);
                    int n19 = this.yaxis.toPixel(d8, this.drawFront);
                    object2 = this.inverted ? Math.sqrt((n19 - n3) * (n19 - n3) + (n18 - n4) * (n18 - n4)) : Math.sqrt((n18 - n3) * (n18 - n3) + (n19 - n4) * (n19 - n4));
                    if (!(object > object2)) continue;
                    n5 = i2 * 2 + n10;
                    object = object2;
                }
            }
            if (n5 >= 0 && n6 >= 0) {
                jCDataIndex = new JCDataIndex(n6, (ChartDataViewSeries)this.seriesList.get(n5), n5);
                jCDataIndex.distance = (int)d2;
            }
            return jCDataIndex;
        }
        catch (Exception exception) {
            JCChart jCChart = (JCChart)this.chartArea.getParent();
            if (jCChart != null) {
                jCChart.getErrorLog().logErrorMessage("picking", exception);
            }
            return null;
        }
    }

    public Point unpick(int n2, int n3) {
        if (this.seriesList == null || this.xaxis == null || this.yaxis == null) {
            return null;
        }
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
        if (chartDataViewSeries == null) {
            return null;
        }
        double d2 = chartDataViewSeries.getY(n2);
        double d3 = chartDataViewSeries.getX(n2);
        if (d2 != this.holeValue && d3 != this.holeValue) {
            int n4;
            int n5;
            if (this.inverted) {
                n5 = this.yaxis.toPixel(d2, this.drawFront);
                n4 = this.xaxis.toPixel(d3, this.drawFront);
            } else {
                n5 = this.xaxis.toPixel(d3, this.drawFront);
                n4 = this.yaxis.toPixel(d2, this.drawFront);
            }
            return new Point(n5, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        int n2 = jCDataIndex.series.getDrawingOrder() / 2;
        this.r = this.chartArea.getDrawingArea();
        this.start = null;
        this.end = null;
        int n3 = n2 * 2;
        int n4 = jCDataIndex.seriesIndex - n3;
        double d2 = ((ChartDataViewSeries)this.seriesList.get(n3 + n4)).getX(jCDataIndex.point);
        double d3 = ((ChartDataViewSeries)this.seriesList.get(n3 + n4)).getY(jCDataIndex.point);
        this.start = this.inverted ? new Point(this.yaxis.toPixel(d3) + this.r.x, this.xaxis.toPixel(d2) + this.r.y) : new Point(this.xaxis.toPixel(d2) + this.r.x, this.yaxis.toPixel(d3) + this.r.y);
    }

    void showEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        JCAxis jCAxis = jCDataIndex.dataView.getXAxis();
        boolean bl = jCAxis.i_vertical;
        this.chartArea.drawRubberLine(this.start, this.end);
        if (this.end == null) {
            int n4 = jCAxis.toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront);
            this.end = bl ? new Point(n2, n4 + this.r.y) : new Point(n4 + this.r.x, n3);
        } else if (bl) {
            this.end.x = n2;
        } else {
            this.end.y = n3;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
    }

    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
        return jCDataIndex.dataView.getXAxis().i_vertical ? n2 - this.r.x : n3 - this.r.y;
    }

    public int getNumSeriesPerData() {
        return 2;
    }
}

