/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCCandleChartFormat;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotPoint;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class FastCandleChartDraw
extends ChartDraw {
    public static final int NUM_SERIES_PER_DATA = 4;
    public static final int HI_SERIES_INDEX = 0;
    public static final int LO_SERIES_INDEX = 1;
    public static final int OPEN_SERIES_INDEX = 2;
    public static final int CLOSE_SERIES_INDEX = 3;
    protected JCCandleChartFormat cf = null;
    protected boolean isComplex = false;
    protected boolean usePercentageWidth = false;
    protected MinMax xlim = new MinMax();
    protected MinMax ylim = new MinMax();
    Point start = null;
    Point end = null;
    Rectangle r = null;
    boolean useRubberBand = false;

    public void recalc() {
        this.recalc(-1);
    }

    public void recalc(int n2) {
        super.recalc();
        if (n2 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.cf = (JCCandleChartFormat)this.dataObject.getChartFormat();
        this.holeValue = this.dataObject.getHoleValue();
        this.xaxis = this.dataObject.getXAxis();
        if (this.xaxis == null) {
            return;
        }
        this.yaxis = this.dataObject.getYAxis();
        this.inverted = this.xaxis.i_vertical;
        if (n2 == -1 || n2 == 0) {
            MinMax minMax = this.dataObject.getXLimits();
            if (minMax == null) {
                return;
            }
            MinMax minMax2 = this.dataObject.getYLimits();
            if (minMax2 == null) {
                return;
            }
            this.xlim = new MinMax(minMax.min, minMax.max);
            this.ylim = new MinMax(minMax2.min, minMax2.max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Graphics graphics2 = null;
        try {
            if (this.seriesList == null || this.xaxis == null || this.yaxis == null) {
                return;
            }
            Rectangle rectangle = graphics2D.getClipBounds();
            if (rectangle.width == 0 || rectangle.height == 0) {
                return;
            }
            this.isComplex = this.cf.isComplex();
            this.usePercentageWidth = this.cf.getCandleWidthMode() == 2;
            boolean bl = this.xaxis.isLogarithmic();
            boolean bl2 = this.yaxis.isLogarithmic();
            graphics2 = (Graphics2D)graphics2D.create();
            DefineShape defineShape = null;
            DefineShape defineShape2 = null;
            if (graphics2D instanceof DefineShape) {
                defineShape = (DefineShape)((Object)graphics2D);
            }
            if (graphics2 instanceof DefineShape) {
                defineShape2 = (DefineShape)((Object)graphics2);
            }
            Rectangle rectangle2 = this.chartArea.getPlotRect();
            int n2 = this.inverted ? rectangle2.height : rectangle2.width;
            int n3 = this.seriesList.size() / 4;
            for (int i2 = 0; i2 < n3; ++i2) {
                JCChartStyle jCChartStyle;
                int n4;
                JCChartStyle jCChartStyle2;
                int n5;
                JCChartStyle jCChartStyle3;
                JCChartStyle jCChartStyle4;
                Serializable serializable;
                int n6;
                int n7 = Integer.MAX_VALUE;
                int n8 = Integer.MAX_VALUE;
                boolean bl3 = true;
                boolean bl4 = true;
                int n9 = n6 = 4 * i2;
                int n10 = 0;
                while (n10 < 4) {
                    serializable = (ChartDataViewSeries)this.seriesList.get(n9);
                    if (!((ChartDataViewSeries)serializable).isVisible()) {
                        bl4 = false;
                        break;
                    }
                    if (((ChartDataViewSeries)serializable).maxXIndex() == 0 || ((ChartDataViewSeries)serializable).maxYIndex() == 0) {
                        bl3 = false;
                        break;
                    }
                    n7 = Math.min(n7, ((ChartDataViewSeries)serializable).getFirstPoint());
                    n8 = Math.min(n8, ((ChartDataViewSeries)serializable).getLastPoint());
                    ++n10;
                    ++n9;
                }
                if (!bl4 || !bl3) continue;
                n9 = 1;
                if (this.usePercentageWidth) {
                    n10 = 0;
                    serializable = (ChartDataViewSeries)this.seriesList.get(n6);
                    for (int i3 = n7; i3 <= n8; ++i3) {
                        double d2 = ((ChartDataViewSeries)serializable).getX(i3);
                        if (this.xaxis.isValueExcluded(d2)) continue;
                        ++n10;
                    }
                    if (n10 == 0) continue;
                    n9 = this.cf.percentageWidth * n2 / (100 * n10);
                }
                if ((jCChartStyle4 = this.cf.getHiloStyle(i2)) == null) continue;
                serializable = jCChartStyle4.getLineStyle();
                if (this.isComplex) {
                    jCChartStyle3 = this.cf.getRisingCandleStyle(i2);
                    if (jCChartStyle3 == null) continue;
                    n5 = jCChartStyle3.getSymbolSize();
                    jCChartStyle2 = this.cf.getFallingCandleStyle(i2);
                    if (jCChartStyle2 == null) continue;
                    n4 = jCChartStyle2.getSymbolSize();
                    jCChartStyle = this.cf.getCandleOutlineStyle(i2);
                    if (jCChartStyle == null) {
                        continue;
                    }
                } else {
                    jCChartStyle3 = jCChartStyle4;
                    jCChartStyle2 = jCChartStyle4;
                    jCChartStyle = jCChartStyle4;
                    n4 = n5 = jCChartStyle4.getSymbolSize();
                }
                boolean bl5 = ((com.klg.jclass.util.style.JCLineStyle)serializable).updateGraphics(graphics2D);
                PlotPoint[] plotPointArray = new PlotPoint[]{new PlotPoint(), new PlotPoint()};
                for (int i4 = n7; i4 <= n8; ++i4) {
                    int n11;
                    double d3;
                    double d4;
                    boolean bl6;
                    ChartDataViewSeries chartDataViewSeries;
                    double d5;
                    int n12 = n6;
                    if (this.xaxis.isValueExcluded(d5 = (chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n12++)).getX(i4))) continue;
                    double d6 = chartDataViewSeries.getY(i4);
                    ChartDataViewSeries chartDataViewSeries2 = (ChartDataViewSeries)this.seriesList.get(n12++);
                    double d7 = chartDataViewSeries2.getX(i4);
                    double d8 = chartDataViewSeries2.getY(i4);
                    if (d6 < d8) {
                        double d9 = d5;
                        double d10 = d6;
                        d5 = d7;
                        d6 = d8;
                        d7 = d9;
                        d8 = d10;
                    }
                    ChartDataViewSeries chartDataViewSeries3 = (ChartDataViewSeries)this.seriesList.get(n12++);
                    double d11 = chartDataViewSeries3.getX(i4);
                    double d12 = chartDataViewSeries3.getY(i4);
                    ChartDataViewSeries chartDataViewSeries4 = (ChartDataViewSeries)this.seriesList.get(n12);
                    double d13 = chartDataViewSeries4.getX(i4);
                    double d14 = chartDataViewSeries4.getY(i4);
                    boolean bl7 = d12 < d14;
                    boolean bl8 = !this.isHoleValue(d7, bl) && !this.isHoleValue(d8, bl2) && !this.isHoleValue(d5, bl) && !this.isHoleValue(d6, bl2);
                    boolean bl9 = bl6 = !this.isHoleValue(d11, bl) && !this.isHoleValue(d12, bl2) && !this.isHoleValue(d13, bl) && !this.isHoleValue(d14, bl2);
                    int n13 = this.usePercentageWidth ? n9 / 2 : (bl7 ? n5 / 2 : n4 / 2);
                    double d15 = d5;
                    double d16 = d6;
                    if (bl8 && bl5) {
                        if (bl6) {
                            d4 = bl7 ? d13 : d11;
                            d3 = bl7 ? d14 : d12;
                        } else {
                            d4 = d7;
                            d3 = d8;
                        }
                        plotPointArray[0].valid = false;
                        plotPointArray[1].valid = false;
                        this.financialClip(d15, d16, d4, d3, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                        if (plotPointArray[0].valid && plotPointArray[1].valid) {
                            graphics2D.draw(new Line2D.Double(Math.floor(plotPointArray[0].px), Math.floor(plotPointArray[0].py), Math.floor(plotPointArray[1].px), Math.floor(plotPointArray[1].py)));
                            if (defineShape != null) {
                                this.defineHighLowShapes(defineShape, graphics2D, this.inverted, true, !bl6, chartDataViewSeries, chartDataViewSeries2, i4, plotPointArray, n13);
                            }
                        }
                        if (!bl6) continue;
                        d15 = d7;
                        d16 = d8;
                        d4 = bl7 ? d11 : d13;
                        d3 = bl7 ? d12 : d14;
                        plotPointArray[0].valid = false;
                        plotPointArray[1].valid = false;
                        this.financialClip(d15, d16, d4, d3, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                        if (plotPointArray[0].valid && plotPointArray[1].valid) {
                            graphics2D.draw(new Line2D.Double(Math.floor(plotPointArray[0].px), Math.floor(plotPointArray[0].py), Math.floor(plotPointArray[1].px), Math.floor(plotPointArray[1].py)));
                            if (defineShape != null) {
                                this.defineHighLowShapes(defineShape, graphics2D, this.inverted, false, true, null, chartDataViewSeries2, i4, plotPointArray, n13);
                            }
                        }
                    }
                    if (!bl6) continue;
                    boolean bl10 = false;
                    int n14 = Integer.MAX_VALUE;
                    int n15 = Integer.MAX_VALUE;
                    int n16 = -2147483647;
                    int n17 = -2147483647;
                    double d17 = d11;
                    double d18 = d12;
                    int n18 = this.xaxis.toPixel(d17, this.drawFront);
                    d15 = this.xaxis.toData(n18 - n13, this.drawFront);
                    d16 = d18;
                    d4 = this.xaxis.toData(n18 + n13, this.drawFront);
                    d3 = d18;
                    boolean bl11 = !(d12 > this.ylim.max && d14 > this.ylim.max || d12 < this.ylim.min && d14 < this.ylim.min);
                    plotPointArray[0].valid = false;
                    plotPointArray[1].valid = false;
                    this.financialClip(d15, d16, d4, d3, this.xlim, this.ylim, plotPointArray, this.inverted, bl11);
                    if (this.xaxis.hasTimeExclusions()) {
                        if (this.inverted) {
                            if (plotPointArray[0].py == 2.147483647E9 || plotPointArray[0].py == Double.MAX_VALUE) {
                                plotPointArray[0].py = n18 - n13;
                            }
                            if (plotPointArray[1].py == 2.147483647E9 || plotPointArray[1].py == Double.MAX_VALUE) {
                                plotPointArray[1].py = n18 + n13;
                            }
                        } else {
                            if (plotPointArray[0].px == 2.147483647E9 || plotPointArray[0].px == Double.MAX_VALUE) {
                                plotPointArray[0].px = n18 - n13;
                            }
                            if (plotPointArray[1].px == 2.147483647E9 || plotPointArray[1].px == Double.MAX_VALUE) {
                                plotPointArray[1].px = n18 + n13;
                            }
                        }
                    }
                    if (!(defineShape2 == null || plotPointArray[0].drawPoint && plotPointArray[1].drawPoint)) {
                        chartDataViewSeries3 = null;
                    }
                    for (n11 = 0; n11 < plotPointArray.length && !bl10; ++n11) {
                        if (plotPointArray[n11].valid) {
                            n14 = Math.min(n14, (int)plotPointArray[n11].px);
                            n16 = Math.max(n16, (int)plotPointArray[n11].px);
                            n15 = Math.min(n15, (int)plotPointArray[n11].py);
                            n17 = Math.max(n17, (int)plotPointArray[n11].py);
                            continue;
                        }
                        bl10 = true;
                    }
                    if (bl10) continue;
                    d17 = d13;
                    d18 = d14;
                    n18 = this.xaxis.toPixel(d17, this.drawFront);
                    d15 = this.xaxis.toData(n18 - n13, this.drawFront);
                    d16 = d18;
                    d4 = this.xaxis.toData(n18 + n13, this.drawFront);
                    d3 = d18;
                    plotPointArray[0].valid = false;
                    plotPointArray[1].valid = false;
                    this.financialClip(d15, d16, d4, d3, this.xlim, this.ylim, plotPointArray, this.inverted, bl11);
                    if (this.xaxis.hasTimeExclusions()) {
                        if (this.inverted) {
                            if (plotPointArray[0].py == 2.147483647E9 || plotPointArray[0].py == Double.MAX_VALUE) {
                                plotPointArray[0].py = n18 - n13;
                            }
                            if (plotPointArray[1].py == 2.147483647E9 || plotPointArray[1].py == Double.MAX_VALUE) {
                                plotPointArray[1].py = n18 + n13;
                            }
                        } else {
                            if (plotPointArray[0].px == 2.147483647E9 || plotPointArray[0].px == Double.MAX_VALUE) {
                                plotPointArray[0].px = n18 - n13;
                            }
                            if (plotPointArray[1].px == 2.147483647E9 || plotPointArray[1].px == Double.MAX_VALUE) {
                                plotPointArray[1].px = n18 + n13;
                            }
                        }
                    }
                    if (!(defineShape2 == null || plotPointArray[0].drawPoint && plotPointArray[1].drawPoint)) {
                        chartDataViewSeries4 = null;
                    }
                    for (n11 = 0; n11 < plotPointArray.length && !bl10; ++n11) {
                        if (plotPointArray[n11].valid) {
                            n14 = Math.min(n14, (int)plotPointArray[n11].px);
                            n16 = Math.max(n16, (int)plotPointArray[n11].px);
                            n15 = Math.min(n15, (int)plotPointArray[n11].py);
                            n17 = Math.max(n17, (int)plotPointArray[n11].py);
                            continue;
                        }
                        bl10 = true;
                    }
                    if (bl10) continue;
                    JCFillStyle jCFillStyle = bl7 ? jCChartStyle3.getFillStyle() : jCChartStyle2.getFillStyle();
                    this.drawCandleRect((Graphics2D)graphics2, jCFillStyle, jCChartStyle.getLineStyle(), n14, n15, n16, n17, this.isComplex, bl7);
                    if (defineShape2 == null) continue;
                    this.defineOpenCloseShape(defineShape2, (Graphics2D)graphics2, this.inverted, bl7, chartDataViewSeries3, chartDataViewSeries4, i4, n14, n15, n16, n17);
                }
                ((com.klg.jclass.util.style.JCLineStyle)serializable).resetGraphics(graphics2D);
            }
        }
        catch (Exception exception) {
            JCChart jCChart = (JCChart)this.chartArea.getParent();
            if (jCChart != null) {
                jCChart.getErrorLog().logErrorMessage("drawing", exception);
            }
        }
        finally {
            if (graphics2 != null) {
                graphics2.dispose();
            }
        }
    }

    protected void defineHighLowShapes(DefineShape defineShape, Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3, ChartDataViewSeries chartDataViewSeries, ChartDataViewSeries chartDataViewSeries2, int n2, PlotPoint[] plotPointArray, int n3) {
        if (bl2 && bl3) {
            if (plotPointArray[0].drawPoint && plotPointArray[1].drawPoint) {
                if (!bl) {
                    int n4 = (int)plotPointArray[0].py + ((int)plotPointArray[1].py - (int)plotPointArray[0].py) / 2;
                    this.defineCandleShape(defineShape, graphics2D, chartDataViewSeries, n2, (int)plotPointArray[0].px - n3, (int)plotPointArray[0].py, n3 * 2 + 1, n4 - (int)plotPointArray[0].py);
                    this.defineCandleShape(defineShape, graphics2D, chartDataViewSeries2, n2, (int)plotPointArray[0].px - n3, n4, n3 * 2 + 1, (int)plotPointArray[1].py - n4);
                } else {
                    int n5 = (int)plotPointArray[0].px + ((int)plotPointArray[1].px - (int)plotPointArray[0].px) / 2;
                    this.defineCandleShape(defineShape, graphics2D, chartDataViewSeries, n2, (int)plotPointArray[0].px, (int)plotPointArray[0].py - n3, n5 - (int)plotPointArray[0].px, n3 * 2 + 1);
                    this.defineCandleShape(defineShape, graphics2D, chartDataViewSeries2, n2, n5, (int)plotPointArray[0].py - n3, (int)plotPointArray[1].px - n5, n3 * 2 + 1);
                }
            } else if (plotPointArray[0].drawPoint) {
                if (!bl) {
                    this.defineCandleShape(defineShape, graphics2D, chartDataViewSeries2, n2, (int)plotPointArray[0].px - n3, (int)plotPointArray[0].py, n3 * 2 + 1, (int)plotPointArray[1].py - (int)plotPointArray[0].py);
                } else {
                    this.defineCandleShape(defineShape, graphics2D, chartDataViewSeries2, n2, (int)plotPointArray[0].px, (int)plotPointArray[0].py - n3, (int)plotPointArray[1].px - (int)plotPointArray[0].px, n3 * 2 + 1);
                }
            } else if (plotPointArray[1].drawPoint) {
                if (!bl) {
                    this.defineCandleShape(defineShape, graphics2D, chartDataViewSeries, n2, (int)plotPointArray[0].px - n3, (int)plotPointArray[0].py, n3 * 2 + 1, (int)plotPointArray[1].py - (int)plotPointArray[0].py);
                } else {
                    this.defineCandleShape(defineShape, graphics2D, chartDataViewSeries, n2, (int)plotPointArray[0].px, (int)plotPointArray[0].py - n3, (int)plotPointArray[1].px - (int)plotPointArray[0].px, n3 * 2 + 1);
                }
            }
        } else if (plotPointArray[0].drawPoint) {
            if (!bl) {
                this.defineCandleShape(defineShape, graphics2D, bl2 ? chartDataViewSeries : chartDataViewSeries2, n2, (int)plotPointArray[0].px - n3, (int)plotPointArray[0].py, n3 * 2 + 1, (int)plotPointArray[1].py - (int)plotPointArray[0].py);
            } else {
                this.defineCandleShape(defineShape, graphics2D, bl2 ? chartDataViewSeries : chartDataViewSeries2, n2, (int)plotPointArray[0].px, (int)plotPointArray[0].py - n3, (int)plotPointArray[1].px - (int)plotPointArray[0].px, n3 * 2 + 1);
            }
        }
    }

    protected void defineOpenCloseShape(DefineShape defineShape, Graphics2D graphics2D, boolean bl, boolean bl2, ChartDataViewSeries chartDataViewSeries, ChartDataViewSeries chartDataViewSeries2, int n2, int n3, int n4, int n5, int n6) {
        if (chartDataViewSeries2 != null && chartDataViewSeries != null) {
            if (!bl) {
                int n7 = n4 + (n6 - n4) / 2;
                this.defineCandleShape(defineShape, graphics2D, bl2 ? chartDataViewSeries2 : chartDataViewSeries, n2, n3, n4, n5 - n3, n7 - n4);
                this.defineCandleShape(defineShape, graphics2D, bl2 ? chartDataViewSeries : chartDataViewSeries2, n2, n3, n7, n5 - n3, n6 - n7);
            } else {
                int n8 = n3 + (n5 - n3) / 2;
                this.defineCandleShape(defineShape, graphics2D, bl2 ? chartDataViewSeries : chartDataViewSeries2, n2, n3, n4, n8 - n3, n6 - n4);
                this.defineCandleShape(defineShape, graphics2D, bl2 ? chartDataViewSeries2 : chartDataViewSeries, n2, n8, n4, n5 - n8, n6 - n4);
            }
        } else if (chartDataViewSeries2 != null) {
            if (!bl) {
                this.defineCandleShape(defineShape, graphics2D, chartDataViewSeries2, n2, n3, n4, n5 - n3, n6 - n4);
            } else {
                this.defineCandleShape(defineShape, graphics2D, chartDataViewSeries2, n2, n3, n4, n5 - n3, n6 - n4);
            }
        } else if (chartDataViewSeries != null) {
            if (!bl) {
                this.defineCandleShape(defineShape, graphics2D, chartDataViewSeries, n2, n3, n4, n5 - n3, n6 - n4);
            } else {
                this.defineCandleShape(defineShape, graphics2D, chartDataViewSeries, n2, n3, n4, n5 - n3, n6 - n4);
            }
        }
    }

    protected void defineCandleShape(DefineShape defineShape, Graphics2D graphics2D, ChartDataViewSeries chartDataViewSeries, int n2, int n3, int n4, int n5, int n6) {
        if (chartDataViewSeries != null) {
            defineShape.beginShape(new JCDataIndex(n2, chartDataViewSeries));
            graphics2D.fillRect(n3, n4, n5, n6);
            defineShape.endShape(false);
        }
    }

    private void drawCandleRect(Graphics2D graphics2D, JCFillStyle jCFillStyle, JCLineStyle jCLineStyle, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        int n6 = Math.max(n4 - n2, 1);
        int n7 = Math.max(n5 - n3, 1);
        Rectangle rectangle = new Rectangle(n2, n3, n6 == 1 ? n6 : n6 + 1, n7 == 1 ? n7 : n7 + 1);
        if (bl) {
            jCFillStyle.updateAnchorRect(rectangle);
            jCFillStyle.fillRect((Graphics)graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            jCFillStyle.updateAnchorRect(null);
            if (jCLineStyle.updateGraphics(graphics2D)) {
                graphics2D.draw(new Rectangle2D.Double(n2, n3, n6, n7));
            }
        } else if (jCLineStyle.updateGraphics(graphics2D)) {
            if (!bl2) {
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            graphics2D.draw(new Rectangle2D.Double(n2, n3, n6, n7));
        }
    }

    public JCDataIndex pick(Point point, int n2) {
        JCDataIndex jCDataIndex;
        block46: {
            Rectangle rectangle = this.chartArea.getDrawingArea();
            int n3 = point.x - rectangle.x;
            int n4 = point.y - rectangle.y;
            int n5 = -1;
            int n6 = -1;
            jCDataIndex = null;
            double d2 = Double.MAX_VALUE;
            double d3 = Double.MAX_VALUE;
            double d4 = Double.MAX_VALUE;
            if (this.seriesList == null || this.xaxis == null || this.yaxis == null) {
                return jCDataIndex;
            }
            this.usePercentageWidth = this.cf.getCandleWidthMode() == 2;
            boolean bl = n2 == 1;
            boolean bl2 = this.xaxis.isLogarithmic();
            boolean bl3 = this.yaxis.isLogarithmic();
            Rectangle rectangle2 = this.chartArea.getPlotRect();
            int n7 = this.inverted ? rectangle2.height : rectangle2.width;
            int n8 = this.seriesList.size() / 4;
            try {
                for (int i2 = n8 - 1; i2 >= 0; --i2) {
                    int n9;
                    int n10;
                    double d5;
                    int n11;
                    Serializable serializable;
                    ChartDataViewSeries chartDataViewSeries;
                    int n12;
                    int n13 = Integer.MAX_VALUE;
                    int n14 = Integer.MAX_VALUE;
                    boolean bl4 = true;
                    boolean bl5 = true;
                    int n15 = n12 = 4 * i2;
                    int n16 = 0;
                    while (n16 < 4) {
                        chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n15);
                        if (!chartDataViewSeries.isVisible()) {
                            bl5 = false;
                            break;
                        }
                        if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) {
                            bl4 = false;
                            break;
                        }
                        n13 = Math.min(n13, chartDataViewSeries.getFirstPoint());
                        n14 = Math.min(n14, chartDataViewSeries.getLastPoint());
                        ++n16;
                        ++n15;
                    }
                    if (!bl5 || !bl4) continue;
                    n15 = 1;
                    if (this.usePercentageWidth) {
                        n16 = 0;
                        chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n12);
                        for (int i3 = n13; i3 <= n14; ++i3) {
                            double d6 = chartDataViewSeries.getX(i3);
                            if (this.xaxis.isValueExcluded(d6)) continue;
                            ++n16;
                        }
                        if (n16 == 0) continue;
                        n15 = this.cf.percentageWidth * n7 / (100 * n16);
                    }
                    n16 = 0;
                    int n17 = 0;
                    if (this.isComplex) {
                        serializable = this.cf.getRisingCandleStyle(i2);
                        if (serializable != null) {
                            n16 = ((JCChartStyle)serializable).getSymbolSize();
                        }
                        if ((serializable = this.cf.getFallingCandleStyle(i2)) != null) {
                            n17 = ((JCChartStyle)serializable).getSymbolSize();
                        }
                    } else {
                        serializable = this.cf.getHiloStyle(i2);
                        if (serializable != null) {
                            n17 = n16 = ((JCChartStyle)serializable).getSymbolSize();
                        }
                    }
                    serializable = (ChartDataViewSeries)this.seriesList.get(n12 + 0);
                    double[] dArray = ((ChartDataViewSeries)serializable).getX();
                    double[] dArray2 = ((ChartDataViewSeries)serializable).getY();
                    ChartDataViewSeries chartDataViewSeries2 = (ChartDataViewSeries)this.seriesList.get(n12 + 1);
                    double[] dArray3 = chartDataViewSeries2.getX();
                    double[] dArray4 = chartDataViewSeries2.getY();
                    ChartDataViewSeries chartDataViewSeries3 = (ChartDataViewSeries)this.seriesList.get(n12 + 2);
                    double[] dArray5 = chartDataViewSeries3.getX();
                    double[] dArray6 = chartDataViewSeries3.getY();
                    ChartDataViewSeries chartDataViewSeries4 = (ChartDataViewSeries)this.seriesList.get(n12 + 3);
                    double[] dArray7 = chartDataViewSeries4.getX();
                    double[] dArray8 = chartDataViewSeries4.getY();
                    double d7 = Double.MAX_VALUE;
                    double d8 = Double.MAX_VALUE;
                    double d9 = Double.MAX_VALUE;
                    double d10 = Double.MAX_VALUE;
                    int n18 = Integer.MAX_VALUE;
                    int n19 = Integer.MAX_VALUE;
                    boolean bl6 = false;
                    double d11 = 0.0;
                    double d12 = 0.0;
                    for (n11 = n14; n11 >= n13; --n11) {
                        double d13;
                        double d14;
                        double d15;
                        int n20;
                        boolean bl7;
                        double d16;
                        double d17;
                        d5 = dArray[n11];
                        double d18 = dArray2[n11];
                        double d19 = dArray3[n11];
                        double d20 = dArray4[n11];
                        boolean bl8 = false;
                        if (d18 < d20) {
                            d17 = d5;
                            d16 = d18;
                            d5 = d19;
                            d18 = d20;
                            d19 = d17;
                            d20 = d16;
                            bl8 = true;
                        }
                        d17 = dArray5[n11];
                        d16 = dArray6[n11];
                        double d21 = dArray7[n11];
                        double d22 = dArray8[n11];
                        boolean bl9 = !this.isHoleValue(d19, bl2) && !this.isHoleValue(d20, bl3) && !this.isHoleValue(d5, bl2) && !this.isHoleValue(d18, bl3);
                        boolean bl10 = !this.isHoleValue(d17, bl2) && !this.isHoleValue(d16, bl3) && !this.isHoleValue(d21, bl2) && !this.isHoleValue(d22, bl3);
                        boolean bl11 = bl7 = d16 < d22;
                        int n21 = this.usePercentageWidth ? n15 : (bl7 ? n16 : n17);
                        int n22 = this.xaxis.toPixel(d5, this.drawFront);
                        if (n22 == Integer.MAX_VALUE) continue;
                        int n23 = 0;
                        int n24 = 0;
                        if (bl9) {
                            n23 = 0;
                            n24 = 4;
                        } else if (bl10) {
                            n23 = 2;
                            n24 = 4;
                        }
                        int n25 = Integer.MAX_VALUE;
                        int n26 = Integer.MAX_VALUE;
                        double d23 = Double.MAX_VALUE;
                        double d24 = Double.MAX_VALUE;
                        Point2D.Double double_ = new Point2D.Double(n3, n4);
                        if (bl10) {
                            n10 = this.xaxis.toPixel(d17, this.drawFront) - n21 / 2;
                            n25 = this.yaxis.toPixel(d16, this.drawFront);
                            n26 = this.yaxis.toPixel(d22, this.drawFront);
                            n9 = Math.min(n25, n26);
                            n20 = Math.abs(n26 - n25);
                            Rectangle rectangle3 = this.inverted ? new Rectangle(n9, n10, n20, n21) : new Rectangle(n10, n9, n21, n20);
                            JCChartStyle jCChartStyle = this.cf.getCandleOutlineStyle(i2);
                            int n27 = jCChartStyle.getLineWidth() / 2;
                            rectangle3.grow(n27, n27);
                            rectangle3 = rectangle3.intersection(rectangle2);
                            d15 = JCChartUtil.getShapeDistance(double_, rectangle3, 1.0);
                            d14 = Double.MAX_VALUE;
                            if (bl) {
                                Point2D.Double double_2 = this.inverted ? new Point2D.Double(rectangle3.getX(), n4) : new Point2D.Double(n3, rectangle3.getY());
                                d15 = JCChartUtil.getShapeDistance(double_2, rectangle3, 1.0);
                            }
                            if (d23 > d15) {
                                d23 = d15;
                            }
                            if (bl && d24 > d14) {
                                d24 = d14;
                            }
                        }
                        n10 = n22;
                        n20 = this.yaxis.toPixel(d18, this.drawFront);
                        int n28 = this.yaxis.toPixel(d20, this.drawFront);
                        if (bl10) {
                            double d25;
                            double d26;
                            n9 = bl7 ? n25 : n26;
                            d13 = this.calcDistanceToLine(double_, n10, n20, n10, n9, n2);
                            d15 = Double.MAX_VALUE;
                            if (bl) {
                                d15 = this.calcDistanceToLine(double_, n10, n20, n10, n9, 0);
                            }
                            n9 = bl7 ? n26 : n25;
                            d14 = this.calcDistanceToLine(double_, n10, n9, n10, n28, n2);
                            double d27 = Double.MAX_VALUE;
                            if (bl) {
                                d27 = this.calcDistanceToLine(double_, n10, n9, n10, n28, 0);
                            }
                            if (d23 > (d26 = Math.min(d13, d14))) {
                                d23 = d26;
                            }
                            if (bl && d24 > (d25 = Math.min(d15, d27))) {
                                d24 = d25;
                            }
                        } else {
                            d13 = this.calcDistanceToLine(double_, n10, n20, n10, n28, n2);
                            d15 = Double.MAX_VALUE;
                            if (bl) {
                                d15 = this.calcDistanceToLine(double_, n10, n20, n10, n28, 0);
                            }
                            if (d23 > d13) {
                                d23 = d13;
                            }
                            if (bl && d24 > d15) {
                                d24 = d15;
                            }
                        }
                        if (!(d2 > d23) && (!bl || d23 != d2 || !(d4 > d24))) continue;
                        d7 = bl8 ? d19 : d5;
                        d8 = bl8 ? d20 : d18;
                        d9 = bl8 ? d5 : d19;
                        d10 = bl8 ? d18 : d20;
                        n18 = n23;
                        n19 = n24;
                        n6 = n11;
                        d2 = d23;
                        bl6 = true;
                        if (!bl || !(d4 > d24)) continue;
                        d4 = d24;
                    }
                    if (!bl6) continue;
                    n11 = n18;
                    block14: while (n11 < n19) {
                        switch (n11) {
                            case 0: {
                                d11 = d7;
                                d12 = d8;
                                break;
                            }
                            case 1: {
                                d11 = d9;
                                d12 = d10;
                                break;
                            }
                            case 2: {
                                if (this.isHoleValue(dArray5[n6], bl2) || this.isHoleValue(dArray6[n6], bl3)) {
                                    ++n11;
                                    continue block14;
                                }
                                d11 = dArray5[n6];
                                d12 = dArray6[n6];
                                break;
                            }
                            case 3: {
                                if (this.isHoleValue(dArray7[n6], bl2) || this.isHoleValue(dArray8[n6], bl3)) {
                                    ++n11;
                                    continue block14;
                                }
                                d11 = dArray7[n6];
                                d12 = dArray8[n6];
                            }
                        }
                        if (d11 > this.xlim.max || this.xlim.min > d11 || d12 > this.ylim.max || this.ylim.min > d12) {
                            ++n11;
                            continue;
                        }
                        switch (n2) {
                            default: 
                        }
                        n10 = this.xaxis.toPixel(d11, this.drawFront);
                        n9 = this.yaxis.toPixel(d12, this.drawFront);
                        double d28 = d5 = this.inverted ? Math.sqrt((n9 - n3) * (n9 - n3) + (n10 - n4) * (n10 - n4)) : Math.sqrt((n10 - n3) * (n10 - n3) + (n9 - n4) * (n9 - n4));
                        if (d3 > d5) {
                            n5 = i2 * 4 + n11;
                            d3 = d5;
                        }
                        ++n11;
                    }
                }
                if (n5 >= 0 && n6 >= 0) {
                    jCDataIndex = new JCDataIndex(n6, (ChartDataViewSeries)this.seriesList.get(n5), n5);
                    jCDataIndex.distance = (int)d2;
                }
            }
            catch (Exception exception) {
                JCChart jCChart = (JCChart)this.chartArea.getParent();
                if (jCChart == null) break block46;
                jCChart.getErrorLog().logErrorMessage("picking", exception);
            }
        }
        return jCDataIndex;
    }

    public Point unpick(int n2, int n3) {
        if (this.seriesList == null || this.xaxis == null || this.yaxis == null) {
            return null;
        }
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
        if (chartDataViewSeries == null) {
            return null;
        }
        double d2 = chartDataViewSeries.getY(n2);
        double d3 = chartDataViewSeries.getX(n2);
        if (d2 != this.holeValue && d3 != this.holeValue) {
            int n4;
            int n5;
            if (this.inverted) {
                n5 = this.yaxis.toPixel(d2, this.drawFront);
                n4 = this.xaxis.toPixel(d3, this.drawFront);
            } else {
                n5 = this.xaxis.toPixel(d3, this.drawFront);
                n4 = this.yaxis.toPixel(d2, this.drawFront);
            }
            return new Point(n5, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        double d2;
        double d3;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.getXAxis().i_vertical;
        int n2 = jCDataIndex.series.getDrawingOrder() / 4;
        this.r = this.chartArea.getDrawingArea();
        this.start = null;
        this.end = null;
        this.useRubberBand = false;
        int n3 = n2 * 4;
        int n4 = jCDataIndex.seriesIndex - n3;
        int n5 = 0;
        int n6 = 0;
        if (this.isComplex) {
            JCChartStyle jCChartStyle = this.cf.getRisingCandleStyle(n2);
            if (jCChartStyle != null) {
                n5 = jCChartStyle.getSymbolSize();
            }
            if ((jCChartStyle = this.cf.getFallingCandleStyle(n2)) != null) {
                n6 = jCChartStyle.getSymbolSize();
            }
        } else {
            JCChartStyle jCChartStyle = this.cf.getHiloStyle(n2);
            if (jCChartStyle != null) {
                n6 = n5 = jCChartStyle.getSymbolSize();
            }
        }
        boolean bl2 = (d3 = ((ChartDataViewSeries)this.seriesList.get(n3 + 2)).getY(jCDataIndex.point)) < (d2 = ((ChartDataViewSeries)this.seriesList.get(n3 + 3)).getY(jCDataIndex.point));
        int n7 = bl2 ? n5 : n6;
        double d4 = ((ChartDataViewSeries)this.seriesList.get(n3 + n4)).getX(jCDataIndex.point);
        double d5 = ((ChartDataViewSeries)this.seriesList.get(n3 + n4)).getY(jCDataIndex.point);
        if (n4 > 1) {
            this.useRubberBand = true;
            if (bl) {
                this.start = new Point(this.yaxis.toPixel(d5) + this.r.x, this.xaxis.toPixel(d4) + this.r.y - n7 / 2);
                this.end = new Point(this.start.x, this.start.y + n7);
            } else {
                this.start = new Point(this.xaxis.toPixel(d4) + this.r.x - n7 / 2, this.yaxis.toPixel(d5) + this.r.y);
                this.end = new Point(this.start.x + n7, this.start.y);
            }
        } else {
            this.start = bl ? new Point(this.yaxis.toPixel(d5) + this.r.x, this.xaxis.toPixel(d4) + this.r.y) : new Point(this.xaxis.toPixel(d4) + this.r.x, this.yaxis.toPixel(d5) + this.r.y);
            this.end = new Point(this.start.x, this.start.y);
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.getXAxis().i_vertical;
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
        } else {
            this.chartArea.drawRubberLine(this.start, this.end);
        }
        if (bl) {
            this.end.x = n2;
        } else {
            this.end.y = n3;
        }
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
        } else {
            this.chartArea.drawRubberLine(this.start, this.end);
        }
    }

    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
        } else {
            this.chartArea.drawRubberLine(this.start, this.end);
        }
        return jCDataIndex.dataView.getXAxis().i_vertical ? n2 - this.r.x : n3 - this.r.y;
    }

    public int getNumSeriesPerData() {
        return 4;
    }
}

