/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.JCChart;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorLog
implements Serializable {
    protected JCChart chart = null;
    protected Hashtable<String, Long> messages = null;
    protected boolean printStackTrace = false;

    ErrorLog(JCChart jCChart) {
        this.chart = jCChart;
        this.messages = new Hashtable();
    }

    public boolean isPrintStackTrace() {
        return this.printStackTrace;
    }

    public void setPrintStackTrace(boolean bl) {
        this.printStackTrace = bl;
    }

    public void logErrorMessage(String string) {
        if (string == null) {
            return;
        }
        if (this.messages.get(string) == null) {
            Long l2 = new Long(System.currentTimeMillis());
            this.messages.put(string, l2);
            if (this.chart != null && this.chart.isWarningDialog()) {
                JOptionPane.showMessageDialog(this.chart, string, "JCChart", 0);
            }
        }
    }

    public void logErrorMessage(String string, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        String string2 = throwable.getLocalizedMessage();
        if (string != null) {
            string2 = string + ": " + string2;
        }
        if (this.printStackTrace) {
            throwable.printStackTrace();
        }
        this.logErrorMessage(string2);
    }

    public List<String> getErrorMessageList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<String> enumeration = this.messages.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            arrayList.add(string);
        }
        return arrayList;
    }

    public long getTimeStamp(String string) {
        Long l2;
        if (string != null && (l2 = this.messages.get(string)) != null) {
            return l2;
        }
        return -1L;
    }

    public void clearMessages() {
        this.messages.clear();
    }
}

