/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ActionHandler;
import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.EditableChartDataModel;
import com.klg.jclass.chart.JCAreaChartFormat;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCBarChartFormat;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartTypeFormat;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.SAreaChartDraw;
import com.klg.jclass.chart.SBarChartDraw;
import java.awt.Point;

public class EditHandler
extends ActionHandler {
    protected ChartDraw drawable = null;
    protected JCDataIndex di = null;

    protected EditHandler() {
    }

    protected void start(int n2, int n3) {
        this.drawable = null;
        this.di = this.parent.pick(new Point(n2, n3), null, -1);
        if (this.di == null || this.di.dataView == null || this.di.series == null) {
            return;
        }
        ChartDataModel chartDataModel = this.di.dataView.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof EditableChartDataModel)) {
            return;
        }
        this.drawable = this.parent.getDrawable(this.di.series.getParent());
        if (this.drawable == null) {
            return;
        }
        if (this.drawable.dataObject.getChartType() == 11) {
            this.drawable = null;
            return;
        }
        this.drawable.startEdit(this.di);
    }

    protected void animate(int n2, int n3) {
        if (this.di == null || this.drawable == null) {
            return;
        }
        this.drawable.showEdit(this.di, n2, n3);
    }

    protected void reanimate(int n2, int n3) {
        this.animate(n2, n3);
    }

    protected void end(int n2, int n3) {
        double d2;
        if (this.di == null || this.drawable == null) {
            return;
        }
        ChartDataView chartDataView = this.drawable.dataObject;
        int n4 = chartDataView.getChartType();
        boolean bl = n4 == 2 || n4 == 3 || n4 == 4;
        int n5 = this.drawable.endEdit(this.di, n2, n3);
        if (n5 == Integer.MIN_VALUE) {
            return;
        }
        JCChartTypeFormat jCChartTypeFormat = chartDataView.getChartFormat();
        JCAxis jCAxis = chartDataView.getYAxis();
        if (n4 == 10 && ((JCBarChartFormat)jCChartTypeFormat).is100Percent()) {
            d2 = jCAxis.toData(n5);
            double d3 = d2 * ((SBarChartDraw)this.drawable).ytotal[this.di.point] / 100.0;
            this.di.series.editPoint(this.di.point, d3);
        } else if (n4 == 12 && ((JCAreaChartFormat)jCChartTypeFormat).is100Percent()) {
            d2 = jCAxis.toData(n5);
            double d4 = d2 * ((SAreaChartDraw)this.drawable).ytotal[this.di.point] / 100.0;
            this.di.series.editPoint(this.di.point, d4);
        } else if (bl) {
            double d5;
            d2 = jCAxis.applyPixelToDataScaling(n5);
            if (jCAxis.isLogarithmic()) {
                d5 = jCAxis.isReversed() ? JCChartUtil.log10(jCAxis.max.value) + d2 : d2 + JCChartUtil.log10(jCAxis.min.value);
                d5 = Math.pow(10.0, d5);
            } else {
                d5 = jCAxis.isReversed() ? jCAxis.max.value + d2 : d2 + jCAxis.min.value;
            }
            this.di.series.editPoint(this.di.point, d5);
        } else {
            this.di.series.editPoint(this.di.point, jCAxis.toData(n5));
        }
        JCChart jCChart = this.getChart();
        if (jCChart != null) {
            jCChart.sendEvent(null);
        }
    }
}

