/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCDataRange;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCSymbolStyle;
import com.klg.jclass.chart.JCTimeLineChartFormat;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.TimeLineInterval;
import com.klg.jclass.chart.TimeLineLayout;
import com.klg.jclass.chart.TimeLineState;
import com.klg.jclass.chart.TimeLineTrack;
import com.klg.jclass.util.JCUtil;
import com.klg.jclass.util.swing.TextRenderer;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTimeLineLayout
implements TimeLineLayout,
Serializable {
    protected static final double INVALID = Double.MAX_VALUE;
    protected ChartDataView dataObject = null;
    protected List<TimeLineState> timeLineStates = null;
    protected Hashtable<ChartDataViewSeries, List<TimeLineTrack>> timeLineTracks = null;
    protected Hashtable<ChartDataViewSeries, List<TimeLineInterval>> timeLineIntervals = null;
    protected JCTimeLineChartFormat format = null;

    public DefaultTimeLineLayout(ChartDataView chartDataView) {
        this.dataObject = chartDataView;
        this.format = (JCTimeLineChartFormat)this.dataObject.getChartFormat();
        this.timeLineStates = this.dataObject.getTimeLineStates();
    }

    protected void computeIntervalCoords() {
        Serializable serializable;
        MinMax minMax = this.dataObject.getXLimits();
        if (minMax == null) {
            return;
        }
        List<ChartDataViewSeries> list = this.dataObject.getSeries();
        int n2 = list.size();
        Hashtable hashtable = new Hashtable();
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2;
            int n3;
            ChartDataViewSeries chartDataViewSeries = list.get(i2);
            if (!chartDataViewSeries.isVisible()) continue;
            serializable = new ArrayList();
            hashtable.put(chartDataViewSeries, serializable);
            int n4 = chartDataViewSeries.getFirstPoint();
            int n5 = chartDataViewSeries.getLastPoint();
            int n6 = n4;
            for (n3 = n4; n3 <= n5; ++n3) {
                double d3;
                TimeLineState timeLineState;
                d2 = chartDataViewSeries.getX(n3);
                if (!(d2 >= minMax.min)) continue;
                int n7 = n3 - 1;
                if (n7 > -1 && (timeLineState = this.getState(d3 = chartDataViewSeries.getY(n3))) != null && !timeLineState.isClearState()) {
                    serializable.add(new JCDataIndex(n7, chartDataViewSeries));
                }
                n6 = n3;
                break;
            }
            for (n3 = n6; n3 <= n5; ++n3) {
                d2 = chartDataViewSeries.getX(n3);
                if (!(d2 >= minMax.min) || !(d2 <= minMax.max)) continue;
                serializable.add(new JCDataIndex(n3, chartDataViewSeries));
            }
        }
        JCAxis jCAxis = this.dataObject.getXAxis();
        this.timeLineIntervals = new Hashtable();
        for (int i3 = 0; i3 < n2; ++i3) {
            double d4;
            boolean bl;
            TimeLineState timeLineState;
            double d5;
            JCDataIndex jCDataIndex;
            serializable = list.get(i3);
            List list2 = (List)hashtable.get(serializable);
            Iterator iterator = list2.iterator();
            ArrayList<TimeLineInterval> arrayList = new ArrayList<TimeLineInterval>();
            this.timeLineIntervals.put((ChartDataViewSeries)serializable, (List<TimeLineInterval>)arrayList);
            double d6 = Double.MAX_VALUE;
            double d7 = Double.MAX_VALUE;
            TimeLineInterval timeLineInterval = null;
            while (iterator.hasNext()) {
                jCDataIndex = (JCDataIndex)iterator.next();
                double d8 = ((ChartDataViewSeries)serializable).getX(jCDataIndex.point);
                d5 = ((ChartDataViewSeries)serializable).getY(jCDataIndex.point);
                timeLineState = this.getState(d5);
                if (timeLineState == null || timeLineState.isClearState()) continue;
                timeLineInterval = new TimeLineInterval(jCDataIndex, timeLineState, this.createIntervalLabel((ChartDataViewSeries)serializable, jCDataIndex.point, timeLineState));
                bl = jCAxis.isValueExcluded(d8);
                if (!bl) {
                    d6 = jCAxis.toPixelDouble(d8);
                }
                timeLineInterval.startX = d6;
                timeLineInterval.timeExclusionAtStart = bl;
                break;
            }
            while (iterator.hasNext()) {
                jCDataIndex = (JCDataIndex)iterator.next();
                d4 = ((ChartDataViewSeries)serializable).getX(jCDataIndex.point);
                d5 = ((ChartDataViewSeries)serializable).getY(jCDataIndex.point);
                timeLineState = this.getState(d5);
                if (timeLineState == null) continue;
                if (d6 == Double.MAX_VALUE) {
                    if (timeLineState.isClearState()) continue;
                    timeLineInterval = new TimeLineInterval(jCDataIndex, timeLineState, this.createIntervalLabel((ChartDataViewSeries)serializable, jCDataIndex.point, timeLineState));
                    bl = jCAxis.isValueExcluded(d4);
                    if (!bl) {
                        d6 = jCAxis.toPixelDouble(d4);
                    }
                    timeLineInterval.startX = d6;
                    timeLineInterval.timeExclusionAtStart = bl;
                    continue;
                }
                bl = jCAxis.isValueExcluded(d4);
                if (!bl) {
                    d7 = jCAxis.toPixelDouble(d4);
                }
                timeLineInterval.endX = d7;
                timeLineInterval.timeExclusionAtEnd = bl;
                timeLineInterval.startsAndStopsOnSameTimeExclusion = timeLineInterval.timeExclusionAtStart && timeLineInterval.timeExclusionAtEnd && (!jCAxis.isReversed() && timeLineInterval.endX < timeLineInterval.startX || jCAxis.isReversed() && timeLineInterval.startX < timeLineInterval.endX);
                arrayList.add(timeLineInterval);
                if (timeLineState.isClearState()) {
                    d6 = Double.MAX_VALUE;
                    timeLineInterval = null;
                    continue;
                }
                timeLineInterval = new TimeLineInterval(jCDataIndex, timeLineState, this.createIntervalLabel((ChartDataViewSeries)serializable, jCDataIndex.point, timeLineState));
                if (!bl) {
                    timeLineInterval.startX = d6 = d7;
                }
                timeLineInterval.timeExclusionAtStart = bl;
            }
            if (timeLineInterval != null && !timeLineInterval.timeLineState.isClearState()) {
                boolean bl2 = jCAxis.isValueExcluded(jCAxis.getMax());
                if (!bl2) {
                    d7 = jCAxis.toPixelDouble(jCAxis.getMax());
                }
                if (d7 == timeLineInterval.startX) {
                    d4 = jCAxis.isReversed() ? -0.01 : 0.01;
                    d7 += d4;
                }
                timeLineInterval.endX = d7;
                timeLineInterval.timeExclusionAtEnd = bl2;
                timeLineInterval.startsAndStopsOnSameTimeExclusion = timeLineInterval.timeExclusionAtStart && timeLineInterval.timeExclusionAtEnd && (!jCAxis.isReversed() && timeLineInterval.endX < timeLineInterval.startX || jCAxis.isReversed() && timeLineInterval.startX < timeLineInterval.endX);
                arrayList.add(timeLineInterval);
            }
            this.mergeIntervals(arrayList);
            this.truncateLabels(arrayList);
        }
    }

    protected void mergeIntervals(List<TimeLineInterval> list) {
        for (int i2 = 0; i2 < list.size() - 1; ++i2) {
            TimeLineInterval timeLineInterval = list.get(i2);
            TimeLineInterval timeLineInterval2 = list.get(i2 + 1);
            if (timeLineInterval.endX != timeLineInterval2.startX || !timeLineInterval.timeLineState.equals(timeLineInterval2.timeLineState)) continue;
            timeLineInterval.endX = timeLineInterval2.endX;
            list.remove(timeLineInterval2);
            this.mergeIntervals(list);
        }
    }

    protected String createIntervalLabel(ChartDataViewSeries chartDataViewSeries, int n2, TimeLineState timeLineState) {
        if (!timeLineState.isClearState()) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            String string = "";
            boolean bl4 = bl3 = (this.format.intervalLabelMode & 1) != 0;
            if (bl3) {
                string = string + (chartDataViewSeries.label == null ? "" : chartDataViewSeries.label);
            }
            boolean bl5 = bl2 = (this.format.intervalLabelMode & 2) != 0;
            if (bl2 && this.dataLabelsAvailable(chartDataViewSeries)) {
                if (string.length() > 0) {
                    string = string + ":";
                }
                String string2 = chartDataViewSeries.getDataLabels()[n2];
                string = string + (string2 == null ? "" : string2);
            }
            boolean bl6 = bl = (this.format.intervalLabelMode & 4) != 0;
            if (bl) {
                if (string.length() > 0) {
                    string = string + ":";
                }
                string = string + (timeLineState.label == null ? "" : timeLineState.label);
            }
            return string;
        }
        return null;
    }

    private boolean dataLabelsAvailable(ChartDataViewSeries chartDataViewSeries) {
        String[] stringArray = chartDataViewSeries.getDataLabels();
        return stringArray != null && stringArray.length > 0;
    }

    protected String createTruncatedLabel(String string, int n2) {
        String string2 = string;
        Graphics graphics = this.dataObject.chart.getChartArea().getGraphics();
        if (this.format.isTruncateLabels() && string2 != null && graphics != null) {
            string2 = JCUtil.truncateString(graphics, this.dataObject.chart, string2, n2, this.format.getTruncateMode(), this.format.isUseEllipsisWhenTruncating(), TextRenderer.isHTML(string2));
        }
        return string2;
    }

    protected void truncateLabels(List<TimeLineInterval> list) {
        if (!this.format.isTruncateLabels()) {
            return;
        }
        JCAxis jCAxis = this.dataObject.getXAxis();
        int n2 = jCAxis.getLeft() + jCAxis.pixelLength();
        for (TimeLineInterval timeLineInterval : list) {
            int n3;
            if (timeLineInterval.endX == timeLineInterval.startX) {
                n3 = Math.min(this.format.getMaxSymbolLabelWidth(), n2 - (int)Math.ceil(timeLineInterval.startX));
            } else {
                int n4 = Math.max((int)timeLineInterval.startX, jCAxis.getLeft());
                int n5 = Math.min((int)timeLineInterval.endX, n2);
                int n6 = n5 - n4;
                int n7 = this.format.getLabelInset();
                if (n7 > n6 / 2) {
                    n7 = n6 / 2;
                }
                n3 = Math.max(0, n6 - n7 - 3);
            }
            timeLineInterval.label = this.createTruncatedLabel(timeLineInterval.label, n3);
        }
    }

    protected boolean isSymbolDisplayed(TimeLineInterval timeLineInterval, JCSymbolStyle jCSymbolStyle) {
        JCChartStyle jCChartStyle = timeLineInterval.timeLineState.getChartStyle();
        JCFillStyle jCFillStyle = jCChartStyle == null ? null : jCChartStyle.getFillStyle();
        boolean bl = jCSymbolStyle != null && jCSymbolStyle.getShape() != 0 && jCSymbolStyle.getSize() > 0;
        return timeLineInterval.startX == timeLineInterval.endX && bl || (jCFillStyle == null || jCFillStyle.getPattern() == 0) && bl;
    }

    protected void computeIntervalLabelCoords() {
        Graphics graphics = this.dataObject.chart.getChartArea().getGraphics();
        if (graphics == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        JCAxis jCAxis = this.dataObject.getXAxis();
        if (jCAxis == null || this.timeLineIntervals == null) {
            return;
        }
        List<ChartDataViewSeries> list = this.dataObject.getSeries();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ChartDataViewSeries chartDataViewSeries = list.get(i2);
            if (!chartDataViewSeries.isVisible()) continue;
            List<TimeLineInterval> list2 = this.timeLineIntervals.get(chartDataViewSeries);
            for (TimeLineInterval timeLineInterval : list2) {
                double d2;
                String string = timeLineInterval.label;
                if (string == null) continue;
                boolean bl = this.format.intervalLabelMode != 0;
                int n3 = Math.round(fontMetrics.stringWidth(string));
                int n4 = bl && n3 > 0 ? this.format.getLabelInset() : 0;
                double d3 = d2 = jCAxis.isReversed() ? timeLineInterval.startX - timeLineInterval.endX : timeLineInterval.endX - timeLineInterval.startX;
                if (this.format.isTruncateLabels() && d2 > 0.0 && (double)n4 > d2 / 2.0) {
                    n4 = (int)(d2 / 2.0);
                }
                if (!this.format.isTruncateLabels() && (double)(n3 + n4) * this.format.labelThreshold > timeLineInterval.endX - timeLineInterval.startX) {
                    JCChartStyle jCChartStyle = timeLineInterval.timeLineState.getChartStyle();
                    JCSymbolStyle jCSymbolStyle = jCChartStyle == null ? null : jCChartStyle.getSymbolStyle();
                    int n5 = 0;
                    if (this.isSymbolDisplayed(timeLineInterval, jCSymbolStyle)) {
                        n5 = jCSymbolStyle.getSize() / 2;
                    }
                    timeLineInterval.labelStartX = timeLineInterval.endX + (double)n5 + (double)n4;
                } else {
                    timeLineInterval.labelStartX = timeLineInterval.startX + (double)n4;
                }
                if (timeLineInterval.labelStartX < (double)(jCAxis.getLeft() + n4)) {
                    timeLineInterval.labelStartX = jCAxis.getLeft() + n4;
                }
                timeLineInterval.labelEndX = timeLineInterval.labelStartX + (double)n3;
                if (!(timeLineInterval.labelEndX >= (double)(jCAxis.getLeft() + jCAxis.pixelLength()))) continue;
                timeLineInterval.labelStartX = timeLineInterval.startX + (double)n4;
                timeLineInterval.labelEndX = timeLineInterval.labelStartX + (double)n3;
            }
        }
    }

    protected boolean isOverlap(TimeLineInterval timeLineInterval, TimeLineInterval timeLineInterval2) {
        JCChartStyle jCChartStyle = timeLineInterval.timeLineState.getChartStyle();
        JCChartStyle jCChartStyle2 = timeLineInterval2.timeLineState.getChartStyle();
        JCSymbolStyle jCSymbolStyle = jCChartStyle == null ? null : jCChartStyle.getSymbolStyle();
        JCSymbolStyle jCSymbolStyle2 = jCChartStyle2 == null ? null : jCChartStyle2.getSymbolStyle();
        boolean bl = this.isSymbolDisplayed(timeLineInterval, jCSymbolStyle);
        boolean bl2 = this.isSymbolDisplayed(timeLineInterval2, jCSymbolStyle2);
        int n2 = 0;
        int n3 = 0;
        if (bl && jCSymbolStyle != null && bl2 && jCSymbolStyle2 != null) {
            n2 = jCSymbolStyle.getSize() / 2;
            n3 = jCSymbolStyle2.getSize() / 2;
        }
        JCAxis jCAxis = this.dataObject.getXAxis();
        boolean bl3 = this.format.getIntervalLabelMode() != 0;
        return !jCAxis.isReversed() && (timeLineInterval.startX - (double)n2 < timeLineInterval2.endX + (double)n3 || bl3 && timeLineInterval.startX - (double)n2 < timeLineInterval2.labelEndX) && (timeLineInterval2.startX - (double)n3 < timeLineInterval.endX + (double)n2 || bl3 && timeLineInterval2.startX - (double)n3 < timeLineInterval.labelEndX) || jCAxis.isReversed() && (timeLineInterval.startX + (double)n2 > timeLineInterval2.endX - (double)n3 || bl3 && timeLineInterval.startX + (double)n2 > timeLineInterval2.labelStartX) && (timeLineInterval2.startX + (double)n3 > timeLineInterval.endX - (double)n2 || bl3 && timeLineInterval2.startX + (double)n3 > timeLineInterval.labelStartX);
    }

    protected TimeLineTrack findTrackWithAvailableSpace(TimeLineInterval timeLineInterval, List<TimeLineTrack> list) {
        for (TimeLineTrack timeLineTrack : list) {
            boolean bl = false;
            for (TimeLineInterval timeLineInterval2 : timeLineTrack) {
                if (!this.isOverlap(timeLineInterval, timeLineInterval2)) continue;
                bl = true;
                break;
            }
            if (timeLineTrack.size() <= 0 || bl) continue;
            return timeLineTrack;
        }
        return null;
    }

    protected int placeIntervals(List<TimeLineTrack> list, List<TimeLineInterval> list2, int n2) {
        for (TimeLineInterval timeLineInterval : list2) {
            if (timeLineInterval.startsAndStopsOnSameTimeExclusion) continue;
            TimeLineTrack timeLineTrack = this.findTrackWithAvailableSpace(timeLineInterval, list);
            if (timeLineTrack != null) {
                timeLineTrack.add(timeLineInterval);
                continue;
            }
            timeLineTrack = new TimeLineTrack(n2++);
            timeLineTrack.add(timeLineInterval);
            list.add(timeLineTrack);
        }
        return n2;
    }

    protected void layoutIntervals() {
        if (this.timeLineIntervals == null) {
            return;
        }
        this.timeLineTracks = new Hashtable();
        int n2 = 0;
        List<ChartDataViewSeries> list = this.dataObject.getSeries();
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            ChartDataViewSeries chartDataViewSeries = list.get(i2);
            if (!chartDataViewSeries.isVisible()) continue;
            ArrayList<TimeLineTrack> arrayList = new ArrayList<TimeLineTrack>();
            this.timeLineTracks.put(chartDataViewSeries, arrayList);
            List<TimeLineInterval> list2 = this.timeLineIntervals.get(chartDataViewSeries);
            n2 = this.placeIntervals(arrayList, list2, n2);
            if (arrayList.size() != 0) continue;
            arrayList.add(new TimeLineTrack(n2++));
        }
    }

    protected boolean anyOverlap(List<TimeLineTrack> list, List<TimeLineTrack> list2) {
        int n2 = list.size();
        int n3 = list2.size();
        int n4 = Math.min(n2, n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            List list3 = list.get(i2);
            List list4 = list2.get(i2);
            for (TimeLineInterval timeLineInterval : list3) {
                for (TimeLineInterval timeLineInterval2 : list4) {
                    if (!this.isOverlap(timeLineInterval, timeLineInterval2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void combineTracks(List<TimeLineTrack> list, List<TimeLineTrack> list2, ChartDataViewSeries chartDataViewSeries) {
        int n2;
        int n3 = list.size();
        int n4 = list2.size();
        int n5 = Math.min(n3, n4);
        for (n2 = 0; n2 < n5; ++n2) {
            List list3 = list.get(n2);
            List list4 = list2.get(n2);
            int n6 = list3.size();
            int n7 = list4.size();
            block1: for (int i2 = n7 - 1; i2 >= 0; --i2) {
                TimeLineInterval timeLineInterval = (TimeLineInterval)list4.get(i2);
                for (int i3 = n6 - 1; i3 >= 0; --i3) {
                    TimeLineInterval timeLineInterval2 = (TimeLineInterval)list3.get(i3);
                    if (!(timeLineInterval.startX > timeLineInterval2.startX)) continue;
                    list3.add(i3 + 1, timeLineInterval);
                    continue block1;
                }
            }
        }
        for (n2 = n3; n2 < n4; ++n2) {
            list.add(list2.get(n2));
        }
        this.timeLineTracks.put(chartDataViewSeries, list);
    }

    protected void mergeTracks() {
        if (!this.format.mergeTracks || this.timeLineTracks == null) {
            return;
        }
        List<ChartDataViewSeries> list = this.dataObject.getSeries();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ChartDataViewSeries chartDataViewSeries = list.get(i2);
            if (!chartDataViewSeries.isVisible()) continue;
            List<TimeLineTrack> list2 = this.timeLineTracks.get(chartDataViewSeries);
            for (int i3 = i2 + 1; i3 < n2; ++i3) {
                List<TimeLineTrack> list3;
                ChartDataViewSeries chartDataViewSeries2 = list.get(i3);
                if (!chartDataViewSeries2.isVisible() || list2 == (list3 = this.timeLineTracks.get(chartDataViewSeries2)) || this.anyOverlap(list2, list3)) continue;
                this.combineTracks(list2, list3, chartDataViewSeries2);
            }
        }
    }

    @Override
    public void layoutChart() {
        this.computeIntervalCoords();
        this.computeIntervalLabelCoords();
        this.layoutIntervals();
        this.mergeTracks();
    }

    @Override
    public TimeLineState getState(double d2) {
        if (this.timeLineStates == null) {
            return null;
        }
        for (TimeLineState timeLineState : this.timeLineStates) {
            if (timeLineState == null) continue;
            List<JCDataRange> list = timeLineState.getDataRanges();
            for (JCDataRange jCDataRange : list) {
                if (jCDataRange == null || !jCDataRange.isIncluded(d2)) continue;
                return timeLineState;
            }
        }
        return null;
    }

    @Override
    public Hashtable<ChartDataViewSeries, List<TimeLineTrack>> getTracks() {
        return this.timeLineTracks;
    }
}

