/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartArea;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataViewIterator
implements Iterator<ChartDataView> {
    protected JCChart chart = null;
    protected ChartDataView currentDV = null;
    protected Iterator<ChartDataView> iterator = null;
    protected boolean hasPie = false;
    protected boolean hasRadar = false;
    protected boolean wantAllRectangular = false;
    protected boolean want3dChartType = false;
    protected boolean wantDrawFront = false;
    protected boolean wantPlot = false;

    public DataViewIterator(JCChart jCChart, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.chart = jCChart;
        if (jCChart != null) {
            this.iterator = jCChart.getOriginalDataView().iterator();
        }
        this.wantAllRectangular = bl;
        this.want3dChartType = bl2;
        this.wantDrawFront = bl3;
        this.wantPlot = bl4;
        this.currentDV = this.getNextDrawable();
    }

    protected boolean isRectangular(int n2) {
        if (n2 < 0 || n2 > 13) {
            throw new IllegalArgumentException("Chart type must be one ofpredefined types.");
        }
        return n2 != 11 && n2 != 2 && n2 != 3 && n2 != 4;
    }

    protected ChartDataView getNextDrawable() {
        ChartDataView chartDataView = null;
        if (this.chart == null) {
            return chartDataView;
        }
        boolean bl = false;
        JCChartArea jCChartArea = this.chart.getChartArea();
        while (this.iterator.hasNext() && !bl && !this.hasPie && !this.hasRadar) {
            boolean bl2;
            ChartDraw chartDraw;
            chartDataView = this.iterator.next();
            if (chartDataView == null || !chartDataView.isVisible() || (chartDraw = jCChartArea.getDrawable(chartDataView)) == null) continue;
            int n2 = chartDataView.getChartType();
            if (jCChartArea.pieFirst) {
                if (n2 != 11) continue;
                this.hasPie = true;
                bl = true;
                continue;
            }
            if (jCChartArea.radarFirst) {
                if (n2 != 3 && n2 != 4) continue;
                this.hasRadar = true;
                bl = true;
                continue;
            }
            if (jCChartArea.polarFirst) {
                if (n2 != 2) continue;
                bl = true;
                continue;
            }
            if (this.wantAllRectangular) {
                if (!this.isRectangular(n2)) continue;
                bl = true;
                continue;
            }
            if (jCChartArea.draw3D) {
                if (!this.isRectangular(n2)) continue;
                if (this.want3dChartType) {
                    if (!chartDataView.is3DChartType()) continue;
                    bl = true;
                    continue;
                }
                if (chartDataView.is3DChartType() || this.wantDrawFront ^ chartDraw.drawFront) continue;
                bl = true;
                continue;
            }
            if (!this.isRectangular(n2) || this.wantPlot ^ (bl2 = n2 == 0 || n2 == 1)) continue;
            bl = true;
        }
        if (!bl) {
            chartDataView = null;
        }
        return chartDataView;
    }

    @Override
    public boolean hasNext() {
        return this.currentDV != null;
    }

    @Override
    public ChartDataView next() {
        ChartDataView chartDataView = this.currentDV;
        this.currentDV = this.getNextDrawable();
        return chartDataView;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supportedby this iterator!");
    }
}

