/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AxisHandler;
import com.klg.jclass.chart.DoubleCoord;
import com.klg.jclass.chart.JCAnno;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataCoord;
import com.klg.jclass.chart.JCValueLabel;
import com.klg.jclass.chart.PolarAxisParams;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;

abstract class CircularChartAxisHandler
extends AxisHandler {
    CircularChartAxisHandler() {
    }

    protected JCAxis getRadialAxis() {
        JCAxis jCAxis = null;
        if (this.parent.isPolar() || this.parent.isRadar()) {
            if (this.parent.i_vertical) {
                jCAxis = this.parent;
            } else if (this.parent.otherAxis != null) {
                jCAxis = this.parent.otherAxis;
            }
        }
        return jCAxis;
    }

    protected double calcThetaAngle(double d2, double d3) {
        double d4;
        double d5 = this.parent.polarAxisParams.getOriginBase(2);
        if (d2 > 0.0) {
            d4 = d3 < 0.0 ? -Math.atan(d3 / d2) : Math.PI * 2 - Math.atan(d3 / d2);
        } else if (d2 < 0.0) {
            d4 = Math.PI - Math.atan(d3 / d2);
        } else if (d3 < 0.0) {
            d4 = 1.5707963267948966;
        } else if (d3 > 0.0) {
            d4 = 4.71238898038469;
        } else {
            return Double.MAX_VALUE;
        }
        d4 = JCChartUtil.boundAngle(2, d4 - d5);
        d4 = JCChartUtil.convertAngle(2, this.parent.chartArea.getAngleUnit(), d4);
        return d4;
    }

    protected JCDataCoord toScreenLocationPolar(double d2, double d3, boolean bl) {
        PolarAxisParams polarAxisParams = this.parent.polarAxisParams;
        double d4 = -(d2 + polarAxisParams.originBase);
        double d5 = d3 * Math.cos(d4);
        double d6 = d3 * Math.sin(d4);
        if (bl) {
            JCAxis jCAxis = this.parent.i_vertical ? this.parent : this.parent.otherAxis;
            double d7 = this.scale;
            if ((this.parent.isPolar() || this.parent.isRadar()) && jCAxis.isReversed()) {
                d7 *= -1.0;
            }
            d5 = d7 * d5;
            d6 = d7 * d6;
        }
        return new JCDataCoord(d5 += polarAxisParams.xCenter, d6 += polarAxisParams.yCenter);
    }

    private DoubleCoord getTickEndPoint(double d2, double d3) {
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = 0.0;
        if (d4 != 0.0) {
            d5 = Math.asin(d2 / d4);
        }
        return new DoubleCoord(d5, d4);
    }

    protected void drawTickPolar(Graphics graphics, JCValueLabel jCValueLabel) {
        boolean bl;
        if (jCValueLabel == null) {
            return;
        }
        JCAnno jCAnno = jCValueLabel.getAnno();
        if (jCAnno == null || !jCAnno.getDrawTicks()) {
            return;
        }
        double d2 = jCValueLabel.getValue();
        double d3 = this.getInnerExtent(jCAnno);
        double d4 = this.getOuterExtent(jCAnno);
        Color color = graphics.getColor();
        Color color2 = this.getTickColor(jCAnno);
        boolean bl2 = bl = color2 != null && !color2.equals(color);
        if (bl) {
            graphics.setColor(color2);
        }
        if (this.parent.i_vertical) {
            if (d2 > this.parent.max.value || d2 < this.parent.min.value) {
                return;
            }
            double d5 = this.getScaledValue(d2);
            double d6 = this.parent.yAxisAngle;
            DoubleCoord doubleCoord = this.getTickEndPoint(d3, d5);
            DoubleCoord doubleCoord2 = this.getTickEndPoint(d4, d5);
            Point point = this.parent.toPixelPolar(d6 + doubleCoord.x, doubleCoord.y, false);
            Point point2 = this.parent.toPixelPolar(d6 - doubleCoord2.x, doubleCoord2.y, false);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
        } else {
            double d7 = JCChartUtil.convertAngle(this.parent.chartArea.getAngleUnit(), 2, d2);
            Point point = this.parent.toPixelPolar(d7, this.parent.polarAxisParams.radius - d3, false);
            Point point3 = this.parent.toPixelPolar(d7, this.parent.polarAxisParams.radius + d4, false);
            graphics.drawLine(point.x, point.y, point3.x, point3.y);
        }
        if (bl) {
            graphics.setColor(color);
        }
    }

    protected void drawTickMark(Graphics graphics, JCValueLabel jCValueLabel, int n2) {
        if (this.parent.isPolar() || this.parent.isRadar() && this.parent.i_vertical) {
            this.drawTickPolar(graphics, jCValueLabel);
        }
    }

    void getAnnoExtent(Dimension dimension, double d2, int n2) {
        this.getAnnotationExtent(dimension, d2, n2);
    }

    protected void makeTickLabels(JCAnno jCAnno) {
        if (!this.parent.isRadar() || this.parent.i_vertical) {
            this.axisScaleHandler.makeTickLabels(jCAnno);
        }
    }

    abstract Point toPixelPolar(double var1, double var3, boolean var5);

    abstract JCDataCoord toDataPolar(int var1, int var2);

    abstract double getScaledValue(double var1);
}

