/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AnnoBoundsInfo;
import com.klg.jclass.chart.AnnotationHandler;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.JCAnno;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCValueLabel;
import com.klg.jclass.chart.PolarAxisParams;
import com.klg.jclass.util.JCUtil;
import com.klg.jclass.util.swing.TextRenderer;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

class CircularChartAnnoHandler
extends AnnotationHandler {
    int thetaAxisLabelOffset = 4;

    CircularChartAnnoHandler(JCAxis jCAxis) {
        super(jCAxis);
    }

    CircularChartAnnoHandler(AnnotationHandler annotationHandler) {
        super(annotationHandler);
    }

    protected AnnoBoundsInfo getPolarAnnotationBounds() {
        AnnoBoundsInfo annoBoundsInfo = null;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        JCValueLabel jCValueLabel = null;
        JCValueLabel jCValueLabel2 = null;
        JCValueLabel jCValueLabel3 = null;
        JCValueLabel jCValueLabel4 = null;
        int n6 = this.firstVisibleLabel();
        int n7 = this.lastVisibleLabel();
        if (n6 >= 0 && n6 < this.valueLabels.size() && n7 >= 0 && n7 < this.valueLabels.size()) {
            for (int i2 = n6; i2 <= n7; ++i2) {
                JCValueLabel jCValueLabel5 = (JCValueLabel)this.valueLabels.elementAt(i2);
                jCValueLabel5.label.recalc();
                if (n2 > jCValueLabel5.label.left.value) {
                    n2 = jCValueLabel5.label.left.value;
                    jCValueLabel = jCValueLabel5;
                }
                if (n3 > jCValueLabel5.label.top.value) {
                    n3 = jCValueLabel5.label.top.value;
                    jCValueLabel3 = jCValueLabel5;
                }
                if (n4 < jCValueLabel5.label.left.value + jCValueLabel5.label.width.value) {
                    n4 = jCValueLabel5.label.left.value + jCValueLabel5.label.width.value;
                    jCValueLabel2 = jCValueLabel5;
                }
                if (n5 >= jCValueLabel5.label.top.value + jCValueLabel5.label.height.value) continue;
                n5 = jCValueLabel5.label.top.value + jCValueLabel5.label.height.value;
                jCValueLabel4 = jCValueLabel5;
            }
            annoBoundsInfo = new AnnoBoundsInfo();
            annoBoundsInfo.x = n2;
            annoBoundsInfo.y = n3;
            annoBoundsInfo.width = n4 - n2;
            annoBoundsInfo.height = n5 - n3;
            annoBoundsInfo.valueLabelMinBoundsX = jCValueLabel;
            annoBoundsInfo.valueLabelMaxBoundsX = jCValueLabel2;
            annoBoundsInfo.valueLabelMinBoundsY = jCValueLabel3;
            annoBoundsInfo.valueLabelMaxBoundsY = jCValueLabel4;
        }
        return annoBoundsInfo;
    }

    protected double getCircumference(int n2) {
        double d2;
        switch (n2) {
            case 2: {
                d2 = Math.PI * 2;
                break;
            }
            case 3: {
                d2 = 400.0;
                break;
            }
            default: {
                d2 = 360.0;
            }
        }
        return d2;
    }

    private void layoutPolar(ChartText chartText, double d2, int n2) {
        chartText.recalc();
        if (this.parent.i_vertical) {
            this.layoutPolarRAxis(chartText, d2, n2);
        } else {
            this.layoutPolarThetaAxis(chartText, d2, n2);
        }
    }

    private void layoutPolarRAxis(ChartText chartText, double d2, int n2) {
        double d3;
        double d4;
        double d5;
        JCAxis jCAxis;
        Point point = null;
        JCAxis jCAxis2 = this.parent.i_vertical ? this.parent : this.parent.otherAxis;
        JCAxis jCAxis3 = jCAxis = this.parent.i_vertical ? this.parent.otherAxis : this.parent;
        if (this.parent.isLogarithmic()) {
            d5 = JCChartUtil.log10(d2);
            if (jCAxis2.isReversed()) {
                d4 = JCChartUtil.log10(this.parent.max.value);
                d3 = this.parent.applyDataToPixelScaling(d4) - this.parent.applyDataToPixelScaling(d5);
            } else {
                d4 = JCChartUtil.log10(this.parent.min.value);
                d3 = this.parent.applyDataToPixelScaling(d5) - this.parent.applyDataToPixelScaling(d4);
            }
        } else {
            d3 = jCAxis2.isReversed() ? this.parent.applyDataToPixelScaling(this.parent.max.value) - this.parent.applyDataToPixelScaling(d2) : this.parent.applyDataToPixelScaling(d2) - this.parent.applyDataToPixelScaling(this.parent.min.value);
        }
        d5 = this.parent.yAxisAngle;
        d4 = JCChartUtil.getAngleRatio(2, d5, this.parent.polarAxisParams.originBase);
        double d6 = Math.sqrt((double)(n2 * n2) + d3 * d3);
        double d7 = 0.0;
        if (d6 != 0.0) {
            d7 = Math.asin((double)n2 / d6);
            if (jCAxis.reversed) {
                d7 = -d7;
            }
        }
        switch (this.anchor) {
            case 2: {
                if (d4 <= 0.0625) {
                    point = this.parent.toPixelPolar(d5 + d7, d6, false);
                    double d8 = chartText.getWidth() / 2;
                    point.x -= (int)Math.round(d8);
                    point.y -= chartText.getHeight();
                    break;
                }
                if (d4 > 0.0625 && d4 < 0.4375) {
                    point = this.parent.toPixelPolar(d5 + d7, d6, false);
                    double d9 = chartText.getWidth();
                    point.x -= (int)Math.round(d9);
                    point.y -= chartText.getHeight() / 2;
                    break;
                }
                if (d4 >= 0.4375 && d4 <= 0.5625) {
                    point = this.parent.toPixelPolar(d5 + d7, d6, false);
                    double d10 = chartText.getWidth() / 2;
                    point.x -= (int)Math.round(d10);
                    break;
                }
                if (d4 > 0.5625 && d4 < 0.9375) {
                    point = this.parent.toPixelPolar(d5 - d7, d6, false);
                    double d11 = chartText.getWidth();
                    point.x -= (int)Math.round(d11);
                    point.y -= chartText.getHeight() / 2;
                    break;
                }
                if (!(d4 >= 0.9375)) break;
                point = this.parent.toPixelPolar(d5 - d7, d6, false);
                double d12 = chartText.getWidth() / 2;
                point.x -= (int)Math.round(d12);
                break;
            }
            case 1: {
                if (d4 <= 0.0625) {
                    point = this.parent.toPixelPolar(d5 - d7, d6, false);
                    double d13 = chartText.getWidth() / 2;
                    point.x -= (int)Math.round(d13);
                    break;
                }
                if (d4 > 0.0625 && d4 < 0.4375) {
                    point = this.parent.toPixelPolar(d5 - d7, d6, false);
                    point.y -= chartText.getHeight() / 2;
                    break;
                }
                if (d4 >= 0.4375 && d4 <= 0.5625) {
                    point = this.parent.toPixelPolar(d5 - d7, d6, false);
                    double d14 = chartText.getWidth() / 2;
                    point.x -= (int)Math.round(d14);
                    point.y -= chartText.getHeight();
                    break;
                }
                if (d4 > 0.5625 && d4 < 0.9375) {
                    point = this.parent.toPixelPolar(d5 + d7, d6, false);
                    point.y -= chartText.getHeight() / 2;
                    break;
                }
                if (!(d4 >= 0.9375)) break;
                point = this.parent.toPixelPolar(d5 - d7, d6, false);
                double d15 = chartText.getWidth() / 2;
                point.x -= (int)Math.round(d15);
                break;
            }
            default: {
                point = this.parent.toPixelPolar(d5, d6, false);
                double d16 = chartText.getWidth() / 2;
                point.x -= (int)Math.round(d16);
                point.y -= chartText.getHeight() / 2;
            }
        }
        chartText.setLocation(point.x, point.y);
    }

    private void layoutPolarThetaAxis(ChartText chartText, double d2, int n2) {
        double d3;
        double d4;
        double d5;
        JCAxis jCAxis;
        this.thetaAxisLabelOffset = n2;
        double d6 = chartText.getHeight();
        double d7 = JCChartUtil.convertAngle(this.parent.chartArea.getAngleUnit(), 2, d2);
        PolarAxisParams polarAxisParams = this.parent.polarAxisParams;
        Point point = this.parent.toPixelPolar(d7, (int)Math.round(polarAxisParams.radius) + this.thetaAxisLabelOffset, false);
        JCAxis jCAxis2 = jCAxis = this.parent.i_vertical ? this.parent.otherAxis : this.parent;
        if (jCAxis.isReversed()) {
            d7 = -d7;
        }
        if ((d5 = JCChartUtil.getAngleRatio(2, d7, polarAxisParams.originBase)) <= 0.25 || d5 >= 0.75) {
            d4 = d5 <= 0.25 ? (double)((int)(2.0 * d6 * (-d5 - 0.25))) : (double)((int)(2.0 * d6 * (1.0 - d5) - d6 / 2.0));
            d3 = d5 < 0.25 || d5 > 0.75 ? 0.0 : (double)(-chartText.getWidth() / 2);
        } else {
            d4 = d5 <= 0.5 ? (double)((int)(2.0 * d6 * (-1.0 + d5) + d6 / 2.0)) : (double)((int)(2.0 * d6 * (d5 - 0.75)));
            d3 = -chartText.getWidth();
        }
        chartText.setLocation((int)((double)point.x + d3), (int)((double)point.y + d4));
    }

    private void makePointLabelsRadar(ChartDataView chartDataView) {
        int[] nArray;
        if (chartDataView != null && (nArray = ChartDataView.getFirstLastPoints(chartDataView)) != null) {
            this.valueLabels = new Vector();
            ChartDataViewSeries chartDataViewSeries = chartDataView.getSeries(0);
            int n2 = Math.min(nArray[1], chartDataView.getPointLabels().size() - 1);
            for (int i2 = nArray[0]; i2 <= n2; ++i2) {
                Object object;
                String string = chartDataView.getPointLabels().get(i2);
                if (string == null) continue;
                String string2 = JCUtil.truncateString(this.parent.getGraphics(), this.parent.getParentChart(), string, this.maxAnnotationWidth, this.truncateMode, this.useEllipsisWhenTruncating, TextRenderer.isHTML(string));
                if (!string.equals(string2) && chartDataView.getShortPointLabels().size() > i2 && (object = chartDataView.getShortPointLabel(i2)) != null) {
                    boolean bl = TextRenderer.isHTML((String)object);
                    string2 = JCUtil.truncateString(this.parent.getGraphics(), this.parent.getParentChart(), (String)object, this.maxAnnotationWidth, 5, false, bl);
                }
                object = new JCValueLabel(chartDataViewSeries.getX(i2), string2, string, this.parent);
                ((JCValueLabel)object).setDataIndex(new JCDataIndex(chartDataView, null, -1, i2));
                if (!this.parent.useAnnoTicks) {
                    ((JCValueLabel)object).anno = this.parent.getDefaultTicks();
                }
                ((JCValueLabel)object).label.setRotation(this.parent.annotationRotation);
                ((JCValueLabel)object).setParent(this.parent);
                this.valueLabels.addElement(object);
            }
        }
    }

    private void makeValueAnnotationsRadar(ChartDataView chartDataView, JCAnno jCAnno) {
        if (chartDataView != null) {
            int n2 = ChartDataView.getNumRadarSpokes(chartDataView);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = this.parent.getChartArea().getAngleUnit();
                double d2 = JCChartUtil.getRadarAngle(n3, n2, i2, false);
                JCValueLabel jCValueLabel = new JCValueLabel(d2, Integer.toString(i2), this.parent);
                jCValueLabel.setParent(this.parent);
                jCValueLabel.setAnno(jCAnno);
                this.valueLabels.addElement(jCValueLabel);
            }
        }
    }

    private int getFontAscent(ChartText chartText) {
        int n2 = -1;
        FontMetrics fontMetrics = chartText.getFontMetrics(chartText.getFont());
        if (fontMetrics != null) {
            n2 = fontMetrics.getAscent();
        }
        return n2;
    }

    private boolean isOverlapping(ChartText chartText, ChartText chartText2) {
        boolean bl = false;
        if (chartText != null && chartText.visible && chartText2 != null && chartText2.visible) {
            int n2 = this.getFontAscent(chartText);
            if (n2 < 0) {
                n2 = chartText.getHeight();
            }
            Rectangle rectangle = new Rectangle(chartText.getLeft(), chartText.getTop(), chartText.getWidth(), n2);
            n2 = this.getFontAscent(chartText2);
            if (n2 < 0) {
                n2 = chartText2.getHeight();
            }
            Rectangle rectangle2 = new Rectangle(chartText2.getLeft(), chartText2.getTop(), chartText2.getWidth(), n2);
            bl = rectangle.intersects(rectangle2);
        }
        return bl;
    }

    protected void checkValueAnnotations() {
        if (this.parent.isPolar() && !this.parent.i_vertical) {
            for (int i2 = 0; i2 < this.valueLabels.size() - 1; ++i2) {
                JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(i2);
                ChartText chartText = jCValueLabel.getChartText();
                if (!chartText.visible) continue;
                JCValueLabel jCValueLabel2 = (JCValueLabel)this.valueLabels.elementAt(i2 + 1);
                ChartText chartText2 = jCValueLabel2.getChartText();
                if (!chartText2.visible || !this.isOverlapping(chartText, chartText2)) continue;
                chartText2.visible = false;
            }
            this.layout();
        } else {
            super.checkValueAnnotations();
        }
    }

    protected void layout() {
        int n2 = this.valueLabels.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(i2);
            JCAnno jCAnno = jCValueLabel.getAnno();
            int n3 = 4;
            if (jCAnno != null) {
                n3 = jCAnno.getLabelExtent();
            }
            if (this.parent.isLogarithmic() && jCValueLabel.value <= 0.0 && (!this.parent.isPolar() && !this.parent.isRadar() || this.parent.i_vertical)) continue;
            if (this.parent.isPolar() || this.parent.isRadar() && this.parent.i_vertical) {
                this.layoutPolar(jCValueLabel.label, jCValueLabel.value, n3);
                continue;
            }
            if (!this.parent.isRadar() || this.parent.i_vertical) continue;
            double d2 = JCChartUtil.getRadarAngle(this.parent.chartArea.getAngleUnit(), n2, i2, false);
            this.layoutPolar(jCValueLabel.label, d2, n3);
        }
    }

    protected void checkUserProvidedAnnotations() {
        this.checkUserProvidedLabels();
    }

    protected void makePointLabels(ChartDataView chartDataView) {
        this.makePointLabelsRadar(chartDataView);
    }

    protected void makeValueAnnotations(ChartDataView chartDataView) {
        if (this.parent.isRadar() && !this.parent.i_vertical) {
            this.valueLabels = new Vector();
            this.makeValueAnnotationsRadar(chartDataView, this.parent.getDefaultLabels());
        } else {
            super.makeValueAnnotations(chartDataView);
        }
    }

    protected void makeAllInRangeLabelsVisible() {
        if (this.parent.isPolarRadar() && !this.parent.i_vertical) {
            for (int i2 = 0; i2 < this.valueLabels.size(); ++i2) {
                JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(i2);
                ChartText chartText = jCValueLabel.getChartText();
                chartText.visible = jCValueLabel.drawLabel;
            }
        } else {
            super.makeAllInRangeLabelsVisible();
        }
    }
}

