/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartInteriorRegion;
import com.klg.jclass.chart.ChartRegion;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCValueLabel;
import com.klg.jclass.chart.Mapper;
import com.klg.jclass.util.graphics.JCFontMetrics;
import com.klg.jclass.util.swing.TextRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import javax.swing.CellRendererPane;

public class ChartText
extends ChartInteriorRegion
implements Serializable {
    protected int adjust = 1;
    protected int rotation = 0;
    protected String text = null;
    protected String shortText = null;
    protected String fullText = null;
    protected JCValueLabel valueLabel = null;
    protected JCAxis parentAxis = null;
    protected boolean isHTML = false;
    protected TextRenderer rendComp = null;
    protected transient Image buffer;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int DEG_0 = 0;
    public static final int DEG_90 = 1;
    public static final int DEG_180 = 2;
    public static final int DEG_270 = 3;
    public static final int DEG_OTHER = 4;

    public ChartText() {
    }

    public ChartText(JCChart jCChart, String string, JCAxis jCAxis) {
        this.setParentAxis(jCAxis);
        this.setText(string);
        this.setParentChart(jCChart);
    }

    public ChartText(JCChart jCChart, String string, ChartRegion chartRegion) {
        this.setParentRegion(chartRegion);
        this.setText(string);
        this.setParentChart(jCChart);
    }

    protected void setParentAxis(JCAxis jCAxis) {
        this.parentAxis = jCAxis;
    }

    public JCAxis getParentAxis() {
        return this.parentAxis;
    }

    public FontMetrics getFontMetrics(Font font) {
        FontMetrics fontMetrics = null;
        if (this.parentChart != null) {
            try {
                Graphics graphics = this.parentChart.getQueryGraphics();
                fontMetrics = graphics != null ? graphics.getFontMetrics(font) : this.parentChart.getToolkit().getFontMetrics(font);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fontMetrics;
    }

    private boolean isTruncatedValueLabel() {
        return this.parentAxis != null && this.parentAxis.getAnnotationMethod() != 3 && this.parentAxis.isTruncatedLabelTooltipEnabled() && this.isTruncated();
    }

    private boolean hasUserProvidedImageMap() {
        return this.valueLabel != null && this.valueLabel.imageMapInfo != null && !this.valueLabel.imageMapInfo.isEmpty();
    }

    public void draw(Graphics graphics) {
        if (!this.visible || this.parentChart == null) {
            return;
        }
        Graphics graphics2 = null;
        if (graphics != null) {
            boolean bl = this.transparent;
            if (this.transparent && this.background != null) {
                this.transparent = false;
            }
            super.draw(graphics);
            this.transparent = bl;
            graphics2 = graphics.create();
            graphics2.setColor(this.getForeground());
            graphics2.setFont(this.getFont());
        }
        if (this.text != null) {
            Rectangle rectangle = this.getDrawingArea();
            Graphics2D graphics2D = (Graphics2D)graphics2;
            boolean bl = true;
            int n2 = 0;
            int n3 = 0;
            double d2 = 0.0;
            if (this.rotation == 1) {
                n2 = rectangle.width;
                d2 = 1.5707963267948966;
            } else if (this.rotation == 2) {
                n2 = rectangle.width;
                n3 = rectangle.height;
                d2 = Math.PI;
            } else if (this.rotation == 3) {
                n3 = rectangle.height + 1;
                d2 = 4.71238898038469;
            } else if (this.rotation == 4 && this.parentAxis != null && !this.parentAxis.isPolar() && !this.parentAxis.isRadar()) {
                d2 = this.parentAxis.getAnnotationRotationAngle(2);
            } else {
                bl = false;
            }
            if (graphics2D != null) {
                if (bl) {
                    graphics2D.translate(n2, n3);
                    graphics2D.rotate(d2, rectangle.x, rectangle.y);
                }
            } else {
                Mapper mapper;
                if (this.parentAxis != null && (mapper = this.parentAxis.getMapper()) != null) {
                    Shape shape = rectangle;
                    AffineTransform affineTransform = new AffineTransform();
                    JCChartArea jCChartArea = this.parentAxis.getChartArea();
                    if (jCChartArea != null) {
                        Point point = jCChartArea.getLocation();
                        Rectangle rectangle2 = jCChartArea.getDrawingArea();
                        affineTransform.translate(rectangle2.x + point.x, rectangle2.y + point.y);
                    }
                    if (bl) {
                        affineTransform.translate(n2, n3);
                        affineTransform.rotate(d2, rectangle.x, rectangle.y);
                    }
                    shape = affineTransform.createTransformedShape(shape);
                    if (this.isTruncatedValueLabel() || this.hasUserProvidedImageMap()) {
                        mapper.addLabelShape(shape, this.valueLabel);
                    } else {
                        mapper.addShape(shape);
                    }
                }
                return;
            }
            if (this.isHTML) {
                ChartRegion chartRegion = this.parentAxis == null ? this.getParentRegion() : this.parentAxis.getParentRegion();
                CellRendererPane cellRendererPane = chartRegion.getCellRendererPane();
                if (cellRendererPane != null) {
                    if (this.rendComp == null) {
                        this.rendComp = new TextRenderer();
                    }
                    if (this.rotation == 4 || this.rotation == 0 || this.rotation == 2) {
                        this.rendComp.drawHTMLText(graphics2D, cellRendererPane, chartRegion, this.text, this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
                    } else {
                        this.rendComp.drawHTMLText(graphics2D, cellRendererPane, chartRegion, this.text, this.getLeft(), this.getTop(), this.getHeight(), this.getWidth());
                    }
                }
            } else {
                FontMetrics fontMetrics = graphics2.getFontMetrics();
                if (fontMetrics != null) {
                    int n4;
                    int n5 = fontMetrics.getAscent();
                    if (fontMetrics instanceof JCFontMetrics && (n4 = (fontMetrics = ((JCFontMetrics)((Object)fontMetrics)).getEncoderFontMetrics()).getAscent()) > n5) {
                        n5 = (n4 + n5) / 2;
                    }
                    if (this.text.length() > 0) {
                        graphics2D.drawString(this.text, rectangle.x + 1, rectangle.y + 1 + n5);
                    }
                }
            }
        }
        if (graphics2 != null) {
            graphics2.dispose();
        }
        this.setChanged(false, 0);
    }

    protected Shape getTransformedDrawingArea(int n2, int n3, double d2, Rectangle rectangle, boolean bl) {
        AffineTransform affineTransform = new AffineTransform();
        JCChartArea jCChartArea = this.parentAxis.getChartArea();
        if (jCChartArea != null) {
            Point point = jCChartArea.getLocation();
            Rectangle rectangle2 = jCChartArea.getDrawingArea();
            affineTransform.translate(rectangle2.x + point.x, rectangle2.y + point.y);
        }
        if (bl) {
            affineTransform.translate(n2, n3);
            affineTransform.rotate(d2, rectangle.x, rectangle.y);
        }
        return affineTransform.createTransformedShape(rectangle);
    }

    protected boolean contains(Point point) {
        if (this.text != null) {
            Rectangle rectangle = this.getDrawingArea();
            boolean bl = true;
            int n2 = 0;
            int n3 = 0;
            double d2 = 0.0;
            if (this.rotation == 1) {
                n2 = rectangle.width;
                d2 = 1.5707963267948966;
            } else if (this.rotation == 2) {
                n2 = rectangle.width;
                n3 = rectangle.height;
                d2 = Math.PI;
            } else if (this.rotation == 3) {
                n3 = rectangle.height + 1;
                d2 = 4.71238898038469;
            } else if (this.rotation == 4 && !this.parentAxis.isPolar() && !this.parentAxis.isRadar()) {
                d2 = this.parentAxis.getAnnotationRotationAngle(2);
            } else {
                bl = false;
            }
            if (this.parentAxis != null) {
                Shape shape = this.getTransformedDrawingArea(n2, n3, d2, rectangle, bl);
                return shape.contains(point.x, point.y);
            }
        }
        return false;
    }

    public void setRotation(int n2) {
        if (n2 == this.rotation) {
            return;
        }
        this.rotation = n2;
        this.setChanged(true, 2);
    }

    public int getRotation() {
        return this.rotation;
    }

    public int getAdjust() {
        return this.adjust;
    }

    public void setAdjust(int n2) {
        if (n2 == this.adjust) {
            return;
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                this.adjust = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Adjust in ChartText.  Must be one of LEFT, CENTER or RIGHT");
            }
        }
        this.setChanged(true, 1);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.setText(string, true);
    }

    public void setText(String string, boolean bl) {
        this.text = string;
        this.isHTML = TextRenderer.isHTML(this.text);
        if (bl) {
            this.setVisible(true);
        }
        if (this.parentChart == null) {
            return;
        }
        this.setChanged(true, 2);
    }

    public void setShortText(String string) {
        this.shortText = string;
    }

    public String getShortText() {
        return this.shortText;
    }

    public String getFullText() {
        return this.fullText;
    }

    protected void setFullText(String string) {
        this.fullText = string;
    }

    public boolean isTruncated() {
        return this.fullText != null && !this.fullText.equals(this.text);
    }

    protected JCValueLabel getValueLabel() {
        return this.valueLabel;
    }

    protected void setValueLabel(JCValueLabel jCValueLabel) {
        this.valueLabel = jCValueLabel;
    }

    protected void recalc(boolean bl) {
        boolean bl2 = false;
        if (this.isChanged(2)) {
            bl2 = true;
        } else if (!bl) {
            return;
        }
        Dimension dimension = this.calcSize();
        if (dimension.width == 0 || dimension.height == 0) {
            this.setSize(0, 0);
        } else if (this.rotation == 1 || this.rotation == 3) {
            this.setSize(dimension.height, dimension.width);
        } else {
            this.setSize(dimension.width, dimension.height);
        }
        if (bl2) {
            this.setChanged(false, 0);
        }
    }

    public void recalc() {
        this.recalc(false);
    }

    public void setParentChart(JCChart jCChart) {
        super.setParentChart(jCChart);
        this.setChanged(true, 2, false);
        this.recalc();
    }

    protected Dimension calcSize() {
        if (this.isHTML) {
            if (this.rendComp == null) {
                this.rendComp = new TextRenderer();
            }
            return this.rendComp.calcHTMLTextSize(this.text);
        }
        Font font = this.getFont();
        if (font == null) {
            return new Dimension(0, 0);
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (fontMetrics instanceof JCFontMetrics) {
            fontMetrics = ((JCFontMetrics)((Object)fontMetrics)).getEncoderFontMetrics();
        }
        if (fontMetrics != null) {
            if (this.text == null || this.text.length() == 0) {
                return new Dimension(0, fontMetrics.getHeight());
            }
            Dimension dimension = new Dimension(fontMetrics.stringWidth(this.text), fontMetrics.getHeight());
            JCChartUtil.fudgeItalicLabel(font, dimension);
            return dimension;
        }
        return new Dimension(0, 0);
    }

    public Dimension calcLineSize() {
        if (this.isHTML) {
            int n2 = 1;
            n2 += JCChartUtil.countInString("<p>", this.text);
            n2 += JCChartUtil.countInString("<br>", this.text);
            n2 += JCChartUtil.countInString("<P>", this.text);
            return new Dimension(this.getWidth(), this.getHeight() / (n2 += JCChartUtil.countInString("<BR>", this.text)));
        }
        Font font = this.getFont();
        if (font == null) {
            return new Dimension(0, 0);
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        return new Dimension(this.getWidth(), fontMetrics.getAscent());
    }

    public Color getForeground() {
        Color color = this.foreground;
        if (color == null && this.parentRegion != null) {
            color = this.parentRegion.getForeground();
        }
        if (color == null && this.parentAxis != null) {
            color = this.parentAxis.getForeground();
        }
        if (color == null && this.parentChart != null) {
            color = this.parentChart.getForeground();
        }
        return color;
    }

    public Color getBackground() {
        Color color = this.background;
        if (color == null && this.parentAxis != null) {
            color = this.parentAxis.getBackground();
        }
        if (color == null && this.parentChart != null) {
            color = this.parentChart.isOpaque() ? this.parentChart.getBackground() : null;
        }
        return color;
    }

    public Font getFont() {
        Font font = this.font;
        if (font == null && this.parentAxis != null) {
            font = this.parentAxis.getFont();
        }
        if (font == null && this.parentChart != null) {
            font = this.parentChart.getFont();
        }
        return font;
    }

    public Dimension preferredSize() {
        this.recalc();
        return this.size();
    }

    public String toString() {
        if (this.text == null) {
            return super.toString();
        }
        return this.text;
    }
}

