/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AxisHandler;
import com.klg.jclass.chart.BarPoint;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.Drawable;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartDateFormat;
import com.klg.jclass.chart.JCChartLabel;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCDrawableColorHandler;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCPlotChartFormat;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotPoint;
import com.klg.jclass.chart.TrackChange;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public abstract class ChartDraw
extends TrackChange
implements Drawable,
Serializable {
    protected List<ChartDataViewSeries> seriesList = null;
    protected boolean inverted = false;
    protected double holeValue = Double.MAX_VALUE;
    protected boolean fastUpdate = false;
    protected boolean cachePlotData = true;
    protected JCAxis xaxis = null;
    protected JCAxis yaxis = null;
    protected int chartType = -1;
    protected ChartDataView dataObject = null;
    protected JCChartArea chartArea = null;
    protected int numActiveDataSeries;
    protected boolean drawFront = true;
    protected boolean usingDoublePixels = false;
    public static String[] drawables = new String[]{"com.klg.jclass.chart.FastPlotChartDraw", "com.klg.jclass.chart.FastPlotChartDraw", "com.klg.jclass.chart.PolarChartDraw", "com.klg.jclass.chart.RadarChartDraw", "com.klg.jclass.chart.AreaRadarChartDraw", "com.klg.jclass.chart.FastHiloChartDraw", "com.klg.jclass.chart.FastHLOCChartDraw", "com.klg.jclass.chart.FastCandleChartDraw", "com.klg.jclass.chart.AreaChartDraw", "com.klg.jclass.chart.BarChartDraw", "com.klg.jclass.chart.SBarChartDraw", "com.klg.jclass.chart.PieChartDraw", "com.klg.jclass.chart.SAreaChartDraw", "com.klg.jclass.chart.TimeLineChartDraw"};
    public static String generalPathPlotDrawable = "com.klg.jclass.chart.GeneralPathPlotChartDraw";
    public static final int BASE_MARGIN = 10;
    public static final int NUM_SERIES_PER_DATA = 1;
    static final int TROUGH_NOT_DRAWN = 0;
    static final int TROUGH_DRAWN = 1;
    static final int FINISH_TROUGH_LATER = 2;

    public ChartDraw() {
    }

    public void setDataView(ChartDataView chartDataView) {
        this.dataObject = chartDataView;
        this.chartArea = null;
        if (this.dataObject != null) {
            JCChart jCChart = this.dataObject.getParent();
            if (jCChart != null) {
                this.chartArea = jCChart.getChartArea();
            }
            this.chartType = this.dataObject.getChartType();
        }
    }

    public ChartDraw(ChartDataView chartDataView) {
        this.setDataView(chartDataView);
    }

    public static ChartDraw makeDrawObject(ChartDataView chartDataView) {
        ChartDraw chartDraw;
        if (chartDataView == null) {
            return null;
        }
        int n2 = chartDataView.getChartType();
        try {
            JCPlotChartFormat jCPlotChartFormat;
            String string = drawables[n2];
            if (n2 == 0 && (jCPlotChartFormat = (JCPlotChartFormat)chartDataView.getChartFormat(0)).isGeneralPathPlotUsed()) {
                string = generalPathPlotDrawable;
            }
            chartDraw = (ChartDraw)Class.forName(string).newInstance();
        }
        catch (Throwable throwable) {
            if (chartDataView.chart != null) {
                chartDataView.chart.getErrorLog().logErrorMessage("makeDrawObject", throwable);
            }
            throw new RuntimeException("Could not find a drawable for chart type " + n2);
        }
        if (chartDraw != null) {
            chartDraw.setDataView(chartDataView);
        }
        return chartDraw;
    }

    public static void setDrawClass(int n2, String string) {
        ChartDraw.drawables[n2] = string;
    }

    public static String getDrawClass(int n2) {
        return drawables[n2];
    }

    public static void setDrawables(String[] stringArray) {
        if (stringArray.length <= 13) {
            throw new IllegalArgumentException("Array too small for pre-existing chart types");
        }
        drawables = stringArray;
    }

    public static String[] getDrawables() {
        return drawables;
    }

    public void recalc() {
        this.chartDrawRecalc();
    }

    protected void chartDrawRecalc() {
        this.numActiveDataSeries = 0;
        List<ChartDataViewSeries> list = this.dataObject.getSeries();
        if (list == null || list.size() == 0) {
            return;
        }
        for (ChartDataViewSeries chartDataViewSeries : list) {
            if (!chartDataViewSeries.isVisible()) continue;
            ++this.numActiveDataSeries;
        }
        this.usingDoublePixels = this.dataObject.isUsingDoublePixels();
        this.drawFront = this.chartArea == null || !this.chartArea.getDraw3D() || this.dataObject.is3DChartType() || this.dataObject.getXAxis().frontPlane && this.dataObject.getYAxis().frontPlane && this.dataObject.getDrawFrontPlane();
    }

    public void recalc(int n2, int n3) {
    }

    public void draw(Graphics graphics, int n2, int n3) {
    }

    protected Color getLineColor(double d2, double d3, double d4, double d5, JCLineStyle jCLineStyle) {
        JCDrawableColorHandler jCDrawableColorHandler;
        Color color = null;
        JCDrawableColorHandler jCDrawableColorHandler2 = jCDrawableColorHandler = this.dataObject == null ? null : this.dataObject.getColorHandler();
        if (jCDrawableColorHandler != null && (color = jCDrawableColorHandler.getColor(d2, d3, d4, d5)) == null) {
            color = jCLineStyle.getColor();
        }
        return color;
    }

    protected Color getSymbolColor(double d2, double d3) {
        JCDrawableColorHandler jCDrawableColorHandler;
        Color color = null;
        JCDrawableColorHandler jCDrawableColorHandler2 = jCDrawableColorHandler = this.dataObject == null ? null : this.dataObject.getColorHandler();
        if (jCDrawableColorHandler != null) {
            color = jCDrawableColorHandler.getColor(d2, d3);
        }
        return color;
    }

    public void setChanged(boolean bl, int n2) {
        super.setChanged(bl, n2);
        if (!this.changed && this.dataObject != null) {
            this.dataObject.setChanged(false, 0, false);
        }
    }

    public void setChanged(boolean bl, int n2, boolean bl2) {
        if (bl2) {
            this.setChanged(bl, n2);
        } else {
            this.changed = bl;
            if (!this.changed && this.dataObject != null) {
                this.dataObject.setChanged(false, 0, false);
            }
        }
    }

    protected void calcTransientData() {
    }

    public JCDataIndex pick(Point point, int n2) {
        return null;
    }

    public JCDataIndex pickSeries(Point point, int n2) {
        return this.pick(point, n2);
    }

    public Point unpick(int n2, int n3) {
        return null;
    }

    public Point calcDataIndexPosition(JCChartLabel jCChartLabel, JCDataIndex jCDataIndex, int n2) {
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
    }

    void showEdit(JCDataIndex jCDataIndex, int n2, int n3) {
    }

    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        return -1;
    }

    public int getNumSeriesPerData() {
        return 1;
    }

    protected boolean isHoleValue(double d2, boolean bl) {
        return d2 == this.holeValue || bl && d2 <= 0.0;
    }

    protected AxisHandler.ClusterAdjustment getClusterAdjustment(double d2, double d3) {
        if (d2 < d3) {
            return AxisHandler.ClusterAdjustment.LEFT;
        }
        if (d2 > d3) {
            return AxisHandler.ClusterAdjustment.RIGHT;
        }
        return AxisHandler.ClusterAdjustment.NONE;
    }

    protected double calcDistanceToLine(Point2D.Double double_, int n2, int n3, int n4, int n5, int n6) {
        double d2;
        switch (n6) {
            case 1: {
                double d3 = this.inverted ? double_.getY() : double_.getX();
                d2 = Math.min(Math.abs((double)n2 - d3), Math.abs((double)n4 - d3));
                break;
            }
            default: {
                Point2D.Double double_2 = this.inverted ? new Point2D.Double(n3, n2) : new Point2D.Double(n2, n3);
                Point2D.Double double_3 = this.inverted ? new Point2D.Double(n5, n4) : new Point2D.Double(n4, n5);
                d2 = JCChartUtil.getDistanceToVector(double_2, double_3, double_);
            }
        }
        return d2;
    }

    protected void financialClip(double d2, double d3, double d4, double d5, MinMax minMax, MinMax minMax2, PlotPoint[] plotPointArray, boolean bl, boolean bl2) {
        boolean bl3;
        double d6 = minMax.min;
        double d7 = minMax.max;
        double d8 = minMax2.min;
        double d9 = minMax2.max;
        boolean bl4 = true;
        boolean bl5 = true;
        double d10 = this.dataObject.getHoleValue();
        if (d3 == d10 || d2 == d10 || d5 == d10 || d4 == d10) {
            return;
        }
        boolean bl6 = d2 == d4;
        boolean bl7 = bl3 = d3 == d5;
        if (!bl6 && !bl3) {
            return;
        }
        if ((d3 < d8 && d5 < d8 || d3 > d9 && d5 > d9) && (!bl3 || !bl2)) {
            return;
        }
        if (d3 < d8) {
            d3 = d8;
            bl4 = false;
        } else if (d3 > d9) {
            d3 = d9;
            bl4 = false;
        }
        if (d5 < d8) {
            d5 = d8;
            bl5 = false;
        } else if (d5 > d9) {
            d5 = d9;
            bl5 = false;
        }
        if (d2 < d6 && d4 < d6 || d2 > d7 && d4 > d7) {
            return;
        }
        if (d2 < d6) {
            d2 = d6;
            bl4 = false;
        } else if (d2 > d7) {
            d2 = d7;
            bl4 = false;
        }
        if (d4 < d6) {
            d4 = d6;
            bl5 = false;
        } else if (d4 > d7) {
            d4 = d7;
            bl5 = false;
        }
        this.addClippedPoint(plotPointArray, 0, d2, d3, this.xaxis, this.yaxis, bl, bl4);
        this.addClippedPoint(plotPointArray, 1, d4, d5, this.xaxis, this.yaxis, bl, bl5);
    }

    protected void addClippedPoint(PlotPoint[] plotPointArray, int n2, double d2, double d3, JCAxis jCAxis, JCAxis jCAxis2, boolean bl, boolean bl2) {
        if (jCAxis.isPolarRadar() || jCAxis2.isPolarRadar()) {
            return;
        }
        PlotPoint plotPoint = plotPointArray[n2];
        if (bl) {
            if (this.usingDoublePixels) {
                plotPoint.px = jCAxis2.toPixelDouble(d3, this.drawFront);
                plotPoint.py = jCAxis.toPixelDouble(d2, this.drawFront);
            } else {
                plotPoint.px = jCAxis2.toPixel(d3, this.drawFront);
                plotPoint.py = jCAxis.toPixel(d2, this.drawFront);
            }
        } else if (this.usingDoublePixels) {
            plotPoint.px = jCAxis.toPixelDouble(d2, this.drawFront);
            plotPoint.py = jCAxis2.toPixelDouble(d3, this.drawFront);
        } else {
            plotPoint.px = jCAxis.toPixel(d2, this.drawFront);
            plotPoint.py = jCAxis2.toPixel(d3, this.drawFront);
        }
        plotPoint.drawPoint = bl2;
        plotPoint.valid = true;
    }

    protected int tryDrawYAxisTroughGrid(Graphics graphics, int n2, int n3, JCAxis jCAxis, int n4, int n5) {
        boolean bl = false;
        boolean bl2 = false;
        if (!this.inverted && n2 > 0 || this.inverted && n3 > 0) {
            if (n4 > jCAxis.linePosition()) {
                if (jCAxis.isVisible() && jCAxis.gridVisible) {
                    jCAxis.drawGridInTrough(graphics, Double.MAX_VALUE, Double.MAX_VALUE);
                }
                jCAxis.postDrawOutlineTrough(graphics, 3);
                bl = true;
            } else if (n5 > jCAxis.linePosition()) {
                if (jCAxis.isVisible() && jCAxis.gridVisible) {
                    jCAxis.drawGridInTrough(graphics, Double.MAX_VALUE, Double.MAX_VALUE);
                }
                bl2 = true;
                bl = true;
            }
        } else if (n5 < jCAxis.linePosition()) {
            if (jCAxis.isVisible() && jCAxis.gridVisible) {
                jCAxis.drawGridInTrough(graphics, Double.MAX_VALUE, Double.MAX_VALUE);
            }
            jCAxis.postDrawOutlineTrough(graphics, 3);
            bl = true;
        } else if (n4 < jCAxis.linePosition()) {
            if (jCAxis.isVisible() && jCAxis.gridVisible) {
                jCAxis.drawGridInTrough(graphics, Double.MAX_VALUE, Double.MAX_VALUE);
            }
            bl2 = true;
            bl = true;
        }
        return bl2 ? 2 : (bl ? 1 : 0);
    }

    protected void finishDrawYAxisTroughGrid(Graphics graphics, int n2, int n3, JCAxis jCAxis, boolean bl, double d2, double d3) {
        if (!this.inverted && !bl && n3 >= 0 || !this.inverted && bl && n3 < 0 || this.inverted && !bl && n2 < 0 || this.inverted && bl && n2 >= 0) {
            if (jCAxis.isVisible() && jCAxis.gridVisible) {
                jCAxis.drawGridInTrough(graphics, -1.7976931348623157E308, Math.min(d2, d3));
            }
            jCAxis.postDrawOutlineTrough(graphics, 2);
        } else {
            if (jCAxis.isVisible() && jCAxis.gridVisible) {
                jCAxis.drawGridInTrough(graphics, Math.max(d3, d2), Double.MAX_VALUE);
            }
            jCAxis.postDrawOutlineTrough(graphics, 1);
        }
    }

    protected int drawXAxisTroughGrid(Graphics graphics, int n2, int n3, JCAxis jCAxis, boolean bl, double d2, int n4, int n5, double d3, double d4, double[] dArray, int n6, int n7, JCLineStyle jCLineStyle) {
        int n8;
        int n9;
        boolean bl2 = this.isDrawOverBar(this.inverted, bl, n3, n2, d2, d4, d3);
        if (!this.inverted && n2 > 0 || this.inverted && n3 > 0) {
            n9 = n4;
            n8 = n5;
        } else {
            n9 = n5;
            n8 = n4;
        }
        double d5 = n7 == 1 ? jCAxis.getMin() : jCAxis.getMax();
        while (n6 >= 0 && n6 < dArray.length && dArray[n6] == Double.MAX_VALUE) {
            n6 += n7;
        }
        boolean bl3 = jCLineStyle.updateGraphics(graphics);
        if (!this.inverted && n2 > 0 || this.inverted && n3 > 0) {
            while (n6 >= 0 && n6 < dArray.length && jCAxis.toPixel(dArray[n6], this.drawFront) <= (bl2 ? n9 : n8)) {
                if (bl3) {
                    jCAxis.drawGridLineInTrough(graphics, jCLineStyle, dArray[n6]);
                }
                if (dArray[n6] == d5) {
                    jCLineStyle.resetGraphics(graphics);
                    if (n7 == 1) {
                        jCAxis.postDrawOutlineTrough(graphics, 1);
                    } else {
                        jCAxis.postDrawOutlineTrough(graphics, 2);
                    }
                    jCLineStyle.updateGraphics(graphics);
                }
                n6 += n7;
            }
        } else {
            while (n6 >= 0 && n6 < dArray.length && jCAxis.toPixel(dArray[n6], this.drawFront) > (bl2 ? n9 : n8)) {
                if (bl3) {
                    jCAxis.drawGridLineInTrough(graphics, jCLineStyle, dArray[n6]);
                }
                if (dArray[n6] == d5) {
                    jCLineStyle.resetGraphics(graphics);
                    if (n7 == 1) {
                        jCAxis.postDrawOutlineTrough(graphics, 1);
                    } else {
                        jCAxis.postDrawOutlineTrough(graphics, 2);
                    }
                    jCLineStyle.updateGraphics(graphics);
                }
                n6 += n7;
            }
        }
        jCLineStyle.resetGraphics(graphics);
        return n6;
    }

    protected boolean isDrawOverBar(boolean bl, boolean bl2, int n2, int n3, double d2, double d3, double d4) {
        return !bl && !bl2 && n2 <= 0 || !bl && bl2 && n2 > 0 || bl && !bl2 && n3 > 0 || bl && bl2 && n3 <= 0 ? d2 >= d3 && d2 >= d4 : d2 <= d3 && d2 <= d4;
    }

    protected boolean isDrawFinalGridAndTrough(BarPoint barPoint, boolean bl, boolean bl2, int n2, int n3) {
        if (bl) {
            return true;
        }
        if (barPoint != null && barPoint.front != null) {
            int n4;
            int n5;
            if (bl2) {
                n5 = barPoint.front.y + barPoint.front.height;
                n4 = barPoint.front.y;
            } else {
                n4 = barPoint.front.x;
                n5 = barPoint.front.x + barPoint.front.width;
            }
            int n6 = Math.max(n2, n3);
            int n7 = Math.min(n2, n3);
            return n4 <= n6 && n5 <= n6 && n4 >= n7 && n5 >= n7;
        }
        return true;
    }

    protected void finalDrawAxisTroughGrid(Graphics graphics, JCAxis jCAxis, JCAxis jCAxis2, boolean bl, boolean bl2, double[] dArray, int n2, int n3, JCLineStyle jCLineStyle) {
        if (!bl2 && jCAxis2.isVisible() && jCAxis2.gridVisible) {
            jCAxis2.drawGridInTrough(graphics, Double.MAX_VALUE, Double.MAX_VALUE);
        }
        if (jCAxis.isVisible() && jCAxis.gridVisible) {
            boolean bl3 = jCLineStyle.updateGraphics(graphics);
            while (n2 >= 0 && n2 < dArray.length && dArray[n2] == Double.MAX_VALUE) {
                n2 += n3;
            }
            while (n2 >= 0 && n2 < dArray.length) {
                if (bl3) {
                    jCAxis.drawGridLineInTrough(graphics, jCLineStyle, dArray[n2]);
                }
                n2 += n3;
            }
            jCLineStyle.resetGraphics(graphics);
        }
        if (!bl2) {
            jCAxis2.postDrawOutlineTrough(graphics, 3);
        }
        if (!bl) {
            jCAxis.postDrawOutlineTrough(graphics, 2);
        } else {
            jCAxis.postDrawOutlineTrough(graphics, 1);
        }
    }

    public boolean isDrawingOnFront() {
        return this.drawFront;
    }

    protected boolean hasTimeExclusions() {
        return this.xaxis != null && this.xaxis.hasTimeExclusions();
    }

    protected boolean checkTimeBase() {
        boolean bl = true;
        if (this.hasTimeExclusions()) {
            Date date = this.xaxis.getTimeBase();
            long l2 = this.xaxis.getTimeUnit();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            if (l2 == 86400000L) {
                bl = calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0;
            } else if (l2 == 3600000L) {
                bl = calendar.get(12) == 0 && calendar.get(13) == 0;
            } else if (l2 == 60000L) {
                boolean bl2 = bl = calendar.get(13) == 0;
            }
            if (!bl) {
                JCChartDateFormat jCChartDateFormat = this.xaxis.getAnnotationHandler().getDateFormatter();
                jCChartDateFormat.roundTime(date, l2, JCChartDateFormat.AdjustType.ZERO);
                JCChart jCChart = (JCChart)this.chartArea.getParent();
                if (jCChart != null) {
                    String string = "Time base has been rounded down to the current time unit.";
                    jCChart.getErrorLog().logErrorMessage(string);
                }
            }
        }
        return bl;
    }

    protected Point[] copyPointArray(Point[] pointArray) {
        if (pointArray == null) {
            return null;
        }
        int n2 = pointArray.length;
        Point[] pointArray2 = new Point[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            pointArray2[i2] = new Point(pointArray[i2].x, pointArray[i2].y);
        }
        return pointArray2;
    }

    protected Point[] getTranslatedPoints(Point[] pointArray, int n2, int n3) {
        Point[] pointArray2 = new Point[pointArray.length];
        if (pointArray.length > 0) {
            pointArray2[0] = new Point(pointArray[0].x + n2, pointArray[0].y + n3);
            for (int i2 = 1; i2 < pointArray2.length; ++i2) {
                pointArray2[i2] = new Point(pointArray[i2].x, pointArray[i2].y);
            }
        }
        return pointArray2;
    }
}

