/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AxisHandler;
import com.klg.jclass.chart.BarPoint;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCAbstractThreshold;
import com.klg.jclass.chart.JCBarChartFormat;
import com.klg.jclass.chart.JCChartLabel;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCDataThreshold;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.OutlineConfigurable;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarChartDraw
extends ChartDraw {
    public static final int SIDE_0 = 1;
    public static final int SIDE_1 = 2;
    public static final int SIDE_2 = 4;
    public static final int SIDE_3 = 8;
    public static final int OUTLINE_SENSITIVITY = 3;
    protected Point firstLast = null;
    protected JCLineStyle outlineStyle = null;
    protected boolean x_reversed = false;
    protected boolean y_reversed = false;
    protected boolean switch_order = false;
    protected int delta_x = 0;
    protected int delta_y = 0;
    protected double xAxisPos = Double.MAX_VALUE;
    protected double[] xGridLineList = null;
    protected JCLineStyle gridLineStyle = null;
    protected boolean fastAction = false;
    protected boolean inAction = false;
    protected double yOrigin = 0.0;
    protected transient BarPoint[][] pts = null;
    protected double bar_base;
    protected int top;
    protected int bottom;
    protected int left;
    protected int right;
    protected boolean is_3d = false;
    protected boolean drawOutline = true;
    Rectangle r = null;
    boolean editInverted = false;
    Point start = null;
    Point end = null;

    @Override
    public void recalc() {
        super.recalc();
        JCBarChartFormat jCBarChartFormat = (JCBarChartFormat)this.dataObject.getChartFormat();
        if (jCBarChartFormat == null || jCBarChartFormat.clusterWidth == 0) {
            this.pts = null;
            return;
        }
        this.delta_x = this.chartArea.getDeltaX();
        this.delta_y = this.chartArea.getDeltaY();
        this.is_3d = this.delta_x != 0 || this.delta_y != 0;
        int n2 = jCBarChartFormat.clusterOverlap;
        if (this.is_3d && n2 > 0) {
            n2 = 0;
        }
        if (this.dataObject.getXLimits() == null) {
            return;
        }
        if (this.dataObject.getYLimits() == null) {
            return;
        }
        MinMax minMax = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
        MinMax minMax2 = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
        this.dataObject.getDataBounds(minMax, minMax2);
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        if (this.xaxis == null || this.yaxis == null) {
            return;
        }
        double d2 = 1.0 - (double)n2 / 100.0;
        double d3 = this.numActiveDataSeries;
        d3 = (d3 - 1.0) * d2 + 1.0;
        this.bar_base = this.dataObject.step * (double)jCBarChartFormat.clusterWidth / (d3 * 100.0);
        double d4 = d3 * this.bar_base / 2.0;
        double d5 = d2 * this.bar_base;
        this.inverted = this.xaxis.i_vertical;
        minMax.min -= d4;
        minMax.max += d4;
        this.xaxis.setLimits(minMax);
        this.xaxis.calcTransformation();
        this.xaxis.layoutAnnotations();
        this.xaxis.checkAnnotations();
        minMax2.min = JCChartUtil.min(this.yaxis.origin.value, minMax2.min);
        minMax2.max = JCChartUtil.max(this.yaxis.origin.value, minMax2.max);
        this.yaxis.setLimits(minMax2);
        this.yaxis.calcTransformation();
        minMax = this.xaxis.dataLimits;
        boolean bl = this.xaxis.isLogarithmic();
        boolean bl2 = this.yaxis.isLogarithmic();
        int n3 = this.inverted ? this.yaxis.getWidth() : this.xaxis.getHeight();
        int n4 = this.inverted ? this.xaxis.getWidth() : this.yaxis.getHeight();
        this.left = this.inverted ? this.yaxis.getLeft() : this.xaxis.getLeft();
        this.right = this.left + n3 - 1;
        this.top = this.inverted ? this.xaxis.getTop() : this.yaxis.getTop();
        this.bottom = this.top + n4 - 1;
        this.firstLast = this.dataObject.getFirstLast();
        if (this.firstLast == null) {
            return;
        }
        this.seriesList = this.dataObject.getSeries();
        int n5 = this.seriesList.size();
        this.holeValue = this.dataObject.getHoleValue();
        this.pts = new BarPoint[this.firstLast.y - this.firstLast.x + 1][n5];
        this.yOrigin = this.yaxis.origin.value;
        int n6 = this.yaxis.toPixel(this.yOrigin, this.drawFront);
        this.x_reversed = this.xaxis.isReversed();
        this.y_reversed = this.yaxis.reversed;
        this.switch_order = this.inverted ? this.delta_y > 0 ^ this.x_reversed : this.delta_x <= 0 ^ this.x_reversed;
        this.fastAction = this.chartArea.getFastAction();
        this.inAction = this.chartArea.getInAction();
        if (!this.fastAction || !this.inAction) {
            this.xAxisPos = this.xaxis.getRealPlacementLocation();
            this.xGridLineList = this.xaxis.getGridLineList();
            if (this.xGridLineList == null) {
                this.xGridLineList = new double[0];
            }
            this.gridLineStyle = this.xaxis.getGridStyle().getLineStyle();
        }
        ArrayList<JCDataThreshold>[] arrayListArray = this.getDataThresholdLists();
        double d6 = this.xaxis.min.value;
        double d7 = this.xaxis.max.value;
        if (this.hasTimeExclusions()) {
            this.checkTimeBase();
            AxisHandler axisHandler = this.xaxis.getAxisHandler();
            d6 = axisHandler.adjustValueForward(d6, this.xaxis.max.value);
            d7 = axisHandler.adjustValueBackward(d7, this.xaxis.min.value);
        }
        int n7 = this.xaxis.toPixel(d6, this.drawFront);
        int n8 = this.xaxis.toPixel(d6 + this.bar_base, this.drawFront);
        this.drawOutline = Math.abs(n8 - n7) > 3;
        for (int i2 = this.firstLast.x; i2 <= this.firstLast.y; ++i2) {
            int n9 = 0;
            for (int i3 = 0; i3 < this.seriesList.size(); ++i3) {
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                double d8;
                BarPoint[] barPointArray = this.pts[i2 - this.firstLast.x];
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(i3);
                if (!chartDataViewSeries.isVisible()) continue;
                double d9 = chartDataViewSeries.getX(i2);
                double d10 = d9 - d4;
                double d11 = d10 + (double)n9 * d5;
                double d12 = d11 + this.bar_base;
                double d13 = this.bar_base;
                ++n9;
                if (d11 < d6 && d12 <= d6 || d11 >= d7 && d12 > d7) continue;
                barPointArray[i3] = new BarPoint();
                barPointArray[i3].x = d11;
                if (minMax != null && (d12 <= minMax.min || d11 >= minMax.max)) {
                    barPointArray[i3].x = this.holeValue;
                }
                if (d11 < d6 && d12 >= d6 && d12 < d7) {
                    barPointArray[i3].x = d6;
                    d13 = Math.max(0.0, this.bar_base - (d6 - d11));
                }
                if (d9 == this.holeValue || bl && d9 <= 0.0) {
                    barPointArray[i3].x = this.holeValue;
                }
                barPointArray[i3].y = (d8 = chartDataViewSeries.getY(i2)) == this.holeValue || bl2 && d8 <= 0.0 ? this.holeValue : d8;
                BarPoint barPoint = barPointArray[i3];
                barPoint.front = null;
                barPoint.top = null;
                barPoint.side = null;
                if (this.hasTimeExclusions() && this.xaxis.toPixel(d9, this.drawFront) == Integer.MAX_VALUE) continue;
                double d14 = barPoint.x + d13;
                if (this.inverted) {
                    n14 = this.xaxis.toPixel(barPoint.x, this.drawFront);
                    if (n14 != Integer.MAX_VALUE && n14 > n7 ^ this.x_reversed) continue;
                    n13 = this.xaxis.toPixel(d14, this.drawFront);
                    if (this.hasTimeExclusions()) {
                        if (n14 == Integer.MAX_VALUE) {
                            n14 = this.xaxis.toPixelInternal(barPoint.x, this.drawFront, this.getClusterAdjustment(barPoint.x, d9));
                        }
                        if (n13 == Integer.MAX_VALUE) {
                            n13 = this.xaxis.toPixelInternal(d14, this.drawFront, this.getClusterAdjustment(d14, d9));
                        }
                    }
                    n12 = n14 - n13;
                    n11 = this.yaxis.toPixel(barPoint.y, this.drawFront);
                    n10 = n11 - n6;
                } else {
                    n11 = this.xaxis.toPixel(barPoint.x, this.drawFront);
                    if (n11 != Integer.MAX_VALUE && n11 < n7 ^ this.x_reversed) continue;
                    n13 = this.xaxis.toPixel(d14, this.drawFront);
                    if (this.hasTimeExclusions()) {
                        if (n11 == Integer.MAX_VALUE) {
                            n11 = this.xaxis.toPixelInternal(barPoint.x, this.drawFront, this.getClusterAdjustment(barPoint.x, d9));
                        }
                        if (n13 == Integer.MAX_VALUE) {
                            n13 = this.xaxis.toPixelInternal(d14, this.drawFront, this.getClusterAdjustment(d14, d9));
                        }
                    }
                    n10 = n13 - n11;
                    n14 = this.yaxis.toPixel(barPoint.y, this.drawFront);
                    n12 = n6 - n14;
                }
                n13 = (this.inverted ? (n10 >= 0 ? 1 : 0) : (n12 >= 0 ? 1 : 0)) ^ this.y_reversed;
                ArrayList<JCDataThreshold> arrayList = arrayListArray[i3];
                if (arrayList != null && arrayList.size() > 1) {
                    Collections.sort(arrayList, new ThresholdAscending(i2));
                }
                boolean bl3 = this.inverted ? n10 >= 0 ^ this.delta_x > 0 : (barPoint.opposite = n12 >= 0 ^ this.delta_y <= 0);
                if (this.is_3d && barPoint.x != this.holeValue && barPoint.y != this.holeValue) {
                    int n15;
                    int n16;
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = new Point[4];
                    pointArray[0] = new Point(0, 0);
                    pointArray[1] = new Point(this.delta_x, this.delta_y);
                    pointArray[2] = new Point(0, 0);
                    pointArray[3] = new Point(-this.delta_x, -this.delta_y);
                    pointArray2[0] = new Point(0, 0);
                    pointArray2[1] = new Point(this.delta_x, this.delta_y);
                    pointArray2[2] = new Point(0, 0);
                    pointArray2[3] = new Point(-this.delta_x, -this.delta_y);
                    if (this.inverted) {
                        pointArray[0].y = this.switch_order ? n14 : n14 - n12;
                        pointArray2[0].y = n14 - n12;
                        pointArray2[2].y = n12;
                    } else {
                        pointArray[0].x = n11;
                        pointArray[2].x = n10;
                        pointArray2[0].x = this.switch_order ? n11 : n11 + n10;
                    }
                    int n17 = n16 = this.inverted ? n11 : n14;
                    if (!chartDataViewSeries.isDataThresholdEntireValue()) {
                        ThresholdIterator thresholdIterator = new ThresholdIterator(arrayList, n13 != 0, i2, barPoint.y);
                        while (thresholdIterator.hasNext()) {
                            int n18;
                            JCDataThreshold jCDataThreshold = thresholdIterator.next();
                            double d15 = jCDataThreshold.getYValue(i2);
                            int n19 = this.yaxis.toPixel(d15, this.drawFront);
                            if (n19 == n16) continue;
                            BarPoint barPoint2 = new BarPoint(d9, d15);
                            barPoint2.work = jCDataThreshold;
                            int n20 = barPoint.opposite ? n19 : n16;
                            int n21 = n18 = barPoint.opposite ? n16 : n19;
                            if (this.inverted) {
                                pointArray[0].x = n18;
                                pointArray[2].x = n20 - n18;
                                pointArray2[0].x = n20;
                            } else {
                                pointArray[0].y = n20;
                                pointArray2[0].y = n18;
                                pointArray2[2].y = n20 - n18;
                            }
                            n16 = n19;
                            barPoint2.top = this.copyPointArray(pointArray);
                            barPoint2.side = this.copyPointArray(pointArray2);
                            if (barPoint.thresholds == null) {
                                barPoint.thresholds = new ArrayList<BarPoint>();
                            }
                            barPoint.thresholds.add(barPoint2);
                        }
                    }
                    int n22 = barPoint.opposite ? n6 : n16;
                    int n23 = n15 = barPoint.opposite ? n16 : n6;
                    if (this.inverted) {
                        pointArray[0].x = n15;
                        pointArray[2].x = n22 - n15;
                        pointArray2[0].x = n22;
                    } else {
                        pointArray[0].y = n22;
                        pointArray2[0].y = n15;
                        pointArray2[2].y = n22 - n15;
                    }
                    barPoint.top = pointArray;
                    barPoint.side = pointArray2;
                }
                if (this.inverted) {
                    if (n12 < 0) {
                        n12 = -n12;
                        n14 -= n12;
                    }
                    n12 = Math.max(1, n12);
                } else {
                    if (n10 < 0) {
                        n10 = -n10;
                        n11 -= n10;
                    }
                    n10 = Math.max(1, n10);
                }
                int n24 = 0;
                int n25 = this.inverted ? n11 : n14;
                ThresholdIterator thresholdIterator = new ThresholdIterator(arrayList, n13 != 0, i2, barPoint.y);
                if (chartDataViewSeries.isDataThresholdEntireValue()) {
                    barPoint.work = thresholdIterator.next();
                } else {
                    while (thresholdIterator.hasNext()) {
                        BarPoint barPoint3;
                        JCDataThreshold jCDataThreshold = thresholdIterator.next();
                        double d16 = jCDataThreshold.getYValue(i2);
                        int n26 = this.yaxis.toPixel(d16, this.drawFront);
                        if (n26 == n25) continue;
                        if (barPoint.thresholds != null && n24 < barPoint.thresholds.size()) {
                            barPoint3 = barPoint.thresholds.get(n24);
                        } else {
                            if (barPoint.thresholds == null) {
                                barPoint.thresholds = new ArrayList<BarPoint>();
                            }
                            barPoint3 = new BarPoint(d9, d16);
                            barPoint3.work = jCDataThreshold;
                            barPoint.thresholds.add(barPoint3);
                        }
                        ++n24;
                        barPoint3.front = this.inverted ? new Rectangle(Math.min(n25, n26), this.x_reversed ? n14 + n12 : n14 - n12, Math.abs(n26 - n25), n12) : new Rectangle(n11, Math.min(n25, n26), n10, Math.abs(n26 - n25));
                        n25 = n26;
                    }
                }
                barPoint.front = this.inverted ? new Rectangle(Math.min(n25, n6), this.x_reversed ? n14 + n12 : n14 - n12, Math.abs(n6 - n25), n12) : new Rectangle(n11, Math.min(n25, n6), n10, Math.abs(n6 - n25));
            }
        }
    }

    protected ArrayList<JCDataThreshold>[] getDataThresholdLists() {
        ArrayList[] arrayListArray = new ArrayList[this.seriesList.size()];
        for (int i2 = 0; i2 < this.seriesList.size(); ++i2) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(i2);
            List<JCDataThreshold> list = chartDataViewSeries.getDataThresholds();
            if (list == null || list.size() <= 0) continue;
            arrayListArray[i2] = new ArrayList<JCDataThreshold>(list);
        }
        return arrayListArray;
    }

    @Override
    public void draw(Graphics graphics) {
        int n2;
        if (this.firstLast == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        if (this.pts == null) {
            try {
                this.recalc();
                if (this.pts == null) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.is_3d) {
            int n3;
            boolean bl;
            int n4;
            int n5;
            boolean bl2 = false;
            boolean bl3 = false;
            int n6 = 0;
            int n7 = this.seriesList.size() - 1;
            if (this.switch_order) {
                n2 = this.firstLast.y;
                n5 = n7;
                n4 = -1;
                bl = n2 >= this.firstLast.x;
                n3 = this.xGridLineList.length - 1;
            } else {
                n2 = this.firstLast.x;
                n5 = n6;
                n4 = 1;
                bl = n2 <= this.firstLast.y;
                n3 = 0;
            }
            BarPoint barPoint = null;
            int n8 = n2;
            while (bl) {
                boolean bl4 = this.switch_order ? n5 >= n6 : n5 <= n7;
                int n9 = n5;
                while (bl4) {
                    ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n9);
                    BarPoint barPoint2 = null;
                    try {
                        barPoint2 = this.pts[n8 - this.firstLast.x][n9];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (!(barPoint2 == null || barPoint2.front == null || this.fastAction && this.inAction)) {
                        int n10;
                        int n11;
                        if (this.inverted) {
                            n11 = barPoint2.front.y + barPoint2.front.height;
                            n10 = barPoint2.front.y;
                        } else {
                            n10 = barPoint2.front.x;
                            n11 = barPoint2.front.x + barPoint2.front.width;
                        }
                        if (!bl2) {
                            int n12 = this.tryDrawYAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.yaxis, n10, n11);
                            if (n12 == 1) {
                                bl2 = true;
                            } else if (n12 == 2) {
                                bl3 = true;
                                bl2 = true;
                            }
                        }
                        if (this.xaxis.gridVisible) {
                            n3 = this.drawXAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.xaxis, this.y_reversed, this.xAxisPos, n10, n11, barPoint2.y, this.yOrigin, this.xGridLineList, n3, n4, this.gridLineStyle);
                        }
                    }
                    if (barPoint2 != null && barPoint2.x != this.holeValue && barPoint2.y != this.holeValue && !chartDataViewSeries.getStyle().getFillStyle().isCustomStackable()) {
                        this.drawBar3dShadows(graphics, barPoint2, n8, n9);
                        barPoint = barPoint2;
                        if (bl3) {
                            this.finishDrawYAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.yaxis, this.y_reversed, barPoint2.y, this.yOrigin);
                            bl3 = false;
                        }
                    }
                    bl4 = this.switch_order ? n9 > n6 : n9 < n7;
                    n9 += n4;
                }
                bl = this.switch_order ? n8 > this.firstLast.x : n8 < this.firstLast.y;
                n8 += n4;
            }
            if (!this.fastAction || !this.inAction) {
                n8 = 1;
                if (barPoint != null) {
                    n8 = this.isDrawFinalGridAndTrough(barPoint, this.isDrawOverBar(this.inverted, this.y_reversed, this.delta_y, this.delta_x, this.xAxisPos, barPoint.y, this.yOrigin), this.inverted, this.xaxis.toPixel(this.xaxis.max.value, this.drawFront), this.xaxis.toPixel(this.xaxis.min.value, this.drawFront)) ? 1 : 0;
                }
                if (n8 != 0) {
                    this.finalDrawAxisTroughGrid(graphics, this.xaxis, this.yaxis, this.switch_order, bl2, this.xGridLineList, n3, n4, this.gridLineStyle);
                }
            }
        }
        for (int i2 = 0; i2 < this.seriesList.size(); ++i2) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(i2);
            if (!chartDataViewSeries.isVisible()) continue;
            for (n2 = this.firstLast.x; n2 <= this.firstLast.y; ++n2) {
                BarPoint barPoint = null;
                try {
                    barPoint = this.pts[n2 - this.firstLast.x][i2];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (barPoint == null || barPoint.front == null || barPoint.x == this.holeValue || barPoint.y == this.holeValue) continue;
                this.drawBarFront(graphics, barPoint, n2, i2);
            }
        }
    }

    protected void drawBarFront(Graphics graphics, BarPoint barPoint, int n2, int n3) {
        Cloneable cloneable;
        Serializable serializable;
        boolean bl;
        if (barPoint == null || this.seriesList == null) {
            return;
        }
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
        int n4 = this.calcFillOrientation(barPoint.y, 0.0, this.inverted, this.y_reversed);
        boolean bl2 = bl = barPoint.y >= 0.0;
        if (barPoint.thresholds != null) {
            for (BarPoint object2 : barPoint.thresholds) {
                JCFillStyle jCFillStyle;
                serializable = (JCDataThreshold)object2.work;
                cloneable = ((JCAbstractThreshold)serializable).getChartStyle();
                JCFillStyle jCFillStyle2 = jCFillStyle = cloneable == null ? null : ((JCChartStyle)cloneable).getFillStyle();
                if (jCFillStyle == null) {
                    jCFillStyle = chartDataViewSeries.getStyle().getFillStyle();
                }
                this.setOutlineStyle(chartDataViewSeries, (JCDataThreshold)serializable);
                this.drawFront(graphics, object2.front, jCFillStyle, n2, chartDataViewSeries, bl, n4);
            }
        }
        Object object = chartDataViewSeries.getStyle().getFillStyle();
        if (barPoint.work instanceof JCDataThreshold) {
            JCDataThreshold jCDataThreshold = (JCDataThreshold)barPoint.work;
            serializable = jCDataThreshold.getChartStyle();
            Cloneable cloneable2 = cloneable = serializable == null ? null : ((JCChartStyle)serializable).getFillStyle();
            if (cloneable != null) {
                object = cloneable;
            }
            this.setOutlineStyle(chartDataViewSeries, jCDataThreshold);
        } else {
            this.setOutlineStyle(chartDataViewSeries, null);
        }
        this.drawFront(graphics, barPoint.front, (JCFillStyle)object, n2, chartDataViewSeries, bl, n4);
    }

    protected void drawFront(Graphics graphics, Rectangle rectangle, JCFillStyle jCFillStyle, int n2, ChartDataViewSeries chartDataViewSeries, boolean bl, int n3) {
        if (rectangle == null || jCFillStyle == null) {
            return;
        }
        if (jCFillStyle.isCustomStackable()) {
            jCFillStyle.fillImageRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl, this.inverted);
        } else {
            jCFillStyle.updateFillOrientation(new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), n3);
            DefineShape defineShape = null;
            if (graphics instanceof DefineShape) {
                defineShape = (DefineShape)((Object)graphics);
            }
            if (defineShape != null) {
                defineShape.beginShape(new JCDataIndex(n2, chartDataViewSeries));
            }
            jCFillStyle.fillRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (defineShape != null) {
                defineShape.endShape(true);
            }
            if (this.drawOutline) {
                jCFillStyle.drawOutlineRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.outlineStyle);
            }
            jCFillStyle.resetFillOrientation();
        }
    }

    private void setOutlineStyle(ChartDataViewSeries chartDataViewSeries, JCDataThreshold jCDataThreshold) {
        this.outlineStyle = this.dataObject.getOutlineStyle();
        OutlineConfigurable outlineConfigurable = (OutlineConfigurable)((Object)this.dataObject.getChartFormat(9));
        int n2 = outlineConfigurable.getOutlineStyle();
        if (n2 == 1) {
            JCLineStyle jCLineStyle;
            JCChartStyle jCChartStyle = chartDataViewSeries.getStyle();
            if (jCDataThreshold != null && jCDataThreshold.getChartStyle() != null) {
                jCChartStyle = jCDataThreshold.getChartStyle();
            }
            JCLineStyle jCLineStyle2 = jCLineStyle = jCChartStyle != null ? jCChartStyle.getLineStyle() : null;
            if (jCLineStyle != null) {
                this.outlineStyle = jCLineStyle;
            }
        } else if (n2 == 2) {
            this.outlineStyle = new JCLineStyle(1, this.chartArea.getForeground(), 1);
        }
    }

    protected void drawBar3dShadows(Graphics graphics, BarPoint barPoint, int n2, int n3) {
        Point[] pointArray;
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        if (barPoint == null || this.seriesList == null) {
            return;
        }
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
        int n4 = this.calcFillOrientation(barPoint.y, 0.0, this.inverted, this.y_reversed);
        if (barPoint.opposite && barPoint.thresholds != null) {
            object3 = barPoint.thresholds.listIterator(0);
            while (object3.hasNext()) {
                JCFillStyle jCFillStyle;
                object2 = (BarPoint)object3.next();
                object = (JCDataThreshold)((BarPoint)object2).work;
                serializable = ((JCAbstractThreshold)object).getChartStyle();
                JCFillStyle jCFillStyle2 = jCFillStyle = serializable == null ? null : ((JCChartStyle)serializable).getFillStyle();
                if (jCFillStyle == null) {
                    jCFillStyle = chartDataViewSeries.getStyle().getFillStyle();
                }
                this.setOutlineStyle(chartDataViewSeries, (JCDataThreshold)object);
                int n5 = this.delta_x <= 0 ? ((BarPoint)object2).front.width : -((BarPoint)object2).front.width;
                Point[] pointArray2 = this.getTranslatedPoints(((BarPoint)object2).side, n5, 0);
                pointArray = new JCFillStyle(null, 0);
                this.drawBarShadow(graphics, pointArray2, (JCFillStyle)pointArray, n2, chartDataViewSeries, n4, this.delta_x <= 0);
                int n6 = this.delta_y <= 0 ? ((BarPoint)object2).front.height : -((BarPoint)object2).front.height;
                Point[] pointArray3 = this.getTranslatedPoints(((BarPoint)object2).top, 0, n6);
                this.drawBarShadow(graphics, pointArray3, (JCFillStyle)pointArray, n2, chartDataViewSeries, n4, this.delta_y <= 0);
                this.drawBarShadow(graphics, ((BarPoint)object2).top, jCFillStyle, n2, chartDataViewSeries, n4, this.delta_y <= 0);
                this.drawBarShadow(graphics, ((BarPoint)object2).side, jCFillStyle, n2, chartDataViewSeries, n4, this.delta_x <= 0);
            }
        }
        object3 = chartDataViewSeries.getStyle().getFillStyle();
        if (barPoint.work instanceof JCDataThreshold) {
            object2 = (JCDataThreshold)barPoint.work;
            object = ((JCAbstractThreshold)object2).getChartStyle();
            Serializable serializable2 = serializable = object == null ? null : ((JCChartStyle)object).getFillStyle();
            if (serializable != null) {
                object3 = serializable;
            }
            this.setOutlineStyle(chartDataViewSeries, (JCDataThreshold)object2);
        } else {
            this.setOutlineStyle(chartDataViewSeries, null);
        }
        if (barPoint.front != null) {
            int n7 = this.delta_x <= 0 ? barPoint.front.width : -barPoint.front.width;
            object = this.getTranslatedPoints(barPoint.side, n7, 0);
            serializable = new JCFillStyle(null, 0);
            this.drawBarShadow(graphics, (Point[])object, (JCFillStyle)serializable, n2, chartDataViewSeries, n4, this.delta_x <= 0);
            int n8 = this.delta_y <= 0 ? barPoint.front.height : -barPoint.front.height;
            Point[] pointArray4 = this.getTranslatedPoints(barPoint.top, 0, n8);
            this.drawBarShadow(graphics, pointArray4, (JCFillStyle)serializable, n2, chartDataViewSeries, n4, this.delta_y <= 0);
        }
        this.drawBarShadow(graphics, barPoint.top, (JCFillStyle)object3, n2, chartDataViewSeries, n4, this.delta_y <= 0);
        this.drawBarShadow(graphics, barPoint.side, (JCFillStyle)object3, n2, chartDataViewSeries, n4, this.delta_x <= 0);
        if (!barPoint.opposite && barPoint.thresholds != null) {
            ListIterator<BarPoint> listIterator = barPoint.thresholds.listIterator(barPoint.thresholds.size());
            while (listIterator.hasPrevious()) {
                JCFillStyle jCFillStyle;
                object = listIterator.previous();
                serializable = (JCDataThreshold)((BarPoint)object).work;
                JCChartStyle jCChartStyle = ((JCAbstractThreshold)serializable).getChartStyle();
                JCFillStyle jCFillStyle3 = jCFillStyle = jCChartStyle == null ? null : jCChartStyle.getFillStyle();
                if (jCFillStyle == null) {
                    jCFillStyle = chartDataViewSeries.getStyle().getFillStyle();
                }
                this.setOutlineStyle(chartDataViewSeries, (JCDataThreshold)serializable);
                int n9 = this.delta_x <= 0 ? ((BarPoint)object).front.width : -((BarPoint)object).front.width;
                pointArray = this.getTranslatedPoints(((BarPoint)object).side, n9, 0);
                JCFillStyle jCFillStyle4 = new JCFillStyle(null, 0);
                this.drawBarShadow(graphics, pointArray, jCFillStyle4, n2, chartDataViewSeries, n4, this.delta_x <= 0);
                int n10 = this.delta_y <= 0 ? ((BarPoint)object).front.height : -((BarPoint)object).front.height;
                Point[] pointArray5 = this.getTranslatedPoints(((BarPoint)object).top, 0, n10);
                this.drawBarShadow(graphics, pointArray5, jCFillStyle4, n2, chartDataViewSeries, n4, this.delta_y <= 0);
                this.drawBarShadow(graphics, ((BarPoint)object).top, jCFillStyle, n2, chartDataViewSeries, n4, this.delta_y <= 0);
                this.drawBarShadow(graphics, ((BarPoint)object).side, jCFillStyle, n2, chartDataViewSeries, n4, this.delta_x <= 0);
            }
        }
    }

    protected void drawBarShadow(Graphics graphics, Point[] pointArray, JCFillStyle jCFillStyle, int n2, ChartDataViewSeries chartDataViewSeries, int n3, boolean bl) {
        if (pointArray != null && jCFillStyle != null) {
            Polygon polygon = JCChartUtil.pointsToPolygon(pointArray);
            jCFillStyle.updateFillOrientation(polygon.getBounds(), n3);
            DefineShape defineShape = null;
            if (graphics instanceof DefineShape) {
                defineShape = (DefineShape)((Object)graphics);
            }
            if (defineShape != null) {
                defineShape.beginShape(new JCDataIndex(n2, chartDataViewSeries));
            }
            if (JCChartUtil.isTransparentColor(jCFillStyle.getColor())) {
                jCFillStyle.fillPolygon(graphics, polygon);
            } else if (bl) {
                jCFillStyle.fillPolygonHighlight(graphics, polygon);
            } else {
                jCFillStyle.fillPolygonShadow(graphics, polygon);
            }
            if (defineShape != null) {
                defineShape.endShape(true);
            }
            if (this.drawOutline) {
                jCFillStyle.drawOutlinePolygon(graphics, polygon, this.outlineStyle);
            }
            jCFillStyle.resetFillOrientation();
        }
    }

    protected int calcFillOrientation(double d2, double d3, boolean bl, boolean bl2) {
        if (!bl) {
            if (!bl2 && d2 >= d3 || bl2 && d2 < d3) {
                return 2;
            }
            return 1;
        }
        if (!bl2 && d2 >= d3 || bl2 && d2 < d3) {
            return 3;
        }
        return 4;
    }

    @Override
    public JCDataIndex pick(Point point, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        int n7 = -1;
        int n8 = -1;
        JCDataIndex jCDataIndex = null;
        int n9 = Integer.MAX_VALUE;
        if (this.firstLast == null || this.pts == null) {
            return null;
        }
        if (this.is_3d) {
            boolean bl;
            int n10 = 0;
            int n11 = this.seriesList.size() - 1;
            if (this.switch_order) {
                n6 = this.firstLast.y;
                n5 = n11;
                n4 = -1;
                bl = n6 >= this.firstLast.x;
            } else {
                n6 = this.firstLast.x;
                n5 = n10;
                n4 = 1;
                bl = n6 <= this.firstLast.y;
            }
            int n12 = n6;
            while (bl) {
                n3 = this.switch_order ? (n5 >= n10 ? 1 : 0) : (n5 <= n11 ? 1 : 0);
                int n13 = n5;
                while (n3 != 0) {
                    BarPoint barPoint = null;
                    try {
                        barPoint = this.pts[n12 - this.firstLast.x][n13];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (barPoint != null) {
                        if (barPoint.thresholds != null) {
                            for (BarPoint barPoint2 : barPoint.thresholds) {
                                int n14 = JCChartUtil.distanceTo3dPolygon(point2.x, point2.y, barPoint2.top, this.inverted, n2);
                                int n15 = JCChartUtil.distanceTo3dPolygon(point2.x, point2.y, barPoint2.side, this.inverted, n2);
                                if (n14 > n9 && n15 > n9) continue;
                                n7 = n13;
                                n8 = n12;
                                n9 = Math.min(n15, n14);
                            }
                        }
                        int n16 = JCChartUtil.distanceTo3dPolygon(point2.x, point2.y, barPoint.top, this.inverted, n2);
                        int n17 = JCChartUtil.distanceTo3dPolygon(point2.x, point2.y, barPoint.side, this.inverted, n2);
                        if (n16 <= n9 || n17 <= n9) {
                            n7 = n13;
                            n8 = n12;
                            n9 = Math.min(n17, n16);
                        }
                    }
                    n3 = this.switch_order ? (n13 > n10 ? 1 : 0) : (n13 < n11 ? 1 : 0);
                    n13 += n4;
                }
                bl = this.switch_order ? n12 > this.firstLast.x : n12 < this.firstLast.y;
                n12 += n4;
            }
        }
        for (n6 = this.firstLast.x; n6 <= this.firstLast.y; ++n6) {
            n5 = n6 - this.firstLast.x;
            if (this.pts[n5] == null) continue;
            for (n4 = 0; n4 < this.pts[n5].length; ++n4) {
                int n18;
                Rectangle rectangle2;
                if (!((ChartDataViewSeries)this.seriesList.get(n4)).isVisible()) continue;
                BarPoint barPoint = null;
                try {
                    barPoint = this.pts[n5][n4];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (barPoint == null || barPoint.x == this.holeValue || barPoint.y == this.holeValue) continue;
                if (barPoint.thresholds != null) {
                    for (BarPoint barPoint3 : barPoint.thresholds) {
                        Rectangle rectangle3 = barPoint3.front;
                        if (rectangle3 == null || (n3 = JCChartUtil.distanceToFrontRect(point2.x, point2.y, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, this.inverted, n2)) > n9) continue;
                        n7 = n4;
                        n8 = n6;
                        n9 = n3;
                    }
                }
                if ((rectangle2 = barPoint.front) == null || (n18 = JCChartUtil.distanceToFrontRect(point2.x, point2.y, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, this.inverted, n2)) > n9) continue;
                n7 = n4;
                n8 = n6;
                n9 = n18;
            }
        }
        if (n7 >= 0 && n8 >= 0) {
            jCDataIndex = new JCDataIndex(n8, (ChartDataViewSeries)this.seriesList.get(n7), n7);
            jCDataIndex.distance = n9;
        }
        return jCDataIndex;
    }

    @Override
    public Point unpick(int n2, int n3) {
        if (this.pts == null) {
            return null;
        }
        BarPoint barPoint = null;
        try {
            barPoint = this.pts[n2 - this.firstLast.x][n3];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (barPoint == null || barPoint.front == null) {
            return null;
        }
        double d2 = barPoint.y;
        double d3 = barPoint.x;
        if (d2 != this.holeValue && d3 != this.holeValue) {
            int n4;
            int n5;
            if (this.inverted) {
                n5 = this.yaxis.toPixel(d2, this.drawFront);
                n4 = barPoint.front.y + barPoint.front.height / 2;
            } else {
                n4 = this.yaxis.toPixel(d2, this.drawFront);
                n5 = barPoint.front.x + barPoint.front.width / 2;
            }
            return new Point(n5, n4);
        }
        return null;
    }

    @Override
    void startEdit(JCDataIndex jCDataIndex) {
        this.r = this.chartArea.getDrawingArea();
        this.editInverted = jCDataIndex.dataView.getXAxis().i_vertical;
        this.end = null;
        this.start = null;
    }

    @Override
    void showEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        BarPoint barPoint = null;
        try {
            barPoint = this.pts[jCDataIndex.point - this.firstLast.x][jCDataIndex.series.getDrawingOrder()];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (barPoint == null) {
            return;
        }
        if (this.start == null || this.end == null) {
            this.start = new Point(0, 0);
            this.end = new Point(0, 0);
        } else {
            this.chartArea.drawRubberBand(this.end, this.start);
        }
        if (this.editInverted) {
            this.start.x = n2;
            this.start.y = barPoint.front.y + this.r.y;
            this.end.x = barPoint.front.x + this.r.x;
            this.end.y = barPoint.front.y + this.r.y + barPoint.front.height;
        } else {
            this.start.x = barPoint.front.x + this.r.x;
            this.start.y = n3;
            this.end.x = barPoint.front.x + this.r.x + barPoint.front.width;
            this.end.y = barPoint.front.height + barPoint.front.y + this.r.y;
        }
        this.chartArea.drawRubberBand(this.end, this.start);
    }

    @Override
    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberBand(this.end, this.start);
        return this.editInverted ? n2 - this.r.x : n3 - this.r.y;
    }

    @Override
    public Point calcDataIndexPosition(JCChartLabel jCChartLabel, JCDataIndex jCDataIndex, int n2) {
        if (jCChartLabel == null || jCChartLabel.getComponent() == null || jCDataIndex == null) {
            return null;
        }
        if (n2 < 1 || n2 > 3) {
            return null;
        }
        int n3 = jCDataIndex.getPoint();
        int n4 = jCDataIndex.getSeriesIndex();
        int n5 = this.dataObject.getNumSeries();
        Point point = this.unpick(n3, n4);
        if (point == null) {
            return null;
        }
        int n6 = n3 - this.firstLast.x;
        if (n6 < 0 || n6 >= this.pts.length || n4 < 0 || n4 >= n5) {
            return null;
        }
        BarPoint barPoint = this.pts[n6][n4];
        if (barPoint == null) {
            return null;
        }
        double d2 = barPoint.y;
        double d3 = barPoint.x;
        if (d3 == this.holeValue || d2 == this.holeValue) {
            return null;
        }
        JComponent jComponent = jCChartLabel.getComponent();
        int n7 = jComponent.getWidth() / 2;
        int n8 = jComponent.getHeight() / 2;
        int n9 = this.getBarFrontSize(barPoint);
        if (n2 == 3) {
            if (this.inverted) {
                point.x = point.x + (this.yaxis.isReversed() ? -n7 - 5 : n7 + 5);
            } else {
                point.y = point.y + (this.yaxis.isReversed() ? n8 + 5 : -n8 - 5);
            }
        } else if (n2 == 1) {
            if (this.inverted) {
                point.x = point.x + (this.yaxis.isReversed() ? n9 + n7 + 5 : -n9 - n7 - 5);
            } else {
                point.y = point.y + (this.yaxis.isReversed() ? -n9 - n8 - 5 : n9 + n8 + 5);
            }
        } else if (n2 == 2) {
            if (this.inverted) {
                point.x = point.x + (this.yaxis.isReversed() ? n9 / 2 : -n9 / 2);
            } else {
                point.y = point.y + (this.yaxis.isReversed() ? -n9 / 2 : n9 / 2);
            }
        }
        return point;
    }

    protected int getBarFrontSize(BarPoint barPoint) {
        if (barPoint == null) {
            return 0;
        }
        int n2 = 0;
        if (barPoint.thresholds != null) {
            for (BarPoint barPoint2 : barPoint.thresholds) {
                n2 += this.inverted ? barPoint2.front.width : barPoint2.front.height;
            }
        }
        return n2 += this.inverted ? barPoint.front.width : barPoint.front.height;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ThresholdIterator
    implements Iterator<JCDataThreshold> {
        protected List<JCDataThreshold> thresholds = null;
        protected boolean reversed = false;
        protected int pointIndex = -1;
        protected double yValue = Double.NaN;
        protected ListIterator<JCDataThreshold> iterator = null;
        protected JCDataThreshold next = null;

        ThresholdIterator(List<JCDataThreshold> list, boolean bl, int n2, double d2) {
            this.thresholds = list;
            this.reversed = bl;
            this.pointIndex = n2;
            this.yValue = d2;
            if (list != null && d2 != BarChartDraw.this.holeValue) {
                this.iterator = list.listIterator(bl ? list.size() : 0);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supportedby this iterator!");
        }

        @Override
        public boolean hasNext() {
            if (this.thresholds == null || this.iterator == null) {
                return false;
            }
            if (this.next != null) {
                return true;
            }
            while (this.reversed ? this.iterator.hasPrevious() : this.iterator.hasNext()) {
                double d2;
                JCDataThreshold jCDataThreshold = this.reversed ? this.iterator.previous() : this.iterator.next();
                JCDataThreshold jCDataThreshold2 = jCDataThreshold;
                if (jCDataThreshold2 == null || (d2 = jCDataThreshold2.getYValue(this.pointIndex)) == BarChartDraw.this.holeValue || d2 == Double.NaN || d2 >= BarChartDraw.this.yOrigin ^ this.yValue > d2) continue;
                this.next = jCDataThreshold2;
                return true;
            }
            return false;
        }

        @Override
        public JCDataThreshold next() {
            if (this.thresholds == null || this.iterator == null) {
                return null;
            }
            if (this.next != null) {
                JCDataThreshold jCDataThreshold = this.next;
                this.next = null;
                return jCDataThreshold;
            }
            if (this.hasNext()) {
                JCDataThreshold jCDataThreshold = this.next;
                this.next = null;
                return jCDataThreshold;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ThresholdAscending
    implements Comparator<JCDataThreshold> {
        protected int pointIndex = -1;

        public ThresholdAscending(int n2) {
            this.pointIndex = n2;
        }

        @Override
        public int compare(JCDataThreshold jCDataThreshold, JCDataThreshold jCDataThreshold2) {
            double d2 = jCDataThreshold.getYValue(this.pointIndex);
            double d3 = jCDataThreshold2.getYValue(this.pointIndex);
            if (d2 == BarChartDraw.this.holeValue || d2 == Double.NaN) {
                return 1;
            }
            if (d3 == BarChartDraw.this.holeValue || d3 == Double.NaN) {
                return -1;
            }
            if (d2 > d3) {
                return 1;
            }
            if (d2 < d3) {
                return -1;
            }
            return 0;
        }
    }
}

