/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AreaPolygon;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataCoord;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCPolarRadarChartFormat;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.RadarChartDraw;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AreaRadarChartDraw
extends RadarChartDraw {
    protected Point firstLast = null;
    protected JCLineStyle outlineStyle = null;
    protected MinMax xlim = null;
    protected MinMax ylim = null;
    protected AreaPolygon[] areaPolygon;

    @Override
    public void recalc() {
        this.recalc(-1, -1, -1);
    }

    @Override
    public void recalc(int n2, int n3) {
        this.recalc(n2, n3, -1);
    }

    @Override
    public void recalc(int n2, int n3, int n4) {
        this.cachePlotData = this.dataObject.getBufferPlotData();
        if (n4 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        if (this.dataObject.getXLimits() == null) {
            return;
        }
        if (this.dataObject.getYLimits() == null) {
            return;
        }
        this.xlim = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
        this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
        this.dataObject.getDataBounds(this.xlim, this.ylim);
        this.holeValue = this.dataObject.getHoleValue();
        this.firstLast = this.dataObject.getFirstLast();
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        boolean bl = this.yaxis.isLogarithmic();
        if (!this.cachePlotData && n4 == -1) {
            if (this.areaPolygon == null) {
                this.areaPolygon = new AreaPolygon[this.seriesList.size()];
            }
            return;
        }
        this.areaPolygon = new AreaPolygon[this.seriesList.size()];
        int n5 = n4 == -1 ? 0 : n4;
        int n6 = n4 == -1 ? this.seriesList.size() : n4 + 1;
        this.firstPoint = n2 = this.getFirstPoint(this.seriesList, n5, n6);
        this.lastPoint = n3 = this.getLastPoint(this.seriesList, n5, n6);
        for (int i2 = n5; i2 < n6; ++i2) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(i2);
            if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) continue;
            int n7 = n3 - n2 + 1;
            this.areaPolygon[i2] = new AreaPolygon();
            this.areaPolygon[i2].series = i2;
            double[] dArray = this.getYVals(chartDataViewSeries);
            double d2 = JCChartUtil.getRadarAngle(2, n7, 0, this.xaxis.isReversed());
            double d3 = dArray[n2];
            if (bl && d3 <= 0.0) {
                d3 = this.holeValue;
            }
            boolean bl2 = false;
            for (int i3 = n2 + 1; i3 <= n3; ++i3) {
                if (i3 >= dArray.length) continue;
                double d4 = JCChartUtil.getRadarAngle(2, n7, i3 - n2, false);
                double d5 = dArray[i3];
                if (bl && d5 <= 0.0) {
                    d5 = this.holeValue;
                }
                bl2 = this.areaPolygonAddPoints(d2, d3, d4, d5, i3, this.areaPolygon[i2], bl2);
                d2 = d4;
                d3 = d5;
            }
            if (this.areaPolygon[i2].poly.npoints != 0) continue;
            this.areaPolygon[i2] = null;
        }
    }

    protected int getFirstPoint(List<ChartDataViewSeries> list, int n2, int n3) {
        int n4 = Integer.MIN_VALUE;
        for (int i2 = n2; i2 < n3; ++i2) {
            ChartDataViewSeries chartDataViewSeries = list.get(i2);
            int n5 = chartDataViewSeries.getFirstPoint();
            if (n5 <= n4) continue;
            n4 = n5;
        }
        return n4;
    }

    protected int getLastPoint(List<ChartDataViewSeries> list, int n2, int n3) {
        int n4 = Integer.MAX_VALUE;
        for (int i2 = n2; i2 < n3; ++i2) {
            ChartDataViewSeries chartDataViewSeries = list.get(i2);
            int n5 = chartDataViewSeries.getLastPoint();
            if (n5 >= n4) continue;
            n4 = n5;
        }
        return n4;
    }

    protected double[] getYVals(ChartDataViewSeries chartDataViewSeries) {
        double[] dArray = chartDataViewSeries.getY();
        double[] dArray2 = new double[dArray.length];
        for (int i2 = 0; i2 < dArray2.length; ++i2) {
            dArray2[i2] = dArray[i2] == this.holeValue || this.yaxis.isLogarithmic() && dArray[i2] <= 0.0 ? Double.MAX_VALUE : dArray[i2];
        }
        return dArray2;
    }

    @Override
    public void draw(Graphics graphics) {
        this.draw(graphics, -1, -1, true);
    }

    public void draw(Graphics graphics, int n2, int n3, boolean bl) {
        int n4;
        Shape shape;
        if (this.seriesList == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        if (this.areaPolygon == null) {
            return;
        }
        DefineShape defineShape = null;
        if (graphics instanceof DefineShape) {
            defineShape = (DefineShape)((Object)graphics);
        }
        JCPolarRadarChartFormat jCPolarRadarChartFormat = (JCPolarRadarChartFormat)this.dataObject.getChartFormat(4);
        this.outlineStyle = this.dataObject.getOutlineStyle();
        if (jCPolarRadarChartFormat.getOutlineStyle() == 2) {
            this.outlineStyle = new JCLineStyle(1, this.chartArea.getForeground(), 1);
        }
        Shape shape2 = graphics.getClip();
        double d2 = this.yaxis.pixelLength();
        double d3 = this.yaxis.polarAxisParams.xCenter;
        double d4 = this.yaxis.polarAxisParams.yCenter;
        if (this.yaxis.polarAxisParams.isCircularGrid()) {
            shape = new Ellipse2D.Double(d3 - d2, d4 - d2, 2.0 * d2, 2.0 * d2);
        } else {
            n4 = ChartDataView.getNumRadarSpokes(this.dataObject);
            shape = this.yaxis.createWebbedShape(d2, n4);
        }
        graphics.setClip(shape);
        int n5 = n4 = bl ? 0 : this.areaPolygon.length - 1;
        while (bl ? n4 < this.areaPolygon.length : n4 >= 0) {
            JCChartStyle jCChartStyle;
            ChartDataViewSeries chartDataViewSeries;
            if (!this.cachePlotData) {
                this.recalc(-1, -1, n4);
            }
            if (this.areaPolygon[n4] != null && (chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n4)).isVisible() && (jCChartStyle = chartDataViewSeries.getStyle()) != null) {
                JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
                Rectangle rectangle2 = this.areaPolygon[n4].poly.getBounds();
                int n6 = this.calcFillOrientation(rectangle2, this.yaxis.origin.value, this.xaxis.reversed, this.yaxis.reversed);
                jCFillStyle.updateFillOrientation(rectangle2, n6);
                if (jCPolarRadarChartFormat.getOutlineStyle() == 1) {
                    JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
                    this.outlineStyle = jCLineStyle != null ? jCLineStyle : this.dataObject.getOutlineStyle();
                }
                jCFillStyle.fillOutlinePolygon(graphics, this.areaPolygon[n4].poly, this.outlineStyle);
                jCFillStyle.resetFillOrientation();
                if (defineShape != null) {
                    this.defineAreaShapes(defineShape, graphics, jCFillStyle, this.areaPolygon[n4], chartDataViewSeries);
                }
                if (!this.cachePlotData) {
                    this.areaPolygon[n4] = null;
                }
            }
            n4 += bl ? 1 : -1;
        }
        graphics.setClip(shape2);
    }

    private Point getPixelPolar(double d2, double d3) {
        return this.yaxis.toPixelPolar(d2, d3, true);
    }

    private boolean areaPolygonAddPoints(double d2, double d3, double d4, double d5, int n2, AreaPolygon areaPolygon, boolean bl) {
        double d6 = d3;
        double d7 = d5;
        if (d6 == Double.MAX_VALUE) {
            double d8 = d6 = this.yaxis.isReversed() ? this.yaxis.max.value : this.yaxis.min.value;
        }
        if (d7 == Double.MAX_VALUE) {
            double d9 = d7 = this.yaxis.isReversed() ? this.yaxis.max.value : this.yaxis.min.value;
        }
        if (bl) {
            Point point = this.getPixelPolar(d4, d7);
            areaPolygon.poly.addPoint(point.x, point.y);
            areaPolygon.endPoint = n2;
        } else {
            Point point = this.getPixelPolar(d2, d6);
            areaPolygon.poly.addPoint(point.x, point.y);
            point = this.getPixelPolar(d4, d7);
            areaPolygon.poly.addPoint(point.x, point.y);
            areaPolygon.startPoint = n2 - 1;
            areaPolygon.endPoint = n2;
        }
        return true;
    }

    protected int calcFillOrientation(Rectangle rectangle, double d2, boolean bl, boolean bl2) {
        return 6;
    }

    protected void defineAreaShapes(DefineShape defineShape, Graphics graphics, JCFillStyle jCFillStyle, AreaPolygon areaPolygon, ChartDataViewSeries chartDataViewSeries) {
        Point point = !this.yaxis.isReversed() ? this.yaxis.toPixelPolar(0.0, this.yaxis.getMin(), true) : this.yaxis.toPixelPolar(0.0, this.yaxis.getMax(), true);
        for (int i2 = areaPolygon.startPoint; i2 <= areaPolygon.endPoint; ++i2) {
            int n2 = i2;
            int n3 = n2 > areaPolygon.startPoint ? n2 - 1 : areaPolygon.endPoint;
            int n4 = n2 < areaPolygon.endPoint ? n2 + 1 : areaPolygon.startPoint;
            Polygon polygon = null;
            int n5 = areaPolygon.poly.xpoints[n2];
            int n6 = areaPolygon.poly.ypoints[n2];
            if (n5 != point.x || n6 != point.y) {
                polygon = new Polygon();
                polygon.addPoint(point.x, point.y);
                int n7 = areaPolygon.poly.xpoints[n3];
                int n8 = areaPolygon.poly.ypoints[n3];
                if (n7 != point.x || n8 != point.y) {
                    n7 -= (int)((double)(n7 - n5) / 2.0);
                    n8 -= (int)((double)(n8 - n6) / 2.0);
                    polygon.addPoint(n7, n8);
                }
                polygon.addPoint(n5, n6);
                int n9 = areaPolygon.poly.xpoints[n4];
                int n10 = areaPolygon.poly.ypoints[n4];
                if (n9 != point.x || n10 != point.y) {
                    n9 += (int)((double)(n5 - n9) / 2.0);
                    n10 += (int)((double)(n6 - n10) / 2.0);
                    polygon.addPoint(n9, n10);
                }
            }
            if (polygon == null) continue;
            defineShape.beginShape(new JCDataIndex(i2, chartDataViewSeries));
            jCFillStyle.fillPolygon(graphics, polygon);
            defineShape.endShape(false);
        }
    }

    @Override
    public JCDataIndex pick(Point point, int n2) {
        return this.pick(point, n2, false);
    }

    @Override
    public JCDataIndex pickSeries(Point point, int n2) {
        return this.pick(point, n2);
    }

    public JCDataIndex pick(Point point, int n2, boolean bl) {
        int n3;
        JCDataIndex jCDataIndex = null;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        Rectangle rectangle = this.chartArea.getDrawingArea();
        int n4 = point.x - rectangle.x;
        int n5 = point.y - rectangle.y;
        JCDataCoord jCDataCoord = this.yaxis.toDataPolar(n4, n5);
        int n6 = n3 = bl ? 0 : this.areaPolygon.length - 1;
        while (bl ? n3 < this.areaPolygon.length : n3 >= 0) {
            if (!this.cachePlotData) {
                this.recalc(-1, -1, n3);
            }
            if (this.areaPolygon[n3] != null && this.areaPolygon[n3].poly.contains(n4, n5)) {
                jCDataIndex = this.findClosestPointInSeries(n3, n2, n4, n5, jCDataCoord);
                jCDataIndex.distance = 0;
                break;
            }
            n3 += bl ? 1 : -1;
        }
        if (bl ? n3 >= this.areaPolygon.length : n3 < 0) {
            switch (n2) {
                case 1: 
                case 2: {
                    jCDataIndex = super.pick(point, n2);
                    break;
                }
                default: {
                    jCDataIndex = this.pickPolygonXY(n4, n5, jCDataCoord);
                }
            }
        }
        return jCDataIndex;
    }

    private JCDataIndex pickPolygonXY(int n2, int n3, JCDataCoord jCDataCoord) {
        JCDataIndex jCDataIndex = null;
        int n4 = -1;
        double d2 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < this.areaPolygon.length; ++i2) {
            if (!this.cachePlotData) {
                this.recalc(-1, -1, i2);
            }
            if (this.areaPolygon[i2] == null) continue;
            double d3 = JCChartUtil.getPolygonDistance(n2, n3, this.areaPolygon[i2].poly);
            if (d3 < d2) {
                n4 = i2;
                d2 = d3;
            }
            if (d3 == 0.0) break;
        }
        if (n4 >= 0) {
            jCDataIndex = this.findClosestPointInSeries(n4, 0, n2, n3, jCDataCoord);
            jCDataIndex.distance = (int)d2;
        }
        return jCDataIndex;
    }
}

