/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AreaPolygon;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.DoubleCoord;
import com.klg.jclass.chart.ImageMapShapeArea;
import com.klg.jclass.chart.JCAreaChartFormat;
import com.klg.jclass.chart.JCAreaDataIndex;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PickShapeArea;
import com.klg.jclass.chart.Picker;
import com.klg.jclass.chart.ProcessShape;
import com.klg.jclass.chart.ProcessShapeArea;
import com.klg.jclass.chart.RenderShape;
import com.klg.jclass.chart.SAreaChartDraw;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AreaChartDraw
extends ChartDraw {
    protected Point firstLast = null;
    protected MinMax xlim = null;
    protected MinMax ylim = null;
    protected int polyNum = 0;
    protected DoubleCoord lastValidPoint = null;
    protected int indexLastValidPoint = -1;
    protected boolean lastValidYHole = false;
    protected double origin = 0.0;
    protected int baseValue = -1;
    protected boolean outConditionDetected = false;
    protected JCAreaChartFormat areaFormat = null;
    protected Vector<AreaPolygon>[] polyList;
    protected int[] polyAboveBaseLine = null;
    protected int[] polyAboveTopLine = null;
    protected int[] polyBelowBaseLine = null;
    protected int[] polyBelowBottomLine = null;
    Point prev = null;
    Point next = null;
    Point last = null;
    Rectangle r = null;

    @Override
    public void recalc() {
        this.recalc(-1, -1, -1);
    }

    @Override
    public void recalc(int n2, int n3) {
        this.recalc(n2, n3, -1);
    }

    public void recalc(int n2, int n3, int n4) {
        super.recalc();
        boolean bl = this instanceof SAreaChartDraw;
        this.fastUpdate = this.dataObject.getFastUpdate() && !bl;
        this.cachePlotData = this.fastUpdate || this.dataObject.getBufferPlotData();
        this.areaFormat = (JCAreaChartFormat)this.dataObject.getChartFormat(8);
        boolean bl2 = false;
        if (n2 >= 0 && n3 >= 0 && n3 >= n2 && this.polyList != null && !bl) {
            bl2 = true;
        }
        if (n4 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.holeValue = this.dataObject.getHoleValue();
        this.firstLast = this.dataObject.getFirstLast();
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        if (this.xaxis == null || this.yaxis == null) {
            return;
        }
        this.inverted = this.xaxis.i_vertical;
        this.origin = this.getYOrigin();
        this.baseValue = this.yaxis.toPixel(this.origin, this.drawFront);
        MinMax minMax = this.dataObject.getXLimits();
        if (minMax == null) {
            return;
        }
        MinMax minMax2 = this.dataObject.getYLimits();
        if (minMax2 == null) {
            return;
        }
        this.xlim = new MinMax(minMax.min, minMax.max);
        this.ylim = new MinMax(minMax2.min, minMax2.max);
        this.dataObject.getDataBounds(this.xlim, this.ylim);
        boolean bl3 = this.yaxis.isLogarithmic();
        if (!this.cachePlotData && n4 == -1) {
            if (this.polyList == null) {
                this.polyList = new Vector[this.seriesList.size()];
            }
            return;
        }
        if (!bl2) {
            this.polyList = new Vector[this.seriesList.size()];
        }
        int n5 = n4 == -1 ? 0 : n4;
        int n6 = n4 == -1 ? this.seriesList.size() : n4 + 1;
        this.polyAboveBaseLine = null;
        this.polyBelowBaseLine = null;
        for (int i2 = n5; i2 < n6; ++i2) {
            boolean bl4;
            Object object;
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(i2);
            if (!chartDataViewSeries.isVisible()) continue;
            if (!bl2) {
                this.polyList[i2] = null;
            }
            if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) continue;
            if (!bl2) {
                n2 = this.getStartPoint(chartDataViewSeries);
                n3 = this.getEndPoint(chartDataViewSeries);
                this.polyList[i2] = new Vector();
            } else {
                int n7;
                int n8 = n7 = this.polyList[i2] == null ? 0 : this.polyList[i2].size();
                if (n2 < n7) {
                    n2 = n7;
                }
            }
            double[] dArray = this.getXVals(chartDataViewSeries);
            double[] dArray2 = this.getCalculatedYVals(chartDataViewSeries);
            JCChartStyle jCChartStyle = chartDataViewSeries.getStyle();
            JCChartStyle jCChartStyle2 = chartDataViewSeries.getHoleStyle();
            boolean bl5 = false;
            if (jCChartStyle2 != null) {
                JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
                object = jCChartStyle2.getFillStyle();
                bl5 = jCFillStyle != null ? jCFillStyle.equals(object) : object == null;
            }
            boolean bl6 = false;
            this.lastValidPoint = null;
            this.indexLastValidPoint = -1;
            this.outConditionDetected = false;
            this.polyNum = 0;
            if (bl2 && n2 > 0) {
                AreaPolygon areaPolygon;
                int n9 = n2 - 1;
                double d2 = chartDataViewSeries.getX(n9);
                while (this.xaxis.skipValue(d2, this.holeValue) && n9 > 0) {
                    d2 = chartDataViewSeries.getX(--n9);
                }
                double d3 = dArray2[n9];
                boolean bl7 = chartDataViewSeries.isYHole(n2, bl3);
                bl4 = d3 < this.origin;
                this.polyNum = this.findLastPoly(this.polyList[i2]);
                bl6 = true;
                boolean bl8 = false;
                if (this.polyNum >= 0) {
                    areaPolygon = this.polyList[i2].elementAt(this.polyNum);
                    if (n9 >= areaPolygon.startPoint && n9 <= areaPolygon.endPoint && !(areaPolygon.belowOrigin ^ bl4) && !(areaPolygon.hole ^ bl7) && areaPolygon.poly.npoints > 0) {
                        --areaPolygon.poly.npoints;
                        bl8 = true;
                    }
                }
                if (!bl8) {
                    areaPolygon = this.createNewPolygon(i2, bl7, d3 < this.origin);
                    if (d2 == this.holeValue) {
                        bl6 = false;
                    } else {
                        this.addFirstPolygonPoints(areaPolygon, d2, d3, n9, this.inverted, false, null);
                    }
                }
            } else {
                object = new AreaPolygon();
                ((AreaPolygon)object).series = i2;
                this.polyList[i2].addElement((AreaPolygon)object);
            }
            this.initPolyEndLines(n2, n3);
            for (int i3 = n2; i3 <= n3; ++i3) {
                double d4;
                int n10 = this.getDataIndex(i3);
                if (n10 >= dArray2.length || this.xaxis.skipValue(d4 = dArray[n10], this.holeValue)) continue;
                double d5 = dArray2[n10];
                bl4 = !bl5 && chartDataViewSeries.isYHole(i3, bl3);
                AreaPolygon areaPolygon = this.polyList[i2].elementAt(this.polyNum);
                if (this.outConditionDetected && !bl6 && this.lastValidPoint != null && JCChartUtil.locateX(d4, this.xaxis.min.value, this.xaxis.max.value) == 0) {
                    areaPolygon.hole = this.lastValidYHole;
                    areaPolygon.belowOrigin = this.lastValidPoint.y < this.origin;
                    this.addFirstPolygonPoints(areaPolygon, this.lastValidPoint.x, this.lastValidPoint.y, this.indexLastValidPoint, this.inverted, false, null);
                    this.outConditionDetected = false;
                    bl6 = true;
                }
                if (!(bl6 = this.clipAreaPolygon(d4, d5, bl4, n10, areaPolygon, bl6, this.inverted, chartDataViewSeries, i2)) && areaPolygon.poly.npoints > 0 && !this.outConditionDetected) {
                    areaPolygon = this.polyList[i2].elementAt(this.polyNum);
                    boolean bl9 = this.isAcrossOrigin(areaPolygon, d5);
                    int n11 = bl4 && !bl9 ? this.indexLastValidPoint : n10;
                    Point point = null;
                    if (bl4 && bl9 && this.isConnectedAcrossOrigin()) {
                        int n12 = this.getBaseValue(areaPolygon, n11);
                        point = this.computeIntersectionWithOrigin(d4, d5, n12);
                    }
                    this.finishAreaPolygon(areaPolygon, n11, this.inverted, chartDataViewSeries, point);
                    AreaPolygon areaPolygon2 = this.createNewPolygon(i2, bl4, bl9 ^ areaPolygon.belowOrigin);
                    if (bl4) {
                        this.beginHolePolygon(areaPolygon2, d4, d5, n10, this.inverted, bl9, point);
                    } else {
                        this.addFirstPolygonPoints(areaPolygon2, d4, d5, n10, this.inverted, false, point);
                    }
                    bl6 = true;
                }
                this.lastValidPoint = new DoubleCoord(d4, d5);
                this.indexLastValidPoint = n10;
                this.lastValidYHole = bl4;
            }
            object = this.polyList[i2].elementAt(this.polyNum);
            if (((AreaPolygon)object).poly.npoints > 0) {
                this.finishAreaPolygon((AreaPolygon)object, this.indexLastValidPoint, this.inverted, chartDataViewSeries, null);
            } else {
                this.polyList[i2].setElementAt(null, this.polyNum);
            }
            this.resetPolyBaseLines();
        }
    }

    protected int getStartPoint(ChartDataViewSeries chartDataViewSeries) {
        if (chartDataViewSeries == null) {
            return 0;
        }
        return chartDataViewSeries.getFirstPoint();
    }

    protected int getEndPoint(ChartDataViewSeries chartDataViewSeries) {
        if (chartDataViewSeries == null) {
            return 0;
        }
        return chartDataViewSeries.getLastPoint();
    }

    protected int getDataIndex(int n2) {
        return n2;
    }

    protected int getPointIndex(int n2) {
        return n2;
    }

    protected AreaPolygon createNewPolygon(int n2, boolean bl, boolean bl2) {
        AreaPolygon areaPolygon = new AreaPolygon();
        areaPolygon.series = n2;
        areaPolygon.hole = bl;
        areaPolygon.belowOrigin = bl2;
        this.polyList[n2].addElement(areaPolygon);
        ++this.polyNum;
        return areaPolygon;
    }

    protected boolean isAcrossOrigin(AreaPolygon areaPolygon, double d2) {
        if (areaPolygon.onlyOriginValues) {
            return false;
        }
        if (areaPolygon.belowOrigin && d2 > this.origin) {
            return true;
        }
        return !areaPolygon.belowOrigin && d2 < this.origin;
    }

    protected void resetPolyBaseLines() {
    }

    protected void initPolyEndLines(int n2, int n3) {
    }

    protected double[] getXVals(ChartDataViewSeries chartDataViewSeries) {
        if (chartDataViewSeries == null) {
            return null;
        }
        return chartDataViewSeries.getX();
    }

    protected double[] getYVals(ChartDataViewSeries chartDataViewSeries) {
        return chartDataViewSeries.getNormalizedYValues(this.yaxis.isLogarithmic(), false);
    }

    protected double[] getCalculatedYVals(ChartDataViewSeries chartDataViewSeries) {
        return this.areaFormat.getCalculatedYValues(chartDataViewSeries, this.xaxis, this.yaxis, this.holeValue);
    }

    @Override
    public void draw(Graphics graphics) {
        this.draw(graphics, -1, -1);
    }

    @Override
    public void draw(Graphics graphics, int n2, int n3) {
        this.draw(graphics, n2, n3, false);
    }

    public void draw(Graphics graphics, int n2, int n3, boolean bl) {
        DefineShape defineShape = null;
        if (graphics instanceof DefineShape) {
            defineShape = (DefineShape)((Object)graphics);
        }
        JCLineStyle jCLineStyle = this.dataObject.getOutlineStyle();
        int n4 = this.areaFormat.getOutlineStyle();
        if (n4 == 2) {
            jCLineStyle = new JCLineStyle(1, this.chartArea.getForeground(), 1);
        }
        RenderShape renderShape = new RenderShape(graphics, jCLineStyle, null, null);
        this.processPlotData(renderShape, defineShape, n2, n3, bl);
    }

    protected void processPlotData(ProcessShape processShape, DefineShape defineShape, int n2, int n3, boolean bl) {
        Graphics graphics;
        Rectangle rectangle;
        if (processShape == null) {
            return;
        }
        if (this.seriesList == null) {
            return;
        }
        if (processShape instanceof RenderShape && (rectangle = (graphics = ((RenderShape)processShape).getGC()).getClipBounds()) != null && (rectangle.width == 0 || rectangle.height == 0)) {
            return;
        }
        boolean bl2 = false;
        if (n2 >= 0 && n3 >= 0 && n3 >= n2) {
            bl2 = true;
        }
        if (this.polyList == null || this.polyList.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.polyList.length; ++i2) {
            Object object;
            Object object2;
            JCChartStyle jCChartStyle;
            ChartDataViewSeries chartDataViewSeries;
            if (!this.cachePlotData) {
                this.recalc(-1, -1, i2);
            }
            if (this.polyList[i2] == null || this.seriesList == null || this.seriesList.size() <= i2 || !(chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(i2)).isVisible() || (jCChartStyle = chartDataViewSeries.getStyle()) == null) continue;
            JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
            JCChartStyle jCChartStyle2 = chartDataViewSeries.getHoleStyle();
            JCFillStyle jCFillStyle2 = null;
            if (jCChartStyle2 != null) {
                jCFillStyle2 = jCChartStyle2.getFillStyle();
            }
            if (!bl2) {
                double[] dArray = null;
                object2 = null;
                if (processShape instanceof ProcessShapeArea || processShape instanceof ImageMapShapeArea) {
                    dArray = this.getXVals(chartDataViewSeries);
                    object2 = this.getCalculatedYVals(chartDataViewSeries);
                }
                for (int i3 = 0; i3 < this.polyList[i2].size(); ++i3) {
                    Object object3;
                    object = this.polyList[i2].elementAt(i3);
                    if (object == null) continue;
                    if (processShape instanceof ProcessShapeArea) {
                        object3 = (ProcessShapeArea)((Object)processShape);
                        object3.setPickShapeData((AreaPolygon)object, dArray, (double[])object2, this.holeValue, this.xaxis, this.yaxis);
                    } else if (processShape instanceof ImageMapShapeArea) {
                        object3 = (ImageMapShapeArea)processShape;
                        ((ImageMapShapeArea)object3).setAreaChartInfo((AreaPolygon)object, this.dataObject, chartDataViewSeries, dArray, (double[])object2, this.holeValue, this.xaxis, this.yaxis);
                    }
                    object3 = ((AreaPolygon)object).hole ? jCFillStyle2 : jCFillStyle;
                    processShape.setFillStyle((JCFillStyle)object3);
                    this.drawPolygon(processShape, ((AreaPolygon)object).poly, false);
                    if (defineShape == null || !(processShape instanceof RenderShape) || object3 == null) continue;
                    this.defineAreaShapes(defineShape, ((RenderShape)processShape).getGC(), (JCFillStyle)object3, this.inverted, (AreaPolygon)object, chartDataViewSeries);
                }
                if (!bl && processShape instanceof RenderShape) {
                    this.drawSeriesOutline((RenderShape)processShape, chartDataViewSeries, i2);
                }
            } else {
                for (int i4 = 0; i4 < this.polyList[i2].size(); ++i4) {
                    object2 = this.polyList[i2].elementAt(i4);
                    if (object2 == null || n2 > object2.endPoint) continue;
                    JCFillStyle jCFillStyle3 = object2.hole ? jCFillStyle2 : jCFillStyle;
                    processShape.setFillStyle(jCFillStyle3);
                    this.setOutlineStyle(processShape, (AreaPolygon)object2, chartDataViewSeries);
                    object = object2.poly;
                    if (object2.startPoint >= n2 - 1 && object2.endPoint <= n3) {
                        this.drawPolygon(processShape, (Polygon)object, false);
                        this.drawPolygonOutline(processShape, (AreaPolygon)object2);
                        continue;
                    }
                    if (n2 - 1 <= object2.startPoint) continue;
                    int n4 = Math.max(n2 - object2.startPoint - 1, 0);
                    int n5 = ((Polygon)object).npoints - n4;
                    int[] nArray = new int[n5];
                    int[] nArray2 = new int[n5];
                    int n6 = this.getBaseValue((AreaPolygon)object2, 0);
                    if (this.inverted) {
                        nArray[0] = n6;
                        nArray2[0] = ((Polygon)object).ypoints[n4];
                    } else {
                        nArray[0] = ((Polygon)object).xpoints[n4];
                        nArray2[0] = n6;
                    }
                    for (int i5 = 1; i5 < n5; ++i5) {
                        int n7 = n4 + i5;
                        nArray[i5] = ((Polygon)object).xpoints[n7];
                        nArray2[i5] = ((Polygon)object).ypoints[n7];
                    }
                    Polygon polygon = new Polygon(nArray, nArray2, n5);
                    this.drawPolygon(processShape, polygon, true);
                }
            }
            if (this.cachePlotData || bl) continue;
            this.polyList[i2] = null;
        }
        if (bl) {
            this.drawAllSeriesOutlines(processShape);
        }
    }

    protected void drawAllSeriesOutlines(ProcessShape processShape) {
        if (!(processShape instanceof RenderShape)) {
            return;
        }
        RenderShape renderShape = (RenderShape)processShape;
        for (int i2 = this.polyList.length - 1; i2 >= 0; --i2) {
            JCChartStyle jCChartStyle;
            ChartDataViewSeries chartDataViewSeries;
            if (this.polyList[i2] == null || this.seriesList == null || this.seriesList.size() <= i2 || !(chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(i2)).isVisible() || (jCChartStyle = chartDataViewSeries.getStyle()) == null) continue;
            this.drawSeriesOutline(renderShape, chartDataViewSeries, i2);
            if (this.cachePlotData) continue;
            this.polyList[i2] = null;
        }
    }

    protected void drawSeriesOutline(RenderShape renderShape, ChartDataViewSeries chartDataViewSeries, int n2) {
        AreaPolygon areaPolygon;
        int n3;
        JCChartStyle jCChartStyle = chartDataViewSeries.getHoleStyle();
        if (jCChartStyle != null && jCChartStyle.getFillStyle() != null) {
            for (n3 = 0; n3 < this.polyList[n2].size(); ++n3) {
                areaPolygon = this.polyList[n2].elementAt(n3);
                if (areaPolygon == null || !areaPolygon.hole) continue;
                this.setOutlineStyle(renderShape, areaPolygon, chartDataViewSeries);
                this.drawPolygonOutline(renderShape, areaPolygon);
            }
        }
        for (n3 = 0; n3 < this.polyList[n2].size(); ++n3) {
            areaPolygon = this.polyList[n2].elementAt(n3);
            if (areaPolygon == null || areaPolygon.hole) continue;
            this.setOutlineStyle(renderShape, areaPolygon, chartDataViewSeries);
            this.drawPolygonOutline(renderShape, areaPolygon);
        }
    }

    protected void setOutlineStyle(ProcessShape processShape, AreaPolygon areaPolygon, ChartDataViewSeries chartDataViewSeries) {
        if (processShape instanceof RenderShape) {
            RenderShape renderShape = (RenderShape)processShape;
            int n2 = this.areaFormat.getOutlineStyle();
            if (n2 == 1) {
                Cloneable cloneable;
                JCChartStyle jCChartStyle = chartDataViewSeries.getStyle();
                if (areaPolygon.hole && (cloneable = chartDataViewSeries.getHoleStyle()) != null) {
                    jCChartStyle = cloneable;
                }
                Cloneable cloneable2 = cloneable = jCChartStyle == null ? null : jCChartStyle.getLineStyle();
                if (cloneable != null) {
                    renderShape.setLineStyle((JCLineStyle)cloneable);
                } else {
                    renderShape.setLineStyle(this.dataObject.getOutlineStyle());
                }
            }
        }
    }

    protected void drawPolygon(ProcessShape processShape, Polygon polygon, boolean bl) {
        if (polygon == null) {
            return;
        }
        Rectangle rectangle = polygon.getBounds();
        int n2 = this.calcFillOrientation(rectangle, this.yaxis.origin.value, this.inverted, this.xaxis.isReversed(), this.yaxis.reversed);
        processShape.updateFillOrientation(rectangle, n2);
        if (bl) {
            processShape.fillOutlinePartialPolygon(polygon);
        } else {
            processShape.fillPolygon(polygon);
        }
        processShape.resetFillOrientation();
    }

    protected void drawPolygonOutline(ProcessShape processShape, AreaPolygon areaPolygon) {
        if (!(processShape instanceof RenderShape) || areaPolygon == null) {
            return;
        }
        RenderShape renderShape = (RenderShape)processShape;
        JCLineStyle jCLineStyle = renderShape.getLineStyle();
        if (jCLineStyle == null) {
            return;
        }
        Graphics graphics = renderShape.getLineGC();
        Polygon polygon = areaPolygon.poly;
        if (jCLineStyle.updateGraphics(graphics)) {
            int n2 = areaPolygon.poly.npoints;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = polygon.xpoints[i2];
                int n4 = polygon.ypoints[i2];
                int n5 = polygon.xpoints[(i2 + 1) % n2];
                int n6 = polygon.ypoints[(i2 + 1) % n2];
                renderShape.drawLine(n3, n4, n5, n6);
            }
        }
        jCLineStyle.resetGraphics(graphics);
    }

    protected boolean clipAreaPolygon(double d2, double d3, boolean bl, int n2, AreaPolygon areaPolygon, boolean bl2, boolean bl3, ChartDataViewSeries chartDataViewSeries, int n3) {
        int n4;
        int n5;
        double d4;
        if (d2 == this.holeValue) {
            return bl2;
        }
        double d5 = d4 = this.lastValidPoint != null ? this.lastValidPoint.x : -1.7976931348623157E308;
        if (d4 != this.holeValue) {
            n5 = JCChartUtil.locateX(d4, this.xaxis.min.value, this.xaxis.max.value);
            n4 = JCChartUtil.locateX(d2, this.xaxis.min.value, this.xaxis.max.value);
            if (n5 != 0 && n4 != 0 && n5 == n4) {
                this.outConditionDetected = true;
                return false;
            }
        }
        if (bl2 && !areaPolygon.hole && bl) {
            if (this.isAcrossOrigin(areaPolygon, d3)) {
                this.finishAreaPolygon(areaPolygon, this.indexLastValidPoint, bl3, chartDataViewSeries, null);
                areaPolygon = this.createNewPolygon(n3, bl, areaPolygon.belowOrigin);
                this.addFirstPolygonPoints(areaPolygon, this.lastValidPoint.x, this.lastValidPoint.y, this.indexLastValidPoint, bl3, false, null);
            }
            return false;
        }
        if (bl2) {
            if (this.isAcrossOrigin(areaPolygon, d3)) {
                n5 = this.yaxis.toPixel(this.lastValidPoint.y, this.drawFront);
                int n6 = n5 == (n4 = this.getBaseValue(areaPolygon, this.indexLastValidPoint)) ? this.indexLastValidPoint : n2;
                Point point = null;
                if (this.isConnectedAcrossOrigin()) {
                    point = this.computeIntersectionWithOrigin(d2, d3, n4);
                }
                this.finishAreaPolygon(areaPolygon, n6, bl3, chartDataViewSeries, point);
                areaPolygon = this.createNewPolygon(n3, areaPolygon.hole, !areaPolygon.belowOrigin);
                this.addFirstPolygonPoints(areaPolygon, d2, d3, n2, bl3, true, point);
            } else {
                this.addPolygonPoint(areaPolygon, d2, d3, n2, bl3);
            }
            return !(bl ^ areaPolygon.hole);
        }
        areaPolygon.hole = bl;
        areaPolygon.originalY = d3;
        areaPolygon.belowOrigin = d3 < this.origin;
        this.addFirstPolygonPoints(areaPolygon, d2, d3, n2, bl3, false, null);
        return true;
    }

    protected Point computeIntersectionWithOrigin(double d2, double d3, int n2) {
        double d4;
        if (this.lastValidPoint == null) {
            return null;
        }
        if (this.lastValidPoint.y == this.origin) {
            return new Point(this.xaxis.toPixel(this.lastValidPoint.x), n2);
        }
        if (this.lastValidPoint.y < this.origin ^ d3 > this.origin) {
            return null;
        }
        double d5 = this.xaxis.toPixelDouble(this.lastValidPoint.x, this.drawFront);
        double d6 = this.yaxis.toPixelDouble(this.lastValidPoint.y, this.drawFront);
        double d7 = this.xaxis.toPixelDouble(d2, this.drawFront);
        double d8 = (d7 - d5) / ((d4 = this.yaxis.toPixelDouble(d3, this.drawFront)) - d6);
        if (d8 == 0.0) {
            return new Point((int)d5, n2);
        }
        double d9 = d5 + ((double)n2 - d6) * d8;
        return new Point((int)d9, n2);
    }

    protected void addPolygonPoint(AreaPolygon areaPolygon, double d2, double d3, int n2, boolean bl) {
        if (bl) {
            areaPolygon.poly.addPoint(this.yaxis.toPixel(d3, this.drawFront), this.xaxis.toPixel(d2, this.drawFront));
        } else {
            areaPolygon.poly.addPoint(this.xaxis.toPixel(d2, this.drawFront), this.yaxis.toPixel(d3, this.drawFront));
        }
        if (d3 != this.origin && areaPolygon.onlyOriginValues) {
            areaPolygon.belowOrigin = d3 < this.origin;
            areaPolygon.onlyOriginValues = false;
        }
        areaPolygon.endPoint = n2;
    }

    protected void addBasePolygonPoint(AreaPolygon areaPolygon, int n2, int n3, boolean bl) {
        int n4 = this.getBaseValue(areaPolygon, n3);
        if (bl) {
            areaPolygon.poly.addPoint(n4, n2);
        } else {
            areaPolygon.poly.addPoint(n2, n4);
        }
        areaPolygon.startPoint = n3;
    }

    protected void addFirstPolygonPoints(AreaPolygon areaPolygon, double d2, double d3, int n2, boolean bl, boolean bl2, Point point) {
        int n3;
        int n4 = n2;
        if (bl2 && this.lastValidPoint != null) {
            n4 = this.indexLastValidPoint;
            areaPolygon.isLeading = true;
            n3 = point != null ? point.x : this.xaxis.toPixel(this.lastValidPoint.x, this.drawFront);
        } else {
            n3 = this.xaxis.toPixel(d2, this.drawFront);
        }
        this.addBasePolygonPoint(areaPolygon, n3, n4, bl);
        this.addPolygonPoint(areaPolygon, d2, d3, n2, bl);
    }

    protected void beginHolePolygon(AreaPolygon areaPolygon, double d2, double d3, int n2, boolean bl, boolean bl2, Point point) {
        areaPolygon.hole = true;
        areaPolygon.isLeading = bl2;
        double d4 = this.lastValidPoint.x;
        double d5 = this.lastValidPoint.y;
        int n3 = bl2 && point != null ? point.x : this.xaxis.toPixel(d4, this.drawFront);
        this.addBasePolygonPoint(areaPolygon, n3, this.indexLastValidPoint, bl);
        if (!bl2) {
            this.addPolygonPoint(areaPolygon, d4, d5, this.indexLastValidPoint, bl);
        }
        this.addPolygonPoint(areaPolygon, d2, d3, n2, bl);
    }

    protected double getYOrigin() {
        if (this.dataObject == null) {
            return Double.MAX_VALUE;
        }
        if (this.yaxis == null) {
            this.yaxis = this.dataObject.getYAxis();
        }
        return this.yaxis.getOrigin();
    }

    protected boolean isConnectedAcrossOrigin() {
        return this.areaFormat.isConnectedAcrossOrigin();
    }

    protected int getBaseValue(AreaPolygon areaPolygon, int n2) {
        return this.baseValue;
    }

    protected void finishAreaPolygon(AreaPolygon areaPolygon, int n2, boolean bl, ChartDataViewSeries chartDataViewSeries, Point point) {
        int n3;
        if (n2 == areaPolygon.startPoint) {
            areaPolygon.endPoint = n2;
            areaPolygon.nBottomPoints = 1;
            return;
        }
        int n4 = this.getBaseValue(areaPolygon, n2);
        Polygon polygon = areaPolygon.poly;
        if (point != null && n2 > areaPolygon.endPoint) {
            n3 = point.x;
        } else {
            double[] dArray = this.getXVals(chartDataViewSeries);
            double d2 = dArray[n2];
            n3 = this.xaxis.toPixel(d2, this.drawFront);
        }
        if (bl) {
            polygon.addPoint(n4, n3);
        } else {
            polygon.addPoint(n3, n4);
        }
        if (n2 > areaPolygon.endPoint) {
            areaPolygon.endPoint = n2;
            areaPolygon.isTrailing = true;
        }
        areaPolygon.nBottomPoints = 2 - (areaPolygon.isLeading ? 1 : 0) - (areaPolygon.isTrailing ? 1 : 0);
    }

    private int findLastPoly(Vector<AreaPolygon> vector) {
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            if (vector.elementAt(i2) != null) continue;
            return i2 - 1;
        }
        return vector.size() - 1;
    }

    protected int calcFillOrientation(Rectangle rectangle, double d2, boolean bl, boolean bl2, boolean bl3) {
        int n2 = this.yaxis.toPixel(d2, this.drawFront);
        if (!bl) {
            if (rectangle.y < n2) {
                rectangle.height = Math.abs(n2 - rectangle.y);
                if (!bl2) {
                    return 6;
                }
                return 8;
            }
            if (!bl2) {
                return 7;
            }
            return 9;
        }
        if (rectangle.x < n2) {
            rectangle.width = Math.abs(n2 - rectangle.x);
            if (!bl2) {
                return 8;
            }
            return 9;
        }
        if (!bl2) {
            return 6;
        }
        return 7;
    }

    protected PickShapeArea createPickShapeArea(Picker picker) {
        return new PickShapeArea(picker, this.inverted);
    }

    @Override
    public JCDataIndex pick(Point point, int n2) {
        if (this.chartArea == null) {
            return null;
        }
        JCAreaDataIndex jCAreaDataIndex = null;
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        Picker picker = new Picker(point2.x, point2.y, n2);
        PickShapeArea pickShapeArea = this.createPickShapeArea(picker);
        this.processPlotData(pickShapeArea, null, -1, -1, false);
        int n3 = this.getPointIndex(picker.point);
        if (picker.series >= 0 && n3 >= 0) {
            jCAreaDataIndex = new JCAreaDataIndex(this.dataObject, picker.series, n3, picker.isHole);
            jCAreaDataIndex.distance = picker.distance;
        }
        return jCAreaDataIndex;
    }

    @Override
    public Point unpick(int n2, int n3) {
        JCChartStyle jCChartStyle;
        if (this.seriesList == null) {
            return null;
        }
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
        if (chartDataViewSeries == null || this.yaxis == null) {
            return null;
        }
        int n4 = this.getDataIndex(n2);
        double[] dArray = this.getXVals(chartDataViewSeries);
        double d2 = this.holeValue;
        if (n4 >= 0 && n4 < dArray.length) {
            d2 = dArray[n4];
        }
        double[] dArray2 = this.getCalculatedYVals(chartDataViewSeries);
        double d3 = this.holeValue;
        if (n4 >= 0 && n4 < dArray2.length) {
            d3 = dArray2[n4];
        }
        if (d3 != this.holeValue && chartDataViewSeries.isYHole(n2, this.yaxis.isLogarithmic()) && ((jCChartStyle = chartDataViewSeries.getHoleStyle()) == null || jCChartStyle.getFillStyle() == null)) {
            d3 = this.holeValue;
        }
        if (!this.xaxis.skipValue(d2, this.holeValue) && d3 != this.holeValue) {
            int n5;
            int n6;
            if (this.inverted) {
                n6 = this.yaxis.toPixel(d3, this.drawFront);
                n5 = this.xaxis.toPixel(d2, this.drawFront);
            } else {
                n6 = this.xaxis.toPixel(d2, this.drawFront);
                n5 = this.yaxis.toPixel(d3, this.drawFront);
            }
            return new Point(n6, n5);
        }
        return null;
    }

    protected Point transformPoint(double d2, double d3) {
        if (this.inverted) {
            return new Point(this.yaxis.toPixel(d3, this.drawFront) + this.r.x, this.xaxis.toPixel(d2, this.drawFront) + this.r.y);
        }
        return new Point(this.xaxis.toPixel(d2, this.drawFront) + this.r.x, this.yaxis.toPixel(d3, this.drawFront) + this.r.y);
    }

    protected void computePrev(JCDataIndex jCDataIndex) {
        ChartDataViewSeries chartDataViewSeries = jCDataIndex.series;
        double d2 = chartDataViewSeries.getX(jCDataIndex.point);
        int n2 = this.getStartPoint(chartDataViewSeries);
        int n3 = this.getEndPoint(chartDataViewSeries);
        double d3 = d2;
        double d4 = Double.MAX_VALUE;
        if (jCDataIndex.point > 0 && jCDataIndex.point > n2 && jCDataIndex.point <= n3) {
            int n4 = jCDataIndex.point - 1;
            while (d3 == d2 && n4 >= 0 && n4 >= n2) {
                double d5 = chartDataViewSeries.getX(n4);
                if (this.xaxis.skipValue(d5, this.holeValue)) {
                    --n4;
                    continue;
                }
                double d6 = chartDataViewSeries.getCalculatedY(n4);
                if (d6 == this.holeValue) break;
                if (JCChartUtil.locateXY(d5, d6, this.xlim.min, this.xlim.max, this.ylim.min, this.ylim.max) == 0) {
                    d3 = d5;
                    d4 = d6;
                }
                --n4;
            }
        }
        if (d4 != Double.MAX_VALUE) {
            this.prev = this.transformPoint(d3, d4);
        }
    }

    protected void computeNext(JCDataIndex jCDataIndex) {
        ChartDataViewSeries chartDataViewSeries = jCDataIndex.series;
        double d2 = chartDataViewSeries.getX(jCDataIndex.point);
        int n2 = this.getStartPoint(chartDataViewSeries);
        int n3 = this.getEndPoint(chartDataViewSeries);
        double d3 = d2;
        double d4 = Double.MAX_VALUE;
        if (jCDataIndex.point < chartDataViewSeries.maxXIndex() && jCDataIndex.point >= n2 && jCDataIndex.point < n3) {
            int n4 = jCDataIndex.point + 1;
            while (d3 == d2 && n4 <= n3) {
                double d5 = chartDataViewSeries.getX(n4);
                if (this.xaxis.skipValue(d5, this.holeValue)) {
                    ++n4;
                    continue;
                }
                double d6 = chartDataViewSeries.getCalculatedY(n4);
                if (d6 == this.holeValue) break;
                if (JCChartUtil.locateXY(d5, d6, this.xlim.min, this.xlim.max, this.ylim.min, this.ylim.max) == 0) {
                    d3 = d5;
                    d4 = d6;
                }
                ++n4;
            }
        }
        if (d4 != Double.MAX_VALUE) {
            this.next = this.transformPoint(d3, d4);
        }
    }

    protected void drawRubberLines() {
        if (this.prev != null && this.prev.equals(this.next)) {
            this.chartArea.drawRubberLine(this.prev, this.last);
        } else {
            this.chartArea.drawRubberLine(this.prev, this.last);
            this.chartArea.drawRubberLine(this.last, this.next);
        }
    }

    @Override
    void startEdit(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        ChartDataViewSeries chartDataViewSeries = jCDataIndex.series;
        int n2 = jCDataIndex.point;
        if (chartDataViewSeries == null || n2 < this.getStartPoint(chartDataViewSeries) || n2 > this.getEndPoint(chartDataViewSeries) || this.xaxis.skipValue(chartDataViewSeries.getX(n2), this.holeValue)) {
            return;
        }
        this.r = this.chartArea.getDrawingArea();
        this.last = null;
        this.next = null;
        this.prev = null;
        int n3 = this.getDataIndex(n2);
        double[] dArray = this.getXVals(chartDataViewSeries);
        double[] dArray2 = this.getCalculatedYVals(chartDataViewSeries);
        this.computePrev(jCDataIndex);
        this.computeNext(jCDataIndex);
        if (this.prev == null) {
            this.prev = this.transformPoint(dArray[n3], dArray2[n3]);
        }
        if (this.next == null) {
            this.next = this.transformPoint(dArray[n3], dArray2[n3]);
        }
    }

    @Override
    void showEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject || jCDataIndex.series == null) {
            return;
        }
        ChartDataViewSeries chartDataViewSeries = jCDataIndex.series;
        if (this.xaxis.skipValue(chartDataViewSeries.getX(jCDataIndex.point), this.holeValue)) {
            return;
        }
        this.drawRubberLines();
        JCAxis jCAxis = jCDataIndex.dataView.getXAxis();
        if (this.last == null) {
            double d2 = chartDataViewSeries.getX(jCDataIndex.point);
            this.last = this.inverted ? new Point(n2, jCAxis.toPixel(d2, this.drawFront) + this.r.y) : new Point(jCAxis.toPixel(d2, this.drawFront) + this.r.x, n3);
        } else if (this.inverted) {
            this.last.x = n2;
        } else {
            this.last.y = n3;
        }
        this.drawRubberLines();
    }

    @Override
    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject || jCDataIndex.series == null) {
            return -1;
        }
        ChartDataViewSeries chartDataViewSeries = jCDataIndex.series;
        if (this.xaxis.skipValue(chartDataViewSeries.getX(jCDataIndex.point), this.holeValue)) {
            return -1;
        }
        this.drawRubberLines();
        this.last = null;
        this.next = null;
        this.prev = null;
        return this.inverted ? n2 - this.r.x : n3 - this.r.y;
    }

    protected void defineAreaShapes(DefineShape defineShape, Graphics graphics, JCFillStyle jCFillStyle, boolean bl, AreaPolygon areaPolygon, ChartDataViewSeries chartDataViewSeries) {
        int n2;
        double[] dArray = this.getXVals(chartDataViewSeries);
        Polygon polygon = areaPolygon.poly;
        int n3 = n2 = areaPolygon.isLeading ? 0 : 1;
        for (int i2 = areaPolygon.startPoint; i2 < areaPolygon.endPoint; ++i2) {
            int n4;
            int n5;
            double d2;
            int n6;
            if (this.xaxis.skipValue(dArray[i2], this.holeValue)) continue;
            int n7 = polygon.xpoints[n3];
            int n8 = polygon.ypoints[n3];
            int n9 = i2 - areaPolygon.startPoint + n2 + 1;
            int n10 = polygon.xpoints[n9];
            int n11 = polygon.ypoints[n9];
            double d3 = n10 - n7;
            double d4 = n11 - n8;
            if (bl) {
                n6 = polygon.xpoints[0];
                d2 = d3 / d4;
                n5 = n8 + (int)(d4 / 2.0);
                n4 = n7 - (int)(d2 * (double)(n8 - n5));
            } else {
                n6 = polygon.ypoints[0];
                d2 = d4 / d3;
                n4 = n7 + (int)(d3 / 2.0);
                n5 = n8 - (int)(d2 * (double)(n7 - n4));
            }
            this.createShape(defineShape, graphics, jCFillStyle, bl, chartDataViewSeries, i2 + 1 - (n9 - n3), n7, n8, n6, n4, n5, n6);
            this.createShape(defineShape, graphics, jCFillStyle, bl, chartDataViewSeries, i2 + 1, n4, n5, n6, n10, n11, n6);
            n3 = n9;
        }
    }

    protected void createShape(DefineShape defineShape, Graphics graphics, JCFillStyle jCFillStyle, boolean bl, ChartDataViewSeries chartDataViewSeries, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Polygon polygon = new Polygon();
        if (bl) {
            polygon.addPoint(n5, n4);
            polygon.addPoint(n3, n4);
            polygon.addPoint(n6, n7);
            polygon.addPoint(n8, n7);
        } else {
            polygon.addPoint(n3, n5);
            polygon.addPoint(n3, n4);
            polygon.addPoint(n6, n7);
            polygon.addPoint(n6, n8);
        }
        int n9 = this.getPointIndex(n2);
        boolean bl2 = chartDataViewSeries.isYHole(n9, this.yaxis.isLogarithmic());
        defineShape.beginShape(new JCAreaDataIndex(n9, chartDataViewSeries, bl2));
        jCFillStyle.fillPolygon(graphics, polygon);
        defineShape.endShape(false);
    }
}

