/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartEnumMappings;
import java.io.Serializable;

public abstract class ActionHandler
implements Serializable {
    protected JCChartArea parent = null;

    protected ActionHandler() {
    }

    protected void setParent(JCChartArea jCChartArea) {
        this.parent = jCChartArea;
    }

    protected static ActionHandler makeHandler(int n2, JCChartArea jCChartArea) {
        ActionHandler actionHandler;
        if (n2 == 6 || n2 == 4 || n2 == 7) {
            return null;
        }
        try {
            String string = "com.klg.jclass.chart." + JCChartEnumMappings.trigger_strings[n2 + 1] + "Handler";
            actionHandler = (ActionHandler)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            JCChart jCChart;
            if (jCChartArea != null && (jCChart = (JCChart)jCChartArea.getParent()) != null) {
                jCChart.getErrorLog().logErrorMessage("makeHandler", exception);
            }
            return null;
        }
        actionHandler.setParent(jCChartArea);
        return actionHandler;
    }

    protected abstract void start(int var1, int var2);

    protected abstract void animate(int var1, int var2);

    protected abstract void reanimate(int var1, int var2);

    protected abstract void end(int var1, int var2);

    protected JCChart getChart() {
        if (this.parent == null) {
            return null;
        }
        return (JCChart)this.parent.getParent();
    }
}

