/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

final class WindowsFieldCaret
extends DefaultCaret
implements UIResource {
    private static final LayeredHighlighter.LayerPainter WindowsPainter = new WindowsHighlightPainter(null);
    private boolean isKeyboardFocusEvent = true;

    WindowsFieldCaret() {
    }

    public void focusGained(FocusEvent e2) {
        JTextComponent c2;
        if (this.getComponent().isEnabled()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
        }
        if ((c2 = this.getComponent()).isEnabled() && this.isKeyboardFocusEvent) {
            if (c2 instanceof JFormattedTextField) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        WindowsFieldCaret.super.setDot(0);
                        WindowsFieldCaret.super.moveDot(c2.getDocument().getLength());
                    }
                });
            } else {
                super.setDot(0);
                super.moveDot(c2.getDocument().getLength());
            }
        }
    }

    public void focusLost(FocusEvent e2) {
        super.focusLost(e2);
        if (!e2.isTemporary()) {
            this.isKeyboardFocusEvent = true;
        }
    }

    public void mousePressed(MouseEvent e2) {
        if (SwingUtilities.isLeftMouseButton(e2) || e2.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
        }
        super.mousePressed(e2);
    }

    public void mouseReleased(MouseEvent e2) {
        super.mouseReleased(e2);
        if (e2.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
            if (this.getComponent() != null && this.getComponent().isEnabled() && this.getComponent().isRequestFocusEnabled()) {
                this.getComponent().requestFocus();
            }
        }
    }

    protected void adjustVisibility(Rectangle r2) {
        SwingUtilities.invokeLater(new SafeScroller(r2));
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return WindowsPainter;
    }

    private static final class WindowsHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        WindowsHighlightPainter(Color c2) {
            super(c2);
        }

        public void paint(Graphics g2, int offs0, int offs1, Shape bounds, JTextComponent c2) {
            Rectangle alloc = bounds.getBounds();
            try {
                TextUI mapper = c2.getUI();
                Rectangle p0 = mapper.modelToView(c2, offs0);
                Rectangle p1 = mapper.modelToView(c2, offs1);
                Color color = this.getColor();
                if (color == null) {
                    g2.setColor(c2.getSelectionColor());
                } else {
                    g2.setColor(color);
                }
                boolean firstIsDot = false;
                boolean secondIsDot = false;
                if (c2.isEditable()) {
                    int dot = c2.getCaretPosition();
                    firstIsDot = offs0 == dot;
                    boolean bl = secondIsDot = offs1 == dot;
                }
                if (p0.y == p1.y) {
                    Rectangle r2 = p0.union(p1);
                    if (r2.width > 0) {
                        if (firstIsDot) {
                            ++r2.x;
                            --r2.width;
                        } else if (secondIsDot) {
                            --r2.width;
                        }
                    }
                    g2.fillRect(r2.x, r2.y, r2.width, r2.height);
                } else {
                    int p0ToMarginWidth = alloc.x + alloc.width - p0.x;
                    if (firstIsDot && p0ToMarginWidth > 0) {
                        ++p0.x;
                        --p0ToMarginWidth;
                    }
                    g2.fillRect(p0.x, p0.y, p0ToMarginWidth, p0.height);
                    if (p0.y + p0.height != p1.y) {
                        g2.fillRect(alloc.x, p0.y + p0.height, alloc.width, p1.y - (p0.y + p0.height));
                    }
                    if (secondIsDot && p1.x > alloc.x) {
                        --p1.x;
                    }
                    g2.fillRect(alloc.x, p1.y, p1.x - alloc.x, p1.height);
                }
            }
            catch (BadLocationException e2) {
                // empty catch block
            }
        }

        public Shape paintLayer(Graphics g2, int offs0, int offs1, Shape bounds, JTextComponent c2, View view) {
            Color color = this.getColor();
            if (color == null) {
                g2.setColor(c2.getSelectionColor());
            } else {
                g2.setColor(color);
            }
            boolean firstIsDot = false;
            boolean secondIsDot = false;
            if (c2.isEditable()) {
                int dot = c2.getCaretPosition();
                firstIsDot = offs0 == dot;
                boolean bl = secondIsDot = offs1 == dot;
            }
            if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                Rectangle alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
                if (firstIsDot && alloc.width > 0) {
                    g2.fillRect(alloc.x + 1, alloc.y, alloc.width - 1, alloc.height);
                } else if (secondIsDot && alloc.width > 0) {
                    g2.fillRect(alloc.x, alloc.y, alloc.width - 1, alloc.height);
                } else {
                    g2.fillRect(alloc.x, alloc.y, alloc.width, alloc.height);
                }
                return alloc;
            }
            try {
                Rectangle r2;
                Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                Rectangle rectangle = r2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                if (firstIsDot && r2.width > 0) {
                    g2.fillRect(r2.x + 1, r2.y, r2.width - 1, r2.height);
                } else if (secondIsDot && r2.width > 0) {
                    g2.fillRect(r2.x, r2.y, r2.width - 1, r2.height);
                } else {
                    g2.fillRect(r2.x, r2.y, r2.width, r2.height);
                }
                return r2;
            }
            catch (BadLocationException e2) {
                return null;
            }
        }
    }

    private final class SafeScroller
    implements Runnable {
        private Rectangle r;

        SafeScroller(Rectangle r2) {
            this.r = r2;
        }

        public void run() {
            JTextField field = (JTextField)WindowsFieldCaret.this.getComponent();
            if (field != null) {
                TextUI ui = field.getUI();
                int dot = WindowsFieldCaret.this.getDot();
                Position.Bias bias = Position.Bias.Forward;
                Rectangle startRect = null;
                try {
                    startRect = ui.modelToView(field, dot, bias);
                }
                catch (BadLocationException ble) {
                    // empty catch block
                }
                Insets i2 = field.getInsets();
                BoundedRangeModel vis = field.getHorizontalVisibility();
                int x = this.r.x + vis.getValue() - i2.left;
                int quarterSpan = vis.getExtent() / 4;
                if (this.r.x < i2.left) {
                    vis.setValue(x - quarterSpan);
                } else if (this.r.x + this.r.width > i2.left + vis.getExtent()) {
                    vis.setValue(x - 3 * quarterSpan);
                }
                if (startRect != null) {
                    try {
                        Rectangle endRect = ui.modelToView(field, dot, bias);
                        if (endRect != null && !endRect.equals(startRect)) {
                            WindowsFieldCaret.this.damage(endRect);
                        }
                    }
                    catch (BadLocationException ble) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

