/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.io.Serializable;

public class VerticalFlowLayout
extends FlowLayout
implements Serializable {
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    int hgap;
    int vgap;
    boolean hfill;
    boolean vfill;

    public VerticalFlowLayout() {
        this(0, 5, 5, true, false);
    }

    public VerticalFlowLayout(boolean hfill, boolean vfill) {
        this(0, 5, 5, hfill, vfill);
    }

    public VerticalFlowLayout(int align) {
        this(align, 5, 5, true, false);
    }

    public VerticalFlowLayout(int align, boolean hfill, boolean vfill) {
        this(align, 5, 5, hfill, vfill);
    }

    public VerticalFlowLayout(int align, int hgap, int vgap, boolean hfill, boolean vfill) {
        this.setAlignment(align);
        this.hgap = hgap;
        this.vgap = vgap;
        this.hfill = hfill;
        this.vfill = vfill;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        super.setHgap(hgap);
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        super.setVgap(vgap);
        this.vgap = vgap;
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension tarsiz = new Dimension(0, 0);
        for (int i2 = 0; i2 < target.getComponentCount(); ++i2) {
            Component m2 = target.getComponent(i2);
            if (!m2.isVisible()) continue;
            Dimension d2 = m2.getPreferredSize();
            tarsiz.width = Math.max(tarsiz.width, d2.width);
            if (i2 > 0) {
                tarsiz.height += this.vgap;
            }
            tarsiz.height += d2.height;
        }
        Insets insets = target.getInsets();
        tarsiz.width += insets.left + insets.right + this.hgap * 2;
        tarsiz.height += insets.top + insets.bottom + this.vgap * 2;
        return tarsiz;
    }

    public Dimension minimumLayoutSize(Container target) {
        Dimension tarsiz = new Dimension(0, 0);
        for (int i2 = 0; i2 < target.getComponentCount(); ++i2) {
            Component m2 = target.getComponent(i2);
            if (!m2.isVisible()) continue;
            Dimension d2 = m2.getMinimumSize();
            tarsiz.width = Math.max(tarsiz.width, d2.width);
            if (i2 > 0) {
                tarsiz.height += this.vgap;
            }
            tarsiz.height += d2.height;
        }
        Insets insets = target.getInsets();
        tarsiz.width += insets.left + insets.right + this.hgap * 2;
        tarsiz.height += insets.top + insets.bottom + this.vgap * 2;
        return tarsiz;
    }

    public void setVerticalFill(boolean vfill) {
        this.vfill = vfill;
    }

    public boolean getVerticalFill() {
        return this.vfill;
    }

    public void setHorizontalFill(boolean hfill) {
        this.hfill = hfill;
    }

    public boolean getHorizontalFill() {
        return this.hfill;
    }

    private void placethem(Container target, int x, int y, int width, int height, int first, int last) {
        int align = this.getAlignment();
        Insets insets = target.getInsets();
        if (align == 1) {
            y += height / 2;
        }
        if (align == 2) {
            y += height;
        }
        for (int i2 = first; i2 < last; ++i2) {
            Component m2 = target.getComponent(i2);
            Dimension md = m2.getSize();
            if (!m2.isVisible()) continue;
            int px = x + (width - md.width) / 2;
            m2.setLocation(px, y);
            y += this.vgap + md.height;
        }
    }

    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        int maxheight = target.getSize().height - (insets.top + insets.bottom + this.vgap * 2);
        int maxwidth = target.getSize().width - (insets.left + insets.right + this.hgap * 2);
        int numcomp = target.getComponentCount();
        int x = insets.left + this.hgap;
        int y = 0;
        int colw = 0;
        int start = 0;
        for (int i2 = 0; i2 < numcomp; ++i2) {
            Component m2 = target.getComponent(i2);
            if (!m2.isVisible()) continue;
            Dimension d2 = m2.getPreferredSize();
            if (this.vfill && i2 == numcomp - 1) {
                d2.height = Math.max(maxheight - y, m2.getPreferredSize().height);
            }
            if (this.hfill) {
                m2.setSize(maxwidth, d2.height);
                d2.width = maxwidth;
            } else {
                m2.setSize(d2.width, d2.height);
            }
            if (y + d2.height > maxheight) {
                this.placethem(target, x, insets.top + this.vgap, colw, maxheight - y, start, i2);
                y = d2.height;
                x += this.hgap + colw;
                colw = d2.width;
                start = i2;
                continue;
            }
            if (y > 0) {
                y += this.vgap;
            }
            y += d2.height;
            colw = Math.max(colw, d2.width);
        }
        this.placethem(target, x, insets.top + this.vgap, colw, maxheight - y, start, numcomp);
    }
}

