/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.test.smi;

import com.agentpp.smi.IModule;
import com.agentpp.smi.IObject;
import com.agentpp.smi.SMIRepository;
import com.agentpp.smi.SMIRepositoryManager;
import com.agentpp.smi.event.ImportModuleEvent;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smi.event.RepositoryEvent;
import com.agentpp.smi.event.RepositoryListener;
import java.io.File;
import java.io.StringBufferInputStream;
import java.util.Random;
import junit.framework.TestCase;

public class TestSMIRepositoryManager
extends TestCase
implements RepositoryListener,
ImportModuleListener {
    private static String SNMPv2_MIB = "\n\n   SNMPv2-MIB DEFINITIONS ::= BEGIN\n\n   IMPORTS\n       MODULE-IDENTITY, OBJECT-TYPE, NOTIFICATION-TYPE,\n       TimeTicks, Counter32, snmpModules, mib-2\n           FROM SNMPv2-SMI\n       DisplayString, TestAndIncr, TimeStamp\n           FROM SNMPv2-TC\n       MODULE-COMPLIANCE, OBJECT-GROUP, NOTIFICATION-GROUP\n           FROM SNMPv2-CONF;\n\n   snmpMIB MODULE-IDENTITY\n       LAST-UPDATED \"200210160000Z\"\n       ORGANIZATION \"IETF SNMPv3 Working Group\"\n       CONTACT-INFO\n               \"WG-EMail:   snmpv3@lists.tislabs.com\n                Subscribe:  snmpv3-request@lists.tislabs.com\n\n                Co-Chair:   Russ Mundy\n                            Network Associates Laboratories\n                postal:     15204 Omega Drive, Suite 300\n                            Rockville, MD 20850-4601\n                            USA\n                EMail:      mundy@tislabs.com\n                phone:      +1 301 947-7107\n\n                Co-Chair:   David Harrington\n                            Enterasys Networks\n                postal:     35 Industrial Way\n                            P. O. Box 5005\n                            Rochester, NH 03866-5005\n                            USA\n                EMail:      dbh@enterasys.com\n                phone:      +1 603 337-2614\n\n                Editor:     Randy Presuhn\n                            BMC Software, Inc.\n                postal:     2141 North First Street\n                            San Jose, CA 95131\n                            USA\n                EMail:      randy_presuhn@bmc.com\n                phone:      +1 408 546-1006\"\n       DESCRIPTION\n               \"The MIB module for SNMP entities.\n\n                Copyright (C) The Internet Society (2002). This\n                version of this MIB module is part of RFC 3418;\n                see the RFC itself for full legal notices.\n               \"\n       REVISION      \"200210160000Z\"\n       DESCRIPTION\n               \"This revision of this MIB module was published as\n                RFC 3418.\"\n       REVISION      \"199511090000Z\"\n       DESCRIPTION\n               \"This revision of this MIB module was published as\n                RFC 1907.\"\n       REVISION      \"199304010000Z\"\n       DESCRIPTION\n               \"The initial revision of this MIB module was published\n               as RFC 1450.\"\n       ::= { snmpModules 1 }\n\n   snmpMIBObjects OBJECT IDENTIFIER ::= { snmpMIB 1 }\n\n   --  ::= { snmpMIBObjects 1 }        this OID is obsolete\n   --  ::= { snmpMIBObjects 2 }        this OID is obsolete\n   --  ::= { snmpMIBObjects 3 }        this OID is obsolete\n\n   -- the System group\n   --\n   -- a collection of objects common to all managed systems.\n\n   system   OBJECT IDENTIFIER ::= { mib-2 1 }\n\n   sysDescr OBJECT-TYPE\n       SYNTAX      DisplayString (SIZE (0..255))\n       MAX-ACCESS  read-only\n       STATUS      current\n       DESCRIPTION\n               \"A textual description of the entity.  This value should\n               include the full name and version identification of\n               the system's hardware type, software operating-system,\n               and networking software.\"\n       ::= { system 1 }\n\n   sysObjectID OBJECT-TYPE\n       SYNTAX      OBJECT IDENTIFIER\n       MAX-ACCESS  read-only\n       STATUS      current\n       DESCRIPTION\n               \"The vendor's authoritative identification of the\n               network management subsystem contained in the entity.\n               This value is allocated within the SMI enterprises\n               subtree (1.3.6.1.4.1) and provides an easy and\n               unambiguous means for determining `what kind of box' is\n               being managed.  For example, if vendor `Flintstones,\n               Inc.' was assigned the subtree 1.3.6.1.4.1.424242,\n               it could assign the identifier 1.3.6.1.4.1.424242.1.1\n               to its `Fred Router'.\"\n       ::= { system 2 }\n\n   sysUpTime OBJECT-TYPE\n       SYNTAX      TimeTicks\n       MAX-ACCESS  read-only\n       STATUS      current\n       DESCRIPTION\n               \"The time (in hundredths of a second) since the\n               network management portion of the system was last\n               re-initialized.\"\n       ::= { system 3 }\n\n   sysContact OBJECT-TYPE\n       SYNTAX      DisplayString (SIZE (0..255))\n       MAX-ACCESS  read-write\n       STATUS      current\n       DESCRIPTION\n               \"The textual identification of the contact person for\n               this managed node, together with information on how\n               to contact this person.  If no contact information is\n               known, the value is the zero-length string.\"\n       ::= { system 4 }\n\n   sysName OBJECT-TYPE\n       SYNTAX      DisplayString (SIZE (0..255))\n       MAX-ACCESS  read-write\n       STATUS      current\n       DESCRIPTION\n               \"An administratively-assigned name for this managed\n               node.  By convention, this is the node's fully-qualified\n               domain name.  If the name is unknown, the value is\n               the zero-length string.\"\n       ::= { system 5 }\n\n   sysLocation OBJECT-TYPE\n       SYNTAX      DisplayString (SIZE (0..255))\n       MAX-ACCESS  read-write\n       STATUS      current\n       DESCRIPTION\n               \"The physical location of this node (e.g., 'telephone\n               closet, 3rd floor').  If the location is unknown, the\n               value is the zero-length string.\"\n       ::= { system 6 }\n\n   sysServices OBJECT-TYPE\n       SYNTAX      INTEGER (0..127)\n       MAX-ACCESS  read-only\n       STATUS      current\n       DESCRIPTION\n               \"A value which indicates the set of services that this\n               entity may potentially offer.  The value is a sum.\n               This sum initially takes the value zero. Then, for\n               each layer, L, in the range 1 through 7, that this node\n               performs transactions for, 2 raised to (L - 1) is added\n               to the sum.  For example, a node which performs only\n               routing functions would have a value of 4 (2^(3-1)).\n               In contrast, a node which is a host offering application\n               services would have a value of 72 (2^(4-1) + 2^(7-1)).\n               Note that in the context of the Internet suite of\n               protocols, values should be calculated accordingly:\n\n                    layer      functionality\n                      1        physical (e.g., repeaters)\n                      2        datalink/subnetwork (e.g., bridges)\n                      3        internet (e.g., supports the IP)\n                      4        end-to-end  (e.g., supports the TCP)\n                      7        applications (e.g., supports the SMTP)\n\n               For systems including OSI protocols, layers 5 and 6\n               may also be counted.\"\n       ::= { system 7 }\n\n   -- object resource information\n   --\n   -- a collection of objects which describe the SNMP entity's\n   -- (statically and dynamically configurable) support of\n   -- various MIB modules.\n\n   sysORLastChange OBJECT-TYPE\n       SYNTAX     TimeStamp\n       MAX-ACCESS read-only\n       STATUS     current\n       DESCRIPTION\n               \"The value of sysUpTime at the time of the most recent\n               change in state or value of any instance of sysORID.\"\n       ::= { system 8 }\n\n   sysORTable OBJECT-TYPE\n       SYNTAX     SEQUENCE OF SysOREntry\n       MAX-ACCESS not-accessible\n       STATUS     current\n       DESCRIPTION\n               \"The (conceptual) table listing the capabilities of\n               the local SNMP application acting as a command\n               responder with respect to various MIB modules.\n               SNMP entities having dynamically-configurable support\n               of MIB modules will have a dynamically-varying number\n               of conceptual rows.\"\n       ::= { system 9 }\n\n   sysOREntry OBJECT-TYPE\n       SYNTAX     SysOREntry\n       MAX-ACCESS not-accessible\n       STATUS     current\n       DESCRIPTION\n               \"An entry (conceptual row) in the sysORTable.\"\n       INDEX      { sysORIndex }\n       ::= { sysORTable 1 }\n\n   SysOREntry ::= SEQUENCE {\n       sysORIndex     INTEGER,\n       sysORID        OBJECT IDENTIFIER,\n       sysORDescr     DisplayString,\n       sysORUpTime    TimeStamp\n   }\n\n   sysORIndex OBJECT-TYPE\n       SYNTAX     INTEGER (1..2147483647)\n       MAX-ACCESS not-accessible\n       STATUS     current\n       DESCRIPTION\n               \"The auxiliary variable used for identifying instances\n               of the columnar objects in the sysORTable.\"\n       ::= { sysOREntry 1 }\n\n   sysORID OBJECT-TYPE\n       SYNTAX     OBJECT IDENTIFIER\n       MAX-ACCESS read-only\n       STATUS     current\n       DESCRIPTION\n               \"An authoritative identification of a capabilities\n               statement with respect to various MIB modules supported\n               by the local SNMP application acting as a command\n               responder.\"\n       ::= { sysOREntry 2 }\n\n   sysORDescr OBJECT-TYPE\n       SYNTAX     DisplayString\n       MAX-ACCESS read-only\n       STATUS     current\n       DESCRIPTION\n               \"A textual description of the capabilities identified\n               by the corresponding instance of sysORID.\"\n       ::= { sysOREntry 3 }\n\n   sysORUpTime OBJECT-TYPE\n       SYNTAX     TimeStamp\n       MAX-ACCESS read-only\n       STATUS     current\n       DESCRIPTION\n               \"The value of sysUpTime at the time this conceptual\n               row was last instantiated.\"\n       ::= { sysOREntry 4 }\n\n\n   -- the SNMP group\n   --\n   -- a collection of objects providing basic instrumentation and\n   -- control of an SNMP entity.\n\n   snmp     OBJECT IDENTIFIER ::= { mib-2 11 }\n\n   snmpInPkts OBJECT-TYPE\n       SYNTAX     Counter32\n       MAX-ACCESS read-only\n       STATUS     current\n       DESCRIPTION\n               \"The total number of messages delivered to the SNMP\n               entity from the transport service.\"\n       ::= { snmp 1 }\n\n   snmpInBadVersions OBJECT-TYPE\n       SYNTAX     Counter32\n       MAX-ACCESS read-only\n       STATUS     current\n       DESCRIPTION\n               \"The total number of SNMP messages which were delivered\n               to the SNMP entity and were for an unsupported SNMP\n               version.\"\n       ::= { snmp 3 }\n\n   snmpInBadCommunityNames OBJECT-TYPE\n       SYNTAX     Counter32\n       MAX-ACCESS read-only\n       STATUS     current\n       DESCRIPTION\n              \"The total number of community-based SNMP messages (for\n              example,  SNMPv1) delivered to the SNMP entity which\n              used an SNMP community name not known to said entity.\n              Also, implementations which authenticate community-based\n              SNMP messages using check(s) in addition to matching\n              the community name (for example, by also checking\n              whether the message originated from a transport address\n              allowed to use a specified community name) MAY include\n              in this value the number of messages which failed the\n              additional check(s).  It is strongly RECOMMENDED that\n              the documentation for any security model which is used\n              to authenticate community-based SNMP messages specify\n              the precise conditions that contribute to this value.\"\n       ::= { snmp 4 }\n\n   snmpInBadCommunityUses OBJECT-TYPE\n       SYNTAX     Counter32\n       MAX-ACCESS read-only\n       STATUS     current\n       DESCRIPTION\n              \"The total number of community-based SNMP messages (for\n              example, SNMPv1) delivered to the SNMP entity which\n              represented an SNMP operation that was not allowed for\n              the SNMP community named in the message.  The precise\n              conditions under which this counter is incremented\n              (if at all) depend on how the SNMP entity implements\n              its access control mechanism and how its applications\n              interact with that access control mechanism.  It is\n              strongly RECOMMENDED that the documentation for any\n              access control mechanism which is used to control access\n              to and visibility of MIB instrumentation specify the\n              precise conditions that contribute to this value.\"\n       ::= { snmp 5 }\n\n   snmpInASNParseErrs OBJECT-TYPE\n       SYNTAX     Counter32\n       MAX-ACCESS read-only\n       STATUS     current\n       DESCRIPTION\n               \"The total number of ASN.1 or BER errors encountered by\n               the SNMP entity when decoding received SNMP messages.\"\n       ::= { snmp 6 }\n\n   snmpEnableAuthenTraps OBJECT-TYPE\n       SYNTAX      INTEGER { enabled(1), disabled(2) }\n       MAX-ACCESS  read-write\n       STATUS      current\n       DESCRIPTION\n               \"Indicates whether the SNMP entity is permitted to\n               generate authenticationFailure traps.  The value of this\n               object overrides any configuration information; as such,\n               it provides a means whereby all authenticationFailure\n               traps may be disabled.\n\n               Note that it is strongly recommended that this object\n               be stored in non-volatile memory so that it remains\n               constant across re-initializations of the network\n               management system.\"\n       ::= { snmp 30 }\n\n   snmpSilentDrops OBJECT-TYPE\n       SYNTAX     Counter32\n       MAX-ACCESS read-only\n       STATUS     current\n       DESCRIPTION\n              \"The total number of Confirmed Class PDUs (such as\n              GetRequest-PDUs, GetNextRequest-PDUs,\n              GetBulkRequest-PDUs, SetRequest-PDUs, and\n              InformRequest-PDUs) delivered to the SNMP entity which\n              were silently dropped because the size of a reply\n              containing an alternate Response Class PDU (such as a\n              Response-PDU) with an empty variable-bindings field\n              was greater than either a local constraint or the\n              maximum message size associated with the originator of\n              the request.\"\n       ::= { snmp 31 }\n\n   snmpProxyDrops OBJECT-TYPE\n       SYNTAX     Counter32\n       MAX-ACCESS read-only\n       STATUS     current\n       DESCRIPTION\n               \"The total number of Confirmed Class PDUs\n               (such as GetRequest-PDUs, GetNextRequest-PDUs,\n               GetBulkRequest-PDUs, SetRequest-PDUs, and\n               InformRequest-PDUs) delivered to the SNMP entity which\n               were silently dropped because the transmission of\n               the (possibly translated) message to a proxy target\n               failed in a manner (other than a time-out) such that\n               no Response Class PDU (such as a Response-PDU) could\n               be returned.\"\n       ::= { snmp 32 }\n\n   -- information for notifications\n   --\n   -- a collection of objects which allow the SNMP entity, when\n   -- supporting a notification originator application,\n   -- to be configured to generate SNMPv2-Trap-PDUs.\n\n   snmpTrap       OBJECT IDENTIFIER ::= { snmpMIBObjects 4 }\n\n   snmpTrapOID OBJECT-TYPE\n       SYNTAX     OBJECT IDENTIFIER\n       MAX-ACCESS accessible-for-notify\n       STATUS     current\n       DESCRIPTION\n               \"The authoritative identification of the notification\n               currently being sent.  This variable occurs as\n               the second varbind in every SNMPv2-Trap-PDU and\n               InformRequest-PDU.\"\n       ::= { snmpTrap 1 }\n\n   --  ::= { snmpTrap 2 }   this OID is obsolete\n\n   snmpTrapEnterprise OBJECT-TYPE\n       SYNTAX     OBJECT IDENTIFIER\n       MAX-ACCESS accessible-for-notify\n       STATUS     current\n       DESCRIPTION\n               \"The authoritative identification of the enterprise\n               associated with the trap currently being sent.  When an\n               SNMP proxy agent is mapping an RFC1157 Trap-PDU\n               into a SNMPv2-Trap-PDU, this variable occurs as the\n               last varbind.\"\n       ::= { snmpTrap 3 }\n\n   --  ::= { snmpTrap 4 }   this OID is obsolete\n\n\n   -- well-known traps\n\n   snmpTraps      OBJECT IDENTIFIER ::= { snmpMIBObjects 5 }\n\n   coldStart NOTIFICATION-TYPE\n       STATUS  current\n       DESCRIPTION\n               \"A coldStart trap signifies that the SNMP entity,\n               supporting a notification originator application, is\n               reinitializing itself and that its configuration may\n               have been altered.\"\n       ::= { snmpTraps 1 }\n\n   warmStart NOTIFICATION-TYPE\n       STATUS  current\n       DESCRIPTION\n               \"A warmStart trap signifies that the SNMP entity,\n               supporting a notification originator application,\n               is reinitializing itself such that its configuration\n               is unaltered.\"\n       ::= { snmpTraps 2 }\n\n   -- Note the linkDown NOTIFICATION-TYPE ::= { snmpTraps 3 }\n   -- and the linkUp NOTIFICATION-TYPE ::= { snmpTraps 4 }\n   -- are defined in RFC 2863 [RFC2863]\n\n   authenticationFailure NOTIFICATION-TYPE\n       STATUS  current\n       DESCRIPTION\n               \"An authenticationFailure trap signifies that the SNMP\n                entity has received a protocol message that is not\n                properly authenticated.  While all implementations\n                of SNMP entities MAY be capable of generating this\n                trap, the snmpEnableAuthenTraps object indicates\n                whether this trap will be generated.\"\n       ::= { snmpTraps 5 }\n\n   -- Note the egpNeighborLoss notification is defined\n   -- as { snmpTraps 6 } in RFC 1213\n\n   -- the set group\n   --\n   -- a collection of objects which allow several cooperating\n   -- command generator applications to coordinate their use of the\n   -- set operation.\n\n   snmpSet        OBJECT IDENTIFIER ::= { snmpMIBObjects 6 }\n\n   snmpSetSerialNo OBJECT-TYPE\n       SYNTAX     TestAndIncr\n       MAX-ACCESS read-write\n       STATUS     current\n       DESCRIPTION\n               \"An advisory lock used to allow several cooperating\n               command generator applications to coordinate their\n               use of the SNMP set operation.\n\n               This object is used for coarse-grain coordination.\n               To achieve fine-grain coordination, one or more similar\n               objects might be defined within each MIB group, as\n               appropriate.\"\n       ::= { snmpSet 1 }\n\n   -- conformance information\n\n   snmpMIBConformance\n                  OBJECT IDENTIFIER ::= { snmpMIB 2 }\n\n   snmpMIBCompliances\n                  OBJECT IDENTIFIER ::= { snmpMIBConformance 1 }\n   snmpMIBGroups  OBJECT IDENTIFIER ::= { snmpMIBConformance 2 }\n\n   -- compliance statements\n\n   --    ::= { snmpMIBCompliances 1 }      this OID is obsolete\n   snmpBasicCompliance MODULE-COMPLIANCE\n       STATUS  deprecated\n       DESCRIPTION\n               \"The compliance statement for SNMPv2 entities which\n               implement the SNMPv2 MIB.\n\n               This compliance statement is replaced by\n               snmpBasicComplianceRev2.\"\n       MODULE  -- this module\n           MANDATORY-GROUPS { snmpGroup, snmpSetGroup, systemGroup,\n                              snmpBasicNotificationsGroup }\n\n           GROUP   snmpCommunityGroup\n           DESCRIPTION\n               \"This group is mandatory for SNMPv2 entities which\n               support community-based authentication.\"\n\n       ::= { snmpMIBCompliances 2 }\n\n   snmpBasicComplianceRev2 MODULE-COMPLIANCE\n       STATUS  current\n       DESCRIPTION\n               \"The compliance statement for SNMP entities which\n               implement this MIB module.\"\n       MODULE  -- this module\n           MANDATORY-GROUPS { snmpGroup, snmpSetGroup, systemGroup,\n                              snmpBasicNotificationsGroup }\n\n           GROUP   snmpCommunityGroup\n           DESCRIPTION\n               \"This group is mandatory for SNMP entities which\n               support community-based authentication.\"\n\n           GROUP   snmpWarmStartNotificationGroup\n           DESCRIPTION\n               \"This group is mandatory for an SNMP entity which\n               supports command responder applications, and is\n               able to reinitialize itself such that its\n               configuration is unaltered.\"\n\n       ::= { snmpMIBCompliances 3 }\n\n   -- units of conformance\n\n   --  ::= { snmpMIBGroups 1 }           this OID is obsolete\n   --  ::= { snmpMIBGroups 2 }           this OID is obsolete\n   --  ::= { snmpMIBGroups 3 }           this OID is obsolete\n   --  ::= { snmpMIBGroups 4 }           this OID is obsolete\n\n   snmpGroup OBJECT-GROUP\n       OBJECTS { snmpInPkts,\n                 snmpInBadVersions,\n                 snmpInASNParseErrs,\n                 snmpSilentDrops,\n                 snmpProxyDrops,\n                 snmpEnableAuthenTraps }\n       STATUS  current\n       DESCRIPTION\n               \"A collection of objects providing basic instrumentation\n               and control of an SNMP entity.\"\n       ::= { snmpMIBGroups 8 }\n\n   snmpCommunityGroup OBJECT-GROUP\n       OBJECTS { snmpInBadCommunityNames,\n                 snmpInBadCommunityUses }\n       STATUS  current\n       DESCRIPTION\n               \"A collection of objects providing basic instrumentation\n               of a SNMP entity which supports community-based\n               authentication.\"\n       ::= { snmpMIBGroups 9 }\n\n   snmpSetGroup OBJECT-GROUP\n       OBJECTS { snmpSetSerialNo }\n       STATUS  current\n       DESCRIPTION\n               \"A collection of objects which allow several cooperating\n               command generator applications to coordinate their\n               use of the set operation.\"\n       ::= { snmpMIBGroups 5 }\n\n   systemGroup OBJECT-GROUP\n       OBJECTS { sysDescr, sysObjectID, sysUpTime,\n                 sysContact, sysName, sysLocation,\n                 sysServices,\n                 sysORLastChange, sysORID,\n                 sysORUpTime, sysORDescr }\n       STATUS  current\n       DESCRIPTION\n               \"The system group defines objects which are common to all\n               managed systems.\"\n       ::= { snmpMIBGroups 6 }\n\n   snmpBasicNotificationsGroup NOTIFICATION-GROUP\n       NOTIFICATIONS { coldStart, authenticationFailure }\n       STATUS        current\n       DESCRIPTION\n          \"The basic notifications implemented by an SNMP entity\n           supporting command responder applications.\"\n       ::= { snmpMIBGroups 7 }\n\n   snmpWarmStartNotificationGroup NOTIFICATION-GROUP\n      NOTIFICATIONS { warmStart }\n      STATUS        current\n      DESCRIPTION\n        \"An additional notification for an SNMP entity supporting\n        command responder applications, if it is able to reinitialize\n        itself such that its configuration is unaltered.\"\n     ::= { snmpMIBGroups 11 }\n\n   snmpNotificationGroup OBJECT-GROUP\n       OBJECTS { snmpTrapOID, snmpTrapEnterprise }\n       STATUS  current\n       DESCRIPTION\n               \"These objects are required for entities\n               which support notification originator applications.\"\n       ::= { snmpMIBGroups 12 }\n\n   -- definitions in RFC 1213 made obsolete by the inclusion of a\n   -- subset of the snmp group in this MIB\n\n   snmpOutPkts OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP Messages which were\n               passed from the SNMP protocol entity to the\n               transport service.\"\n       ::= { snmp 2 }\n\n   -- { snmp 7 } is not used\n\n   snmpInTooBigs OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP PDUs which were\n               delivered to the SNMP protocol entity and for\n               which the value of the error-status field was\n               `tooBig'.\"\n       ::= { snmp 8 }\n\n   snmpInNoSuchNames OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP PDUs which were\n               delivered to the SNMP protocol entity and for\n               which the value of the error-status field was\n               `noSuchName'.\"\n       ::= { snmp 9 }\n\n   snmpInBadValues OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP PDUs which were\n               delivered to the SNMP protocol entity and for\n               which the value of the error-status field was\n               `badValue'.\"\n       ::= { snmp 10 }\n\n   snmpInReadOnlys OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number valid SNMP PDUs which were delivered\n               to the SNMP protocol entity and for which the value\n               of the error-status field was `readOnly'.  It should\n               be noted that it is a protocol error to generate an\n               SNMP PDU which contains the value `readOnly' in the\n               error-status field, as such this object is provided\n               as a means of detecting incorrect implementations of\n               the SNMP.\"\n       ::= { snmp 11 }\n\n   snmpInGenErrs OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP PDUs which were delivered\n               to the SNMP protocol entity and for which the value\n               of the error-status field was `genErr'.\"\n       ::= { snmp 12 }\n\n   snmpInTotalReqVars OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of MIB objects which have been\n               retrieved successfully by the SNMP protocol entity\n               as the result of receiving valid SNMP Get-Request\n               and Get-Next PDUs.\"\n       ::= { snmp 13 }\n\n   snmpInTotalSetVars OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of MIB objects which have been\n               altered successfully by the SNMP protocol entity as\n               the result of receiving valid SNMP Set-Request PDUs.\"\n       ::= { snmp 14 }\n\n   snmpInGetRequests OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP Get-Request PDUs which\n               have been accepted and processed by the SNMP\n               protocol entity.\"\n       ::= { snmp 15 }\n\n   snmpInGetNexts OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP Get-Next PDUs which have been\n               accepted and processed by the SNMP protocol entity.\"\n       ::= { snmp 16 }\n\n   snmpInSetRequests OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP Set-Request PDUs which\n               have been accepted and processed by the SNMP protocol\n               entity.\"\n       ::= { snmp 17 }\n\n   snmpInGetResponses OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP Get-Response PDUs which\n               have been accepted and processed by the SNMP protocol\n               entity.\"\n       ::= { snmp 18 }\n\n   snmpInTraps OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP Trap PDUs which have been\n               accepted and processed by the SNMP protocol entity.\"\n       ::= { snmp 19 }\n\n   snmpOutTooBigs OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP PDUs which were generated\n               by the SNMP protocol entity and for which the value\n               of the error-status field was `tooBig.'\"\n       ::= { snmp 20 }\n\n   snmpOutNoSuchNames OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP PDUs which were generated\n               by the SNMP protocol entity and for which the value\n               of the error-status was `noSuchName'.\"\n       ::= { snmp 21 }\n\n   snmpOutBadValues OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP PDUs which were generated\n               by the SNMP protocol entity and for which the value\n               of the error-status field was `badValue'.\"\n       ::= { snmp 22 }\n\n   -- { snmp 23 } is not used\n\n   snmpOutGenErrs OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP PDUs which were generated\n               by the SNMP protocol entity and for which the value\n               of the error-status field was `genErr'.\"\n       ::= { snmp 24 }\n\n   snmpOutGetRequests OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP Get-Request PDUs which\n               have been generated by the SNMP protocol entity.\"\n       ::= { snmp 25 }\n\n   snmpOutGetNexts OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP Get-Next PDUs which have\n               been generated by the SNMP protocol entity.\"\n       ::= { snmp 26 }\n\n   snmpOutSetRequests OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP Set-Request PDUs which\n               have been generated by the SNMP protocol entity.\"\n       ::= { snmp 27 }\n\n   snmpOutGetResponses OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP Get-Response PDUs which\n               have been generated by the SNMP protocol entity.\"\n       ::= { snmp 28 }\n\n   snmpOutTraps OBJECT-TYPE\n       SYNTAX      Counter32\n       MAX-ACCESS  read-only\n       STATUS      obsolete\n       DESCRIPTION\n               \"The total number of SNMP Trap PDUs which have\n               been generated by the SNMP protocol entity.\"\n       ::= { snmp 29 }\n\n   snmpObsoleteGroup OBJECT-GROUP\n       OBJECTS { snmpOutPkts, snmpInTooBigs, snmpInNoSuchNames,\n                 snmpInBadValues, snmpInReadOnlys, snmpInGenErrs,\n                 snmpInTotalReqVars, snmpInTotalSetVars,\n                 snmpInGetRequests, snmpInGetNexts, snmpInSetRequests,\n                 snmpInGetResponses, snmpInTraps, snmpOutTooBigs,\n                 snmpOutNoSuchNames, snmpOutBadValues,\n                 snmpOutGenErrs, snmpOutGetRequests, snmpOutGetNexts,\n                 snmpOutSetRequests, snmpOutGetResponses, snmpOutTraps\n                 }\n       STATUS  obsolete\n       DESCRIPTION\n               \"A collection of objects from RFC 1213 made obsolete\n               by this MIB module.\"\n       ::= { snmpMIBGroups 10 }\n\n   END\n";
    private static final String SNMPv2_SMI = "-- extracted from rfc2578.txt\n-- at Mon Nov 15 17:12:02 1999\n\nSNMPv2-SMI DEFINITIONS ::= BEGIN\n\n\n-- the path to the root\n\norg            OBJECT IDENTIFIER ::= { iso 3 }  --  \"iso\" = 1\ndod            OBJECT IDENTIFIER ::= { org 6 }\ninternet       OBJECT IDENTIFIER ::= { dod 1 }\n\ndirectory      OBJECT IDENTIFIER ::= { internet 1 }\n\nmgmt           OBJECT IDENTIFIER ::= { internet 2 }\nmib-2          OBJECT IDENTIFIER ::= { mgmt 1 }\ntransmission   OBJECT IDENTIFIER ::= { mib-2 10 }\n\nexperimental   OBJECT IDENTIFIER ::= { internet 3 }\n\nprivate        OBJECT IDENTIFIER ::= { internet 4 }\nenterprises    OBJECT IDENTIFIER ::= { private 1 }\n\nsecurity       OBJECT IDENTIFIER ::= { internet 5 }\n\nsnmpV2         OBJECT IDENTIFIER ::= { internet 6 }\n\n-- transport domains\nsnmpDomains    OBJECT IDENTIFIER ::= { snmpV2 1 }\n\n-- transport proxies\nsnmpProxys     OBJECT IDENTIFIER ::= { snmpV2 2 }\n\n-- module identities\nsnmpModules    OBJECT IDENTIFIER ::= { snmpV2 3 }\n\n-- Extended UTCTime, to allow dates with four-digit years\n-- (Note that this definition of ExtUTCTime is not to be IMPORTed\n--  by MIB modules.)\nExtUTCTime ::= OCTET STRING(SIZE(11 | 13))\n    -- format is YYMMDDHHMMZ or YYYYMMDDHHMMZ\n    --   where: YY   - last two digits of year (only years\n    --                 between 1900-1999)\n    --          YYYY - last four digits of the year (any year)\n    --          MM   - month (01 through 12)\n    --          DD   - day of month (01 through 31)\n    --          HH   - hours (00 through 23)\n    --          MM   - minutes (00 through 59)\n    --          Z    - denotes GMT (the ASCII character Z)\n    --\n    -- For example, \"9502192015Z\" and \"199502192015Z\" represent\n    -- 8:15pm GMT on 19 February 1995. Years after 1999 must use\n    -- the four digit year format. Years 1900-1999 may use the\n    -- two or four digit format.\n\n-- MACRO definitions removed because they are not SMI\n--\n\n-- definitions of administrative identifiers\n\nzeroDotZero    OBJECT-IDENTITY\n    STATUS     current\n    DESCRIPTION\n            \"A value used for null identifiers.\"\n    ::= { 0 0 }\n\nEND\n\n-- \n--    Copyright (C) The Internet Society (1999).  All Rights Reserved.\n-- \n--    This document and translations of it may be copied and furnished to\n--    others, and derivative works that comment on or otherwise explain it\n--    or assist in its implementation may be prepared, copied, published\n--    and distributed, in whole or in part, without restriction of any\n--    kind, provided that the above copyright notice and this paragraph are\n--    included on all such copies and derivative works.  However, this\n--    document itself may not be modified in any way, such as by removing\n--    the copyright notice or references to the Internet Society or other\n--    Internet organizations, except as needed for the purpose of\n--    developing Internet standards in which case the procedures for\n--    copyrights defined in the Internet Standards process must be\n--    followed, or as required to translate it into languages other than\n--    English.\n-- \n--    The limited permissions granted above are perpetual and will not be\n--    revoked by the Internet Society or its successors or assigns.\n-- \n--    This document and the information contained herein is provided on an\n--    \"AS IS\" basis and THE INTERNET SOCIETY AND THE INTERNET ENGINEERING\n--    TASK FORCE DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING\n--    BUT NOT LIMITED TO ANY WARRANTY THAT THE USE OF THE INFORMATION\n--    HEREIN WILL NOT INFRINGE ANY RIGHTS OR ANY IMPLIED WARRANTIES OF\n--    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.\"\n";
    private static final String SNMPv2_TC = "-- extracted from rfc2579.txt\n-- at Fri Dec 24 21:34:57 1999\n\nSNMPv2-TC DEFINITIONS ::= BEGIN\n\nIMPORTS\n    TimeTicks         FROM SNMPv2-SMI;\n\n-- MACROs removed because they are not SMI\n\n-- definition of textual conventions\n\nDisplayString ::= TEXTUAL-CONVENTION\n    DISPLAY-HINT \"255a\"\n    STATUS       current\n    DESCRIPTION\n            \"Represents textual information taken from the NVT ASCII\n            character set, as defined in pages 4, 10-11 of RFC 854.\n\n            To summarize RFC 854, the NVT ASCII repertoire specifies:\n\n              - the use of character codes 0-127 (decimal)\n\n              - the graphics characters (32-126) are interpreted as\n                US ASCII\n\n              - NUL, LF, CR, BEL, BS, HT, VT and FF have the special\n                meanings specified in RFC 854\n\n              - the other 25 codes have no standard interpretation\n\n              - the sequence 'CR LF' means newline\n\n              - the sequence 'CR NUL' means carriage-return\n\n              - an 'LF' not preceded by a 'CR' means moving to the\n                same column on the next line.\n\n              - the sequence 'CR x' for any x other than LF or NUL is\n                illegal.  (Note that this also means that a string may\n                end with either 'CR LF' or 'CR NUL', but not with CR.)\n\n            Any object defined using this syntax may not exceed 255\n            characters in length.\"\n    SYNTAX       OCTET STRING (SIZE (0..255))\n\nPhysAddress ::= TEXTUAL-CONVENTION\n    DISPLAY-HINT \"1x:\"\n    STATUS       current\n    DESCRIPTION\n            \"Represents media- or physical-level addresses.\"\n    SYNTAX       OCTET STRING\n\n\nMacAddress ::= TEXTUAL-CONVENTION\n    DISPLAY-HINT \"1x:\"\n    STATUS       current\n    DESCRIPTION\n            \"Represents an 802 MAC address represented in the\n            `canonical' order defined by IEEE 802.1a, i.e., as if it\n            were transmitted least significant bit first, even though\n            802.5 (in contrast to other 802.x protocols) requires MAC\n            addresses to be transmitted most significant bit first.\"\n    SYNTAX       OCTET STRING (SIZE (6))\n\nTruthValue ::= TEXTUAL-CONVENTION\n    STATUS       current\n    DESCRIPTION\n            \"Represents a boolean value.\"\n    SYNTAX       INTEGER { true(1), false(2) }\n\nTestAndIncr ::= TEXTUAL-CONVENTION\n    STATUS       current\n    DESCRIPTION\n            \"Represents integer-valued information used for atomic\n            operations.  When the management protocol is used to specify\n            that an object instance having this syntax is to be\n            modified, the new value supplied via the management protocol\n            must precisely match the value presently held by the\n            instance.  If not, the management protocol set operation\n            fails with an error of `inconsistentValue'.  Otherwise, if\n            the current value is the maximum value of 2^31-1 (2147483647\n            decimal), then the value held by the instance is wrapped to\n            zero; otherwise, the value held by the instance is\n            incremented by one.  (Note that regardless of whether the\n            management protocol set operation succeeds, the variable-\n            binding in the request and response PDUs are identical.)\n\n            The value of the ACCESS clause for objects having this\n            syntax is either `read-write' or `read-create'.  When an\n            instance of a columnar object having this syntax is created,\n            any value may be supplied via the management protocol.\n\n            When the network management portion of the system is re-\n            initialized, the value of every object instance having this\n            syntax must either be incremented from its value prior to\n            the re-initialization, or (if the value prior to the re-\n            initialization is unknown) be set to a pseudo-randomly\n            generated value.\"\n    SYNTAX       INTEGER (0..2147483647)\n\nAutonomousType ::= TEXTUAL-CONVENTION\n    STATUS       current\n    DESCRIPTION\n            \"Represents an independently extensible type identification\n            value.  It may, for example, indicate a particular sub-tree\n            with further MIB definitions, or define a particular type of\n            protocol or hardware.\"\n    SYNTAX       OBJECT IDENTIFIER\n\n\nInstancePointer ::= TEXTUAL-CONVENTION\n    STATUS       obsolete\n    DESCRIPTION\n            \"A pointer to either a specific instance of a MIB object or\n            a conceptual row of a MIB table in the managed device.  In\n            the latter case, by convention, it is the name of the\n            particular instance of the first accessible columnar object\n            in the conceptual row.\n\n            The two uses of this textual convention are replaced by\n            VariablePointer and RowPointer, respectively.\"\n    SYNTAX       OBJECT IDENTIFIER\n\n\nVariablePointer ::= TEXTUAL-CONVENTION\n    STATUS       current\n    DESCRIPTION\n            \"A pointer to a specific object instance.  For example,\n            sysContact.0 or ifInOctets.3.\"\n    SYNTAX       OBJECT IDENTIFIER\n\n\nRowPointer ::= TEXTUAL-CONVENTION\n    STATUS       current\n    DESCRIPTION\n            \"Represents a pointer to a conceptual row.  The value is the\n            name of the instance of the first accessible columnar object\n            in the conceptual row.\n\n            For example, ifIndex.3 would point to the 3rd row in the\n            ifTable (note that if ifIndex were not-accessible, then\n            ifDescr.3 would be used instead).\"\n    SYNTAX       OBJECT IDENTIFIER\n\nRowStatus ::= TEXTUAL-CONVENTION\n    STATUS       current\n    DESCRIPTION\n            \"The RowStatus textual convention is used to manage the\n            creation and deletion of conceptual rows, and is used as the\n            value of the SYNTAX clause for the status column of a\n            conceptual row (as described in Section 7.7.1 of [2].)\n            The status column has six defined values:\n\n                 - `active', which indicates that the conceptual row is\n                 available for use by the managed device;\n\n                 - `notInService', which indicates that the conceptual\n                 row exists in the agent, but is unavailable for use by\n                 the managed device (see NOTE below); 'notInService' has\n                 no implication regarding the internal consistency of\n                 the row, availability of resources, or consistency with\n                 the current state of the managed device;\n\n                 - `notReady', which indicates that the conceptual row\n                 exists in the agent, but is missing information\n                 necessary in order to be available for use by the\n                 managed device (i.e., one or more required columns in\n                 the conceptual row have not been instanciated);\n\n                 - `createAndGo', which is supplied by a management\n                 station wishing to create a new instance of a\n                 conceptual row and to have its status automatically set\n                 to active, making it available for use by the managed\n                 device;\n\n                 - `createAndWait', which is supplied by a management\n                 station wishing to create a new instance of a\n                 conceptual row (but not make it available for use by\n                 the managed device); and,\n\n                 - `destroy', which is supplied by a management station\n                 wishing to delete all of the instances associated with\n                 an existing conceptual row.\n\n            Whereas five of the six values (all except `notReady') may\n            be specified in a management protocol set operation, only\n            three values will be returned in response to a management\n            protocol retrieval operation:  `notReady', `notInService' or\n            `active'.  That is, when queried, an existing conceptual row\n            has only three states:  it is either available for use by\n            the managed device (the status column has value `active');\n            it is not available for use by the managed device, though\n            the agent has sufficient information to attempt to make it\n            so (the status column has value `notInService'); or, it is\n            not available for use by the managed device, and an attempt\n            to make it so would fail because the agent has insufficient\n            information (the state column has value `notReady').\n                                     NOTE WELL\n\n                 This textual convention may be used for a MIB table,\n                 irrespective of whether the values of that table's\n                 conceptual rows are able to be modified while it is\n                 active, or whether its conceptual rows must be taken\n                 out of service in order to be modified.  That is, it is\n                 the responsibility of the DESCRIPTION clause of the\n                 status column to specify whether the status column must\n                 not be `active' in order for the value of some other\n                 column of the same conceptual row to be modified.  If\n                 such a specification is made, affected columns may be\n                 changed by an SNMP set PDU if the RowStatus would not\n                 be equal to `active' either immediately before or after\n                 processing the PDU.  In other words, if the PDU also\n                 contained a varbind that would change the RowStatus\n                 value, the column in question may be changed if the\n                 RowStatus was not equal to `active' as the PDU was\n                 received, or if the varbind sets the status to a value\n                 other than 'active'.\n\n\n            Also note that whenever any elements of a row exist, the\n            RowStatus column must also exist.\n            To summarize the effect of having a conceptual row with a\n            status column having a SYNTAX clause value of RowStatus,\n            consider the following state diagram:\n\n\n                                         STATE\n              +--------------+-----------+-------------+-------------\n              |      A       |     B     |      C      |      D\n              |              |status col.|status column|\n              |status column |    is     |      is     |status column\n    ACTION    |does not exist|  notReady | notInService|  is active\n--------------+--------------+-----------+-------------+-------------\nset status    |noError    ->D|inconsist- |inconsistent-|inconsistent-\ncolumn to     |       or     |   entValue|        Value|        Value\ncreateAndGo   |inconsistent- |           |             |\n              |         Value|           |             |\n--------------+--------------+-----------+-------------+-------------\nset status    |noError  see 1|inconsist- |inconsistent-|inconsistent-\ncolumn to     |       or     |   entValue|        Value|        Value\ncreateAndWait |wrongValue    |           |             |\n--------------+--------------+-----------+-------------+-------------\nset status    |inconsistent- |inconsist- |noError      |noError\ncolumn to     |         Value|   entValue|             |\nactive        |              |           |             |\n              |              |     or    |             |\n              |              |           |             |\n              |              |see 2   ->D|see 8     ->D|          ->D\n--------------+--------------+-----------+-------------+-------------\nset status    |inconsistent- |inconsist- |noError      |noError   ->C\ncolumn to     |         Value|   entValue|             |\nnotInService  |              |           |             |\n              |              |     or    |             |      or\n              |              |           |             |\n              |              |see 3   ->C|          ->C|see 6\n--------------+--------------+-----------+-------------+-------------\nset status    |noError       |noError    |noError      |noError   ->A\ncolumn to     |              |           |             |      or\ndestroy       |           ->A|        ->A|          ->A|see 7\n--------------+--------------+-----------+-------------+-------------\nset any other |see 4         |noError    |noError      |see 5\ncolumn to some|              |           |             |\nvalue         |              |      see 1|          ->C|          ->D\n--------------+--------------+-----------+-------------+-------------\n\n            (1) goto B or C, depending on information available to the\n            agent.\n\n            (2) if other variable bindings included in the same PDU,\n            provide values for all columns which are missing but\n            required, and all columns have acceptable values, then\n            return noError and goto D.\n\n            (3) if other variable bindings included in the same PDU,\n            provide legal values for all columns which are missing but\n            required, then return noError and goto C.\n\n            (4) at the discretion of the agent, the return value may be\n            either:\n\n                 inconsistentName:  because the agent does not choose to\n                 create such an instance when the corresponding\n                 RowStatus instance does not exist, or\n\n                 inconsistentValue:  if the supplied value is\n                 inconsistent with the state of some other MIB object's\n                 value, or\n\n                 noError: because the agent chooses to create the\n                 instance.\n\n            If noError is returned, then the instance of the status\n            column must also be created, and the new state is B or C,\n            depending on the information available to the agent.  If\n            inconsistentName or inconsistentValue is returned, the row\n            remains in state A.\n\n            (5) depending on the MIB definition for the column/table,\n            either noError or inconsistentValue may be returned.\n\n            (6) the return value can indicate one of the following\n            errors:\n\n                 wrongValue: because the agent does not support\n                 notInService (e.g., an agent which does not support\n                 createAndWait), or\n\n                 inconsistentValue: because the agent is unable to take\n                 the row out of service at this time, perhaps because it\n                 is in use and cannot be de-activated.\n\n            (7) the return value can indicate the following error:\n\n                 inconsistentValue: because the agent is unable to\n                 remove the row at this time, perhaps because it is in\n                 use and cannot be de-activated.\n\n            (8) the transition to D can fail, e.g., if the values of the\n            conceptual row are inconsistent, then the error code would\n            be inconsistentValue.\n\n            NOTE: Other processing of (this and other varbinds of) the\n            set request may result in a response other than noError\n            being returned, e.g., wrongValue, noCreation, etc.\n\n\n                              Conceptual Row Creation\n\n            There are four potential interactions when creating a\n            conceptual row:  selecting an instance-identifier which is\n            not in use; creating the conceptual row; initializing any\n            objects for which the agent does not supply a default; and,\n            making the conceptual row available for use by the managed\n            device.\n\n            Interaction 1: Selecting an Instance-Identifier\n\n            The algorithm used to select an instance-identifier varies\n            for each conceptual row.  In some cases, the instance-\n            identifier is semantically significant, e.g., the\n            destination address of a route, and a management station\n            selects the instance-identifier according to the semantics.\n\n            In other cases, the instance-identifier is used solely to\n            distinguish conceptual rows, and a management station\n            without specific knowledge of the conceptual row might\n            examine the instances present in order to determine an\n            unused instance-identifier.  (This approach may be used, but\n            it is often highly sub-optimal; however, it is also a\n            questionable practice for a naive management station to\n            attempt conceptual row creation.)\n\n            Alternately, the MIB module which defines the conceptual row\n            might provide one or more objects which provide assistance\n            in determining an unused instance-identifier.  For example,\n            if the conceptual row is indexed by an integer-value, then\n            an object having an integer-valued SYNTAX clause might be\n            defined for such a purpose, allowing a management station to\n            issue a management protocol retrieval operation.  In order\n            to avoid unnecessary collisions between competing management\n            stations, `adjacent' retrievals of this object should be\n            different.\n\n            Finally, the management station could select a pseudo-random\n            number to use as the index.  In the event that this index\n            was already in use and an inconsistentValue was returned in\n            response to the management protocol set operation, the\n            management station should simply select a new pseudo-random\n            number and retry the operation.\n\n            A MIB designer should choose between the two latter\n            algorithms based on the size of the table (and therefore the\n            efficiency of each algorithm).  For tables in which a large\n            number of entries are expected, it is recommended that a MIB\n            object be defined that returns an acceptable index for\n            creation.  For tables with small numbers of entries, it is\n            recommended that the latter pseudo-random index mechanism be\n            used.\n\n            Interaction 2: Creating the Conceptual Row\n\n            Once an unused instance-identifier has been selected, the\n            management station determines if it wishes to create and\n            activate the conceptual row in one transaction or in a\n            negotiated set of interactions.\n\n            Interaction 2a: Creating and Activating the Conceptual Row\n\n            The management station must first determine the column\n            requirements, i.e., it must determine those columns for\n            which it must or must not provide values.  Depending on the\n            complexity of the table and the management station's\n            knowledge of the agent's capabilities, this determination\n            can be made locally by the management station.  Alternately,\n            the management station issues a management protocol get\n            operation to examine all columns in the conceptual row that\n            it wishes to create.  In response, for each column, there\n            are three possible outcomes:\n\n                 - a value is returned, indicating that some other\n                 management station has already created this conceptual\n                 row.  We return to interaction 1.\n\n                 - the exception `noSuchInstance' is returned,\n                 indicating that the agent implements the object-type\n                 associated with this column, and that this column in at\n                 least one conceptual row would be accessible in the MIB\n                 view used by the retrieval were it to exist. For those\n                 columns to which the agent provides read-create access,\n                 the `noSuchInstance' exception tells the management\n                 station that it should supply a value for this column\n                 when the conceptual row is to be created.\n                 - the exception `noSuchObject' is returned, indicating\n                 that the agent does not implement the object-type\n                 associated with this column or that there is no\n                 conceptual row for which this column would be\n                 accessible in the MIB view used by the retrieval.  As\n                 such, the management station can not issue any\n                 management protocol set operations to create an\n                 instance of this column.\n\n            Once the column requirements have been determined, a\n            management protocol set operation is accordingly issued.\n            This operation also sets the new instance of the status\n            column to `createAndGo'.\n\n            When the agent processes the set operation, it verifies that\n            it has sufficient information to make the conceptual row\n            available for use by the managed device.  The information\n            available to the agent is provided by two sources:  the\n            management protocol set operation which creates the\n            conceptual row, and, implementation-specific defaults\n            supplied by the agent (note that an agent must provide\n            implementation-specific defaults for at least those objects\n            which it implements as read-only).  If there is sufficient\n            information available, then the conceptual row is created, a\n            `noError' response is returned, the status column is set to\n            `active', and no further interactions are necessary (i.e.,\n            interactions 3 and 4 are skipped).  If there is insufficient\n            information, then the conceptual row is not created, and the\n            set operation fails with an error of `inconsistentValue'.\n            On this error, the management station can issue a management\n            protocol retrieval operation to determine if this was\n            because it failed to specify a value for a required column,\n            or, because the selected instance of the status column\n            already existed.  In the latter case, we return to\n            interaction 1.  In the former case, the management station\n            can re-issue the set operation with the additional\n            information, or begin interaction 2 again using\n            `createAndWait' in order to negotiate creation of the\n            conceptual row.\n                                     NOTE WELL\n\n                 Regardless of the method used to determine the column\n                 requirements, it is possible that the management\n                 station might deem a column necessary when, in fact,\n                 the agent will not allow that particular columnar\n                 instance to be created or written.  In this case, the\n                 management protocol set operation will fail with an\n                 error such as `noCreation' or `notWritable'.  In this\n                 case, the management station decides whether it needs\n                 to be able to set a value for that particular columnar\n                 instance.  If not, the management station re-issues the\n                 management protocol set operation, but without setting\n                 a value for that particular columnar instance;\n                 otherwise, the management station aborts the row\n                 creation algorithm.\n\n            Interaction 2b: Negotiating the Creation of the Conceptual\n            Row\n\n            The management station issues a management protocol set\n            operation which sets the desired instance of the status\n            column to `createAndWait'.  If the agent is unwilling to\n            process a request of this sort, the set operation fails with\n            an error of `wrongValue'.  (As a consequence, such an agent\n            must be prepared to accept a single management protocol set\n            operation, i.e., interaction 2a above, containing all of the\n            columns indicated by its column requirements.)  Otherwise,\n            the conceptual row is created, a `noError' response is\n            returned, and the status column is immediately set to either\n            `notInService' or `notReady', depending on whether it has\n            sufficient information to (attempt to) make the conceptual\n            row available for use by the managed device.  If there is\n            sufficient information available, then the status column is\n            set to `notInService'; otherwise, if there is insufficient\n            information, then the status column is set to `notReady'.\n            Regardless, we proceed to interaction 3.\n\n            Interaction 3: Initializing non-defaulted Objects\n\n            The management station must now determine the column\n            requirements.  It issues a management protocol get operation\n            to examine all columns in the created conceptual row.  In\n            the response, for each column, there are three possible\n            outcomes:\n                 - a value is returned, indicating that the agent\n                 implements the object-type associated with this column\n                 and had sufficient information to provide a value.  For\n                 those columns to which the agent provides read-create\n                 access (and for which the agent allows their values to\n                 be changed after their creation), a value return tells\n                 the management station that it may issue additional\n                 management protocol set operations, if it desires, in\n                 order to change the value associated with this column.\n\n                 - the exception `noSuchInstance' is returned,\n                 indicating that the agent implements the object-type\n                 associated with this column, and that this column in at\n                 least one conceptual row would be accessible in the MIB\n                 view used by the retrieval were it to exist. However,\n                 the agent does not have sufficient information to\n                 provide a value, and until a value is provided, the\n                 conceptual row may not be made available for use by the\n                 managed device.  For those columns to which the agent\n                 provides read-create access, the `noSuchInstance'\n                 exception tells the management station that it must\n                 issue additional management protocol set operations, in\n                 order to provide a value associated with this column.\n\n                 - the exception `noSuchObject' is returned, indicating\n                 that the agent does not implement the object-type\n                 associated with this column or that there is no\n                 conceptual row for which this column would be\n                 accessible in the MIB view used by the retrieval.  As\n                 such, the management station can not issue any\n                 management protocol set operations to create an\n                 instance of this column.\n\n            If the value associated with the status column is\n            `notReady', then the management station must first deal with\n            all `noSuchInstance' columns, if any.  Having done so, the\n            value of the status column becomes `notInService', and we\n            proceed to interaction 4.\n            Interaction 4: Making the Conceptual Row Available\n\n            Once the management station is satisfied with the values\n            associated with the columns of the conceptual row, it issues\n            a management protocol set operation to set the status column\n            to `active'.  If the agent has sufficient information to\n            make the conceptual row available for use by the managed\n            device, the management protocol set operation succeeds (a\n            `noError' response is returned).  Otherwise, the management\n            protocol set operation fails with an error of\n            `inconsistentValue'.\n\n                                     NOTE WELL\n\n                 A conceptual row having a status column with value\n                 `notInService' or `notReady' is unavailable to the\n                 managed device.  As such, it is possible for the\n                 managed device to create its own instances during the\n                 time between the management protocol set operation\n                 which sets the status column to `createAndWait' and the\n                 management protocol set operation which sets the status\n                 column to `active'.  In this case, when the management\n                 protocol set operation is issued to set the status\n                 column to `active', the values held in the agent\n                 supersede those used by the managed device.\n\n            If the management station is prevented from setting the\n            status column to `active' (e.g., due to management station\n            or network failure) the conceptual row will be left in the\n            `notInService' or `notReady' state, consuming resources\n            indefinitely.  The agent must detect conceptual rows that\n            have been in either state for an abnormally long period of\n            time and remove them.  It is the responsibility of the\n            DESCRIPTION clause of the status column to indicate what an\n            abnormally long period of time would be.  This period of\n            time should be long enough to allow for human response time\n            (including `think time') between the creation of the\n            conceptual row and the setting of the status to `active'.\n            In the absence of such information in the DESCRIPTION\n            clause, it is suggested that this period be approximately 5\n            minutes in length.  This removal action applies not only to\n            newly-created rows, but also to previously active rows which\n            are set to, and left in, the notInService state for a\n            prolonged period exceeding that which is considered normal\n            for such a conceptual row.\n                             Conceptual Row Suspension\n\n            When a conceptual row is `active', the management station\n            may issue a management protocol set operation which sets the\n            instance of the status column to `notInService'.  If the\n            agent is unwilling to do so, the set operation fails with an\n            error of `wrongValue' or `inconsistentValue'.  Otherwise,\n            the conceptual row is taken out of service, and a `noError'\n            response is returned.  It is the responsibility of the\n            DESCRIPTION clause of the status column to indicate under\n            what circumstances the status column should be taken out of\n            service (e.g., in order for the value of some other column\n            of the same conceptual row to be modified).\n\n\n                              Conceptual Row Deletion\n\n            For deletion of conceptual rows, a management protocol set\n            operation is issued which sets the instance of the status\n            column to `destroy'.  This request may be made regardless of\n            the current value of the status column (e.g., it is possible\n            to delete conceptual rows which are either `notReady',\n            `notInService' or `active'.)  If the operation succeeds,\n            then all instances associated with the conceptual row are\n            immediately removed.\"\n    SYNTAX       INTEGER {\n                     -- the following two values are states:\n                     -- these values may be read or written\n                     active(1),\n                     notInService(2),\n\n                     -- the following value is a state:\n                     -- this value may be read, but not written\n                     notReady(3),\n\n                     -- the following three values are\n                     -- actions: these values may be written,\n                     --   but are never read\n                     createAndGo(4),\n                     createAndWait(5),\n                     destroy(6)\n                 }\n\nTimeStamp ::= TEXTUAL-CONVENTION\n    STATUS       current\n    DESCRIPTION\n            \"The value of the sysUpTime object at which a specific\n            occurrence happened.  The specific occurrence must be\n            defined in the description of any object defined using this\n            type.\n\n            If sysUpTime is reset to zero as a result of a re-\n            initialization of the network management (sub)system, then\n            the values of all TimeStamp objects are also reset.\n            However, after approximately 497 days without a re-\n            initialization, the sysUpTime object will reach 2^^32-1 and\n            then increment around to zero; in this case, existing values\n            of TimeStamp objects do not change.  This can lead to\n            ambiguities in the value of TimeStamp objects.\"\n    SYNTAX       TimeTicks\n\n\nTimeInterval ::= TEXTUAL-CONVENTION\n    STATUS       current\n    DESCRIPTION\n            \"A period of time, measured in units of 0.01 seconds.\"\n    SYNTAX       INTEGER (0..2147483647)\n\nDateAndTime ::= TEXTUAL-CONVENTION\n    DISPLAY-HINT \"2d-1d-1d,1d:1d:1d.1d,1a1d:1d\"\n    STATUS       current\n    DESCRIPTION\n            \"A date-time specification.\n\n            field  octets  contents                  range\n            -----  ------  --------                  -----\n              1      1-2   year*                     0..65536\n              2       3    month                     1..12\n              3       4    day                       1..31\n              4       5    hour                      0..23\n              5       6    minutes                   0..59\n              6       7    seconds                   0..60\n                           (use 60 for leap-second)\n              7       8    deci-seconds              0..9\n              8       9    direction from UTC        '+' / '-'\n              9      10    hours from UTC*           0..13\n             10      11    minutes from UTC          0..59\n\n            * Notes:\n            - the value of year is in network-byte order\n            - daylight saving time in New Zealand is +13\n\n            For example, Tuesday May 26, 1992 at 1:30:15 PM EDT would be\n            displayed as:\n\n                             1992-5-26,13:30:15.0,-4:0\n\n            Note that if only local time is known, then timezone\n            information (fields 8-10) is not present.\"\n    SYNTAX       OCTET STRING (SIZE (8 | 11))\n\n\nStorageType ::= TEXTUAL-CONVENTION\n    STATUS       current\n    DESCRIPTION\n            \"Describes the memory realization of a conceptual row.  A\n            row which is volatile(2) is lost upon reboot.  A row which\n            is either nonVolatile(3), permanent(4) or readOnly(5), is\n            backed up by stable storage.  A row which is permanent(4)\n            can be changed but not deleted.  A row which is readOnly(5)\n            cannot be changed nor deleted.\n\n            If the value of an object with this syntax is either\n            permanent(4) or readOnly(5), it cannot be written.\n            Conversely, if the value is either other(1), volatile(2) or\n            nonVolatile(3), it cannot be modified to be permanent(4) or\n            readOnly(5).  (All illegal modifications result in a\n            'wrongValue' error.)\n\n            Every usage of this textual convention is required to\n            specify the columnar objects which a permanent(4) row must\n            at a minimum allow to be writable.\"\n    SYNTAX       INTEGER {\n                     other(1),       -- eh?\n                     volatile(2),    -- e.g., in RAM\n                     nonVolatile(3), -- e.g., in NVRAM\n                     permanent(4),   -- e.g., partially in ROM\n                     readOnly(5)     -- e.g., completely in ROM\n                 }\n\nTDomain ::= TEXTUAL-CONVENTION\n    STATUS       current\n    DESCRIPTION\n          \"Denotes a kind of transport service.\n\n          Some possible values, such as snmpUDPDomain, are defined in\n          the SNMPv2-TM MIB module.  Other possible values are defined\n          in other MIB modules.\"\n    REFERENCE    \"The SNMPv2-TM MIB module is defined in RFC 1906.\"\n    SYNTAX       OBJECT IDENTIFIER\n\n\nTAddress ::= TEXTUAL-CONVENTION\n    STATUS       current\n    DESCRIPTION\n          \"Denotes a transport service address.\n\n          A TAddress value is always interpreted within the context of a\n          TDomain value.  Thus, each definition of a TDomain value must\n          be accompanied by a definition of a textual convention for use\n          with that TDomain.  Some possible textual conventions, such as\n          SnmpUDPAddress for snmpUDPDomain, are defined in the SNMPv2-TM\n          MIB module.  Other possible textual conventions are defined in\n          other MIB modules.\"\n    REFERENCE    \"The SNMPv2-TM MIB module is defined in RFC 1906.\"\n    SYNTAX       OCTET STRING (SIZE (1..255))\n\n\nEND\n\n-- \n--    Copyright (C) The Internet Society (1999).  All Rights Reserved.\n-- \n--    This document and translations of it may be copied and furnished to\n--    others, and derivative works that comment on or otherwise explain it\n--    or assist in its implementation may be prepared, copied, published\n--    and distributed, in whole or in part, without restriction of any\n--    kind, provided that the above copyright notice and this paragraph are\n--    included on all such copies and derivative works.  However, this\n--    document itself may not be modified in any way, such as by removing\n--    the copyright notice or references to the Internet Society or other\n--    Internet organizations, except as needed for the purpose of\n--    developing Internet standards in which case the procedures for\n--    copyrights defined in the Internet Standards process must be\n--    followed, or as required to translate it into languages other than\n--    English.\n-- \n--    The limited permissions granted above are perpetual and will not be\n--    revoked by the Internet Society or its successors or assigns.\n-- \n--    This document and the information contained herein is provided on an\n--    \"AS IS\" basis and THE INTERNET SOCIETY AND THE INTERNET ENGINEERING\n--    TASK FORCE DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING\n--    BUT NOT LIMITED TO ANY WARRANTY THAT THE USE OF THE INFORMATION\n--    HEREIN WILL NOT INFRINGE ANY RIGHTS OR ANY IMPLIED WARRANTIES OF\n--    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.\"\n";
    public static final String SNMPv2_CONF = "-- extracted from rfc2580.txt\n-- at Fri Dec 24 21:43:20 1999\n\nSNMPv2-CONF DEFINITIONS ::= BEGIN\n\n-- Imports removed because MACROS cannot be imported in SMI:\n-- IMPORTS ObjectName, NotificationName, ObjectSyntax\n--                                               FROM SNMPv2-SMI;\n\n-- MACROs removed because they are not SMI\n\nEND\n\n-- \n--    Copyright (C) The Internet Society (1999).  All Rights Reserved.\n-- \n--    This document and translations of it may be copied and furnished to\n--    others, and derivative works that comment on or otherwise explain it\n--    or assist in its implementation may be prepared, copied, published\n--    and distributed, in whole or in part, without restriction of any\n--    kind, provided that the above copyright notice and this paragraph are\n--    included on all such copies and derivative works.  However, this\n--    document itself may not be modified in any way, such as by removing\n--    the copyright notice or references to the Internet Society or other\n--    Internet organizations, except as needed for the purpose of\n--    developing Internet standards in which case the procedures for\n--    copyrights defined in the Internet Standards process must be\n--    followed, or as required to translate it into languages other than\n--    English.\n-- \n--    The limited permissions granted above are perpetual and will not be\n--    revoked by the Internet Society or its successors or assigns.\n-- \n--    This document and the information contained herein is provided on an\n--    \"AS IS\" basis and THE INTERNET SOCIETY AND THE INTERNET ENGINEERING\n--    TASK FORCE DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING\n--    BUT NOT LIMITED TO ANY WARRANTY THAT THE USE OF THE INFORMATION\n--    HEREIN WILL NOT INFRINGE ANY RIGHTS OR ANY IMPLIED WARRANTIES OF\n--    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.\"\n";
    public static int moduleID = new Random(System.currentTimeMillis()).nextInt();
    SMIRepositoryManager smirepositorymanager;

    public TestSMIRepositoryManager(String s) {
        super(s);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testAddModule() throws Exception {
        String val1 = "90 40 50 cc 3c 59 a3 7f";
        String val2 = "5M3G00AN";
        this.smirepositorymanager = new SMIRepositoryManager(val1, val2);
        this.smirepositorymanager.addRepositoryListener(this);
        this.smirepositorymanager.open(new File("D:/tmp/testmibrepository"));
        IModule m2 = null;
        IModule[] modules = this.smirepositorymanager.getModules(new StringBufferInputStream(SNMPv2_MIB), this);
        m2 = modules[0];
        try {
            this.smirepositorymanager.addModule(m2);
            this.smirepositorymanager.removeRepositoryListener(this);
            IModule o2 = this.smirepositorymanager.getModule("SNMPv2-MIB");
            TestSMIRepositoryManager.assertNotNull((Object)o2);
            SMIRepository rep1 = new SMIRepository();
            rep1.addObject(m2);
            SMIRepository rep2 = new SMIRepository();
            rep2.addObject(o2);
            TestSMIRepositoryManager.assertEquals((String)rep1.printModule("SNMPv2-MIB"), (String)rep2.printModule("SNMPv2-MIB"));
            System.out.println(rep1.printModule("SNMPv2-MIB"));
        }
        catch (Exception e2) {
            System.err.println("Exception thrown:  " + e2);
            e2.printStackTrace();
        }
    }

    public void writeModule(RepositoryEvent event) {
    }

    public void readModule(RepositoryEvent event) {
        if (event.getModuleName().equals("SNMPv2-MIB")) {
            event.setInputStream(new StringBufferInputStream("SNMPv2-MIB"));
        }
    }

    public void deleteModule(RepositoryEvent event) {
    }

    public void importModule(ImportModuleEvent e2) {
        String source;
        if (e2.getModuleName().equals("SNMPv2-MIB")) {
            source = SNMPv2_MIB;
        } else if (e2.getModuleName().equals("SNMPv2-SMI")) {
            source = SNMPv2_SMI;
        } else if (e2.getModuleName().equals("SNMPv2-TC")) {
            source = SNMPv2_TC;
        } else if (e2.getModuleName().equals("SNMPv2-CONF")) {
            source = SNMPv2_CONF;
        } else {
            return;
        }
        try {
            IModule[] m2 = this.smirepositorymanager.getModules(new StringBufferInputStream(source), this);
            for (int i2 = 0; i2 < m2.length; ++i2) {
                Object[] objects = new IObject[m2[i2].size()];
                m2[i2].getObjectsVector().copyInto(objects);
                e2.setObjects((IObject[])objects);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Integer createModuleID(String moduleName) {
        return new Integer(moduleID++);
    }

    public void freeModuleID(Integer moduleID, String moduleName) {
    }

    public String[] listModuleNames() {
        return null;
    }
}

