/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.snmp;

import java.io.Serializable;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OID;

public class UserProfile
implements Serializable,
Comparable {
    public static final long serialVersionUID = -5181547924067075519L;
    private String name;
    private UsmUser user;
    private boolean principal = false;

    public UserProfile(String name, UsmUser user) {
        this.user = user;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n2) {
        this.name = n2;
    }

    public UsmUser getUser() {
        return this.user;
    }

    public boolean isPrincipal() {
        return this.principal;
    }

    public void setUser(UsmUser newUser) {
        this.user = newUser;
    }

    public void setPrincipal(boolean isPrincipal) {
        this.principal = isPrincipal;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        UserProfile that = (UserProfile)o2;
        if (this.principal != that.principal) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.user != null ? this.user.equals(that.user) : that.user == null;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public static String getAuthProtocol(OID auth) {
        if (auth == null) {
            return "noAuth";
        }
        if (auth.equals(AuthMD5.ID)) {
            return "MD5";
        }
        if (auth.equals(AuthSHA.ID)) {
            return "SHA";
        }
        return "?";
    }

    public static String getPrivProtocol(OID priv) {
        if (priv == null) {
            return "noPriv";
        }
        if (priv.equals(PrivDES.ID)) {
            return "DES";
        }
        if (priv.equals(PrivAES128.ID)) {
            return "AES128";
        }
        if (priv.equals(PrivAES192.ID)) {
            return "AES192";
        }
        if (priv.equals(PrivAES256.ID)) {
            return "AES256";
        }
        return "?";
    }

    public String toDetailedString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name);
        if (this.user == null) {
            return buf.toString();
        }
        buf.append(": secName=");
        buf.append(this.user.getSecurityName());
        buf.append(", secModel=");
        buf.append(this.user.getSecurityModel());
        buf.append(", ");
        buf.append(UserProfile.getAuthProtocol(this.user.getAuthenticationProtocol()));
        if (this.user.getAuthenticationProtocol() != null) {
            buf.append("=");
            buf.append(this.user.getAuthenticationPassphrase());
        }
        buf.append(", ");
        buf.append(UserProfile.getPrivProtocol(this.user.getPrivacyProtocol()));
        if (this.user.getPrivacyProtocol() != null) {
            buf.append("=");
            buf.append(this.user.getPrivacyPassphrase());
        }
        buf.append(", localized=").append(this.user.isLocalized());
        buf.append(", principal=").append(this.isPrincipal());
        return buf.toString();
    }

    public int compareTo(Object o2) {
        return ((UserProfile)o2).getName().compareTo(this.name);
    }
}

