/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.ObjectID;
import com.agentpp.smiparser.SMIObjectEntry;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.SimpleNode;
import com.agentpp.smiparser.StringToken;
import java.util.ArrayList;

public class SMIObjectIdentifier
extends SimpleNode {
    private StringToken name;
    private StringToken[] tokenOid;
    private String[] oid;
    public static final int ID = -17;

    public SMIObjectIdentifier() {
        super(-17);
        this.name = new StringToken("", null);
    }

    public SMIObjectIdentifier(StringToken name) {
        super(-17);
        this.name = name;
        this.oid = null;
    }

    public long size() {
        return this.jjtGetNumChildren();
    }

    public final String[] getOid(SMIRepository smiRep) {
        if (this.oid == null) {
            this.oid = SMIObjectIdentifier.buildOid(this.createOid(smiRep));
            return this.oid;
        }
        return this.oid;
    }

    public String getName() {
        return this.name.string;
    }

    public static final ObjectID buildObjectID(StringToken[] tokenOid) {
        StringBuffer buf = new StringBuffer(128);
        for (int j2 = 0; j2 < tokenOid.length; ++j2) {
            if (j2 > 0) {
                buf.append('.');
            }
            buf.append(tokenOid[j2].string);
        }
        return new ObjectID(buf.toString());
    }

    public final ObjectID buildObjectID() {
        return SMIObjectIdentifier.buildObjectID(this.tokenOid);
    }

    public static String[] buildOid(StringToken[] oid) {
        String[] o2 = new String[oid.length];
        for (int j2 = 0; j2 < o2.length; ++j2) {
            o2[j2] = oid[j2].string;
        }
        return o2;
    }

    public StringToken[] createOid(SMIRepository smiRep) {
        boolean resolved = true;
        int sz = this.jjtGetNumChildren();
        ArrayList<StringToken> v = new ArrayList<StringToken>();
        for (int i2 = 0; i2 < sz; ++i2) {
            SMIObjectEntry entry = (SMIObjectEntry)this.jjtGetChild(i2);
            String subid = entry.getSubID();
            String subName = entry.getName();
            if (subid == null) {
                ObjectID foid = smiRep.getObjectID(subName);
                if (foid != null) {
                    v = new ArrayList();
                    String[] subids = SMIObjectIdentifier.fromString(foid.toString());
                    for (int k2 = 0; k2 < subids.length; ++k2) {
                        v.add(new StringToken(subids[k2], null));
                    }
                    continue;
                }
                resolved = false;
                v.add(new StringToken(subName, entry.getNameToken()));
                continue;
            }
            v.add(new StringToken(subid, null));
        }
        this.tokenOid = v.toArray(new StringToken[v.size()]);
        this.oid = SMIObjectIdentifier.buildOid(this.tokenOid);
        if (!"".equals(this.name)) {
            if (resolved) {
                try {
                    smiRep.addKnownObject(new MIBObject(this.buildObjectID(), this.name.string));
                }
                catch (SMIParseException pex) {
                    // empty catch block
                }
                smiRep.checkUnresolved(this.name, this.tokenOid);
            } else {
                smiRep.addUnresolvedName(this.tokenOid, this.name);
                StringToken[] tempOid = this.tokenOid;
                this.tokenOid = null;
                this.oid = null;
                return tempOid;
            }
        }
        return this.tokenOid;
    }

    public StringToken getFirstUnresolvedSubId(SMIRepository smiRep) {
        if (this.oid != null) {
            return null;
        }
        StringToken[] tempOid = this.createOid(smiRep);
        for (int i2 = 0; i2 < tempOid.length; ++i2) {
            for (int j2 = 0; j2 < tempOid[i2].string.length(); ++j2) {
                if (Character.isDigit(tempOid[i2].string.charAt(j2))) continue;
                return tempOid[i2];
            }
        }
        return null;
    }

    public static String toString(String[] array) {
        return ObjectID.fromArray(array);
    }

    public static String toSMI(String[] array) {
        return ObjectID.fromArrayToSMI(array);
    }

    public static String[] fromString(String s) {
        return ObjectID.toArray(s);
    }

    public String toString() {
        return ObjectID.fromArray(this.oid);
    }
}

