/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.smiparser.Node;
import com.agentpp.smiparser.SMIObjectIdentifier;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.SimpleNode;
import com.agentpp.smiparser.StringToken;
import java.util.Vector;

public class SMIObject
extends SimpleNode {
    private String name;
    private String status = null;
    private int type = 0;
    public String asn1Comment = null;
    public String inlineAsn1Comment;
    public Integer sequenceID = null;
    public static final int ID = -1;

    public SMIObject() {
        super(-1);
    }

    public void setType(int newType) {
        this.type = newType;
    }

    public int getType() {
        return this.type;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public static Vector getUpTreeSMIObjects(Node o2) {
        Vector<SMIObject> v = new Vector<SMIObject>();
        if (o2 == null) {
            return v;
        }
        SMIObject n2 = SMIObject.getParentSMIObject(o2);
        while (n2 != null) {
            v.addElement(n2);
            Node p2 = n2.jjtGetParent();
            if (p2 != null) {
                int sz = p2.jjtGetNumChildren();
                for (int i2 = 0; i2 < sz; ++i2) {
                    if (((SimpleNode)p2.jjtGetChild((int)i2)).id != -1) continue;
                    v.addElement((SMIObject)p2.jjtGetChild(i2));
                }
            }
            n2 = SMIObject.getParentSMIObject(n2);
        }
        return v;
    }

    public static SMIObject getParentSMIObject(Node o2) {
        if (o2.jjtGetParent() == null) {
            return null;
        }
        if (((SimpleNode)o2.jjtGetParent()).id == -1) {
            return (SMIObject)o2.jjtGetParent();
        }
        return SMIObject.getParentSMIObject(o2.jjtGetParent());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getOid(SMIRepository smiRep) {
        int sz = this.jjtGetNumChildren();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (!(this.jjtGetChild(i2) instanceof SMIObjectIdentifier)) continue;
            return ((SMIObjectIdentifier)this.jjtGetChild(i2)).getOid(smiRep);
        }
        return new String[0];
    }

    public StringToken getFirstUnresolvedSubId(SMIRepository smiRep) {
        int sz = this.jjtGetNumChildren();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (!(this.jjtGetChild(i2) instanceof SMIObjectIdentifier)) continue;
            return ((SMIObjectIdentifier)this.jjtGetChild(i2)).getFirstUnresolvedSubId(smiRep);
        }
        return null;
    }

    public String getPrintableOid(SMIRepository smiRep) {
        String[] subids = this.getOid(smiRep);
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < subids.length; ++i2) {
            buf.append(subids[i2]);
            if (i2 + 1 >= subids.length) continue;
            buf.append(".");
        }
        return buf.toString();
    }
}

