/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.smiparser.ModuleInfo;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class ModuleInfoSorter {
    private ModuleInfo[] list = new ModuleInfo[0];
    private Vector sorted = new Vector();
    private Vector source = new Vector();
    private HashSet missing = new HashSet();
    private Hashtable pool = null;
    private HashSet backupPool = null;

    public ModuleInfoSorter(ModuleInfo[] list) {
        this.list = list;
        this.resetPool();
    }

    public static ModuleInfo[] difference(ModuleInfo[] a2, ModuleInfo[] b2) {
        Vector<ModuleInfo> v = new Vector<ModuleInfo>(a2.length);
        for (int i2 = 0; i2 < a2.length; ++i2) {
            boolean match = false;
            for (int j2 = 0; j2 < b2.length; ++j2) {
                if (!a2[i2].moduleName.equals(b2[j2].moduleName)) continue;
                match = true;
                break;
            }
            if (match) continue;
            v.add(a2[i2]);
        }
        Object[] r2 = new ModuleInfo[v.size()];
        v.copyInto(r2);
        return r2;
    }

    public void setPool(ModuleInfo[] poolList) {
        this.pool = new Hashtable(this.list.length + poolList.length);
        for (int i2 = 0; i2 < poolList.length; ++i2) {
            this.pool.put(poolList[i2].moduleName, poolList[i2]);
        }
    }

    public void resetPool() {
        this.pool = new Hashtable(this.list.length + 1);
    }

    public void setBackupPool(String[] moduleNames) {
        this.backupPool = new HashSet<String>(Arrays.asList(moduleNames));
    }

    public boolean sort() {
        this.source = new Vector(this.list.length);
        for (int i2 = 0; i2 < this.list.length; ++i2) {
            this.source.add(this.list[i2]);
        }
        this.sorted = new Vector(this.list.length);
        this.missing = new HashSet();
        boolean foundAny = true;
        boolean useBackupPool = false;
        while (foundAny && this.source.size() > 0) {
            foundAny = false;
            Iterator en = this.source.iterator();
            while (en.hasNext()) {
                ModuleInfo m2 = (ModuleInfo)en.next();
                boolean found = true;
                for (int i3 = 0; i3 < m2.getImports().length; ++i3) {
                    if (this.pool.get(m2.getImports()[i3]) != null || useBackupPool && (!useBackupPool || this.backupPool.contains(m2.getImports()[i3]))) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                foundAny = true;
                en.remove();
                this.pool.put(m2.moduleName, m2);
                this.sorted.add(m2);
            }
            if (!foundAny && this.backupPool != null && !useBackupPool) {
                useBackupPool = true;
                foundAny = true;
                continue;
            }
            useBackupPool = false;
        }
        Hashtable<String, ModuleInfo> failed = new Hashtable<String, ModuleInfo>(this.source.size() + 1);
        Enumeration en = this.source.elements();
        while (en.hasMoreElements()) {
            ModuleInfo m3 = (ModuleInfo)en.nextElement();
            failed.put(m3.moduleName, m3);
        }
        return this.source.size() == 0;
    }

    public ModuleInfo[] getSortedList() {
        Object[] r2 = new ModuleInfo[this.sorted.size()];
        this.sorted.copyInto(r2);
        return r2;
    }

    public ModuleInfo[] getFailedList() {
        Object[] r2 = new ModuleInfo[this.source.size()];
        this.source.copyInto(r2);
        return r2;
    }

    public String[] getMissingModules() {
        Object[] o2 = this.missing.toArray();
        String[] s = new String[o2.length];
        for (int i2 = 0; i2 < o2.length; ++i2) {
            s[i2] = o2[i2].toString();
        }
        return s;
    }
}

