/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.smiparser.SMI;
import com.agentpp.smiparser.SMI2Java;
import com.agentpp.smiparser.SMIAgentCapabilities;
import com.agentpp.smiparser.SMICompliance;
import com.agentpp.smiparser.SMIDefaultValue;
import com.agentpp.smiparser.SMIDescription;
import com.agentpp.smiparser.SMIFile;
import com.agentpp.smiparser.SMIIndex;
import com.agentpp.smiparser.SMIMib;
import com.agentpp.smiparser.SMIModule;
import com.agentpp.smiparser.SMINotifyType;
import com.agentpp.smiparser.SMIObject;
import com.agentpp.smiparser.SMIObjectType;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.SMIRevision;
import com.agentpp.smiparser.SMISeqEntries;
import com.agentpp.smiparser.SMISyntax;
import com.agentpp.smiparser.SMITextualConvention;
import com.agentpp.smiparser.SimpleNode;
import com.agentpp.smiparser.StringToken;
import com.agentpp.smiparser.Token;
import com.agentpp.smiparser.pib.PIBMib;
import com.agentpp.smiparser.pib.PIBObjectType;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class LenientSMI2Java
extends SMI2Java {
    public LenientSMI2Java(SMIRepository r2, int options) {
        super(r2, options);
    }

    protected void checkVariation(String s, MIBVariation v, Token t) {
    }

    protected void checkAgentCaps(MIBAgentCaps ac) throws SMIParseException {
    }

    protected void checkPibObjectType(com.agentpp.mib.pib.PIBObjectType ot, PIBObjectType o2) {
    }

    protected void checkSyntax(String oname, String syntax) throws SMIParseException {
        String s = (String)this.nameToSyntax.get(oname);
        this.nameToSyntax.put(oname, syntax);
    }

    protected void checkSyntax(StringToken oname, StringToken syntax) throws SMIParseException {
        if (syntax == null) {
            return;
        }
        StringToken s = (StringToken)this.nameToSyntax.get(oname);
        this.nameToSyntax.put(oname, syntax);
    }

    protected void checkWhetherIndexIsPositive(MIBObjectType ot) throws SMIParseException {
    }

    protected String readImports(MIBImport list) throws SMIParseException {
        String cyclic;
        String source = list.getSource();
        Vector<String> entries = list.getImportsVector();
        Token[] token = (Token[])list.getUserObject();
        if (!(this.smiRep.isModuleAlreadyImported(source) || this.smiRep.importModule(source, this.rep, false) || this.failedImports.contains(source))) {
            this.failedImports.add(source);
            this.throwLocalizedError(token[1], new Vector<String>(Arrays.asList(source)), 1100, source);
        }
        if ((cyclic = this.smiRep.hasCircularImport(source, this.currentModule.getModuleName())) != null) {
            this.throwLocalizedError(token[1], new Vector<String>(Arrays.asList(cyclic)), 1101, source);
        }
        Enumeration<String> en = entries.elements();
        while (en.hasMoreElements()) {
            MIBObject o2;
            String oname = en.nextElement();
            if (SMI.isASN1KeyWord(oname) || (o2 = this.smiRep.getObject(source, oname)) == null) continue;
            Vector sources = this.currentModule.getImportSources(oname);
            if (sources.size() > 0) {
                MIBObject dup;
                String moduleName;
                if (!sources.contains(source) && (moduleName = this.smiRep.getModuleName((dup = this.smiRep.getKnownObject(oname)).getModuleID())) != null) {
                    dup = dup.getClone();
                    dup.setName(moduleName + "." + dup.getName());
                    this.smiRep.replaceKnownObject(oname, dup);
                }
                o2 = o2.getClone();
                o2.setName(source + "." + o2.getName());
                this.smiRep.addKnownObject(o2);
                continue;
            }
            this.smiRep.addKnownObject(o2);
        }
        MIBImport mi = new MIBImport(source, entries, list.getComment());
        this.currentModule.addImport(mi);
        this.smiRep.createOids(this.currentModule.getModuleName());
        return source;
    }

    public Object visit(SimpleNode node, Object data) throws SMIParseException {
        this.healBrokenNodeStructure(node, data);
        if (this.currentModuleInfo != null || node.getId() == -4 || node.getId() == -29) {
            switch (node.getId()) {
                case -5: {
                    this.currentFile = ((SMIFile)node).getName();
                    break;
                }
                case -4: {
                    if (this.currentModuleInfo != null) break;
                    this.smiRep.setScope(((SMIMib)node).getName(), this);
                    this.currentModuleInfo = this.readModule((SMIMib)node);
                    ((Vector)data).addElement(this.currentModuleInfo);
                    break;
                }
                case -29: {
                    this.smiRep.setScope(((PIBMib)node).getName(), this);
                    this.currentModuleInfo = this.readModule((PIBMib)node);
                    ((Vector)data).addElement(this.currentModuleInfo);
                    break;
                }
                case -3: {
                    this.readModuleIdentity((SMIModule)node);
                    break;
                }
                case -1: {
                    this.currentSyntax = null;
                    if (((SMIObject)node).getType() == 11) break;
                    this.readObject((SMIObject)node);
                    break;
                }
                case -16: {
                    this.readObjectType((SMIObjectType)node);
                    break;
                }
                case -15: {
                    this.readNotifyType((SMINotifyType)node);
                    break;
                }
                case -12: {
                    break;
                }
                case -20: {
                    this.readSeqEntries((SMISeqEntries)node);
                    break;
                }
                case -7: {
                    if (this.currentObject == null) break;
                    this.currentObject.setDescription(((SMIDescription)node).getValue());
                    break;
                }
                case -24: {
                    if (this.currentObject == null) break;
                    this.currentObject.setReference(node.toString());
                    break;
                }
                case -19: {
                    this.readRevision((SMIRevision)node);
                    break;
                }
                case -8: {
                    if (!(this.currentObject instanceof MIBObjectType)) break;
                    MIBObjectType ot = (MIBObjectType)this.currentObject;
                    ot.setDefaultValue(((SMIDefaultValue)node).getDefaultValue().string);
                    break;
                }
                case -21: {
                    this.readSyntax((SMISyntax)node);
                    break;
                }
                case -23: {
                    this.readVariable(new StringToken(node.toString(), node.getToken()));
                    break;
                }
                case -14: {
                    this.readIndex((SMIIndex)node);
                    break;
                }
                case -22: {
                    MIBTextualConvention tc = (MIBTextualConvention)this.currentObject;
                    SMITextualConvention t = (SMITextualConvention)node;
                    tc.setDisplayHint(t.getDisplayHint());
                    tc.setSyntax(t.syntax);
                    this.currentSyntax = t.syntax;
                    this.checkSyntax(tc.getName(), this.currentSyntax.getSyntax());
                    switch (this.currentSyntax.getType()) {
                        case 2: 
                        case 3: {
                            this.smiRep.checkUnresolvedSyntax((StringToken)this.currentSyntax.userObject);
                        }
                    }
                    this.smiRep.replaceKnownObject(tc.getName(), tc);
                    break;
                }
                case -9: {
                    this.readAgentCaps((SMIAgentCapabilities)node);
                    break;
                }
                case -11: {
                    this.readCompliance((SMICompliance)node);
                }
            }
        }
        node.childrenAccept(this, data);
        switch (node.getId()) {
            case -4: {
                this.smiRep.resolveSyntaxes();
                ++this.moduleCount;
                this.currentModuleInfo = null;
            }
        }
        return data;
    }

    protected void throwInconsistentSyntaxError(MIBObjectType ot) throws SMIParseException {
    }
}

