/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.smiparser.Node;
import java.util.Stack;

class JJTSMIParserState {
    private Stack nodes = new Stack();
    private Stack marks = new Stack();
    private int sp = 0;
    private int mk = 0;
    private boolean node_created;
    private boolean saveNext;
    private Node saveNode;

    JJTSMIParserState() {
    }

    boolean nodeCreated() {
        return this.node_created;
    }

    void reset() {
        this.nodes.removeAllElements();
        this.marks.removeAllElements();
        this.sp = 0;
        this.mk = 0;
    }

    Node rootNode() {
        return (Node)this.nodes.elementAt(0);
    }

    void pushNode(Node n2) {
        this.nodes.push(n2);
        ++this.sp;
    }

    Node popNode() {
        if (--this.sp < this.mk) {
            this.mk = (Integer)this.marks.pop();
        }
        return (Node)this.nodes.pop();
    }

    Node peekNode() {
        return (Node)this.nodes.peek();
    }

    int nodeArity() {
        return this.sp - this.mk;
    }

    void clearNodeScope(Node n2) {
        while (this.sp > this.mk) {
            this.popNode();
        }
        this.mk = (Integer)this.marks.pop();
    }

    void openNodeScope(Node n2) {
        this.marks.push(new Integer(this.mk));
        this.mk = this.sp;
        n2.jjtOpen();
        if (this.saveNext) {
            this.saveNext = false;
            this.saveNode = n2;
        }
    }

    Node getSaveNode() {
        return this.saveNode;
    }

    void closeNodeScope(Node n2, int num) {
        this.mk = (Integer)this.marks.pop();
        while (num-- > 0) {
            Node c2 = this.popNode();
            c2.jjtSetParent(n2);
            n2.jjtAddChild(c2, num);
        }
        n2.jjtClose();
        this.pushNode(n2);
        this.node_created = true;
        if (this.saveNode == n2) {
            this.saveNode = null;
        }
    }

    void closeNodeScope(Node n2, boolean condition) {
        if (condition) {
            int a2 = this.nodeArity();
            this.mk = (Integer)this.marks.pop();
            while (a2-- > 0) {
                Node c2 = this.popNode();
                c2.jjtSetParent(n2);
                n2.jjtAddChild(c2, a2);
            }
            n2.jjtClose();
            this.pushNode(n2);
            this.node_created = true;
            if (this.saveNode == n2) {
                this.saveNode = null;
            }
        } else {
            this.mk = (Integer)this.marks.pop();
            this.node_created = false;
        }
    }

    void setSaveNext(boolean saveNext) {
        this.saveNext = saveNext;
    }
}

