/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smi.examples;

import com.agentpp.smi.IModule;
import com.agentpp.smi.IObject;
import com.agentpp.smi.IObjectType;
import com.agentpp.smi.SMIRepositoryManager;
import com.agentpp.smi.event.RepositoryEvent;
import com.agentpp.smi.event.RepositoryListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DumpObjectTypes
implements RepositoryListener {
    private SMIRepositoryManager repMan;
    private File repositoryFile;

    public DumpObjectTypes(String license, String licenseKey, String repositoryPath, String moduleName) {
        this.repMan = new SMIRepositoryManager(license, licenseKey);
        try {
            this.repositoryFile = new File(repositoryPath);
            if (this.repositoryFile.isDirectory()) {
                this.repMan.open(this.repositoryFile);
            } else {
                this.repMan.addRepositoryListener(this);
            }
            IModule module = this.repMan.getModule(moduleName);
            Enumeration en = module.objectsByOid().elements();
            while (en.hasMoreElements()) {
                IObject o2 = (IObject)en.nextElement();
                if (!(o2 instanceof IObjectType)) continue;
                IObjectType ot = (IObjectType)o2;
                System.out.println(ot.getName() + " = " + ot.getPrintableOid() + "; " + ot.getAccess() + "; " + ot.getStatus() + "; " + ot.getSyntaxDef().getSyntax());
            }
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Usage: DumpObjectTypes <license> <licenseKey> <repositoryPath> <moduleName>");
            System.exit(1);
        }
        DumpObjectTypes dumpObjectTypes1 = new DumpObjectTypes(args[0], args[1], args[2], args[3]);
    }

    public void writeModule(RepositoryEvent event) {
    }

    public void deleteModule(RepositoryEvent event) {
    }

    public void readModule(RepositoryEvent event) {
        try {
            ZipFile rep = this.repositoryFile.getPath().toUpperCase().endsWith(".JAR") ? new JarFile(this.repositoryFile) : new ZipFile(this.repositoryFile);
            ZipEntry entry = rep.getEntry(event.getModuleName());
            event.setInputStream(rep.getInputStream(entry));
        }
        catch (IOException iox) {
            System.err.print("Could not open repository '" + this.repositoryFile.getPath() + "' to load MIB module: " + event.getModuleName());
            return;
        }
    }

    public String[] listModuleNames() {
        try {
            ZipFile rep = this.repositoryFile.getPath().toUpperCase().endsWith(".JAR") ? new JarFile(this.repositoryFile) : new ZipFile(this.repositoryFile);
            ArrayList<String> names = new ArrayList<String>();
            Enumeration<? extends ZipEntry> en = rep.entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                names.add(entry.getName());
            }
            return names.toArray(new String[names.size()]);
        }
        catch (IOException iox) {
            System.err.print("Could not open repository '" + this.repositoryFile.getPath() + "': " + iox.getMessage());
            return null;
        }
    }
}

