/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smi.examples;

import com.agentpp.smi.IModule;
import com.agentpp.smi.IModuleInfo;
import com.agentpp.smi.IModuleInfoSorter;
import com.agentpp.smi.IObject;
import com.agentpp.smi.IRepository;
import com.agentpp.smi.SMIRepository;
import com.agentpp.smi.SMIRepositoryManager;
import com.agentpp.smi.event.ImportModuleEvent;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smiparser.SMIParseException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DumpObjectNames
implements ImportModuleListener {
    private SMIRepositoryManager repMan;
    private String mibFileDir;
    private boolean useCache = false;
    private Hashtable moduleHash = new Hashtable();
    private Hashtable moduleFileNames = new Hashtable();
    private static int moduleID = 1;

    public DumpObjectNames(String license, String licenseKey, String mibFileDir, String cache) {
        this.useCache = Boolean.valueOf(cache);
        this.repMan = new SMIRepositoryManager(license, licenseKey);
        this.mibFileDir = mibFileDir;
    }

    public void run() {
        File f2 = new File(this.mibFileDir);
        Vector v = DumpObjectNames.getSubtree(f2);
        Vector<IModuleInfo> moduleInfos = new Vector<IModuleInfo>();
        Vector<File> files = new Vector<File>();
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            f2 = (File)en.nextElement();
            try {
                IModuleInfo[] mi = this.repMan.getModuleInfo(f2);
                for (int i2 = 0; i2 < mi.length; ++i2) {
                    moduleInfos.addElement(mi[i2]);
                    this.moduleFileNames.put(mi[i2].getModuleName(), f2);
                }
                files.addElement(f2);
            }
            catch (Exception ex) {
                System.err.println("Error in file " + f2.getPath() + ": " + ex.toString());
            }
        }
        Object[] infoList = new IModuleInfo[moduleInfos.size()];
        moduleInfos.copyInto(infoList);
        IModuleInfoSorter sorter = new IModuleInfoSorter((IModuleInfo[])infoList);
        if (!sorter.sort()) {
            System.err.println("Could not resolve all imports!");
        }
        infoList = sorter.getSortedList();
        SMIRepository repository = new SMIRepository();
        for (int i3 = 0; i3 < infoList.length; ++i3) {
            try {
                f2 = (File)this.moduleFileNames.get(infoList[i3].getModuleName());
                if (f2 == null) continue;
                FileInputStream fis = new FileInputStream(f2);
                IModule[] modules = this.repMan.getModules(fis, this);
                fis.close();
                for (int j2 = 0; j2 < modules.length; ++j2) {
                    if (this.useCache) {
                        this.moduleHash.put(modules[j2].getModuleName(), modules[j2]);
                    }
                    repository.addObject(modules[j2]);
                    Enumeration en2 = modules[j2].objects();
                    while (en2.hasMoreElements()) {
                        repository.addObject((IObject)en2.nextElement());
                    }
                }
                repository.structureChanged();
                continue;
            }
            catch (SMIParseException pex) {
                System.out.println("Errors of " + infoList[i3].getModuleName() + ":");
                if (pex.getErrorList() != null && pex.getErrorList().size() > 0) {
                    for (int j3 = 0; j3 < pex.getErrorList().size(); ++j3) {
                        SMIParseException p2 = pex.getErrorList().get(j3);
                        System.out.println("#" + (j3 + 1) + ": " + this.repMan.getErrorText(p2));
                    }
                    continue;
                }
                System.out.println(this.repMan.getErrorText(pex));
                continue;
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
        DumpObjectNames.dumpRepository(repository);
    }

    private static void dumpRepository(IRepository repository) {
        try {
            Vector v = repository.getObjectClassOID("sysDescr.0");
            System.out.println("Resolved OID 'sysDescr.0': class=" + v.elementAt(0) + ", instance suffix=" + v.elementAt(1));
        }
        catch (Exception ex) {
            System.out.println("MIB modules do not include sysDescr.0!");
        }
        Enumeration en = repository.objects();
        while (en.hasMoreElements()) {
            IObject o2 = (IObject)en.nextElement();
            System.out.println(o2.getName() + " = " + o2.getPrintableOid());
        }
    }

    public Integer createModuleID(String moduleName) {
        return new Integer(moduleID++);
    }

    public void freeModuleID(Integer i2, String moduleName) {
    }

    public void importModule(ImportModuleEvent e2) {
        if (this.useCache) {
            IModule m2 = (IModule)this.moduleHash.get(e2.getModuleName());
            if (m2 != null) {
                Vector v = m2.getObjectsVector();
                Object[] objs = new IObject[v.size()];
                v.copyInto(objs);
                e2.setObjects((IObject[])objs);
            }
        } else {
            File f2 = (File)this.moduleFileNames.get(e2.getModuleName());
            if (f2 != null) {
                try {
                    FileInputStream fis = new FileInputStream(f2);
                    IModule[] modules = this.repMan.getModules(fis, this);
                    fis.close();
                    for (int i2 = 0; i2 < modules.length; ++i2) {
                        if (!modules[i2].getModuleName().equals(e2.getModuleName())) continue;
                        Object[] objs = new IObject[modules[i2].size()];
                        Vector v = modules[i2].getObjectsVector();
                        v.copyInto(objs);
                        e2.setObjects((IObject[])objs);
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static Vector getSubtree(File directory) {
        if (directory.isDirectory()) {
            int i2;
            File[] files = directory.listFiles(new FileFilter(){

                public boolean accept(File f2) {
                    return !f2.isDirectory();
                }
            });
            File[] dirs = directory.listFiles(new FileFilter(){

                public boolean accept(File f2) {
                    return f2.isDirectory();
                }
            });
            Vector<File> v = new Vector<File>(files.length, 10);
            for (i2 = 0; i2 < files.length; ++i2) {
                v.addElement(files[i2]);
            }
            for (i2 = 0; i2 < dirs.length; ++i2) {
                v.addAll(DumpObjectNames.getSubtree(dirs[i2]));
            }
            return v;
        }
        return new Vector();
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Usage: DumpObjectNames <license> <licenseKey> <mibFileDir> <useCache>");
            System.out.println("where: <useCache>   is \"true\" or \"false\"");
            System.out.println("       <mibFileDir> is a directory containing SMIv1/v2 MIB files.");
            System.exit(1);
        }
        DumpObjectNames dumpObjectNames = new DumpObjectNames(args[0], args[1], args[2], args[3]);
        dumpObjectNames.run();
    }
}

