/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smi.examples;

import com.agentpp.smi.IModuleInfo;
import com.agentpp.smi.SMIRepositoryManager;
import com.agentpp.smiparser.SMIParseException;
import java.io.File;

public class CompileMIB {
    private SMIRepositoryManager repMan;

    public CompileMIB(String license, String licenseKey, String repositoryPath, String mibPath) {
        this.repMan = new SMIRepositoryManager(license, licenseKey);
        try {
            this.repMan.open(new File(repositoryPath));
            IModuleInfo[] modules = this.repMan.addModules(new File(mibPath));
            System.out.print("Compiled " + mibPath + " successfully, it contains ");
            for (int i2 = 0; i2 < modules.length; ++i2) {
                modules[i2].getModuleName();
                if (i2 + 1 >= modules.length) continue;
                System.out.print(", ");
            }
            System.out.println();
        }
        catch (SMIParseException pex) {
            if (pex.getErrorList() != null && pex.getErrorList().size() > 0) {
                for (int i3 = 0; i3 < pex.getErrorList().size(); ++i3) {
                    SMIParseException p2 = pex.getErrorList().get(i3);
                    System.out.println("#" + (i3 + 1) + ": " + this.repMan.getErrorText(p2));
                }
            } else {
                System.out.println(this.repMan.getErrorText(pex));
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Usage: CompileMIB <license> <licenseKey> <repositoryPath> <mibFile>");
            System.exit(1);
        }
        CompileMIB c2 = new CompileMIB(args[0], args[1], args[2], args[3]);
    }
}

