/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.xsd;

import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.smiparser.SMI;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMComment;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class MIBModule2XSD {
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private MIBRepository _$12267;
    private MIBModule _$26771;
    private Vector _$26772 = new Vector();
    private static SimpleDateFormat _$18074 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private String _$26773 = "http://www.mibexplorer.com/xsd/mibs/";

    public MIBModule2XSD(MIBRepository rep) {
        this._$12267 = rep;
    }

    public void setURLPrefix(String urlPrefix) {
        this._$26773 = urlPrefix;
    }

    public synchronized Document createXML(MIBModule m2, String header, String schemaURL) {
        this._$26771 = m2;
        this._$26772 = new Vector();
        DOMElement root = new DOMElement("xsd:schema");
        root.addAttribute("xmlns", this._$26773 + m2.getModuleName());
        root.addAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        root.addAttribute("xmlns:smi", this._$26773 + "smi");
        DOMDocument doc = new DOMDocument(root);
        String[] dependecies = m2.getImportSources();
        for (int i2 = 0; i2 < dependecies.length; ++i2) {
            DOMAttribute nspace = new DOMAttribute(new QName("xmlns:" + dependecies[i2]), this._$26773 + dependecies[i2]);
            root.add(nspace);
        }
        root.addAttribute("xml:lang", "en");
        root.addAttribute("elementFormDefault", "qualified");
        root.addAttribute("attributeFormDefault", "unqualified");
        root.addAttribute("targetNamespace", this._$26773 + m2.getModuleName());
        doc.add(new DOMComment(header));
        try {
            Vector v = this._$26710(m2);
            for (int i3 = 0; i3 < v.size(); ++i3) {
                root.add((DOMElement)v.get(i3));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int i4 = 0; i4 < this._$26772.size(); ++i4) {
            root.add((DOMElement)this._$26772.get(i4));
        }
        Vector<MIBTextualConvention> simpleTypes = this._$26771.getTextualConventions();
        for (int i5 = 0; i5 < simpleTypes.size(); ++i5) {
            root.add(this._$26717(simpleTypes.get(i5)));
        }
        this._$26771 = null;
        this._$26772 = null;
        return doc;
    }

    public void output(OutputStream os, Document doc, int indent) {
        try {
            OutputFormat outputFormat = new OutputFormat();
            outputFormat.setIndent(true);
            outputFormat.setIndentSize(indent);
            outputFormat.setNewlines(true);
            XMLWriter xmlWriter = new XMLWriter(os, outputFormat);
            xmlWriter.write(doc);
            xmlWriter.flush();
            xmlWriter.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private DOMElement _$26711(String descr) {
        DOMElement description = new DOMElement("xsd:documentation");
        description.setText(MIBObject.getUnquotedString(descr));
        return description;
    }

    private DOMElement _$26785(MIBObjectType o2) {
        DOMElement annotation = new DOMElement("xsd:annotation");
        DOMElement appinfo = new DOMElement("xsd:appinfo");
        annotation.add(appinfo);
        DOMElement maxAccess = new DOMElement("maxAccess");
        maxAccess.setText(this._$26736(o2.getAccess()));
        appinfo.add(maxAccess);
        DOMElement status = new DOMElement("status");
        status.setText(o2.getStatus());
        appinfo.add(status);
        DOMElement oid = new DOMElement("oid");
        oid.setText(o2.getOid().toString());
        appinfo.add(oid);
        if (o2.hasUnits()) {
            DOMElement units = new DOMElement("units");
            units.setText(o2.getUnits());
            appinfo.add(units);
        }
        appinfo.add(this._$26711(o2.getDescription()));
        return annotation;
    }

    private DOMElement _$26788(Vector enums) {
        DOMElement r2 = new DOMElement("xsd:restriction");
        r2.addAttribute("base", "xsd:NMTOKEN");
        for (int i2 = 0; i2 < enums.size(); ++i2) {
            MIBEnum en = (MIBEnum)enums.get(i2);
            DOMElement e2 = new DOMElement("xsd:enumeration");
            e2.addAttribute("value", en.getLabel());
            DOMElement annotation = new DOMElement("xsd:annotation");
            DOMElement appinfo = new DOMElement("xsd:appinfo");
            annotation.add(appinfo);
            e2.add(annotation);
            DOMElement intVal = new DOMElement("intValue");
            intVal.setText("" + en.getLongValue());
            appinfo.add(intVal);
            if (en.hasComment()) {
                appinfo.add(this._$26711(en.getComment()));
            }
            r2.add(e2);
        }
        return r2;
    }

    private Vector _$26791(String displayHint) {
        if (displayHint == null) {
            return null;
        }
        Vector<DisplayHint> v = new Vector<DisplayHint>();
        int pos = 0;
        while (pos < displayHint.length()) {
            DisplayHint dh = new DisplayHint();
            while (pos < displayHint.length() && Character.isDigit(displayHint.charAt(pos))) {
                ++pos;
            }
            try {
                dh.number = Integer.parseInt(displayHint.substring(0, pos));
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            displayHint = displayHint.substring(pos);
            pos = 0;
            dh.format = displayHint.charAt(pos++);
            if (!Character.isDigit(displayHint.charAt(pos))) {
                dh.sep = new Character(displayHint.charAt(pos++));
                if (!Character.isDigit(displayHint.charAt(pos))) {
                    dh.repeater = new Character(displayHint.charAt(pos++));
                }
            }
            displayHint = displayHint.substring(pos);
            pos = 0;
            v.add(dh);
        }
        return v;
    }

    private static int _$26794(long n2) {
        int i2 = 1;
        while (n2 / 10L > 0L) {
            n2 /= 10L;
            ++i2;
        }
        return i2;
    }

    private DOMElement _$26795(String format, Vector ranges) {
        if (format == null || format.indexOf(42) >= 0) {
            return null;
        }
        DOMElement pattern = new DOMElement("xsd:pattern");
        Vector v = this._$26791(format);
        if (v == null || ranges == null || ranges.size() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(((MIBRange)ranges.get(0)).getLowerValue() != 0L ? "(" : "((");
        Iterator rit = ranges.iterator();
        block7: do {
            MIBRange range = (MIBRange)rit.next();
            int bytesUsed = 0;
            for (int i2 = 0; i2 < v.size(); ++i2) {
                DisplayHint dh = (DisplayHint)v.get(i2);
                String regex = "";
                switch (dh.format) {
                    case 'a': 
                    case 't': {
                        regex = "(#x00-#x7f)";
                        break;
                    }
                    case 'b': {
                        regex = "((0|1){8})";
                        break;
                    }
                    case 'd': {
                        regex = "([0-9]{3})";
                        break;
                    }
                    case 'o': {
                        regex = "([0-7]{3})";
                        break;
                    }
                    case 'x': {
                        regex = "([0-9A-Fa-f]{2})";
                    }
                }
                if ((long)bytesUsed < range.getLowerValue()) {
                    if (dh.format == 'd') {
                        buf.append("(0|[1-9](([0-9]){0,");
                        buf.append(MIBModule2XSD._$26794(0xFF ^ dh.number) - 1);
                        buf.append("}))");
                        if ((long)(bytesUsed += dh.number) >= range.getUpperValue()) continue block7;
                        if (dh.sep != null) {
                            buf.append(dh.sep);
                        }
                    } else if (rit.hasNext()) {
                        buf.append("(" + regex + "{");
                        buf.append(dh.number);
                        buf.append("})");
                        if (dh.sep != null) {
                            buf.append(dh.sep);
                        }
                        if ((long)(bytesUsed += dh.number) >= range.getUpperValue()) {
                            continue block7;
                        }
                    } else {
                        buf.append("(" + regex);
                        if (dh.sep != null) {
                            buf.append(dh.sep);
                        }
                        buf.append(dh.number);
                        buf.append("{");
                        buf.append(range.getLowerValue() - 1L);
                        buf.append(",");
                        buf.append(range.getUpperValue() - 1L);
                        buf.append("})");
                        buf.append(regex);
                        if ((long)(bytesUsed += dh.number) >= range.getUpperValue()) {
                            continue block7;
                        }
                    }
                } else if (dh.format == 'd') {
                    if ((long)dh.number < range.getUpperValue()) {
                        buf.append("(0|[1-9](([0-9]){0,");
                        buf.append(MIBModule2XSD._$26794(0xFF ^ dh.number) - 1);
                        buf.append("}))");
                        bytesUsed = (int)((long)bytesUsed + range.getLowerValue());
                        if ((long)bytesUsed >= range.getUpperValue()) continue block7;
                        if (dh.sep != null) {
                            buf.append(dh.sep);
                        }
                    } else {
                        buf.append("(0|[1-9](([0-9]){0,");
                        buf.append(MIBModule2XSD._$26794(0xFFL ^ range.getUpperValue()) - 1);
                        buf.append("}))");
                        bytesUsed = (int)((long)bytesUsed + range.getUpperValue());
                    }
                } else {
                    buf.append("(" + regex);
                    if (rit.hasNext()) {
                        if (dh.sep != null) {
                            buf.append(dh.sep);
                        }
                        if (range.getLowerValue() == 0L && range.getUpperValue() >= 65535L) {
                            buf.append(")*");
                        } else {
                            buf.append("){");
                            buf.append(range.getLowerValue());
                            buf.append(",");
                            buf.append(Math.min(range.getUpperValue(), (long)dh.number) - 1L);
                            buf.append("}");
                        }
                        bytesUsed = (int)((long)bytesUsed + range.getLowerValue());
                        if ((long)bytesUsed >= range.getUpperValue()) {
                            continue block7;
                        }
                    } else {
                        bytesUsed = (int)((long)bytesUsed + range.getLowerValue());
                        if (dh.sep != null && (long)bytesUsed < range.getUpperValue()) {
                            if (range.getLowerValue() == 0L && range.getUpperValue() >= 65535L) {
                                buf.append(dh.sep);
                                buf.append(")*");
                            } else {
                                buf.append("){");
                                buf.append(range.getLowerValue());
                                buf.append(",");
                                buf.append(range.getUpperValue() - 1L);
                                buf.append("}");
                            }
                            buf.append(regex);
                        } else {
                            if (range.getLowerValue() == 0L && range.getUpperValue() >= 65535L) {
                                buf.append(")*");
                            } else {
                                buf.append("){");
                                buf.append(range.getLowerValue());
                                buf.append(",");
                                buf.append(range.getUpperValue() - 1L);
                                buf.append("}");
                            }
                            buf.append(dh.sep);
                        }
                    }
                }
                if ((long)bytesUsed >= range.getUpperValue()) continue block7;
            }
        } while (rit.hasNext());
        pattern.setText(buf.toString());
        return pattern;
    }

    private DOMElement _$26800(long maxValue, int fraction) {
        DOMElement max = new DOMElement("xsd:maxInclusive");
        if (fraction > 0) {
            max.addAttribute("value", "" + maxValue / (long)(0xA ^ fraction) + "." + maxValue % (long)Math.abs(0xA ^ fraction));
        } else {
            max.addAttribute("value", "" + maxValue);
        }
        return max;
    }

    private Vector _$26802(Vector ranges, String baseType) {
        Vector<DOMElement> v = new Vector<DOMElement>(ranges.size() + 1);
        for (int i2 = 0; i2 < ranges.size(); ++i2) {
            DOMElement simpleType = new DOMElement("xsd:simpleType");
            DOMElement restriction = new DOMElement("xsd:restriction");
            simpleType.add(restriction);
            restriction.addAttribute("base", baseType);
            MIBRange r2 = (MIBRange)ranges.get(i2);
            restriction.add(this._$26806(r2.getLowerValue(), 0));
            restriction.add(this._$26800(r2.getUpperValue(), 0));
            v.add(simpleType);
        }
        return v;
    }

    private DOMElement _$26806(long minValue, int fraction) {
        DOMElement min = new DOMElement("xsd:minInclusive");
        if (fraction > 0) {
            min.addAttribute("value", "" + minValue / (long)(0xA ^ fraction) + "." + minValue % (long)Math.abs(0xA ^ fraction));
        } else {
            min.addAttribute("value", "" + minValue);
        }
        return min;
    }

    private DOMElement _$26808(MIBTextualConvention base) {
        if (base.getSyntax().hasEnums()) {
            return this._$26788(base.getSyntax().getEnumsVector());
        }
        String baseSyntax = base.getSyntax().getSyntax();
        DOMElement e2 = new DOMElement("xsd:restriction");
        int fraction = -1;
        if (base.hasDisplayHint()) {
            if (SMI.isString(baseSyntax)) {
                e2.addAttribute("base", "xsd:string");
            } else if (base.getDisplayHint().indexOf(45) > 0) {
                e2.addAttribute("base", "xsd:decimal");
                Vector v = this._$26791(base.getDisplayHint());
                if (v != null && v.size() > 0) {
                    DisplayHint dh = (DisplayHint)v.get(0);
                    DOMElement d2 = new DOMElement("xsd:fractionDigits");
                    d2.setText("" + dh.number);
                    e2.add(d2);
                    fraction = dh.number;
                }
            } else {
                e2.addAttribute("base", "xsd:integer");
            }
        } else {
            String impSource;
            String bs = baseSyntax;
            bs = bs.equals(SMI.SMI_SYNTAX[1]) ? "smi:OctetString" : (bs.equals(SMI.SMI_SYNTAX[2]) ? "smi:ObjectIdentifier" : (this._$26771.getImportSource(baseSyntax) != null ? ((impSource = this._$26771.getImportSource(baseSyntax)).equals("SNMPv2-SMI") || impSource.equals("RFC1155-SMI") ? "smi:" + baseSyntax : impSource + ":" + baseSyntax) : "smi:" + baseSyntax));
            e2.addAttribute("base", bs);
        }
        if (SMI.isUnsignedNumeric(baseSyntax)) {
            long m2 = 0xFFFFFFFFL;
            if (SMI.basicSyntax(baseSyntax) == 7) {
                m2 = Long.MAX_VALUE;
            }
            long minValue = Math.max(base.getSyntax().getMinOfRanges(), 0L);
            long maxValue = Math.min(base.getSyntax().getMaxOfRanges(), m2);
            e2.add(this._$26806(minValue, fraction));
            e2.add(this._$26800(maxValue, fraction));
        } else if (base.getSyntax().hasEnums()) {
            e2.add(this._$26788(base.getSyntax().getEnumsVector()));
        } else if (SMI.isNumeric(baseSyntax)) {
            long m3 = Integer.MAX_VALUE;
            DOMElement min = new DOMElement("xsd:minInclusive");
            long minValue = Math.max(base.getSyntax().getMinOfRanges(), Integer.MIN_VALUE);
            long maxValue = Math.min(base.getSyntax().getMaxOfRanges(), m3);
            e2.add(this._$26806(minValue, fraction));
            e2.add(this._$26800(maxValue, fraction));
        } else if (SMI.isString(baseSyntax) && !base.hasDisplayHint()) {
            int minLength = 0;
            int maxLength = 65535;
            long minValue = Math.max(base.getSyntax().getMinOfRanges(), (long)minLength);
            long maxValue = Math.min(base.getSyntax().getMaxOfRanges(), (long)maxLength);
            e2.add(this._$26806(minValue, fraction));
            e2.add(this._$26800(maxValue, fraction));
        } else if (SMI.isString(baseSyntax) && base.hasDisplayHint()) {
            DOMElement pattern;
            Vector<MIBRange> ranges = base.getSyntax().getRangesVector();
            if (base.getSyntax().hasRanges()) {
                ranges = new Vector(1);
                ranges.add(new MIBRange(0L, 65535L));
            }
            if ((pattern = this._$26795(base.getDisplayHint(), ranges)) != null) {
                e2.add(pattern);
            } else {
                e2.addComment("Repeat in DISPLAY-HINT is not supported");
            }
        } else if (SMI.smiSyntax(baseSyntax) == 3) {
            // empty if block
        }
        return e2;
    }

    private DOMElement _$26717(MIBTextualConvention tc) {
        DOMElement typedef = new DOMElement("xsd:simpleType");
        String m2 = this._$12267.getModuleName(tc.getModuleID());
        MIBTextualConvention baseSyntax = this._$12267.getEffectiveSyntax(tc.getSyntax());
        String base = baseSyntax.getSyntax().getSyntax();
        if (tc.getName() != null) {
            typedef.addAttribute("name", tc.getName());
        }
        if (tc.hasDescription() || tc.hasDisplayHint()) {
            DOMElement annotation = new DOMElement("xsd:annotation");
            if (tc.hasDescription()) {
                annotation.add(this._$26711(tc.getDescription()));
            }
            if (tc.hasDisplayHint()) {
                DOMElement appinfo = new DOMElement("xsd:appinfo");
                appinfo.add(this._$26813(MIBObject.getUnquotedString(tc.getDisplayHint())));
                annotation.add(appinfo);
            }
            typedef.add(annotation);
        }
        if (baseSyntax.getSyntax().hasRanges() && SMI.isNumeric(base)) {
            DOMElement union = new DOMElement("xsd:union");
            String type = "xsd:int";
            if (SMI.isUnsignedNumeric(base)) {
                type = "xsd:unsignedInt";
            }
            Vector ranges = this._$26802(baseSyntax.getSyntax().getRangesVector(), type);
            for (int i2 = 0; i2 < ranges.size(); ++i2) {
                union.add((DOMElement)ranges.get(i2));
            }
            typedef.add(union);
        } else {
            typedef.add(this._$26808(baseSyntax));
        }
        return typedef;
    }

    private Vector _$26729(Vector tcs) {
        tcs = new Vector<DOMElement>(tcs);
        for (int i2 = 0; i2 < tcs.size(); ++i2) {
            tcs.setElementAt(this._$26717((MIBTextualConvention)tcs.elementAt(i2)), i2);
        }
        return tcs;
    }

    private Vector _$26732(Vector i2) {
        Vector<DOMElement> v = new Vector<DOMElement>();
        DOMElement schema = new DOMElement("xsd:import");
        schema.addAttribute("namespace", "http://www.w3.org/2001/XMLSchema");
        schema.addAttribute("schemaLocation", "http://www.w3.org/2001/XMLSchema.xsd");
        v.add(schema);
        DOMElement smi = new DOMElement("xsd:import");
        smi.addAttribute("namespace", this._$26773 + "smi");
        smi.addAttribute("schemaLocation", this._$26773 + "smi.xsd");
        v.add(smi);
        if (i2 != null) {
            Enumeration en = i2.elements();
            while (en.hasMoreElements()) {
                MIBImport ii = (MIBImport)en.nextElement();
                DOMElement imp = new DOMElement("xsd:import");
                imp.addAttribute("namespace", this._$26773 + ii.getSource());
                imp.addAttribute("schemaLocation", this._$26773 + ii.getSource() + ".xsd");
                v.addElement(imp);
            }
        }
        return v;
    }

    private DOMElement _$26814(MIBIndexPart index) {
        DOMElement attr = new DOMElement("xsd:attribute");
        return attr;
    }

    private String _$26815(MIBObjectType ot) {
        String s = ot.getSyntax().getSyntax();
        if (ot.getSyntax().getType() == 3) {
            String m2 = this._$26771.getImportSource(s);
            if (m2 != null) {
                return m2 + ":" + s;
            }
            return s;
        }
        if (s.equals(SMI.SMI_SYNTAX[1])) {
            return "smi:OctetString";
        }
        if (s.equals(SMI.SMI_SYNTAX[12])) {
            return "smi:Bits";
        }
        if (s.equals(SMI.SMI_SYNTAX[2])) {
            return "smi:ObjectIdentifier";
        }
        return "smi:" + s;
    }

    private Vector _$26816(MIBObjectType ot) {
        Vector<? extends MIBObjectType> indexCols = this._$12267.getColumnarObjectsOfTable(ot, true, false);
        if (indexCols == null) {
            return new Vector();
        }
        Vector<DOMElement> v = new Vector<DOMElement>(indexCols.size() + 1);
        for (int i2 = 0; i2 < indexCols.size(); ++i2) {
            DOMElement appinfo;
            DOMElement annotation;
            MIBObjectType ip = indexCols.get(i2);
            DOMElement attr = new DOMElement("xsd:attribute");
            attr.addAttribute("name", ip.getName());
            attr.addAttribute("type", this._$26815(ip));
            if (ot.getIndexPart().isAugment()) {
                annotation = new DOMElement("xsd:annotation");
                appinfo = new DOMElement("xsd:appinfo");
                annotation.add(appinfo);
                DOMElement augments = new DOMElement("augments");
                appinfo.add(augments);
                String m2 = this._$26771.getImportSource(ot.getIndexPart().getIndexPart()[0]);
                m2 = m2 != null ? m2 + ":" + ot.getIndexPart().getIndexPart()[0] : ot.getIndexPart().getIndexPart()[0];
                augments.setText(m2);
                attr.add(annotation);
            } else if (ot.getIndexPart().isImplied() && i2 + 1 == indexCols.size()) {
                annotation = new DOMElement("xsd:annotation");
                appinfo = new DOMElement("xsd:appinfo");
                annotation.add(appinfo);
                DOMElement implied = new DOMElement("impliedLength");
                appinfo.add(implied);
                attr.add(annotation);
            }
            v.add(attr);
        }
        return v;
    }

    private DOMElement _$26819(MIBObjectType table, Vector cols) {
        int i2;
        DOMElement complexEntry = new DOMElement("xsd:complexType");
        complexEntry.addAttribute("name", table.getName() + "Type");
        if (cols.size() > 0) {
            DOMElement sequence = new DOMElement("xsd:sequence");
            for (i2 = 0; i2 < cols.size(); ++i2) {
                DOMElement e2 = this._$26821((MIBObjectType)cols.get(i2));
                if (e2 == null) continue;
                sequence.add(e2);
            }
            complexEntry.add(sequence);
        }
        Vector index = this._$26816(table);
        for (i2 = 0; i2 < index.size(); ++i2) {
            complexEntry.add((DOMElement)index.get(i2));
        }
        return complexEntry;
    }

    /*
     * Unable to fully structure code
     */
    private DOMElement _$26821(MIBObject object) {
        switch (object.getType()) {
            case 1: {
                element = new DOMElement("xsd:element");
                element.addAttribute("name", object.getName());
                ot = (MIBObjectType)object;
                if (!SMI.isAccessible(ot.getAccess())) ** GOTO lbl29
                v0 = scalar = this._$12267.hasDescendants(ot) == false;
                if (ot.isColumnarObject() || scalar) {
                    if (ot.getSyntax().getType() == 4) {
                        element.addAttribute("type", this._$26815(ot));
                        element.addAttribute("minOccurs", "0");
                        element.add(this._$26785(ot));
                    } else {
                        element.addAttribute("minOccurs", "0");
                        base = this._$12267.getEffectiveSyntax(ot.getSyntax());
                        if (base.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                            element.addAttribute("type", ot.getName() + "Type");
                            element.add(this._$26785(ot));
                        } else {
                            element.add(this._$26785(ot));
                            element.add(this._$26717(base));
                        }
                    }
                    return element;
                }
                ** GOTO lbl41
lbl29:
                // 1 sources

                if (ot.isTable()) {
                    element.addAttribute("type", ot.getName() + "Type");
                    element.addAttribute("minOccurs", "0");
                    element.addAttribute("maxOccurs", "unbounded");
                    element.add(this._$26785(ot));
                    columns = this._$12267.getColumnarObjectsOfTable(ot, false, true);
                    this._$26772.add(this._$26819(ot, columns));
                    return element;
                }
            }
lbl41:
            // 4 sources

            case 0: 
            case 5: 
            case 10: {
                element = new DOMElement("xsd:element");
                element.addAttribute("name", object.getName());
                element.addAttribute("minOccurs", "0");
                complexType = new DOMElement("xsd:complexType");
                sequence = new DOMElement("xsd:sequence");
                complexType.add(sequence);
                element.add(complexType);
                children = this._$12267.getChildren(object);
                hasInstances = false;
                for (i = 0; i < children.size(); ++i) {
                    o = children.get(i);
                    if (!(o instanceof MIBObjectType)) continue;
                    ot = (MIBObjectType)o;
                    v1 = scalar = this._$12267.hasDescendants(ot) == false;
                    if (!ot.isColumnarObject() && !scalar) continue;
                    hasInstances = true;
                    e = this._$26821(ot);
                    if (e == null) continue;
                    sequence.add(e);
                }
                if (!hasInstances) break;
                return element;
            }
        }
        return null;
    }

    private String _$12743(String objectName) {
        String module = "";
        try {
            String m2;
            MIBObject obj = this._$12267.getObject(objectName);
            if (obj != null && (m2 = this._$12267.getModuleName(obj.getModuleID())) != null) {
                module = m2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return module;
    }

    private Vector _$26745() {
        Vector<DOMElement> v = new Vector<DOMElement>();
        Enumeration it = this._$26771.objectsByOid().elements();
        while (it.hasMoreElements()) {
            DOMElement e2;
            MIBObject o2 = (MIBObject)it.nextElement();
            if ((!(o2 instanceof MIBObjectType) || ((MIBObjectType)o2).isColumnarObject()) && o2.getType() != 0 && o2.getType() != 10 && !(o2 instanceof MIBModule) || (e2 = this._$26821(o2)) == null) continue;
            v.add(e2);
        }
        return v;
    }

    private Vector _$26710(MIBModule m2) {
        Vector<DOMElement> v = new Vector<DOMElement>();
        if (m2.hasDescription()) {
            DOMElement annotation = new DOMElement("xsd:annotation");
            DOMElement appinfo = new DOMElement("xsd:appinfo");
            annotation.add(appinfo);
            appinfo.add(this._$26711(m2.getDescription()));
            v.add(annotation);
        }
        Vector imports = this._$26732(m2.getImportsVector());
        for (int i2 = 0; i2 < imports.size(); ++i2) {
            v.add((DOMElement)imports.get(i2));
        }
        DOMElement module = new DOMElement("xsd:element");
        module.addAttribute("name", "snmp-data");
        DOMElement complexType0 = new DOMElement("xsd:complexType");
        DOMElement sequence0 = new DOMElement("xsd:sequence");
        complexType0.add(sequence0);
        DOMElement element = new DOMElement("xsd:element");
        sequence0.add(element);
        element.addAttribute("name", "context");
        element.addAttribute("minOccurs", "0");
        element.addAttribute("maxOccurs", "unbounded");
        DOMElement complexType = new DOMElement("xsd:complexType");
        DOMElement sequence = new DOMElement("xsd:sequence");
        complexType.add(sequence);
        element.add(complexType);
        Vector nodes = this._$26745();
        for (int i3 = 0; i3 < nodes.size(); ++i3) {
            DOMElement e2 = (DOMElement)nodes.get(i3);
            if (e2 == null) continue;
            sequence.add(e2);
        }
        DOMElement a1 = new DOMElement("xsd:attribute");
        a1.addAttribute("name", "agent");
        a1.addAttribute("type", "xsd:NMTOKEN");
        a1.addAttribute("use", "required");
        DOMElement a2 = new DOMElement("xsd:attribute");
        a2.addAttribute("name", "port");
        a2.addAttribute("type", "xsd:integer");
        a2.addAttribute("use", "required");
        complexType.add(a1);
        complexType.add(a2);
        module.add(complexType0);
        v.add(module);
        return v;
    }

    private DOMElement _$26813(String displayHint) {
        DOMElement e2 = new DOMElement("displayHint");
        e2.setText(displayHint);
        return e2;
    }

    private String _$26736(String access) {
        switch (SMI.accessType(access)) {
            case 5: {
                return "notify";
            }
            case 0: {
                return "not-accessible";
            }
            case 6: {
                return "not-implemented";
            }
            case 2: 
            case 3: {
                return "read-write";
            }
            case 1: {
                return "read-only";
            }
            case 4: {
                return "write-only";
            }
        }
        return "unknown";
    }

    class DisplayHint {
        public int number = 0;
        public char format = (char)100;
        public Character sep = null;
        public Character repeater = null;

        DisplayHint() {
        }
    }
}

