/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.xml;

import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBRevision;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.smiparser.SMI;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.dom.DOMCDATA;
import org.dom4j.dom.DOMComment;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentType;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class MIBModule2XML {
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private MIBRepository _$12267;
    private static SimpleDateFormat _$18074 = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public MIBModule2XML(MIBRepository rep) {
        this._$12267 = rep;
    }

    public DOMDocument createXML(MIBModule m2, String header, String dtdURL) {
        DOMElement root = new DOMElement("smi");
        DOMDocument doc = new DOMDocument(root);
        DOMDocumentType docType = new DOMDocumentType("smi", dtdURL);
        doc.setDocType(docType);
        doc.add(new DOMComment(header));
        try {
            List l2 = this._$26710(m2);
            Iterator it = l2.iterator();
            while (it.hasNext()) {
                root.add((DOMElement)it.next());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return doc;
    }

    private DOMElement _$26711(String descr) {
        DOMElement description = new DOMElement("description");
        description.add(new DOMCDATA(MIBObject.getUnquotedString(descr)));
        return description;
    }

    private DOMElement _$26713(String ref) {
        DOMElement reference = new DOMElement("reference");
        reference.add(new DOMCDATA(MIBObject.getUnquotedString(ref)));
        return reference;
    }

    private DOMElement _$26714(MIBRevision r2) {
        DOMElement revision = new DOMElement("revision");
        Date d2 = MIBModule.getDateFromUTC(MIBObject.getUnquotedString(r2.getRevision()));
        revision.addAttribute("date", _$18074.format(d2));
        revision.add(this._$26711(r2.getDescription()));
        return revision;
    }

    private DOMElement _$26717(MIBTextualConvention tc) {
        Enumeration<Serializable> en;
        DOMElement typedef = new DOMElement("typedef");
        String m2 = this._$12267.getModuleName(tc.getModuleID());
        if (m2 != null) {
            typedef.addAttribute("parent", m2);
        }
        if (tc.getName() != null) {
            typedef.addAttribute("name", tc.getName());
        }
        typedef.addAttribute("basetype", tc.getSyntax().getSyntax());
        if (tc.hasStatus()) {
            typedef.addAttribute("status", tc.getStatus());
        }
        if (tc.getSyntax().hasRanges()) {
            en = tc.getSyntax().getRangesVector().elements();
            while (en.hasMoreElements()) {
                MIBRange r2 = en.nextElement();
                DOMElement range = new DOMElement("range");
                range.addAttribute("min", r2.getLower().toString());
                range.addAttribute("max", r2.getUpper().toString());
                typedef.add(range);
            }
        }
        if (tc.getSyntax().hasEnums()) {
            en = tc.getSyntax().getEnumsVector().elements();
            while (en.hasMoreElements()) {
                MIBEnum e2 = (MIBEnum)en.nextElement();
                DOMElement enumeration = new DOMElement("namednumber");
                enumeration.addAttribute("name", e2.getLabel());
                enumeration.addAttribute("number", e2.getValue());
                typedef.add(enumeration);
            }
        }
        if (tc.hasDisplayHint()) {
            DOMElement format = new DOMElement("format");
            format.setText(MIBObject.getUnquotedString(tc.getDisplayHint()));
            typedef.add(format);
        }
        if (tc.hasDescription()) {
            typedef.add(this._$26711(tc.getDescription()));
        }
        if (tc.hasReference()) {
            typedef.add(this._$26713(tc.getReference()));
        }
        return typedef;
    }

    private DOMElement _$26722(MIBSyntax s) {
        DOMElement syntax = new DOMElement("syntax");
        if (!s.hasEnums() && !s.hasRanges()) {
            DOMElement type = new DOMElement("type");
            type.addAttribute("name", s.getSyntax());
            type.addAttribute("module", this._$12743(s.getSyntax()));
            syntax.add(type);
        } else {
            Enumeration<Serializable> en;
            DOMElement typedef = new DOMElement("typedef");
            typedef.addAttribute("basetype", s.getSyntax());
            if (s.hasRanges()) {
                en = s.getRangesVector().elements();
                while (en.hasMoreElements()) {
                    MIBRange r2 = (MIBRange)en.nextElement();
                    DOMElement range = new DOMElement("range");
                    range.addAttribute("min", r2.getLower().toString());
                    range.addAttribute("max", r2.getUpper().toString());
                    typedef.add(range);
                }
            }
            if (s.hasEnums()) {
                en = s.getEnumsVector().elements();
                while (en.hasMoreElements()) {
                    MIBEnum e2 = (MIBEnum)en.nextElement();
                    DOMElement enumeration = new DOMElement("namednumber");
                    enumeration.addAttribute("name", e2.getLabel());
                    enumeration.addAttribute("number", e2.getValue());
                    typedef.add(enumeration);
                }
            }
            syntax.add(typedef);
        }
        return syntax;
    }

    public void output(OutputStream os, Document doc, int indent) {
        try {
            OutputFormat outputFormat = new OutputFormat();
            outputFormat.setIndent(true);
            outputFormat.setIndentSize(indent);
            outputFormat.setNewlines(true);
            XMLWriter xmlWriter = new XMLWriter(os, outputFormat);
            xmlWriter.write(doc);
            xmlWriter.flush();
            xmlWriter.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private DOMElement _$26729(Vector tcs) {
        DOMElement typedefs = new DOMElement("typedefs");
        tcs = new Vector(tcs);
        for (int i2 = 0; i2 < tcs.size(); ++i2) {
            typedefs.add(this._$26717((MIBTextualConvention)tcs.elementAt(i2)));
        }
        return typedefs;
    }

    private DOMElement _$26732(Vector i2) {
        DOMElement imports = new DOMElement("imports");
        Enumeration en = i2.elements();
        while (en.hasMoreElements()) {
            MIBImport ii = (MIBImport)en.nextElement();
            for (int j2 = 0; j2 < ii.getImports().length; ++j2) {
                DOMElement imp = new DOMElement("import");
                imp.addAttribute("module", ii.getSource());
                imp.addAttribute("name", ii.getImportsVector().elementAt(j2));
                imports.add(imp);
            }
        }
        return imports;
    }

    private DOMElement _$26734(MIBObjectType ot, String t) {
        DOMElement scalar = new DOMElement(t);
        scalar.addAttribute("name", ot.getName());
        scalar.addAttribute("oid", ot.getPrintableOid());
        scalar.addAttribute("status", ot.getStatus());
        MIBTextualConvention tc = null;
        if (ot.getSyntax().getType() == 3 || ot.getSyntax().hasEnums() || ot.getSyntax().hasRanges()) {
            tc = this._$12267.getEffectiveSyntax(ot.getSyntax());
        }
        scalar.add(this._$26722(ot.getSyntax()));
        DOMElement access = new DOMElement("access");
        access.setText(this._$26736(ot.getAccess()));
        scalar.add(access);
        if (ot.hasDefaultValue()) {
            DOMElement defaultValue = new DOMElement("default");
            defaultValue.add(new DOMCDATA(ot.getDefaultValue()));
            scalar.add(defaultValue);
        }
        if (tc != null && tc.hasDisplayHint()) {
            DOMElement format = new DOMElement("format");
            format.add(new DOMCDATA(MIBObject.getUnquotedString(tc.getDisplayHint())));
            scalar.add(format);
        }
        if (ot.hasUnits()) {
            DOMElement units = new DOMElement("units");
            units.add(new DOMCDATA(MIBObject.getUnquotedString(ot.getUnits())));
            scalar.add(units);
        }
        scalar.add(this._$26711(ot.getDescription()));
        if (ot.hasReference()) {
            scalar.add(this._$26713(ot.getReference()));
        }
        return scalar;
    }

    private DOMElement _$26737(MIBIndexPart index, MIBObjectType ot) {
        DOMElement linkage = new DOMElement("linkage");
        linkage.addAttribute("implied", "" + index.isImplied());
        if (index.isAugment()) {
            DOMElement augments = new DOMElement("augments");
            MIBObject o2 = this._$12267.getObject(index.getIndexPart()[0]);
            if (o2 != null) {
                String m2 = this._$12267.getModuleName(o2.getModuleID());
                if (m2 != null) {
                    augments.addAttribute("module", m2);
                } else {
                    augments.addAttribute("module", "");
                }
            } else {
                augments.addAttribute("module", "");
            }
            augments.addAttribute("name", index.getIndexPart()[0]);
            linkage.add(augments);
        } else {
            Vector<? extends MIBObjectType> v = this._$12267.getColumnarObjectsOfTable(ot, true, false);
            for (int i2 = 0; i2 < v.size(); ++i2) {
                DOMElement ind = new DOMElement("index");
                MIBObjectType o3 = v.elementAt(i2);
                String m3 = this._$12267.getModuleName(o3.getModuleID());
                if (m3 != null) {
                    ind.addAttribute("module", m3);
                } else {
                    ind.addAttribute("module", "");
                }
                ind.addAttribute("name", o3.getName());
                linkage.add(ind);
            }
        }
        return linkage;
    }

    private DOMElement _$26743(MIBObjectType ot) {
        DOMElement row = new DOMElement("row");
        row.addAttribute("name", ot.getName());
        row.addAttribute("oid", ot.getPrintableOid());
        row.addAttribute("status", ot.getStatus());
        row.add(this._$26737(ot.getIndexPart(), ot));
        row.add(this._$26711(ot.getDescription()));
        if (ot.hasReference()) {
            row.add(this._$26713(ot.getReference()));
        }
        Vector<? extends MIBObjectType> cols = this._$12267.getColumnarObjectsOfTable(ot, false, true);
        boolean rowCreation = false;
        Enumeration<? extends MIBObjectType> en = cols.elements();
        while (en.hasMoreElements()) {
            MIBObjectType c2 = en.nextElement();
            row.add(this._$26734(c2, "column"));
            if (SMI.accessType(c2.getAccess()) != 3) continue;
            rowCreation = true;
        }
        if (rowCreation) {
            row.addAttribute("create", "true");
        } else {
            row.addAttribute("create", "false");
        }
        return row;
    }

    private DOMElement _$26745(Enumeration en) {
        DOMElement nodes = new DOMElement("nodes");
        while (en.hasMoreElements()) {
            MIBObject o2 = (MIBObject)en.nextElement();
            if (!o2.getClass().equals(MIBObject.class) && !(o2 instanceof MIBObjectType) && !(o2 instanceof MIBModule)) continue;
            if (o2 instanceof MIBObjectType) {
                MIBObjectType ot = (MIBObjectType)o2;
                MIBObjectType row = this._$12267.getTableEntry(o2);
                if (row != null) {
                    DOMElement table = new DOMElement("table");
                    table.addAttribute("name", ot.getName());
                    table.addAttribute("oid", ot.getPrintableOid());
                    table.addAttribute("status", ot.getStatus());
                    table.add(this._$26711(ot.getDescription()));
                    if (ot.hasReference()) {
                        table.add(this._$26713(ot.getReference()));
                    }
                    table.add(this._$26743(row));
                    nodes.add(table);
                    continue;
                }
                if (ot.isTable() || ot.isColumnarObject()) continue;
                nodes.add(this._$26734(ot, "scalar"));
                continue;
            }
            DOMElement node = new DOMElement("node");
            node.addAttribute("name", o2.getName());
            node.addAttribute("oid", o2.getPrintableOid());
            if (o2.hasDescription()) {
                node.add(this._$26711(o2.getDescription()));
            }
            if (o2.hasReference()) {
                node.add(this._$26713(o2.getReference()));
            }
            if (o2.hasStatus()) {
                node.addAttribute("status", o2.getStatus());
            }
            nodes.add(node);
        }
        return nodes;
    }

    private String _$12743(String objectName) {
        String module = "";
        try {
            String m2;
            MIBObject obj = this._$12267.getObject(objectName);
            if (obj != null && (m2 = this._$12267.getModuleName(obj.getModuleID())) != null) {
                module = m2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return module;
    }

    private DOMElement _$26748(Enumeration en) {
        DOMElement groups = new DOMElement("groups");
        while (en.hasMoreElements()) {
            MIBObject o2 = (MIBObject)en.nextElement();
            if (!(o2 instanceof MIBGroup)) continue;
            MIBGroup g2 = (MIBGroup)o2;
            DOMElement group = new DOMElement("group");
            group.addAttribute("name", o2.getName());
            group.addAttribute("oid", o2.getPrintableOid());
            group.addAttribute("status", o2.getStatus());
            DOMElement members = new DOMElement("members");
            Enumeration gen = g2.getObjectsVector().elements();
            while (gen.hasMoreElements()) {
                String name = (String)gen.nextElement();
                DOMElement member = new DOMElement("member");
                member.addAttribute("module", this._$12743(name));
                member.addAttribute("name", name);
                members.add(member);
            }
            group.add(members);
            group.add(this._$26711(o2.getDescription()));
            if (o2.hasReference()) {
                group.add(this._$26713(o2.getReference()));
            }
            groups.add(group);
        }
        return groups;
    }

    private DOMElement _$26750(MIBException variation) {
        DOMElement refinement = new DOMElement("refinement");
        refinement.addAttribute("module", this._$12743(variation.getVariation()));
        refinement.addAttribute("name", variation.getVariation());
        if (variation.hasSyntax()) {
            refinement.add(this._$26722(variation.getSyntax()));
        }
        if (variation.hasAccess()) {
            DOMElement access = new DOMElement("access");
            access.setText(this._$26736(variation.getAccess()));
            refinement.add(access);
        }
        refinement.add(this._$26711(variation.getDescription()));
        return refinement;
    }

    private DOMElement _$26752(Enumeration en) {
        DOMElement compliances = new DOMElement("compliances");
        while (en.hasMoreElements()) {
            MIBObject o2 = (MIBObject)en.nextElement();
            if (!(o2 instanceof MIBCompliance)) continue;
            MIBCompliance c2 = (MIBCompliance)o2;
            DOMElement comp = new DOMElement("compliance");
            comp.addAttribute("name", o2.getName());
            comp.addAttribute("oid", o2.getPrintableOid());
            if (o2.hasStatus()) {
                comp.addAttribute("status", o2.getStatus());
            }
            comp.add(this._$26711(o2.getDescription()));
            DOMElement requires = new DOMElement("requires");
            DOMElement refinements = new DOMElement("refinements");
            boolean refined = false;
            Enumeration<MIBComplianceModule> gen = c2.getModules().elements();
            while (gen.hasMoreElements()) {
                MIBComplianceModule cm = gen.nextElement();
                if (cm.hasMandatory()) {
                    String[] mand = cm.getMandatory();
                    for (int i2 = 0; i2 < mand.length; ++i2) {
                        DOMElement mandatory = new DOMElement("mandatory");
                        if (cm.getModuleName() == null || cm.getModuleName().trim().length() == 0) {
                            mandatory.addAttribute("module", this._$12743(mand[i2]));
                        } else {
                            mandatory.addAttribute("module", cm.getModuleName());
                        }
                        mandatory.addAttribute("name", mand[i2]);
                        requires.add(mandatory);
                    }
                }
                if (!cm.hasVariations()) continue;
                Enumeration ven = cm.getVariationsVector().elements();
                while (ven.hasMoreElements()) {
                    MIBVariation vv = (MIBVariation)ven.nextElement();
                    if (vv instanceof MIBException) {
                        refinements.add(this._$26750((MIBException)vv));
                        refined = true;
                        continue;
                    }
                    if (!(vv instanceof MIBCondGroup)) continue;
                    MIBCondGroup cg = (MIBCondGroup)vv;
                    DOMElement cond = new DOMElement("option");
                    if (cm.getModuleName() == null || cm.getModuleName().trim().length() == 0) {
                        cond.addAttribute("module", this._$12743(cg.getVariation()));
                    } else {
                        cond.addAttribute("module", cm.getModuleName());
                    }
                    cond.addAttribute("name", cg.getVariation());
                    cond.add(this._$26711(cg.getDescription()));
                    requires.add(cond);
                }
            }
            comp.add(requires);
            if (refined) {
                comp.add(refinements);
            }
            if (o2.hasReference()) {
                comp.add(this._$26713(o2.getReference()));
            }
            compliances.add(comp);
        }
        return compliances;
    }

    private List _$26710(MIBModule m2) {
        Vector<MIBTextualConvention> tcs;
        Vector<DOMElement> v = new Vector<DOMElement>(1);
        DOMElement module = new DOMElement("module");
        module.addAttribute("name", m2.getModuleName());
        module.addAttribute("language", "SMIv" + m2.getSMIVersion());
        if (m2.getSMIVersion() > 1) {
            DOMElement organization = new DOMElement("organization");
            organization.add(new DOMCDATA(MIBObject.getUnquotedString(m2.getOrganization())));
            module.add(organization);
            DOMElement contact = new DOMElement("contact");
            contact.add(new DOMCDATA(MIBObject.getUnquotedString(m2.getContactInfo())));
            module.add(contact);
            module.add(this._$26711(m2.getDescription()));
            if (m2.hasReference()) {
                module.add(this._$26713(m2.getReference()));
            }
            if (m2.hasRevisions()) {
                Enumeration en = m2.getRevisionsVector().elements();
                while (en.hasMoreElements()) {
                    module.add(this._$26714((MIBRevision)en.nextElement()));
                }
            }
            DOMElement identity = new DOMElement("identity");
            identity.addAttribute("node", m2.getName());
            module.add(identity);
        }
        v.add(module);
        if (m2.hasImports()) {
            v.add(this._$26732(m2.getImportsVector()));
        }
        if ((tcs = m2.getTextualConventions()).size() > 0) {
            v.add(this._$26729(tcs));
        }
        v.add(this._$26745(m2.objectsByOid().elements()));
        v.add(this._$26748(m2.objectsByOid().elements()));
        v.add(this._$26752(m2.objectsByOid().elements()));
        return v;
    }

    private String _$26736(String access) {
        switch (SMI.accessType(access)) {
            case 5: {
                return "notifyonly";
            }
            case 0: {
                return "noaccess";
            }
            case 6: {
                return "notimplemented";
            }
            case 2: 
            case 3: {
                return "readwrite";
            }
            case 1: {
                return "readonly";
            }
            case 4: {
                return "writeonly";
            }
        }
        return "unknown";
    }
}

