/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.util;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ChangeModuleID {
    private static final int COMPRESSION_FLAG = -1;
    private static final int COMPRESSION_MODE_GZIP = 1;

    private static MIBModule readModule(File f2) throws IOException, ClassNotFoundException {
        FileInputStream file = new FileInputStream(f2);
        ObjectInputStream input = new ObjectInputStream(file);
        int sz = input.readInt();
        MIBModule m2 = null;
        if (sz == -1) {
            GZIPInputStream zis = new GZIPInputStream(input);
            ObjectInputStream zois = new ObjectInputStream(zis);
            sz = zois.readInt();
            m2 = ChangeModuleID.readObjects(zois, sz);
        } else {
            m2 = ChangeModuleID.readObjects(input, sz);
        }
        try {
            input.close();
            file.close();
        }
        catch (IOException iox) {
            // empty catch block
        }
        return m2;
    }

    private static MIBModule readObjects(ObjectInputStream input, int sz) throws ClassNotFoundException, IOException {
        MIBModule m2 = (MIBModule)input.readObject();
        m2.reinit();
        for (int i2 = 0; i2 < sz - 1; ++i2) {
            MIBObject obj = (MIBObject)input.readObject();
            m2.add(obj);
        }
        return m2;
    }

    protected static void saveModule(MIBModule m2, File f2, boolean useCompression) throws IOException {
        FileOutputStream file = new FileOutputStream(f2);
        ObjectOutputStream output = new ObjectOutputStream(file);
        if (useCompression) {
            output.writeInt(-1);
            GZIPOutputStream zos = new GZIPOutputStream(output);
            ObjectOutputStream zoos = new ObjectOutputStream(zos);
            ChangeModuleID.writeObjects(m2, zoos);
            zoos.flush();
            zoos.close();
        } else {
            ChangeModuleID.writeObjects(m2, output);
        }
        output.flush();
        output.close();
    }

    private static void writeObjects(MIBModule m2, ObjectOutputStream output) throws IOException {
        int size = m2.size();
        if (m2.objectsByName().get(m2.getName()) == null) {
            ++size;
        }
        output.writeInt(size);
        output.writeObject(m2);
        Enumeration objects = m2.objects();
        while (objects.hasMoreElements()) {
            MIBObject o2 = (MIBObject)objects.nextElement();
            if (o2 instanceof MIBModule) continue;
            try {
                output.writeObject(o2);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: ChangeModuleID [-i <ModuleDir>] [-n <Compiled-MIB-File> <New-Module-ID> [<New-MIB-File>]]");
        }
        if ("-i".equals(args[0])) {
            File[] files = new File(args[1]).listFiles();
            for (int i2 = 0; i2 < files.length; ++i2) {
                try {
                    MIBModule m2 = ChangeModuleID.readModule(files[i2]);
                    Integer newModuleID = new Integer(-m2.getModuleID().intValue());
                    System.out.println("Converting " + m2.getModuleName() + " from " + m2.getModuleID() + " to " + newModuleID);
                    Iterator<MIBObject> it = m2.objectsIterator();
                    while (it.hasNext()) {
                        MIBObject o2 = it.next();
                        o2.setModuleID(newModuleID);
                        System.out.println(o2.getName() + "=" + o2.getOid() + "|" + o2.getClass() + "#" + newModuleID);
                    }
                    m2.setModuleID(newModuleID);
                    ChangeModuleID.saveModule(m2, files[i2], true);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            System.out.println("Converted " + files.length + " files.");
        } else if ("-n".equals(args[0])) {
            Integer newModuleID = new Integer(args[2]);
            try {
                MIBModule m3 = ChangeModuleID.readModule(new File(args[1]));
                Iterator<MIBObject> it = m3.objectsIterator();
                while (it.hasNext()) {
                    MIBObject o3 = it.next();
                    o3.setModuleID(newModuleID);
                }
                m3.setModuleID(newModuleID);
                String newFile = args.length > 2 ? args[3] : args[1];
                ChangeModuleID.saveModule(m3, new File(newFile), true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

