/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.pdf;

import com.agentpp.common.font.FontStyle;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectOrderComparator;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBRevision;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.pib.PIBComplianceObject;
import com.agentpp.mib.pib.PIBIndexPart;
import com.agentpp.mib.pib.PIBModule;
import com.agentpp.mib.pib.PIBObjectType;
import com.agentpp.smi.IEnum;
import com.agentpp.smiparser.SMI;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBModule2PDF {
    private static final String _$26839 = "Comments";
    private static final String _$26840 = "Keywords";
    private static final String _$26841 = "Identifier";
    private static final String _$26842 = "Values";
    private static final String _$26843 = "Types";
    private static final String _$26844 = "Clauses";
    private static final String _$26845 = "Text";
    private static final int _$26846 = 160;
    private static final int _$26847 = 160;
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final SimpleDateFormat _$26849 = new SimpleDateFormat("yyyy-MM-dd");
    private MIBRepository _$12267;
    private Vector _$17615;
    private int _$14899 = 8;
    private int _$26850 = 2;
    private int _$295 = 160;
    private float _$26851 = 11.0f;
    private float _$26852 = 10.0f;
    private String _$15323 = "";
    private Rectangle _$23980;
    private Date _$26853;
    private Font _$24096 = FontFactory.getFont((String)"Courier", (float)this._$26852, (int)0);
    private Hashtable _$26856 = new Hashtable();
    private boolean _$26857;
    private boolean _$26858;
    private boolean _$26859 = true;
    private boolean _$26860 = true;
    private Vector _$26861 = new Vector();
    private int _$26862 = 0;
    private boolean _$26863;

    public MIBModule2PDF(MIBRepository rep, Vector fontStyles, int tabSize) {
        this._$12267 = rep;
        this._$17615 = fontStyles;
        this._$14899 = tabSize;
        this._$26864(fontStyles);
    }

    public void setFontSize(float fontSize) {
        this._$24096.setSize(fontSize);
    }

    private void _$26864(Vector fontStyles) {
        for (int i2 = 0; i2 < fontStyles.size(); ++i2) {
            FontStyle style = (FontStyle)fontStyles.elementAt(i2);
            int s = 0;
            if (style.isBold() && style.isItalic()) {
                s = 3;
            } else if (style.isBold()) {
                s = 1;
            } else if (style.isItalic()) {
                s = 2;
            }
            Font f2 = FontFactory.getFont((String)this._$24096.getFamilyname(), (float)this._$24096.getSize(), (int)s, (Color)style.getColor());
            this._$26856.put(style.getName(), f2);
        }
    }

    private String _$25446(int num) {
        StringBuffer buf = new StringBuffer(num);
        for (int i2 = 0; i2 < num * this._$14899; ++i2) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public void writePDF(MIBModule m2, OutputStream os, String creator, Rectangle pageSize) throws DocumentException {
        if (pageSize == null) {
            pageSize = PageSize.A4;
        }
        this._$26853 = new Date();
        this._$26850 = m2.getSMIVersion();
        this._$15323 = m2.getModuleName();
        this._$23980 = pageSize;
        Document doc = new Document(pageSize);
        PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)os);
        doc.addAuthor(System.getProperty("user.name"));
        doc.addKeywords(m2.getModuleName() + ", " + (m2.getSMIVersion() == 1 ? "SMIv1" : "SMIv2") + ", " + "MIB specification");
        doc.addTitle(m2.getModuleName());
        doc.addCreator(creator);
        this._$26876(m2);
        MyPageEvents events = new MyPageEvents();
        writer.setPageEvent((PdfPageEvent)events);
        doc.open();
        if (m2.hasCopyrightComment()) {
            this._$26861.add(null);
            doc.add((Element)new Paragraph(this._$26851, m2.getCopyrightComment(), (Font)this._$26856.get(_$26839)));
        }
        doc.add((Element)this._$26881("\n"));
        this._$26882(doc, m2);
        if (m2.hasCopyrightCommentEnd()) {
            this._$26861.add(null);
            doc.add((Element)new Paragraph(this._$26851, m2.getCopyrightCommentEnd(), (Font)this._$26856.get(_$26839)));
        }
        try {
            doc.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void _$26876(MIBModule m2) {
        this._$26861 = new Vector(m2.size() + 1);
        this._$26862 = 0;
    }

    private Chunk _$26883(String keyword) {
        return new Chunk(keyword, (Font)this._$26856.get(_$26840));
    }

    private Chunk _$26881(String text) {
        return new Chunk(text, this._$24096);
    }

    private Chunk _$15513(String text) {
        return new Chunk(text, (Font)this._$26856.get(_$26839));
    }

    private Chunk _$317(String text) {
        return new Chunk(text, (Font)this._$26856.get(_$26845));
    }

    private Phrase _$317(int ident, String lines) {
        String prefix = this._$25446(ident);
        if (lines == null) {
            return new Phrase(prefix + "\"\"", (Font)this._$26856.get(_$26845));
        }
        StringTokenizer st = new StringTokenizer(lines, "\n\r", true);
        Phrase p2 = new Phrase();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("\n")) {
                p2.add((Object)this._$317(s));
                continue;
            }
            if (s.equals("\r")) continue;
            p2.add((Object)this._$317(prefix + s));
        }
        return p2;
    }

    private Chunk _$26888(String text) {
        return new Chunk(text, (Font)this._$26856.get(_$26844));
    }

    private Chunk _$8639(String text) {
        return new Chunk(text, (Font)this._$26856.get(_$26843));
    }

    private Chunk _$63(String value) {
        return new Chunk(value, (Font)this._$26856.get(_$26842));
    }

    private Chunk _$19460(String value) {
        return new Chunk(value, (Font)this._$26856.get(_$26841));
    }

    private Chunk _$26889(String objectName) {
        Chunk chunk = new Chunk(objectName, (Font)this._$26856.get(_$26841));
        chunk.setLocalGoto(objectName);
        return chunk;
    }

    private void _$26892(Paragraph doc, MIBRange range) {
        if (range.getLower().equals(range.getUpper())) {
            doc.add((Object)this._$63(range.getUpper().toString()));
        } else {
            doc.add((Object)this._$63(range.getLower().toString()));
            doc.add((Object)this._$26881(".."));
            doc.add((Object)this._$63(range.getUpper().toString()));
        }
    }

    private void _$26893(Paragraph doc, IEnum enumeration) {
        doc.add((Object)this._$19460(enumeration.getLabel()));
        doc.add((Object)this._$26881("("));
        doc.add((Object)this._$63(enumeration.getValue()));
        doc.add((Object)this._$26881(")"));
    }

    private void _$23759(Paragraph doc, MIBSyntax syn) {
        switch (syn.getType()) {
            case 2: {
                doc.add((Object)this._$26883("SEQUENCE OF "));
                doc.add((Object)this._$63(syn.getSyntax()));
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                if (this._$12267.getObject(syn.getSyntax()) != null) {
                    doc.add((Object)this._$26889(syn.getSyntax()));
                } else {
                    doc.add((Object)this._$8639(syn.getSyntax()));
                }
                if (!syn.hasRanges()) break;
                MIBTextualConvention effective = this._$12267.getEffectiveSyntax(syn);
                MIBSyntax base = effective.getSyntax();
                if (base.getSyntax().equals(SMI.SMI_SYNTAX[1]) || base.getSyntax().equals(SMI.SMI_SYNTAX[10]) || base.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    doc.add((Object)this._$26881(" ("));
                    doc.add((Object)this._$26883("SIZE"));
                }
                doc.add((Object)this._$26881(" ("));
                Enumeration<MIBRange> en = syn.getRangesVector().elements();
                while (en.hasMoreElements()) {
                    this._$26892(doc, en.nextElement());
                    if (!en.hasMoreElements()) continue;
                    doc.add((Object)this._$26881(" | "));
                }
                doc.add((Object)this._$26881(")"));
                if (!base.getSyntax().equals(SMI.SMI_SYNTAX[1]) && !base.getSyntax().equals(SMI.SMI_SYNTAX[12])) break;
                doc.add((Object)this._$26881(")"));
            }
        }
        if (syn.hasEnums()) {
            this._$26896(doc, syn.getEnumsVector());
        }
    }

    private void _$26896(Paragraph doc, List<MIBEnum> enums) {
        doc.add((Object)this._$26881(" {\n" + this._$25446(3)));
        int max = MIBObject.getMaxLength(enums.iterator());
        Iterator<MIBEnum> en = enums.iterator();
        while (en.hasNext()) {
            MIBEnum enumeration = en.next();
            this._$26893(doc, enumeration);
            if (enumeration.hasComment()) {
                if (en.hasNext()) {
                    doc.add((Object)this._$26881(","));
                } else {
                    doc.add((Object)this._$26881(" "));
                }
                String space = MIBObject.space(max - enumeration.toString().length() + 1);
                doc.add((Object)this._$26881(space));
                String lines = enumeration.getComment();
                String first = enumeration.getComment();
                int suffix = lines.indexOf(10);
                if (suffix < 0) {
                    lines = null;
                } else {
                    first = lines.substring(0, suffix);
                    lines = lines.substring(suffix);
                }
                doc.add((Object)this._$15513(this._$25446(1) + first));
                if (lines != null) {
                    StringTokenizer st = new StringTokenizer(lines, "\n");
                    while (st.hasMoreTokens()) {
                        doc.add((Object)this._$26881("\n" + this._$25446(4) + MIBObject.space(max)));
                        doc.add((Object)this._$15513(st.nextToken()));
                    }
                }
                doc.add((Object)this._$26881("\n" + this._$25446(3)));
                continue;
            }
            if (en.hasNext()) {
                doc.add((Object)this._$26881(",\n" + this._$25446(3)));
                continue;
            }
            doc.add((Object)this._$26881(" "));
        }
        doc.add((Object)this._$26881("}"));
    }

    private void _$26898(Paragraph doc, MIBObject o2) {
        doc.add((Object)this._$26881(this._$25446(1)));
        doc.add((Object)this._$26888("STATUS      "));
        if (!o2.hasStatus()) {
            doc.add((Object)this._$26881("current"));
        } else {
            doc.add((Object)this._$26881(o2.getStatus()));
        }
        doc.add((Object)this._$26881("\n" + this._$25446(1)));
        doc.add((Object)this._$26888("DESCRIPTION"));
        if (!o2.hasDescription()) {
            doc.add((Object)this._$317(" \"\"\n"));
        } else {
            doc.add((Object)this._$26881("\n"));
            doc.add((Object)this._$317(2, o2.getDescription()));
            doc.add((Object)this._$26881("\n"));
        }
        if (o2 instanceof PIBObjectType) {
            doc.add((Object)this._$26881(this._$25446(1)));
            doc.add((Object)this._$26888("INSTALL-ERRORS"));
            this._$26896(doc, ((PIBObjectType)o2).getInstallErrors());
            doc.add((Object)this._$26881("\n"));
        }
        if (o2.hasReference()) {
            doc.add((Object)this._$26881(this._$25446(1)));
            doc.add((Object)this._$26888("REFERENCE"));
            doc.add((Object)this._$317(2, o2.getReference()));
            doc.add((Object)this._$26881("\n"));
        }
    }

    private void _$26900(Paragraph doc, ObjectID oid, MIBObject parent, String qualified) {
        try {
            int diff = oid.size();
            doc.add((Object)this._$26881("{ "));
            if (parent != null) {
                diff = oid.size() - parent.getOid().size();
                if (qualified != null) {
                    doc.add((Object)this._$26889(qualified + "." + parent.getName()));
                } else {
                    doc.add((Object)this._$26889(parent.getName()));
                }
            }
            doc.add((Object)this._$26881(" "));
            for (int i2 = oid.size() - diff; i2 < oid.size(); ++i2) {
                String oname = null;
                if (i2 + 1 < oid.size()) {
                    this._$12267.getObjectName(oid.getPrefix(i2 + 1));
                }
                if (oname != null) {
                    doc.add((Object)this._$19460(oname));
                    doc.add((Object)this._$26881("("));
                    doc.add((Object)this._$63(oid.getSubID(i2)));
                    doc.add((Object)this._$26881(")"));
                } else {
                    doc.add((Object)this._$63(oid.getSubID(i2)));
                }
                doc.add((Object)this._$26881(" "));
            }
            doc.add((Object)this._$26881("}"));
        }
        catch (ObjectIDFormatException ex) {
            doc.add((Object)this._$26881("{ " + oid.toString() + " }"));
        }
    }

    private void _$26904(Paragraph doc, MIBObject o2, MIBObject parent) {
        MIBObject[] parents = this._$12267.getObjectsByName(parent.getName());
        if (parents == null || parents.length <= 1) {
            this._$26900(doc, o2.getOid(), parent, null);
        } else {
            String m2 = this._$12267.getModuleName(parent.getModuleID());
            if (m2 == null) {
                this._$26900(doc, o2.getOid(), parent, null);
            } else {
                this._$26900(doc, o2.getOid(), parent, m2);
            }
        }
    }

    private void _$26906(Paragraph doc, MIBObject o2) {
        if ((this._$295 & 0x20) > 0) {
            if ((this._$295 & 0x400) > 0) {
                doc.add((Object)this._$15513(" -- " + o2.getPrintableOid() + " --  "));
            } else {
                doc.add((Object)this._$26881(this._$25446(1)));
                doc.add((Object)this._$15513("-- " + o2.getPrintableOid()));
                doc.add((Object)this._$26881("\n"));
                doc.add((Object)this._$26881(this._$25446(1)));
            }
        } else {
            doc.add((Object)this._$26881(this._$25446(1)));
        }
        doc.add((Object)this._$26883("::= "));
        MIBObject parent = this._$12267.getParent(o2);
        if (parent == null) {
            doc.add((Object)this._$26881(o2.getOid().toSMI()));
        } else if (o2 instanceof MIBModule && parent.getModuleID() == o2.getModuleID()) {
            while (parent != null && parent.getModuleID() == o2.getModuleID()) {
                parent = this._$12267.getParent(parent);
            }
            if (parent == null) {
                this._$26900(doc, o2.getOid(), parent, null);
            } else {
                this._$26904(doc, o2, parent);
            }
        } else {
            this._$26904(doc, o2, parent);
        }
    }

    private void _$26907(Paragraph doc, MIBIndexPart index) {
        if (index.getType() == 1) {
            if (index instanceof PIBIndexPart) {
                doc.add((Object)this._$26888("PIB-INDEX "));
            } else {
                doc.add((Object)this._$26888("INDEX "));
            }
        } else if (index.getType() == 3) {
            doc.add((Object)this._$26888("EXTENDS "));
        } else {
            doc.add((Object)this._$26888("AUGMENTS "));
        }
        doc.add((Object)this._$26881("{\n"));
        Vector v = index.getIndexPartVector();
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            String element = (String)en.nextElement();
            doc.add((Object)this._$26881(this._$25446(2)));
            if (index.isImplied() && !en.hasMoreElements()) {
                doc.add((Object)this._$26883("IMPLIED "));
            }
            doc.add((Object)this._$26889(element));
            if (en.hasMoreElements()) {
                doc.add((Object)this._$26881(",\n"));
                continue;
            }
            doc.add((Object)this._$26881("\n"));
        }
        doc.add((Object)this._$26881(this._$25446(1) + "}\n"));
    }

    private void _$26909(Document doc, MIBObject o2) throws DocumentException {
        Paragraph para = this._$26911(doc, o2);
        if (o2.getType() == 0 && o2.hasStatus()) {
            para.add((Object)this._$26883(" OBJECT-IDENTITY\n"));
            this._$26898(para, o2);
        } else {
            para.add((Object)this._$26883(" OBJECT IDENTIFIER"));
        }
        para.add((Object)this._$26881("\n"));
        this._$26906(para, o2);
        doc.add((Element)para);
    }

    private void _$26912(Document doc, MIBObjectType ot) throws DocumentException {
        Paragraph p2 = this._$26911(doc, ot);
        p2.add((Object)this._$26883(" OBJECT-TYPE"));
        p2.add((Object)this._$26881("\n" + this._$25446(1)));
        p2.add((Object)this._$26888("SYNTAX      "));
        this._$23759(p2, ot.getSyntax());
        p2.add((Object)this._$26881("\n"));
        if (ot.hasUnits()) {
            p2.add((Object)this._$26881(this._$25446(1)));
            p2.add((Object)this._$26888("UNITS       "));
            if (ot.getUnits().indexOf(10) > 0) {
                p2.add((Object)this._$26881("\n"));
                p2.add((Object)this._$317(2, ot.getUnits()));
            } else {
                p2.add((Object)this._$317(ot.getUnits()));
            }
            p2.add((Object)this._$26881("\n"));
        }
        p2.add((Object)this._$26881(this._$25446(1)));
        if (ot.getAccess() != null) {
            if (this._$26850 == 1) {
                p2.add((Object)this._$26888("ACCESS      "));
            } else {
                p2.add((Object)this._$26888("MAX-ACCESS  "));
            }
            p2.add((Object)this._$26881(ot.getAccess()));
            p2.add((Object)this._$26881("\n"));
        }
        this._$26898(p2, ot);
        if (ot.hasIndexPart()) {
            p2.add((Object)this._$26881(this._$25446(1)));
            this._$26907(p2, ot.getIndexPart());
        }
        if (ot instanceof PIBObjectType) {
            p2.add((Object)this._$26881(this._$25446(1)));
            this._$26907(p2, ((PIBObjectType)ot).getMibIndexPart());
            if (((PIBObjectType)ot).getUniqueObjects() != null) {
                p2.add((Object)this._$26881(this._$25446(1)));
                p2.add((Object)this._$26888("UNIQUENESS  "));
                p2.add((Object)"{\n");
                Iterator<String> it = ((PIBObjectType)ot).getUniqueObjects().iterator();
                while (it.hasNext()) {
                    String element = it.next();
                    doc.add((Element)this._$26881(this._$25446(2)));
                    doc.add((Element)this._$26889(element));
                    if (it.hasNext()) {
                        doc.add((Element)this._$26881(",\n"));
                        continue;
                    }
                    doc.add((Element)this._$26881("\n"));
                }
                doc.add((Element)this._$26881(this._$25446(1) + "}\n"));
            }
        }
        if (ot.hasDefaultValue()) {
            p2.add((Object)this._$26881(this._$25446(1)));
            p2.add((Object)this._$26888("DEFVAL      "));
            p2.add((Object)this._$26881("{ "));
            p2.add((Object)this._$63(ot.getDefaultValue()));
            p2.add((Object)this._$26881(" }\n"));
        }
        this._$26906(p2, ot);
        if (this._$12267 != null && ot.isTable()) {
            p2.add((Object)this._$26881("\n\n"));
            p2.add((Object)this._$19460(ot.getSyntax().getSyntax()));
            p2.add((Object)this._$26881(" ::= "));
            p2.add((Object)this._$26883("SEQUENCE"));
            p2.add((Object)this._$26881(" {\n"));
            int max = MIBObject.getMaxLength(ot.getTableEntriesVector().iterator());
            if (ot.getTableEntriesVector().size() == 0) {
                p2.add((Object)this._$26881(this._$25446(1) + "}\n"));
            }
            Enumeration en = ot.getTableEntriesVector().elements();
            while (en.hasMoreElements()) {
                String s = (String)en.nextElement();
                p2.add((Object)this._$26881(this._$25446(2)));
                p2.add((Object)this._$26889(s));
                p2.add((Object)this._$26881(MIBObject.space(max - s.length() + 1)));
                MIBObjectType o2 = (MIBObjectType)this._$12267.getObject(s);
                if (o2 == null) continue;
                p2.add((Object)this._$19460(o2.getSyntax().getSyntax()));
                if (en.hasMoreElements()) {
                    p2.add((Object)this._$26881(",\n"));
                    continue;
                }
                p2.add((Object)this._$26881("\n" + this._$25446(1) + "}\n"));
            }
            p2.add((Object)this._$26881("\n"));
        }
        doc.add((Element)p2);
    }

    private Paragraph _$26911(Document doc, MIBObject o2) throws DocumentException {
        if (o2.hasComment()) {
            this._$26861.add(null);
            doc.add((Element)new Paragraph(this._$26851, this._$15513(o2.getComment())));
        }
        Chunk chunk = new Chunk(o2.getName(), (Font)this._$26856.get(_$26841));
        chunk.setLocalDestination(o2.getName());
        this._$26861.add(o2);
        Paragraph para = new Paragraph(this._$26851, "\n");
        para.add((Object)chunk);
        para.setKeepTogether(this._$26857);
        return para;
    }

    private Phrase _$26917(int indent, Enumeration en, boolean link) {
        Phrase doc = new Phrase();
        while (en.hasMoreElements()) {
            String element = (String)en.nextElement();
            doc.add((Object)this._$26881(this._$25446(indent)));
            if (link) {
                doc.add((Object)this._$26889(element));
            } else {
                doc.add((Object)this._$19460(element));
            }
            if (en.hasMoreElements()) {
                doc.add((Object)this._$26881(",\n"));
                continue;
            }
            doc.add((Object)this._$26881("\n"));
        }
        return doc;
    }

    private void _$26919(Document doc, MIBNotifyType o2) throws DocumentException {
        Paragraph p2 = this._$26911(doc, o2);
        if (o2.isV1Trap()) {
            p2.add((Object)this._$26883(" TRAP-TYPE"));
            p2.add((Object)this._$26881("\n" + this._$25446(1)));
            p2.add((Object)this._$26888("ENTERPRISE "));
            p2.add((Object)this._$26881(o2.getEnterprise() + "\n"));
            if (o2.hasVariables()) {
                p2.add((Object)this._$26881(this._$25446(1)));
                p2.add((Object)this._$26888("VARIABLES"));
                p2.add((Object)this._$26881(" {\n"));
                p2.add((Object)this._$26917(2, o2.getVariablesVector().elements(), true));
                p2.add((Object)this._$26881(this._$25446(1) + "}\n"));
            }
            if (o2.hasDescription()) {
                p2.add((Object)this._$26881("\n" + this._$25446(1)));
                p2.add((Object)this._$26888("DESCRIPTION "));
                p2.add((Object)this._$26881("\n"));
                if (!o2.hasDescription()) {
                    p2.add((Object)this._$317(" \"\"\n"));
                } else {
                    p2.add((Object)this._$26881("\n"));
                    p2.add((Object)this._$317(2, o2.getDescription()));
                    p2.add((Object)this._$26881("\n"));
                }
            }
        } else {
            p2.add((Object)this._$26888(" NOTIFICATION-TYPE"));
            p2.add((Object)this._$26881("\n"));
            if (o2.hasVariables()) {
                p2.add((Object)this._$26881(this._$25446(1)));
                p2.add((Object)this._$26888("OBJECTS"));
                p2.add((Object)this._$26881(" {\n"));
                p2.add((Object)this._$26917(2, o2.getVariablesVector().elements(), true));
                p2.add((Object)this._$26881(this._$25446(1) + "}\n"));
            }
            this._$26898(p2, o2);
        }
        if (o2.isV1Trap()) {
            try {
                p2.add((Object)this._$26881(" ::= "));
                p2.add((Object)this._$63("" + o2.getOid().getLastSubID()));
                p2.add((Object)this._$26881("\n"));
            }
            catch (ObjectIDFormatException oex) {}
        } else {
            this._$26906(p2, o2);
        }
        doc.add((Element)p2);
    }

    private void _$26925(Document doc, MIBGroup o2) throws DocumentException {
        Paragraph p2 = this._$26911(doc, o2);
        p2.add((Object)this._$26883(" " + SMI.ENTRY_TYPES[o2.getType()]));
        p2.add((Object)this._$26881("\n"));
        if (o2.getType() == 7) {
            p2.add((Object)this._$26881(this._$25446(1)));
            p2.add((Object)this._$26888("NOTIFICATIONS"));
            p2.add((Object)this._$26881(" {\n"));
        } else {
            p2.add((Object)this._$26881(this._$25446(1)));
            p2.add((Object)this._$26888("OBJECTS"));
            p2.add((Object)this._$26881(" {\n"));
        }
        p2.add((Object)this._$26917(2, o2.getObjectsVector().elements(), true));
        p2.add((Object)this._$26881(this._$25446(1) + "}\n"));
        this._$26898(p2, o2);
        this._$26906(p2, o2);
        doc.add((Element)p2);
    }

    private void _$26926(Paragraph p2, MIBVariation o2) {
        p2.add((Object)this._$26881(this._$25446(1)));
        if (o2 instanceof MIBException) {
            p2.add((Object)this._$26888("OBJECT         "));
        } else {
            p2.add((Object)this._$26888("VARIATION      "));
        }
        p2.add((Object)this._$26881(o2.getVariation()));
        if (o2.hasSyntax()) {
            p2.add((Object)this._$26881("\n" + this._$25446(1) + "  "));
            p2.add((Object)this._$26888("SYNTAX       "));
            this._$23759(p2, o2.getSyntax());
        }
        if (o2.hasWriteSyntax()) {
            p2.add((Object)this._$26881("\n" + this._$25446(1) + "  "));
            p2.add((Object)this._$26888("WRITE-SYNTAX "));
            this._$23759(p2, o2.getWriteSyntax());
        }
        if (o2.hasAccess()) {
            p2.add((Object)this._$26881("\n" + this._$25446(1) + "  "));
            if (o2 instanceof MIBException) {
                if (o2 instanceof PIBComplianceObject) {
                    p2.add((Object)this._$26888("PIB-MIN-ACCESS "));
                } else {
                    p2.add((Object)this._$26888("MIN-ACCESS   "));
                }
            } else {
                p2.add((Object)this._$26888("ACCESS       "));
            }
            p2.add((Object)this._$26881(o2.getAccess()));
        }
        if (o2.hasCreationRequires()) {
            p2.add((Object)this._$26881("\n" + this._$25446(1) + "  "));
            p2.add((Object)this._$26888("CREATION-REQUIRES"));
            p2.add((Object)this._$26881(" {\n"));
            p2.add((Object)this._$26917(3, o2.getCreationRequiresVector().elements(), false));
            p2.add((Object)this._$26881(" }"));
        }
        if (o2.hasDefaultValue()) {
            p2.add((Object)this._$26881("\n" + this._$25446(1) + "  "));
            p2.add((Object)this._$26888("DEFVAL       "));
            p2.add((Object)this._$26881(" { "));
            p2.add((Object)this._$26881(o2.getDefval()));
            p2.add((Object)this._$26881(" }"));
        }
        p2.add((Object)this._$26881("\n" + this._$25446(1) + "  "));
        p2.add((Object)this._$26888("DESCRIPTION "));
        if (o2.getDescription() != null) {
            p2.add((Object)this._$26881("\n"));
            p2.add((Object)this._$317(2, o2.getDescription()));
        } else {
            p2.add((Object)this._$317("\"\""));
        }
        p2.add((Object)this._$26881("\n"));
    }

    private void _$26927(Paragraph p2, MIBComplianceModule o2) {
        p2.add((Object)this._$26881(this._$25446(1)));
        p2.add((Object)this._$26888("MODULE "));
        if (o2.hasModuleName()) {
            p2.add((Object)this._$19460(o2.getModuleName()));
        }
        p2.add((Object)this._$26881("\n"));
        if (o2.hasMandatory()) {
            p2.add((Object)this._$26881(this._$25446(1)));
            p2.add((Object)this._$26888("MANDATORY-GROUPS"));
            p2.add((Object)this._$26881(" {\n"));
            p2.add((Object)this._$26917(3, o2.getMandatoryVector().elements(), false));
            p2.add((Object)this._$26881(this._$25446(1) + "}\n"));
        }
        if (o2.hasVariations()) {
            Enumeration en = o2.getVariationsVector().elements();
            while (en.hasMoreElements()) {
                MIBVariation v = (MIBVariation)en.nextElement();
                this._$26926(p2, v);
            }
        }
    }

    private void _$26928(Document doc, MIBCompliance o2) throws DocumentException {
        if (this._$26850 > 1) {
            Paragraph p2 = this._$26911(doc, o2);
            p2.add((Object)this._$26883(" MODULE-COMPLIANCE"));
            p2.add((Object)this._$26881("\n"));
            this._$26898(p2, o2);
            Enumeration<MIBComplianceModule> en = o2.getModules().elements();
            while (en.hasMoreElements()) {
                this._$26927(p2, en.nextElement());
            }
            this._$26906(p2, o2);
            doc.add((Element)p2);
        }
    }

    private void _$26929(Paragraph p2, MIBSupportedModule o2) {
        p2.add((Object)this._$26881("\n\n" + this._$25446(1)));
        p2.add((Object)this._$26888("SUPPORTS "));
        p2.add((Object)this._$26881(o2.getSupports()));
        p2.add((Object)this._$26881("\n" + this._$25446(1)));
        p2.add((Object)this._$26888("INCLUDES"));
        p2.add((Object)this._$26881(" {\n"));
        p2.add((Object)this._$26917(2, o2.getIncludes().elements(), false));
        p2.add((Object)this._$26881(this._$25446(1) + "}\n"));
        if (o2.hasVariations()) {
            Enumeration en = o2.getVariationsVector().elements();
            while (en.hasMoreElements()) {
                MIBVariation v = (MIBVariation)en.nextElement();
                this._$26926(p2, v);
            }
        }
    }

    private void _$26930(Document doc, MIBAgentCaps o2) throws DocumentException {
        if (this._$26850 > 1) {
            Paragraph p2 = this._$26911(doc, o2);
            p2.setKeepTogether(false);
            p2.add((Object)this._$26883(" AGENT-CAPABILITIES"));
            p2.add((Object)this._$26881("\n\n" + this._$25446(1)));
            p2.add((Object)this._$26888("PRODUCT-RELEASE"));
            p2.add((Object)this._$26881("\n"));
            p2.add((Object)this._$317(2, o2.getProductRelease()));
            p2.add((Object)this._$26881("\n"));
            this._$26898(p2, o2);
            Enumeration en = o2.getModules().elements();
            while (en.hasMoreElements()) {
                this._$26929(p2, (MIBSupportedModule)en.nextElement());
            }
            this._$26906(p2, o2);
            doc.add((Element)p2);
        }
    }

    private void _$26931(Document doc, MIBTextualConvention o2) throws DocumentException {
        Paragraph p2 = this._$26911(doc, o2);
        if (!o2.hasStatus() || SMI.statusType(o2.getStatus()) == 0) {
            p2.add((Object)this._$26881(" ::= "));
            this._$23759(p2, o2.getSyntax());
        } else {
            p2.add((Object)this._$26881(" ::= "));
            p2.add((Object)this._$26883("TEXTUAL-CONVENTION"));
            p2.add((Object)this._$26881("\n"));
            if (o2.hasDisplayHint()) {
                p2.add((Object)this._$26881(this._$25446(1)));
                p2.add((Object)this._$26888("DISPLAY-HINT "));
                p2.add((Object)this._$317(o2.getDisplayHint()));
                p2.add((Object)this._$26881("\n"));
            }
            this._$26898(p2, o2);
            p2.add((Object)this._$26881(this._$25446(1)));
            p2.add((Object)this._$26888("SYNTAX      "));
            this._$23759(p2, o2.getSyntax());
        }
        doc.add((Element)p2);
    }

    private void writeObject(Document doc, MIBObject o2) throws DocumentException {
        if (o2 instanceof MIBObjectType) {
            this._$26912(doc, (MIBObjectType)o2);
        } else if (o2 instanceof MIBTextualConvention) {
            this._$26931(doc, (MIBTextualConvention)o2);
        } else if (o2 instanceof MIBNotifyType) {
            this._$26919(doc, (MIBNotifyType)o2);
        } else if (o2 instanceof MIBGroup) {
            this._$26925(doc, (MIBGroup)o2);
        } else if (o2 instanceof MIBCompliance) {
            this._$26928(doc, (MIBCompliance)o2);
        } else if (o2 instanceof MIBAgentCaps) {
            this._$26930(doc, (MIBAgentCaps)o2);
        } else {
            this._$26909(doc, o2);
        }
    }

    private void _$18100(Document doc, MIBModule m2) throws DocumentException {
        TreeMap<MIBObject, MIBObject> orderedObjects = new TreeMap<MIBObject, MIBObject>(new MIBObjectOrderComparator(this._$295));
        Enumeration en = m2.objects();
        while (en.hasMoreElements()) {
            MIBObject obj = (MIBObject)en.nextElement();
            orderedObjects.put(obj, obj);
        }
        for (MIBObject o2 : orderedObjects.values()) {
            if (!(o2 instanceof MIBModule)) {
                this.writeObject(doc, o2);
                continue;
            }
            if (!(o2 instanceof MIBModule) || m2.getSMIVersion() != 1 || !o2.getOid().isValid()) continue;
            this.writeObject(doc, o2);
        }
    }

    private Chunk _$26933(String moduleName, String objectName) {
        Chunk anchor;
        if (moduleName != null) {
            anchor = new Chunk(moduleName + "." + objectName, (Font)this._$26856.get(_$26841));
            anchor.setLocalDestination(moduleName + "." + objectName);
        } else {
            anchor = new Chunk(objectName, (Font)this._$26856.get(_$26841));
            anchor.setLocalDestination(objectName);
        }
        return anchor;
    }

    private void _$26934(Paragraph doc, MIBImport imports) {
        Enumeration<String> en = imports.getImportsVector().elements();
        while (en.hasMoreElements()) {
            doc.add((Object)this._$26881(this._$25446(1)));
            String name = en.nextElement().toString();
            MIBObject[] o2 = this._$12267.getObjectsByName(name);
            if (o2 != null && o2.length > 1) {
                doc.add((Object)this._$26933(imports.getSource(), name));
            } else {
                doc.add((Object)this._$26933(null, name));
            }
            if (!en.hasMoreElements()) continue;
            doc.add((Object)this._$26881(",\n"));
        }
        doc.add((Object)this._$26881("\n" + this._$25446(2)));
        doc.add((Object)this._$26883("FROM "));
        doc.add((Object)this._$19460(imports.getSource()));
        if (imports.hasComment()) {
            doc.add((Object)this._$26881(this._$25446(2)));
            doc.add((Object)this._$15513(imports.getComment()));
        }
    }

    private void _$26935(Document doc, MIBModule o2) throws DocumentException {
        if (this._$26850 > 1 && o2.getOid().size() > 0) {
            String d2;
            Paragraph p2 = this._$26911(doc, o2);
            p2.add((Object)this._$26883(" MODULE-IDENTITY"));
            if (o2 instanceof PIBModule) {
                p2.add((Object)this._$26881("\n" + this._$25446(1)));
                p2.add((Object)this._$26888("SUBJECT-CATEGORIES {"));
                p2.add((Object)this._$26881("\n"));
                Iterator<? extends IEnum> it = ((PIBModule)o2).getCategories().iterator();
                while (it.hasNext()) {
                    IEnum element = it.next();
                    p2.add((Object)this._$26881(this._$25446(2)));
                    this._$26893(p2, element);
                    if (it.hasNext()) {
                        p2.add((Object)this._$26881(",\n"));
                        continue;
                    }
                    p2.add((Object)this._$26881("\n"));
                }
                p2.add((Object)this._$26881(this._$25446(1) + "}\n"));
            }
            p2.add((Object)this._$26881("\n" + this._$25446(1)));
            p2.add((Object)this._$26888("LAST-UPDATED "));
            p2.add((Object)this._$317(o2.getLastUpdated()));
            if ((this._$295 & 0x20) > 0 && (d2 = MIBModule.getTimeFromUTC(MIBObject.getUnquotedString(o2.getLastUpdated()))) != null) {
                p2.add((Object)this._$26881(this._$25446(1)));
                p2.add((Object)this._$15513("-- " + d2));
            }
            p2.add((Object)this._$26881("\n" + this._$25446(1)));
            p2.add((Object)this._$26888("ORGANIZATION "));
            p2.add((Object)this._$317(o2.getOrganization()));
            p2.add((Object)this._$26881("\n" + this._$25446(1)));
            p2.add((Object)this._$26888("CONTACT-INFO"));
            p2.add((Object)this._$26881("\n"));
            p2.add((Object)this._$317(2, o2.getContactInfo()));
            p2.add((Object)this._$26881("\n" + this._$25446(1)));
            p2.add((Object)this._$26888("DESCRIPTION"));
            p2.add((Object)this._$26881("\n"));
            p2.add((Object)this._$317(2, o2.getDescription()));
            p2.add((Object)this._$26881("\n"));
            if (o2.hasRevisions()) {
                Enumeration en = o2.getRevisionsVector().elements();
                while (en.hasMoreElements()) {
                    String d3;
                    MIBRevision r2 = (MIBRevision)en.nextElement();
                    p2.add((Object)this._$26881("\n" + this._$25446(1)));
                    p2.add((Object)this._$26888("REVISION "));
                    p2.add((Object)this._$317(r2.getRevision()));
                    if ((this._$295 & 0x20) > 0 && (d3 = MIBModule.getTimeFromUTC(MIBObject.getUnquotedString(r2.getRevision()))) != null) {
                        p2.add((Object)this._$26881(this._$25446(1)));
                        p2.add((Object)this._$15513("-- " + d3));
                    }
                    p2.add((Object)this._$26881("\n" + this._$25446(1)));
                    p2.add((Object)this._$26888("DESCRIPTION"));
                    p2.add((Object)this._$26881("\n"));
                    p2.add((Object)this._$317(2, r2.getDescription()));
                    p2.add((Object)this._$26881("\n"));
                }
            }
            this._$26906(p2, o2);
            doc.add((Element)p2);
        }
    }

    private void _$26882(Document doc, MIBModule m2) throws DocumentException {
        this._$26861.add(m2.getModuleName());
        Paragraph top = new Paragraph(this._$26851, this._$26881(m2.getModuleName()));
        if (m2 instanceof PIBModule) {
            top.add((Object)this._$26883(" PIB-DEFINITIONS ::= BEGIN"));
        } else {
            top.add((Object)this._$26883(" DEFINITIONS ::= BEGIN"));
        }
        top.add((Object)this._$26881("\n\n"));
        doc.add((Element)top);
        if (m2.hasImports()) {
            this._$26861.add("IMPORTS");
            Paragraph p2 = new Paragraph(this._$26851, "IMPORTS\n", (Font)this._$26856.get(_$26840));
            Enumeration<MIBImport> en = m2.getImportsVector().elements();
            while (en.hasMoreElements()) {
                MIBImport mi = en.nextElement();
                this._$26934(p2, mi);
                if (en.hasMoreElements() || !mi.hasComment()) continue;
                p2.add((Object)this._$26881("\n"));
            }
            p2.add((Object)this._$26881(";"));
            doc.add((Element)p2);
        }
        this._$26935(doc, m2);
        this._$18100(doc, m2);
        doc.add((Element)this._$26881("\n"));
        this._$26861.add("END");
        doc.add((Element)new Paragraph("END", (Font)this._$26856.get(_$26840)));
    }

    public void setDefaultFont(Font defaultFont) {
        this._$24096 = defaultFont;
    }

    public Font getDefaultFont() {
        return this._$24096;
    }

    public void setLeading(float leading) {
        this._$26851 = leading;
    }

    public void setKeepTogether(boolean keepTogether) {
        this._$26857 = keepTogether;
    }

    public boolean isKeepTogether() {
        return this._$26857;
    }

    public void setDisplayPageNumbers(boolean displayPageNumbers) {
        this._$26858 = displayPageNumbers;
    }

    public boolean isDisplayPageNumbers() {
        return this._$26858;
    }

    public void setOutlineAsTree(boolean outlineTree) {
        this._$26859 = outlineTree;
        if (outlineTree) {
            this._$295 = 160;
        }
    }

    public boolean isOutlineAsTree() {
        return this._$26859;
    }

    public void setShowBookmarks(boolean showBookmarks) {
        this._$26860 = showBookmarks;
    }

    public boolean isShowBookmarks() {
        return this._$26860;
    }

    public void setDisplayCurrentDate(boolean displayCurrentDate) {
        this._$26863 = displayCurrentDate;
    }

    public void setMode(int mode) {
        this._$295 = mode;
    }

    public boolean isDisplayCurrentDate() {
        return this._$26863;
    }

    public int getMode() {
        return this._$295;
    }

    class MyPageEvents
    extends PdfPageEventHelper {
        PdfContentByte cb;
        PdfTemplate template;
        BaseFont bf = null;

        MyPageEvents() {
        }

        public void onParagraph(PdfWriter writer, Document document, float position) {
            try {
                PdfContentByte cb = writer.getDirectContent();
                PdfOutline root = null;
                String title = null;
                if (MIBModule2PDF.this._$26861.elementAt(MIBModule2PDF.this._$26862) == null) {
                    MIBModule2PDF.this._$26862++;
                    return;
                }
                MIBObject o2 = null;
                if (MIBModule2PDF.this._$26861.elementAt(MIBModule2PDF.this._$26862) instanceof MIBObject) {
                    o2 = (MIBObject)MIBModule2PDF.this._$26861.elementAt(MIBModule2PDF.this._$26862);
                    title = o2.getName();
                    MIBObject parent = MIBModule2PDF.this._$12267.getParent(o2);
                    if (parent != null) {
                        root = (PdfOutline)parent.userObject;
                    }
                } else {
                    title = MIBModule2PDF.this._$26861.elementAt(MIBModule2PDF.this._$26862).toString();
                }
                if (!MIBModule2PDF.this._$26859 || root == null) {
                    root = cb.getRootOutline().getKids().size() > 0 ? (PdfOutline)cb.getRootOutline().getKids().get(0) : cb.getRootOutline();
                }
                PdfDestination destination = new PdfDestination(2, position);
                PdfOutline outline = new PdfOutline(root, destination, title);
                if (o2 != null) {
                    o2.userObject = outline;
                }
                MIBModule2PDF.this._$26862++;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void onOpenDocument(PdfWriter writer, Document document) {
            try {
                this.bf = BaseFont.createFont((String)"Courier", (String)"Cp1252", (boolean)false);
                this.cb = writer.getDirectContent();
                this.template = this.cb.createTemplate(50.0f, 50.0f);
            }
            catch (DocumentException de) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void onEndPage(PdfWriter writer, Document document) {
            if (!MIBModule2PDF.this._$26858) {
                return;
            }
            int pageN = writer.getPageNumber();
            String text = "Page " + pageN + " of     ";
            float lenNum = this.bf.getWidthPoint("8888", 8.0f);
            float len = this.bf.getWidthPoint(text, 8.0f);
            this.cb.beginText();
            this.cb.setFontAndSize(this.bf, 8.0f);
            this.cb.setTextMatrix(MIBModule2PDF.this._$23980.getWidth() - 30.0f - len, 30.0f);
            this.cb.showText(text);
            this.cb.endText();
            this.cb.addTemplate(this.template, MIBModule2PDF.this._$23980.getWidth() - 30.0f - lenNum, 30.0f);
            this.cb.beginText();
            this.cb.setFontAndSize(this.bf, 8.0f);
            this.cb.setTextMatrix(30.0f, 30.0f);
            this.cb.showText(MIBModule2PDF.this._$15323);
            this.cb.endText();
            if (MIBModule2PDF.this._$26863) {
                this.cb.beginText();
                this.cb.setFontAndSize(this.bf, 8.0f);
                String date = _$26849.format(MIBModule2PDF.this._$26853);
                len = this.bf.getWidthPoint(date, 8.0f);
                this.cb.setTextMatrix(MIBModule2PDF.this._$23980.getWidth() / 2.0f - len / 2.0f, 30.0f);
                this.cb.showText(date);
                this.cb.endText();
            }
        }

        public void onCloseDocument(PdfWriter writer, Document document) {
            this.template.beginText();
            this.template.setFontAndSize(this.bf, 8.0f);
            this.template.showText(String.valueOf(writer.getPageNumber() - 1));
            this.template.endText();
        }
    }
}

