/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.smi.ext.SMIRange;
import com.agentpp.smiparser.SMI;
import java.io.Serializable;
import java.util.Collections;
import java.util.Vector;

public class MIBRange
implements Serializable,
SMIRange,
Comparable {
    public static final long serialVersionUID = 1000L;
    protected Long lower = null;
    protected Long upper = null;

    public MIBRange() {
    }

    public MIBRange(long lower, long upper) {
        this.lower = new Long(lower);
        this.upper = new Long(upper);
    }

    public MIBRange(String lower, String upper) {
        this.lower = new Long(SMI.parseLongConstant(lower));
        this.upper = new Long(SMI.parseLongConstant(upper));
    }

    public Long getLower() {
        return this.lower;
    }

    public Long getUpper() {
        return this.upper;
    }

    public void setLower(long l2) {
        this.lower = new Long(l2);
    }

    public void setUpper(long u) {
        this.upper = new Long(u);
    }

    public void setLowerValue(long l2) {
        this.lower = new Long(l2);
    }

    public void setUpperValue(long u) {
        this.upper = new Long(u);
    }

    public long getLowerValue() {
        return this.lower;
    }

    public long getUpperValue() {
        return this.upper;
    }

    public String toSMI(int mode) {
        StringBuffer buf = new StringBuffer();
        if (this.lower.equals(this.upper)) {
            MIBObject.addNum(mode, buf, this.upper);
        } else {
            MIBObject.addNum(mode, buf, this.lower);
            buf.append("..");
            MIBObject.addNum(mode, buf, this.upper);
        }
        return buf.toString();
    }

    public String toString() {
        return this.toSMI(1);
    }

    public boolean equals(Object o2) {
        if (o2 instanceof MIBRange) {
            return this.lower.equals(((MIBRange)o2).lower) && this.upper.equals(((MIBRange)o2).upper);
        }
        return false;
    }

    public static boolean normalizeRanges(Vector in, Vector normalized) {
        boolean isAlreadyNormalized = true;
        for (MIBRange r2 : in) {
            boolean add = true;
            for (MIBRange nr : normalized) {
                if (nr.getLowerValue() > r2.getLowerValue() || nr.getUpperValue() < r2.getUpperValue()) {
                    if (nr.getUpperValue() < r2.getLowerValue() || nr.getLowerValue() > r2.getUpperValue()) continue;
                    nr.setLowerValue(Math.min(nr.getLowerValue(), r2.getLowerValue()));
                    nr.setUpperValue(Math.min(nr.getUpperValue(), r2.getUpperValue()));
                    add = false;
                    continue;
                }
                add = false;
            }
            if (add) {
                normalized.add(new MIBRange(r2.getLowerValue(), r2.getUpperValue()));
                continue;
            }
            isAlreadyNormalized = false;
        }
        return isAlreadyNormalized;
    }

    public static int compareRanges(Vector a2, Vector b2) {
        if (a2.size() == 0 && b2.size() > 0) {
            return 1;
        }
        if (a2.size() > 0 && b2.size() == 0) {
            return -1;
        }
        Collections.sort(a2);
        Collections.sort(b2);
        for (int i2 = 0; i2 < Math.min(a2.size(), b2.size()); ++i2) {
            MIBRange ra = (MIBRange)a2.get(i2);
            MIBRange rb = (MIBRange)b2.get(i2);
            if (ra.getLowerValue() > rb.getLowerValue()) {
                return -1;
            }
            if (ra.getLowerValue() < rb.getLowerValue()) {
                return 1;
            }
            if (ra.getUpperValue() > rb.getUpperValue()) {
                return 1;
            }
            if (ra.getLowerValue() >= rb.getLowerValue()) continue;
            return -1;
        }
        return a2.size() - b2.size();
    }

    public int compareTo(Object o2) {
        MIBRange other = (MIBRange)o2;
        if (this.getLowerValue() == other.getLowerValue()) {
            return 0;
        }
        if (this.getLowerValue() > other.getLowerValue()) {
            return 1;
        }
        return -1;
    }
}

