/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.IRequirementsSpec;
import com.agentpp.smi.ext.SMIComplianceStatement;
import com.agentpp.smi.ext.SMIRequirementsSpec;
import com.agentpp.smiparser.SMI;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBCompliance
extends MIBObject
implements Serializable,
SMIComplianceStatement {
    public static final long serialVersionUID = 1000L;
    protected Vector<MIBComplianceModule> modules = new Vector();

    public MIBCompliance() {
    }

    public MIBCompliance(ObjectID oid, String name, Integer moduleID) {
        super(oid, name, moduleID);
    }

    public MIBCompliance(MIBCompliance other) {
        super(other);
        Iterator<MIBComplianceModule> en = other.modules.iterator();
        while (en.hasNext()) {
            this.modules.add(new MIBComplianceModule(en.next()));
        }
    }

    @Override
    public MIBObject getClone() {
        return new MIBCompliance(this);
    }

    public void setModules(Vector newModules) {
        this.modules = newModules;
    }

    @Override
    public String getTypeString() {
        return SMI.ENTRY_TYPES[8];
    }

    @Override
    public int getType() {
        return 8;
    }

    public Vector<MIBComplianceModule> getModules() {
        return this.modules;
    }

    @Override
    public final IRequirementsSpec[] getRequirements() {
        Object[] m2 = new MIBComplianceModule[this.modules.size()];
        this.modules.copyInto(m2);
        return m2;
    }

    @Override
    public final void setRequirements(SMIRequirementsSpec[] requirements) {
        this.modules = new Vector<SMIRequirementsSpec>(Arrays.asList(requirements));
    }

    @Override
    public String toSMI(int mode, int smiversion, MIBRepository rep, String lineSeparator) {
        MIBCompliance c2 = (MIBCompliance)this.comparable(mode);
        if (smiversion != 1) {
            StringBuffer buf = new StringBuffer(lineSeparator);
            MIBCompliance.addNavigationLinks(this, mode, buf, rep, lineSeparator);
            if (this.hasComment()) {
                MIBCompliance.addComment(mode, buf, this.asn1Comment, lineSeparator);
                buf.append(lineSeparator);
            }
            MIBCompliance.addObjectRef(null, mode, buf, this.name, c2 == null ? null : c2.name);
            MIBCompliance.addKeyWord(mode, buf, " MODULE-COMPLIANCE");
            buf.append(lineSeparator);
            buf.append(this.getSMIDefBegin(mode, lineSeparator));
            Enumeration<MIBComplianceModule> cen = null;
            if (c2 != null) {
                cen = c2.modules.elements();
            }
            Enumeration<MIBComplianceModule> en = this.modules.elements();
            while (en.hasMoreElements()) {
                MIBComplianceModule compModule;
                MIBComplianceModule cs = null;
                if (cen != null) {
                    cs = cen.hasMoreElements() ? cen.nextElement() : new MIBComplianceModule("");
                }
                if ((compModule = en.nextElement()) instanceof MIBComplianceModule) {
                    buf.append(compModule.toSMI(mode, rep, cs, lineSeparator));
                    continue;
                }
                buf.append(((Object)compModule).toString());
            }
            buf.append(lineSeparator);
            buf.append(this.getSMIDefEnd(mode, rep, this.asn1CommentInline, lineSeparator));
            return buf.toString();
        }
        return "";
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 instanceof MIBCompliance && super.equals(o2)) {
            MIBCompliance other = (MIBCompliance)o2;
            return MIBCompliance.saveCompare(this.modules, other.modules);
        }
        return false;
    }

    @Override
    public void freeUserObjects() {
        super.freeUserObjects();
        for (MIBComplianceModule cm : this.modules) {
            cm.freeUserObjects();
        }
    }
}

