/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.ui;

import com.agentpp.commons.ui.SearchPopupPanel;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Position;

public abstract class PopupFindAction
extends AbstractAction
implements ActionListener,
PopupMenuListener,
DocumentListener,
KeyListener {
    private SearchPopupPanel searchPopupPanel;
    private JPopupMenu popupMenu;
    protected JComponent comp = null;
    protected boolean matchCase = true;
    protected boolean shiftDown;
    protected boolean controlDown;

    protected PopupFindAction(boolean matchCase) {
        super("popup-search-action-" + (matchCase ? "match" : "ignore") + "-case");
        this.matchCase = matchCase;
        this.searchPopupPanel = new SearchPopupPanel();
        int modifiers = 2;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, modifiers));
    }

    public SearchPopupPanel getSearchPopupPanel() {
        return this.searchPopupPanel;
    }

    protected abstract boolean changed(JComponent var1, String var2, Position.Bias var3);

    protected void createPopup() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.setBorder(BorderFactory.createLineBorder(Color.black));
        this.popupMenu.add(this.searchPopupPanel.getSearchPanel());
        this.popupMenu.addPopupMenuListener(this);
        this.searchPopupPanel.getSearchField().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PopupFindAction.this.popupMenu.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
    }

    public static void installActions(JComponent comp, Action[] actions, int condition) {
        ActionMap actionMap = comp.getActionMap();
        InputMap inputMap = comp.getInputMap(condition);
        for (Action action : actions) {
            String name = (String)action.getValue("Name");
            actionMap.put(name, action);
            inputMap.put((KeyStroke)action.getValue("AcceleratorKey"), name);
        }
    }

    public static void installActions(JComponent comp, Action[] actions) {
        PopupFindAction.installActions(comp, actions, 0);
    }

    @Override
    public void keyTyped(KeyEvent e2) {
    }

    public void setComponent(JComponent component) {
        this.comp = component;
    }

    @Override
    public void keyPressed(KeyEvent e2) {
        this.shiftDown = e2.isShiftDown();
        this.controlDown = e2.isControlDown();
        switch (e2.getKeyCode()) {
            case 38: {
                this.changed(Position.Bias.Backward);
                break;
            }
            case 40: {
                this.changed(Position.Bias.Forward);
                break;
            }
            case 10: {
                if (this.popupMenu != null) break;
                this.commitSearch();
            }
        }
    }

    protected void commitSearch() {
    }

    @Override
    public void keyReleased(KeyEvent e2) {
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (this.popupMenu != null) {
            if (e2.getSource() == this.searchPopupPanel.getSearchField()) {
                this.popupMenu.setVisible(false);
                this.comp = null;
            } else if (!this.popupMenu.hasFocus() && !this.popupMenu.isVisible()) {
                this.comp = (JComponent)e2.getSource();
                this.disconnectSearchField();
                this.resetSearch(e2);
                this.connectSearchField();
                Rectangle rect = this.comp.getVisibleRect();
                int y = this.getMinY(rect.y, this.popupMenu.getPreferredSize().height);
                this.popupMenu.show(this.comp, rect.x, y);
                JTextField searchField = this.searchPopupPanel.getSearchField();
                searchField.requestFocusInWindow();
                searchField.setCaret(new DefaultCaret());
            }
        }
    }

    public void connectSearchField() {
        JTextField searchField = this.searchPopupPanel.getSearchField();
        searchField.addActionListener(this);
        searchField.addKeyListener(this);
        searchField.getDocument().addDocumentListener(this);
    }

    public void disconnectSearchField() {
        JTextField searchField = this.searchPopupPanel.getSearchField();
        searchField.addActionListener(this);
        searchField.addKeyListener(this);
        searchField.getDocument().addDocumentListener(this);
    }

    private int getMinY(int y, int height) {
        int preferredY = y - height - 5;
        int minY = -this.comp.getY();
        if (preferredY < minY) {
            return minY;
        }
        return preferredY;
    }

    protected void resetSearch(ActionEvent e2) {
        this.searchPopupPanel.getSearchField().setText("");
        this.searchPopupPanel.getSearchField().setBackground(Color.white);
    }

    @Override
    public void insertUpdate(DocumentEvent e2) {
        this.changed(null);
    }

    @Override
    public void removeUpdate(DocumentEvent e2) {
        this.changed(null);
    }

    @Override
    public void changedUpdate(DocumentEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
        this.comp.requestFocusInWindow();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e2) {
    }

    private void changed(Position.Bias bias) {
        if (this.popupMenu != null) {
            this.popupMenu.setVisible(false);
            this.popupMenu.setVisible(true);
        }
        this.searchPopupPanel.getSearchField().requestFocusInWindow();
        this.searchPopupPanel.getSearchField().setBackground(this.changed(this.comp, this.searchPopupPanel.getSearchField().getText(), bias) ? Color.white : Color.pink);
    }
}

