/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.ui;

import com.agentpp.common.table.TableUtils;
import com.agentpp.commons.ui.PopupFindAction;
import com.agentpp.util.Regex;
import com.klg.jclass.table.JCTable;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.text.Position;

public class JCTablePopupFindAction
extends PopupFindAction {
    protected boolean useExactMatch;

    public JCTablePopupFindAction(boolean matchCase) {
        super(matchCase);
        this.createPopup();
    }

    private JCTable findTable(JComponent component) {
        if (component instanceof JCTable) {
            return (JCTable)component;
        }
        for (int i2 = 0; i2 < component.getComponentCount(); ++i2) {
            JComponent next = (JComponent)component.getComponent(i2);
            JCTable table = this.findTable(next);
            if (table == null) continue;
            return table;
        }
        return null;
    }

    @Override
    protected boolean changed(JComponent comp, String text, Position.Bias bias) {
        int index;
        int startingRow;
        JCTable table = this.findTable(comp);
        boolean startingFromSelection = true;
        int max = table.getNumRows();
        int increment = 0;
        if (bias != null) {
            int n2 = increment = bias == Position.Bias.Forward ? 1 : -1;
        }
        if ((startingRow = (TableUtils.getFirstSelectedRow(table) + increment + max) % max) < 0 || startingRow >= table.getNumRows()) {
            startingFromSelection = false;
            startingRow = 0;
        }
        if ((index = this.matchNext(table, text, startingRow, bias)) != -1) {
            this.changeSelection(table, index);
            return true;
        }
        if (startingFromSelection && (index = this.matchNext(table, text, 0, bias)) != -1) {
            this.changeSelection(table, index);
            return true;
        }
        return false;
    }

    private int matchNext(JCTable table, String searchPattern, int startIndex, Position.Bias bias) {
        Regex regex;
        int max;
        int column;
        block11: {
            column = TableUtils.getFirstSelectedColumn(table);
            if (column < 0) {
                column = 0;
            }
            max = table.getNumRows();
            if (searchPattern == null) {
                throw new IllegalArgumentException();
            }
            regex = new Regex();
            try {
                if (!this.matchCase) {
                    searchPattern = "(?i)" + searchPattern;
                }
                if (this.useExactMatch) {
                    regex.compileWithExactMatch(searchPattern);
                } else {
                    regex.compile(searchPattern);
                }
            }
            catch (ParseException e2) {
                regex = null;
                if (this.matchCase) break block11;
                searchPattern = searchPattern.toUpperCase();
            }
        }
        if (startIndex < 0 || startIndex >= max) {
            throw new IllegalArgumentException();
        }
        int increment = bias == null || bias == Position.Bias.Forward ? 1 : -1;
        int index = startIndex;
        do {
            Object item;
            if ((item = table.getDataView().getTableDataItem(index, column)) == null) continue;
            String text = item.toString();
            if (!this.matchCase && regex == null) {
                text = text.toUpperCase();
            }
            if (text == null) continue;
            if (regex == null && text.startsWith(searchPattern)) {
                return index;
            }
            if (regex == null || !regex.match(text)) continue;
            return index;
        } while ((index = (index + increment + max) % max) != startIndex);
        return -1;
    }

    protected void changeSelection(JCTable table, int index) {
        if (this.controlDown) {
            table.addRowSelection(index, index);
        } else {
            table.setRowSelection(index, index);
        }
        table.makeRowVisible(index);
    }
}

