/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.snmp;

import com.agentpp.commons.ui.OctetStringField;
import com.agentpp.commons.ui.UIObjectUpdateListener;
import com.agentpp.snmp.UserProfile;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.snmp4j.security.AuthHMAC128SHA224;
import org.snmp4j.security.AuthHMAC192SHA256;
import org.snmp4j.security.AuthHMAC256SHA384;
import org.snmp4j.security.AuthHMAC384SHA512;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.nonstandard.PrivAES192With3DESKeyExtension;
import org.snmp4j.security.nonstandard.PrivAES256With3DESKeyExtension;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class UsmUserEditorPanel {
    private JLabel userNameLabel;
    private JTextField userProfileName;
    private JLabel securityNameLabel;
    private OctetStringField securityName;
    private JLabel authProtocolLabel;
    private JComboBox authProtocol;
    private JLabel authPassphraseLabel;
    private OctetStringField authPassphrase;
    private JLabel privProtocolLabel;
    private OctetStringField privPassphrase;
    private JLabel privPassphraseLabel;
    private JComboBox privProtocol;
    private JPanel panel;
    private JLabel principalLabel;
    private JCheckBox principal;
    private JLabel localizationEngineIdLabel;
    private OctetStringField localizationEngineId;
    private UserProfile userProfile;
    private UIObjectUpdateListener<UserProfile> updateListener;
    private UpdateInputVerifier updateInputVerifier = new UpdateInputVerifier();
    private volatile boolean updating;

    public UsmUserEditorPanel() {
        this.$$$setupUI$$$();
        this.userProfileName.setInputVerifier(this.updateInputVerifier);
        this.securityName.setInputVerifier(this.updateInputVerifier);
        this.authProtocol.setInputVerifier(this.updateInputVerifier);
        this.authPassphrase.setInputVerifier(this.updateInputVerifier);
        this.privProtocol.setInputVerifier(this.updateInputVerifier);
        this.privPassphrase.setInputVerifier(this.updateInputVerifier);
        this.localizationEngineId.setInputVerifier(this.updateInputVerifier);
        this.principal.setInputVerifier(this.updateInputVerifier);
        this.localizationEngineId.setMinLength(5);
        this.localizationEngineId.setMaxLength(32);
        this.localizationEngineId.setEmptyAllowed(true);
        this.authPassphrase.setEmptyAllowed(true);
        this.privPassphrase.setEmptyAllowed(true);
        this.securityName.setMinLength(1);
        this.securityName.setMaxLength(32);
        this.localizationEngineId.setMode(OctetStringField.EditMode.Hex);
        this.setEnabled(false);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void setUserProfile(UserProfile userProfile) {
        this.updating = true;
        if (userProfile != null) {
            this.userProfileName.setText(userProfile.getName());
            this.securityName.setOctetString(userProfile.getUser().getSecurityName());
            this.authProtocol.setSelectedItem(UsmUserEditorPanel.getSecurityProtocolName(userProfile.getUser().getAuthenticationProtocol()));
            this.authPassphrase.setOctetString(userProfile.getUser().getAuthenticationPassphrase());
            this.privProtocol.setSelectedItem(UsmUserEditorPanel.getSecurityProtocolName(userProfile.getUser().getPrivacyProtocol()));
            this.privPassphrase.setOctetString(userProfile.getUser().getPrivacyPassphrase());
            this.localizationEngineId.setOctetString(userProfile.getUser().getLocalizationEngineID());
            this.principal.setSelected(userProfile.isPrincipal());
            this.setEnabled(true);
        } else {
            this.userProfileName.setText("");
            this.securityName.setOctetString(new OctetString());
            this.authProtocol.setSelectedItem(null);
            this.authPassphrase.setOctetString(new OctetString());
            this.privProtocol.setSelectedItem(null);
            this.privPassphrase.setOctetString(new OctetString());
            this.localizationEngineId.setOctetString(new OctetString());
            this.principal.setSelected(false);
            this.setEnabled(false);
        }
        this.userProfile = userProfile;
        this.updating = false;
    }

    public UserProfile getUserProfile() {
        if (this.userProfile == null) {
            return null;
        }
        UserProfile userProfile = new UserProfile("", null);
        this.updateUserProfile(userProfile);
        return userProfile;
    }

    public void updateUserProfile() {
        this.updateUserProfile(this.userProfile);
    }

    private void updateUserProfile(UserProfile userProfile) {
        if (userProfile == null) {
            return;
        }
        userProfile.setName(this.userProfileName.getText());
        userProfile.setUser(new UsmUser(this.securityName.getOctetString(), UsmUserEditorPanel.getSecurityProtocol(this.authProtocol.getSelectedItem().toString()), this.nonEmpty(this.authPassphrase.getOctetString()), UsmUserEditorPanel.getSecurityProtocol(this.privProtocol.getSelectedItem().toString()), this.nonEmpty(this.privPassphrase.getOctetString()), this.nonEmpty(this.localizationEngineId.getOctetString())));
        userProfile.setPrincipal(this.principal.isSelected());
    }

    public UIObjectUpdateListener<UserProfile> getUpdateListener() {
        return this.updateListener;
    }

    public void setUpdateListener(UIObjectUpdateListener<UserProfile> updateListener) {
        this.updateListener = updateListener;
    }

    private OctetString nonEmpty(OctetString octetString) {
        if (octetString == null || octetString.length() == 0) {
            return null;
        }
        return octetString;
    }

    public void setEnabled(boolean enabled) {
        this.userProfileName.setEnabled(enabled);
        this.securityName.setEnabled(enabled);
        this.authProtocol.setEnabled(enabled);
        this.authPassphrase.setEnabled(enabled);
        this.privProtocol.setEnabled(enabled);
        this.privPassphrase.setEnabled(enabled);
        this.localizationEngineId.setEnabled(enabled);
        this.principal.setEnabled(enabled);
    }

    public static String getSecurityProtocolName(OID secProtocolID) {
        if (secProtocolID == null) {
            return "";
        }
        if (AuthMD5.ID.equals(secProtocolID)) {
            return "MD5";
        }
        if (AuthSHA.ID.equals(secProtocolID)) {
            return "SHA-1";
        }
        if (AuthHMAC128SHA224.ID.equals(secProtocolID)) {
            return "SHA224";
        }
        if (AuthHMAC192SHA256.ID.equals(secProtocolID)) {
            return "SHA256";
        }
        if (AuthHMAC256SHA384.ID.equals(secProtocolID)) {
            return "SHA384";
        }
        if (AuthHMAC384SHA512.ID.equals(secProtocolID)) {
            return "SHA512";
        }
        if (PrivDES.ID.equals(secProtocolID)) {
            return "DES";
        }
        if (Priv3DES.ID.equals(secProtocolID)) {
            return "3DES";
        }
        if (PrivAES128.ID.equals(secProtocolID)) {
            return "AES128";
        }
        if (PrivAES192.ID.equals(secProtocolID)) {
            return "AES192";
        }
        if (PrivAES256.ID.equals(secProtocolID)) {
            return "AES256";
        }
        if (PrivAES192With3DESKeyExtension.ID.equals(secProtocolID)) {
            return "AES192-KeyExt3DES";
        }
        if (PrivAES256With3DESKeyExtension.ID.equals(secProtocolID)) {
            return "AES256-KeyExt3DES";
        }
        return null;
    }

    public static OID getSecurityProtocol(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (name.equals("MD5")) {
            return AuthMD5.ID;
        }
        if (name.equals("SHA") || name.equals("SHA-1")) {
            return AuthSHA.ID;
        }
        if (name.equals("SHA224")) {
            return AuthHMAC128SHA224.ID;
        }
        if (name.equals("SHA256")) {
            return AuthHMAC192SHA256.ID;
        }
        if (name.equals("SHA384")) {
            return AuthHMAC256SHA384.ID;
        }
        if (name.equals("SHA512")) {
            return AuthHMAC384SHA512.ID;
        }
        if (name.equals("DES")) {
            return PrivDES.ID;
        }
        if (name.equals("3DES")) {
            return Priv3DES.ID;
        }
        if (name.equals("AES128")) {
            return PrivAES128.ID;
        }
        if (name.equals("AES192")) {
            return PrivAES192.ID;
        }
        if (name.equals("AES256")) {
            return PrivAES256.ID;
        }
        if (name.equals("AES192-KeyExt3DES")) {
            return PrivAES192With3DESKeyExtension.ID;
        }
        if (name.equals("AES256-KeyExt3DES")) {
            return PrivAES256With3DESKeyExtension.ID;
        }
        return null;
    }

    private void $$$setupUI$$$() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.userNameLabel = new JLabel();
        this.userNameLabel.setText("User Profile Name:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.userNameLabel, gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.panel.add((Component)spacer1, gbc);
        JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.fill = 3;
        this.panel.add((Component)spacer2, gbc);
        this.userProfileName = new JTextField();
        this.userProfileName.setToolTipText("The unique name of the user profile");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.userProfileName, gbc);
        this.securityNameLabel = new JLabel();
        this.securityNameLabel.setText("Security Name:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.securityNameLabel, gbc);
        this.securityName = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.securityName.$$$getRootComponent$$$(), gbc);
        this.authProtocolLabel = new JLabel();
        this.authProtocolLabel.setText("Authentication Protocol:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.authProtocolLabel, gbc);
        this.authProtocol = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel1 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel1.addElement("");
        defaultComboBoxModel1.addElement("MD5");
        defaultComboBoxModel1.addElement("SHA-1");
        defaultComboBoxModel1.addElement("SHA224");
        defaultComboBoxModel1.addElement("SHA256");
        defaultComboBoxModel1.addElement("SHA384");
        defaultComboBoxModel1.addElement("SHA512");
        this.authProtocol.setModel(defaultComboBoxModel1);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.authProtocol, gbc);
        this.privProtocolLabel = new JLabel();
        this.privProtocolLabel.setText("Privacy Protocol:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.privProtocolLabel, gbc);
        this.privProtocol = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement("");
        defaultComboBoxModel2.addElement("DES");
        defaultComboBoxModel2.addElement("3DES");
        defaultComboBoxModel2.addElement("AES128");
        defaultComboBoxModel2.addElement("AES192");
        defaultComboBoxModel2.addElement("AES256");
        defaultComboBoxModel2.addElement("AES192-KeyExt3DES");
        defaultComboBoxModel2.addElement("AES256-KeyExt3DES");
        this.privProtocol.setModel(defaultComboBoxModel2);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.privProtocol, gbc);
        this.principalLabel = new JLabel();
        this.principalLabel.setText("Principal:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.principalLabel, gbc);
        this.principal = new JCheckBox();
        this.principal.setText("Check to receive traps with this user profile");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.principal, gbc);
        this.localizationEngineIdLabel = new JLabel();
        this.localizationEngineIdLabel.setText("Localization Engine ID:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.localizationEngineIdLabel, gbc);
        this.localizationEngineId = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 5;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.localizationEngineId.$$$getRootComponent$$$(), gbc);
        this.privPassphraseLabel = new JLabel();
        this.privPassphraseLabel.setText("Privacy Passphrase:");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.privPassphraseLabel, gbc);
        this.privPassphrase = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.privPassphrase.$$$getRootComponent$$$(), gbc);
        this.authPassphraseLabel = new JLabel();
        this.authPassphraseLabel.setText("Authentication Passphrase:");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.authPassphraseLabel, gbc);
        this.authPassphrase = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.authPassphrase.$$$getRootComponent$$$(), gbc);
        this.userNameLabel.setLabelFor(this.userProfileName);
        this.securityNameLabel.setLabelFor(this.securityName);
        this.authProtocolLabel.setLabelFor(this.authProtocol);
        this.privProtocolLabel.setLabelFor(this.privProtocol);
        this.privPassphraseLabel.setLabelFor(this.privPassphrase);
        this.authPassphraseLabel.setLabelFor(this.authPassphrase);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private class UpdateInputVerifier
    extends InputVerifier {
        private UpdateInputVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            boolean ok = true;
            if (!UsmUserEditorPanel.this.updating && UsmUserEditorPanel.this.userProfile != null && UsmUserEditorPanel.this.updateListener != null) {
                try {
                    UserProfile userProfile = UsmUserEditorPanel.this.getUserProfile();
                    if (userProfile == null || !UsmUserEditorPanel.this.updateListener.uiObjectVerification(UsmUserEditorPanel.this, userProfile, UsmUserEditorPanel.this.userProfile)) {
                        ok = false;
                    } else {
                        UsmUserEditorPanel.this.updateUserProfile();
                        UsmUserEditorPanel.this.updateListener.uiObjectUpdated(UsmUserEditorPanel.this, UsmUserEditorPanel.this.userProfile);
                    }
                }
                catch (IllegalArgumentException iax) {
                    ok = false;
                }
            }
            if (ok) {
                if (input.getBackground() == Color.pink) {
                    input.setBackground(Color.white);
                }
            } else if (input.getBackground() == Color.white) {
                input.setBackground(Color.pink);
            }
            return ok;
        }
    }
}

