/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.mib.editor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

public class ErrorUnderlineHighlightPainter
extends DefaultHighlighter.DefaultHighlightPainter {
    private static final int ZIGZAG_POINTS = 2;

    public ErrorUnderlineHighlightPainter(Color color) {
        super(color);
    }

    @Override
    public Shape paintLayer(Graphics g2, int offs0, int offs1, Shape bounds, JTextComponent c2, View view) {
        Color color = this.getColor();
        if (color == null) {
            g2.setColor(c2.getSelectionColor());
        } else {
            g2.setColor(color);
        }
        if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
            Rectangle rectangle = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            this.paintZigzag(g2, rectangle);
            return rectangle;
        }
        try {
            Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            this.paintZigzag(g2, rectangle);
            return rectangle;
        }
        catch (BadLocationException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    protected void paintZigzag(Graphics g2, Rectangle rectangle) {
        int x = rectangle.x;
        int y = rectangle.y + rectangle.height - 2;
        int delta = -2;
        while (x + 2 < rectangle.x + rectangle.width) {
            g2.drawLine(x, y, x + 2, y + delta);
            y += delta;
            delta = -delta;
            x += 2;
        }
    }
}

