/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.mib.editor;

import com.agentpp.commons.mib.editor.AnnotationMark;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class AnnotationBarDataModel {
    private SortedMap<Integer, List<AnnotationMark>> marks = new TreeMap<Integer, List<AnnotationMark>>();

    public void setMarks(SortedMap<Integer, List<AnnotationMark>> marks) {
        this.marks = marks;
    }

    public SortedMap<Integer, List<AnnotationMark>> getMarks() {
        return this.marks;
    }

    public Map<AnnotationMark.MarkSeverity, Integer> getAnnotationCounts() {
        HashMap<AnnotationMark.MarkSeverity, Integer> counterMap = new HashMap<AnnotationMark.MarkSeverity, Integer>(AnnotationMark.MarkSeverity.values().length);
        for (AnnotationMark.MarkSeverity severity : AnnotationMark.MarkSeverity.values()) {
            counterMap.put(severity, 0);
        }
        SortedMap<Integer, List<AnnotationMark>> markMap = this.marks;
        for (List<AnnotationMark> markList : markMap.values()) {
            for (AnnotationMark mark : markList) {
                counterMap.put(mark.getSeverity(), (Integer)counterMap.get((Object)mark.getSeverity()) + 1);
            }
        }
        return counterMap;
    }

    public AnnotationMark.MarkSeverity getStatus() {
        SortedMap<Integer, List<AnnotationMark>> markMap = this.marks;
        if (markMap.isEmpty()) {
            return AnnotationMark.MarkSeverity.info;
        }
        AnnotationMark.MarkSeverity maxSeverity = AnnotationMark.MarkSeverity.info;
        for (List<AnnotationMark> markList : markMap.values()) {
            for (AnnotationMark mark : markList) {
                if (mark.getSeverity().ordinal() <= maxSeverity.ordinal() || (maxSeverity = mark.getSeverity()) != AnnotationMark.MarkSeverity.error) continue;
                return maxSeverity;
            }
        }
        return maxSeverity;
    }

    public AnnotationMark getTopLevelMarkForSpan(int startLine, int endLine) {
        SortedMap<Integer, List<AnnotationMark>> spanMarks = this.marks.subMap(startLine, endLine);
        AnnotationMark selected = null;
        for (List markList : spanMarks.values()) {
            AnnotationMark mark = this.getTopLevelAnnotationMark(markList);
            if (selected == null) {
                selected = mark;
            } else if (mark.getPriority() > selected.getPriority()) {
                selected = mark;
            }
            if (selected.getSeverity() != AnnotationMark.MarkSeverity.error) continue;
            return selected;
        }
        return selected;
    }

    public AnnotationMark getTopLevelMarkForPosition(int position) {
        SortedMap<Integer, List<AnnotationMark>> posMarks = this.marks;
        AnnotationMark selected = null;
        for (Map.Entry markListEntry : posMarks.entrySet()) {
            AnnotationMark selectedMark;
            int startPos;
            if (((List)markListEntry.getValue()).isEmpty() || (startPos = (selectedMark = (AnnotationMark)((List)markListEntry.getValue()).get(0)).getEndPosition()) < position) continue;
            AnnotationMark mark = this.getTopLevelAnnotationMark((List)markListEntry.getValue());
            if (selected == null) {
                selected = mark;
            } else if (mark.getPriority() > selected.getPriority()) {
                selected = mark;
            }
            if (selected.getSeverity() != AnnotationMark.MarkSeverity.error) continue;
            return selected;
        }
        return selected;
    }

    public Iterator<AnnotationMark> iterator() {
        return new MarkIterator();
    }

    private AnnotationMark getTopLevelAnnotationMark(Integer startLine) {
        List values = (List)this.marks.get(startLine);
        return this.getTopLevelAnnotationMark(values);
    }

    private AnnotationMark getTopLevelAnnotationMark(List<AnnotationMark> values) {
        int minPos = Integer.MAX_VALUE;
        int maxSeverity = Integer.MIN_VALUE;
        AnnotationMark selected = null;
        for (AnnotationMark mark : values) {
            if (mark.getSeverity().ordinal() > maxSeverity) {
                maxSeverity = mark.getSeverity().ordinal();
                selected = mark;
                continue;
            }
            if (mark.getSeverity().ordinal() != maxSeverity || mark.getPosition() >= minPos) continue;
            minPos = mark.getPosition();
            selected = mark;
        }
        return selected;
    }

    private class MarkIterator
    implements Iterator<AnnotationMark> {
        private Iterator<Integer> annotationMarkIterator;

        private MarkIterator() {
            this.annotationMarkIterator = AnnotationBarDataModel.this.marks.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.annotationMarkIterator.hasNext();
        }

        @Override
        public AnnotationMark next() {
            Integer nextKey = this.annotationMarkIterator.next();
            return AnnotationBarDataModel.this.getTopLevelAnnotationMark(nextKey);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum Status {
        updateInProgress,
        noAnnotations,
        annotationsAvailable;

    }
}

