/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.agentgen;

import com.agentpp.agentgen.AgentGen;
import com.agentpp.agentgen.ListReader;
import com.agentpp.mib.LexicographicPredicate;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.SMIParseException;
import com.objectspace.jgl.OrderedMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class AgentGenConsole {
    public static final int CMD_LOAD = 0;
    public static final int CMD_REMOVE = 1;
    public static final int CMD_CONTENTS = 2;
    public static final int CMD_MODULE = 3;
    public static final int CMD_GEN = 4;
    public static final int CMD_INIT = 5;
    public static final int CMD_ADD = 6;
    public static final int[][] paramSet = new int[][]{{3, 3}, {3, 3}, {2, 2}, {3, 3}, {4, 5}, {2, 2}, {3, 3}};
    protected DefaultRepositoryManager repMan = new DefaultRepositoryManager();
    protected MIBRepository rep = new MIBRepository();
    protected AgentGen gen = null;

    public AgentGenConsole(String[] stringArray) {
        if (stringArray.length < 1) {
            AgentGenConsole.printCopyright(false);
            AgentGenConsole.printUsage();
        }
        File file = new File(stringArray[0]);
        int n2 = 0;
        if (stringArray[1].startsWith("r")) {
            n2 = 1;
        } else if (stringArray[1].startsWith("l")) {
            n2 = 0;
        } else if (stringArray[1].startsWith("m")) {
            n2 = 3;
        } else if (stringArray[1].startsWith("g")) {
            n2 = 4;
        } else if (stringArray[1].startsWith("i")) {
            n2 = 5;
        } else if (stringArray[1].startsWith("c")) {
            n2 = 2;
        } else if (stringArray[1].startsWith("a")) {
            n2 = 6;
        } else {
            AgentGenConsole.printCopyright(false);
            AgentGenConsole.printUsage();
        }
        AgentGenConsole.printCopyright(n2 == 4);
        if (stringArray.length < paramSet[n2][0] || stringArray.length > paramSet[n2][1]) {
            AgentGenConsole.printUsage();
        }
        try {
            this.repMan.open(file);
        }
        catch (IOException iOException) {
            System.out.println("The given directory '" + file.getPath() + "' is not a valid repository path.");
            AgentGenConsole.printUsage();
        }
        this.gen = new AgentGen(this.rep, this.repMan);
        block11 : switch (n2) {
            case 6: {
                try {
                    ModuleInfo[] moduleInfoArray = this.repMan.addModules(new File(stringArray[2]));
                    System.out.println("MIB file '" + stringArray[2] + "' contains " + moduleInfoArray.length + " MIB module(s):");
                    for (int i2 = 0; i2 < moduleInfoArray.length; ++i2) {
                        System.out.print("  " + moduleInfoArray[i2].moduleName);
                        if (moduleInfoArray[i2].getImports().length <= 0) continue;
                        System.out.println(" which imports from " + moduleInfoArray[i2].getImportList());
                    }
                    break;
                }
                catch (SMIParseException sMIParseException) {
                    System.out.println("  Reason: " + DefaultRepositoryManager.getErrorText(sMIParseException) + ".");
                    break;
                }
            }
            case 0: {
                try {
                    File[] fileArray = ListReader.read(new File(stringArray[2]));
                    for (int i3 = 0; i3 < fileArray.length; ++i3) {
                        try {
                            System.out.println();
                            ModuleInfo[] moduleInfoArray = this.repMan.addModules(fileArray[i3]);
                            for (int i4 = 0; i4 < moduleInfoArray.length; ++i4) {
                                System.out.print("   Loaded " + moduleInfoArray[i4].moduleName);
                                if (moduleInfoArray[i4].getImports().length > 0) {
                                    System.out.println(" which imports from " + moduleInfoArray[i4].getImportList());
                                    continue;
                                }
                                System.out.println();
                            }
                            continue;
                        }
                        catch (SMIParseException sMIParseException) {
                            if (sMIParseException.errorType == 0) {
                                sMIParseException.printStackTrace();
                            }
                            System.out.println("   Reason: " + DefaultRepositoryManager.getErrorText(sMIParseException) + ".");
                        }
                    }
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("Cannot find file '" + stringArray[2] + "'.");
                    System.exit(1);
                    break;
                }
                catch (IOException iOException) {
                    System.out.println("Cannot open file '" + stringArray[2] + "'.");
                    System.exit(1);
                    break;
                }
                catch (ParseException parseException) {
                    System.out.println("Syntax error in list '" + stringArray[2] + "'.");
                    System.exit(1);
                    break;
                }
            }
            case 5: {
                try {
                    this.repMan.initialize();
                    System.out.println("Repository initialized successfully, you may now load your MIB files.");
                }
                catch (IOException iOException) {
                    System.out.println("Repository initialization failed: " + iOException.getMessage());
                }
                break;
            }
            case 1: {
                try {
                    boolean bl = this.repMan.removeModule(stringArray[2]);
                    if (bl) {
                        System.out.println("MIB module '" + stringArray[2] + "' successfully removed from repository.");
                        break;
                    }
                    System.out.println("MIB module '" + stringArray[2] + "' not found in repository.");
                }
                catch (IOException iOException) {
                    System.out.println("Internal Error: " + iOException.getMessage());
                }
                break;
            }
            case 3: {
                try {
                    MIBObject[] mIBObjectArray = this.repMan.getImportedObjects(stringArray[2]);
                    MIBObject[] mIBObjectArray2 = this.repMan.getObjects(stringArray[2]);
                    this.rep = new MIBRepository(mIBObjectArray2);
                    for (int i5 = 0; i5 < mIBObjectArray.length; ++i5) {
                        this.rep.addObject(mIBObjectArray[i5]);
                    }
                    this.rep.structureChanged();
                    System.out.println("-- MIB " + stringArray[2] + " contains " + mIBObjectArray2.length + " objects.\n");
                    Iterator<MIBModule> iterator = this.rep.modulesIterator();
                    while (iterator.hasNext()) {
                        System.out.println(iterator.next().toSMI(1, this.rep, MIBObject.getLineSeparator()));
                    }
                    break;
                }
                catch (IOException iOException) {
                    System.out.println("MIB module '" + stringArray[2] + "' not found in repository.");
                    System.exit(1);
                    break;
                }
            }
            case 2: {
                try {
                    MIBModule[] mIBModuleArray = this.repMan.getModules();
                    System.out.println("Repository '" + stringArray[0] + "' contains " + mIBModuleArray.length + " MIB module(s):");
                    OrderedMap orderedMap = new OrderedMap(new LexicographicPredicate());
                    for (int i6 = 0; i6 < mIBModuleArray.length; ++i6) {
                        orderedMap.add(mIBModuleArray[i6].getModuleName(), mIBModuleArray[i6]);
                    }
                    Enumeration enumeration = orderedMap.elements();
                    while (enumeration.hasMoreElements()) {
                        MIBModule mIBModule = (MIBModule)enumeration.nextElement();
                        System.out.println(mIBModule.getModuleName());
                        if (mIBModule.getImportsVector() == null) continue;
                        System.out.print("  imports from: ");
                        Vector<MIBImport> vector = mIBModule.getImportsVector();
                        for (int i7 = 0; i7 < vector.size(); ++i7) {
                            System.out.print(((Object)vector.elementAt(i7)).toString());
                            if (i7 + 1 >= vector.size()) continue;
                            System.out.print(", ");
                        }
                        System.out.println();
                    }
                    break;
                }
                catch (IOException iOException) {
                    System.out.println("Internal error: " + iOException.getMessage());
                    break;
                }
            }
            case 4: {
                Object object;
                try {
                    object = this.repMan.getModule(stringArray[2]);
                }
                catch (IOException iOException) {
                    System.out.println("MIB module '" + stringArray[2] + "' not found in repository.");
                    System.exit(1);
                }
                try {
                    Object object2;
                    this.gen.setCheckOnly(false);
                    this.gen.setSimulationMode(false);
                    this.gen.setPersistence(true);
                    this.gen.setMatch(null);
                    this.gen.setVersion(3.3f);
                    this.gen.initRepository(stringArray[2], true);
                    if (stringArray.length > 4) {
                        object = new StringTokenizer(stringArray[4], ",");
                        float f2 = 3.4f;
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            object2 = ((StringTokenizer)object).nextToken();
                            try {
                                f2 = Float.valueOf((String)object2).floatValue();
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (((String)object2).startsWith("SIM")) {
                                    this.gen.setSimulationMode(true);
                                    continue;
                                }
                                if (((String)object2).startsWith("CHECK")) {
                                    this.gen.setCheckOnly(true);
                                    continue;
                                }
                                if (!((String)object2).startsWith("OBJECTS=")) continue;
                                this.gen.setMatch(((String)object2).substring(8));
                            }
                        }
                        this.gen.setVersion(f2);
                    }
                    object = new StringBuffer();
                    StringBuffer stringBuffer = new StringBuffer();
                    object2 = new File(AgentGen.moduleName2FileName(stringArray[2], true));
                    File file2 = new File(AgentGen.moduleName2FileName(stringArray[2], false));
                    this.gen.genCodeForModule(stringArray[2], (File)object2, file2, (StringBuffer)object, stringBuffer, null);
                    if (stringArray.length > 3) {
                        switch (stringArray[3].charAt(0)) {
                            case 'h': {
                                System.out.println(((StringBuffer)object).toString());
                                break block11;
                            }
                            case 'c': {
                                System.out.println(stringBuffer.toString());
                                break block11;
                            }
                        }
                        break;
                    }
                    System.out.println(((StringBuffer)object).toString());
                    System.out.println(stringBuffer.toString());
                    break;
                }
                catch (IOException iOException) {
                    System.out.println("Internal error: " + iOException.getMessage());
                    System.exit(1);
                }
            }
        }
    }

    public static void printCopyright(boolean bl) {
        if (bl) {
            System.out.println("//");
        } else {
            System.out.println();
        }
        if (bl) {
            System.out.print("// ");
        }
        System.out.println("AgentGen Standard v1.8.7  Copyright (C) Frank Fock, All rights reserved");
        try {
            ClassLoader.getSystemClassLoader().loadClass("com.agentpp.agentgen.gui.AgentGenFrame");
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                System.out.print("// ");
            }
            System.out.println("Not for use in a commercial environment");
        }
        if (bl) {
            System.out.println("//");
        } else {
            System.out.println();
        }
    }

    public static void printUsage() {
        System.out.println("Usage: AgentGenConsole <repository> <command> [<par_1>..]");
        System.out.println();
        String[] stringArray = new String[]{"i[init]                       - Initialize the repository (clear all contents).", "a[dd]      <file>             - Add a MIB file to the repository.", "l[oad]     <list>             - Load a list of MIB files into the repository.", "                                File <list> is a newline separated list of file", "                                names. Comment lines start with #.", "r[emove]   <MIB>              - remove a MIB from the repository", "c[ontents]                    - Show contents of the MIB repository.", "m[odule]   <MIB>              - Dump the SMI definition of the given MIB module.", "g[enerate] <MIB> <h|c> [mode] - Generate C++ code for a MIB module, where 'h'", "                                generates the header and 'c' generates the cpp", "                                file.", "                                <mode> is any comma (no spaces!) separated", "                                list of: 'SIM', '<ver>.<rel>', and", "                                'OBJECTS=<regex>'."};
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            System.out.println(stringArray[i2]);
        }
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        AgentGenConsole agentGenConsole = new AgentGenConsole(stringArray);
    }
}

