/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.agenpro;

import com.agentpp.agenpro.AgenProFrame;
import com.agentpp.agenpro.AttributesPanel;
import com.agentpp.agenpro.Generator;
import com.agentpp.agenpro.SimAgent;
import com.agentpp.agenpro.SimAgentPanel_jButtonImport_actionAdapter;
import com.agentpp.agenpro.SimAgentPanel_jButtonSendTrap_actionAdapter;
import com.agentpp.agenpro.SimAgentPanel_jToggleButtonRun_actionAdapter;
import com.agentpp.agenpro.SimAgentPanel_saveDataButton_actionAdapter;
import com.agentpp.agenpro.TrapEntry;
import com.agentpp.agenpro.agent.MIBConfigXML;
import com.agentpp.agenpro.agent.SimAgentIndexPanel;
import com.agentpp.agenpro.agent.SimAgentNotifyCallback;
import com.agentpp.common.FilePanel;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.event.MIBObjectEvent;
import com.agentpp.mib.event.MIBObjectListener;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.snmp.SerializableMIBInstance;
import com.agentpp.snmp.ValueConverter;
import com.agentpp.util.UserConfigFile;
import com.borland.jbcl.layout.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.snmp4j.agent.MOServer;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimAgentPanel
extends JPanel
implements ActionListener,
MIBObjectListener,
SimAgentNotifyCallback {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelButtons = new JPanel();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    JPanel jPanelSettings = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JToggleButton jToggleButtonRun = new JToggleButton();
    JLabel jLabelAddress = new JLabel();
    JTextField jTextFieldParameters = new JTextField();
    FilePanel configFilePanel = new FilePanel();
    JLabel jLabelConfig = new JLabel();
    private SimAgent _$943;
    private UserConfigFile _$436;
    private MIBRepository _$438;
    private RepositoryManager _$15137;
    JLabel jLabelRuntimeCfg = new JLabel();
    FilePanel filePanelSimData = new FilePanel();
    JLabel jLabelRefresh = new JLabel();
    JSlider jSliderRefresh = new JSlider();
    JButton saveDataButton = new JButton();
    JScrollPane jScrollPaneTraps = new JScrollPane();
    DefaultListModel listModel = new DefaultListModel();
    JList jListTraps = new JList();
    JButton jButtonSendTrap = new JButton();
    JButton jButtonImport = new JButton();
    JCheckBox jCheckBoxResetPersistentData = new JCheckBox();
    JLabel jLabelPersistentConfig = new JLabel();
    JTextField jTextFieldPersistentConfigFile = new JTextField();
    private OID _$688 = null;
    private AgenProFrame _$12699;
    private Map<ObjectID, MIBObject> _$18960 = new HashMap<ObjectID, MIBObject>();

    public SimAgentPanel() {
        this(null, null, null, null);
    }

    public SimAgentPanel(UserConfigFile userConfigFile, RepositoryManager repositoryManager, MIBRepository mIBRepository, AgenProFrame agenProFrame) {
        this._$436 = userConfigFile;
        this._$438 = mIBRepository;
        this._$15137 = repositoryManager;
        this._$12699 = agenProFrame;
        try {
            this._$305();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.readConfig();
        this.saveDataButton.setEnabled(false);
        this.jButtonSendTrap.setEnabled(false);
    }

    public SimAgent getAgent() {
        return this._$943;
    }

    public void readConfig() {
        String string = this._$436.get("agenpro.simAgent.parameters", "udp:0.0.0.0/161");
        this.jTextFieldParameters.setText(string);
        String string2 = this._$436.get("agenpro.simAgent.config", "");
        this.configFilePanel.setPath(string2);
        this.filePanelSimData.setPath(this._$436.get("agenpro.simAgent.data", ""));
        this.jSliderRefresh.setValue(this._$436.getInteger("agenpro.simAgent.data.refresh", 10));
        this.jCheckBoxResetPersistentData.setSelected(this._$436.getBoolean("agenpro.simAgent.data.persistent.reset", false));
        this.updateConfigFileDisplay();
    }

    public void saveConfig() {
        this._$436.put("agenpro.simAgent.parameters", this.jTextFieldParameters.getText());
        this._$436.put("agenpro.simAgent.config", this.configFilePanel.getPath());
        this._$436.put("agenpro.simAgent.data", this.filePanelSimData.getPath());
        this._$436.putInteger("agenpro.simAgent.data.refresh", this.jSliderRefresh.getValue());
        this._$436.putBoolean("agenpro.simAgent.data.persistent.reset", this.jCheckBoxResetPersistentData.isSelected());
    }

    private void _$305() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanelButtons.setLayout(this.verticalFlowLayout1);
        this.jPanelSettings.setLayout(this.gridBagLayout1);
        this.jToggleButtonRun.setToolTipText("Starts or stops the simulation agent");
        this.jToggleButtonRun.setActionCommand("Run");
        this.jToggleButtonRun.setText("Start");
        this.jToggleButtonRun.addActionListener(new SimAgentPanel_jToggleButtonRun_actionAdapter(this));
        this.jLabelAddress.setText("Parameters:");
        this.jTextFieldParameters.setToolTipText("Parameters for the agent,i.e. listen addresses");
        this.configFilePanel.setToolTipText("Sets the (security) configuration properties file (default settings apply if empty)");
        this.configFilePanel.setLabelText("");
        this.jLabelConfig.setText("Initial Configuration:");
        this.jLabelRuntimeCfg.setToolTipText("");
        this.jLabelRuntimeCfg.setText("Simulation Data:");
        this.filePanelSimData.setLabelText("");
        this.jLabelRefresh.setText("Simulation Data Refresh:");
        this.jSliderRefresh.setMajorTickSpacing(100);
        this.jSliderRefresh.setMaximum(300);
        this.jSliderRefresh.setMinorTickSpacing(10);
        this.jSliderRefresh.setPaintLabels(true);
        this.jSliderRefresh.setPaintTicks(true);
        this.jSliderRefresh.setToolTipText("Time interval in seconds the config file is checked for modifications to load");
        this.saveDataButton.setToolTipText("Save simulation data to a XML file");
        this.saveDataButton.setActionCommand("saveDataButton");
        this.saveDataButton.setText("Save Data...");
        this.saveDataButton.addActionListener(new SimAgentPanel_saveDataButton_actionAdapter(this));
        this.jButtonSendTrap.setText("Send Notification");
        this.jButtonSendTrap.addActionListener(new SimAgentPanel_jButtonSendTrap_actionAdapter(this));
        this.jButtonImport.setToolTipText("Import simulation properties/data from a snapshot");
        this.jButtonImport.setActionCommand("importSnapshot");
        this.jButtonImport.setText("Import...");
        this.jButtonImport.addActionListener(new SimAgentPanel_jButtonImport_actionAdapter(this));
        this.add((Component)this.jPanelButtons, "West");
        this.add((Component)this.jPanelSettings, "Center");
        this.jPanelButtons.add(this.jToggleButtonRun);
        this.jPanelButtons.add(this.saveDataButton);
        this.jPanelButtons.add(this.jButtonImport);
        this.jTextFieldParameters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimAgentPanel.this.updateConfigFileDisplay();
            }
        });
        this.jTextFieldParameters.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SimAgentPanel.this.updateConfigFileDisplay();
            }
        });
        this.jTextFieldParameters.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SimAgentPanel.this.updateConfigFileDisplay();
            }
        });
        this.jLabelPersistentConfig.setText("MIB Data Config File:");
        this.jTextFieldPersistentConfigFile.setToolTipText("The path to the config file for persistent MIB data defined by the start parameters above");
        this.jCheckBoxResetPersistentData.setText("Reset persistent data");
        this.jCheckBoxResetPersistentData.setToolTipText("If checked, persistent data will not be loaded on start-up but written agent shutdown");
        this.jTextFieldPersistentConfigFile.setEnabled(false);
        this.jTextFieldPersistentConfigFile.setEditable(false);
        this.jPanelSettings.add((Component)this.jTextFieldParameters, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 5, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jLabelAddress, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 5, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jLabelConfig, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jLabelRuntimeCfg, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jSliderRefresh, new GridBagConstraints(1, 4, 2, 2, 1.0, 1.0, 11, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jLabelRefresh, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 12, 0, new Insets(20, 10, 20, 10), 0, 0));
        this.jPanelSettings.add((Component)this.configFilePanel, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 11, 2, new Insets(10, 0, 10, 0), 0, 0));
        this.jPanelSettings.add((Component)this.filePanelSimData, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 11, 2, new Insets(10, 0, 10, 0), 0, 0));
        this.jPanelSettings.add((Component)this.jLabelPersistentConfig, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jTextFieldPersistentConfigFile, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jCheckBoxResetPersistentData, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.jListTraps.setModel(this.listModel);
        this.jScrollPaneTraps.setViewportView(this.jListTraps);
        this.jPanelSettings.add((Component)this.jScrollPaneTraps, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jButtonSendTrap, new GridBagConstraints(0, 5, 1, 1, 0.0, 1.0, 12, 0, new Insets(10, 10, 10, 10), 0, 0));
    }

    public void updateConfigFileDisplay() {
        try {
            Map map = SimAgent.parseCommandLine(this.jTextFieldParameters.getText());
            String string = (String)((List)map.get("c")).get(0);
            string = SimAgent.getConfigFilePath(string);
            File file = new File(string);
            this.jTextFieldPersistentConfigFile.setText(file.getCanonicalPath());
        }
        catch (ParseException parseException) {
            this.jTextFieldPersistentConfigFile.setText("Error in Parameters: " + parseException.getMessage());
        }
        catch (IOException iOException) {
            this.jTextFieldPersistentConfigFile.setText("File error: " + iOException.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.jToggleButtonRun.isSelected()) {
            this.startAgent(null);
        } else {
            this.stopAgent();
        }
    }

    public boolean isAgentRunning() {
        boolean bl = this._$943 != null && this._$943.getAgent() != null && this._$943.getAgent().getState() >= 40;
        this.saveDataButton.setEnabled(bl);
        this.jButtonSendTrap.setEnabled(bl);
        return bl;
    }

    public void stopAgent() {
        if (this._$943 != null) {
            this._$943.stop();
            this._$943 = null;
        }
        this._$18960.clear();
        this.jToggleButtonRun.setSelected(this.isAgentRunning());
    }

    public void startAgent(final Runnable runnable) throws HeadlessException {
        Object object2;
        List<Object> list;
        if (this._$943 != null) {
            this._$943.stop();
        }
        this.saveConfig();
        this._$943 = new SimAgent(this._$436);
        String string = this._$436.get("agenpro.AgentCapabilities", null);
        MIBAgentCaps mIBAgentCaps = null;
        if (string != null) {
            mIBAgentCaps = (MIBAgentCaps)this._$438.getObject(new ObjectID(string));
        }
        if (this._$436.getBoolean("agenpro.UseRepositoryModules", false)) {
            try {
                list = Arrays.asList(this._$15137.getModuleNames());
            }
            catch (IOException iOException) {
                list = this._$436.getArray("agenpro.Modules");
            }
        } else {
            list = this._$436.getArray("agenpro.Modules");
        }
        HashSet<MIBModule> hashSet = new HashSet<MIBModule>();
        final ArrayList<MIBObjectType> arrayList = new ArrayList<MIBObjectType>();
        final ArrayList<MIBObjectType> arrayList2 = new ArrayList<MIBObjectType>();
        final ArrayList<MIBNotifyType> arrayList3 = new ArrayList<MIBNotifyType>();
        final HashMap<MIBObjectType, List<MIBObjectType>> hashMap = new HashMap<MIBObjectType, List<MIBObjectType>>();
        final HashMap hashMap2 = new HashMap();
        this._$18960.clear();
        HashMap hashMap3 = new HashMap();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        if (mIBAgentCaps != null) {
            Generator.determineFilter(this._$15137, this._$438, mIBAgentCaps, hashMap3, arrayList4);
        } else {
            hashMap3 = null;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object2 = this._$438.getModule(((String)list.get(i2)).toString());
            try {
                object2 = Generator.loadFromRepository(i2, (MIBModule)object2, list, this._$15137, this._$438, hashSet);
                arrayList.addAll(Generator.getLeafs(hashMap3, ((MIBModule)object2).objectsByOid().elements(), this._$438));
                arrayList2.addAll(Generator.getTables(hashMap3, ((MIBModule)object2).objectsByOid().elements()));
                hashMap.putAll(Generator.getColumnarObjects(this._$438, hashMap3, ((MIBModule)object2).objectsByOid().elements()));
                hashMap2.putAll(Generator.getIndexes(this._$438, hashMap3, ((MIBModule)object2).objectsByOid().elements()));
                arrayList3.addAll(Generator.getTraps(hashMap3, ((MIBModule)object2).objectsByOid().elements()));
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        SimAgentPanel._$18989(this._$18960, arrayList, arrayList2, arrayList3);
        for (Object object2 : hashMap.values()) {
            SimAgentPanel._$18989(this._$18960, new Collection[]{object2});
        }
        for (Object object2 : hashMap2.values()) {
            SimAgentPanel._$18989(this._$18960, new Collection[]{object2});
        }
        final ProgressMonitor progressMonitor = new ProgressMonitor(this._$12699, "Starting Simulation Agent", "", 0, 100);
        progressMonitor.setMillisToDecideToPopup(10);
        progressMonitor.setMillisToPopup(10);
        object2 = new Thread(new Runnable(){

            public void run() {
                final boolean bl = SimAgentPanel.this._$943.start(progressMonitor, SimAgentPanel.this.jTextFieldParameters.getText(), SimAgentPanel.this.configFilePanel.getPath(), SimAgentPanel.this.filePanelSimData.getPath(), SimAgentPanel.this.jSliderRefresh.getValue(), SimAgentPanel.this._$438, arrayList, arrayList2, hashMap, hashMap2, SimAgentPanel.this.jCheckBoxResetPersistentData.isSelected());
                if (!bl) {
                    if (!progressMonitor.isCanceled()) {
                        JOptionPane.showMessageDialog(SimAgentPanel.this._$12699, new String[]{"The simulation agent could not be started.", "Please see the Log for details."}, "Agent Start Failed", 0);
                    }
                    SimAgentPanel.this.stopAgent();
                } else {
                    SimAgentPanel.this._$436.putBoolean("agenpro.simAgent.data.properties.sync", !SimAgentPanel.this._$943.isConfigXmlRefreshActive() && SimAgentPanel.this._$436.getBoolean("agenpro.simAgent.data.properties.sync", true));
                }
                if (runnable != null) {
                    try {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        progressMonitor.close();
                        if (bl) {
                            SimAgentPanel.this._$18997(arrayList3);
                        }
                        SimAgentPanel.this.jToggleButtonRun.setSelected(SimAgentPanel.this.isAgentRunning());
                    }
                });
            }
        });
        ((Thread)object2).start();
    }

    public MIBObject getSimMIBObject(ObjectID objectID) {
        return this._$18960.get(objectID);
    }

    private static void _$18989(Map<ObjectID, MIBObject> map, Collection<? extends MIBObject> ... collectionArray) {
        for (Collection<? extends MIBObject> collection : collectionArray) {
            for (MIBObject mIBObject : collection) {
                map.put(mIBObject.getOid(), mIBObject);
            }
        }
    }

    private void _$18997(List<MIBNotifyType> list) {
        this.listModel.removeAllElements();
        for (MIBNotifyType mIBNotifyType : list) {
            String string;
            Hashtable hashtable = AttributesPanel.getAllAttributes(mIBNotifyType.getOid(), this._$436);
            if (hashtable == null || !hashtable.containsKey("traps") || (string = (String)hashtable.get("traps")) == null) continue;
            String[] stringArray = string.split("\\|");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.listModel.addElement(new TrapEntry(mIBNotifyType, stringArray[i2]));
            }
        }
    }

    @Override
    public void changedMIBObject(MIBObjectEvent mIBObjectEvent) {
        if (mIBObjectEvent.getType() == 0 && mIBObjectEvent.getObject() != null) {
            try {
                this._$688 = new OID(mIBObjectEvent.getObject().getOid().asIntArray());
            }
            catch (ObjectIDFormatException objectIDFormatException) {}
        } else {
            this._$688 = null;
        }
        if (this._$943 != null && this._$688 != null) {
            this._$943.updateTables(this._$688);
        }
    }

    public void jToggleButtonRun_actionPerformed(ActionEvent actionEvent) {
        this.actionPerformed(actionEvent);
    }

    public void saveDataButton_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser;
        File file = new File(this._$436.get("agenpro.simAgent.data", ""));
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        if ((jFileChooser = new JFileChooser(file)).showSaveDialog(this) == 0) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(jFileChooser.getSelectedFile());
                MIBConfigXML mIBConfigXML = new MIBConfigXML(this._$438, new MOServer[]{this._$943.server});
                mIBConfigXML.writeConfig(fileOutputStream);
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void jButtonSendTrap_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.jListTraps.getSelectedValues();
        if (this._$943 != null && objectArray != null && objectArray.length > 0) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                TrapEntry trapEntry = (TrapEntry)objectArray[i2];
                this._$943.sendNotification(trapEntry.notificationType, trapEntry.trapName, this);
            }
        } else {
            JOptionPane.showMessageDialog(this, new String[]{"To send a trap, please select a template from the list.", "If the list is empty please define one or more 'traps' properties on trap MIB objects", "and restart the agent afterwards. See the manual for details."}, "No Trap Template Selected", 1);
        }
    }

    public void jButtonImport_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        if (this._$688 == null && JOptionPane.showConfirmDialog(this, new String[]{"You have not selected a root MIB node that defines the scope of snapshot objects to be loaded!", "This will potentially overwrite any MIB object of the agent. Do you want to continue anyway?"}, "MIB Node Not Selected", 0, 2) == 1) {
            return;
        }
        if (jFileChooser.showOpenDialog(this) == 0) {
            SnapshotLoader snapshotLoader = new SnapshotLoader(jFileChooser.getSelectedFile(), this._$688);
            snapshotLoader.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$19014(File file, OID oID) {
        FileInputStream fileInputStream = null;
        ProgressMonitor progressMonitor = null;
        this._$436.setDisableChangeEvents(true);
        try {
            fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            List list = (List)objectInputStream.readObject();
            progressMonitor = new ProgressMonitor(this, "Reading snapshot...", "", 0, list.size());
            int n2 = 0;
            int n3 = 0;
            Iterator iterator = list.iterator();
            while (!progressMonitor.isCanceled() && iterator.hasNext()) {
                Cloneable cloneable;
                Object object;
                String[] stringArray;
                Object e2 = iterator.next();
                VariableBinding variableBinding = null;
                ValueConverter valueConverter = null;
                Object var13_16 = null;
                if (e2 instanceof VariableBinding) {
                    variableBinding = (VariableBinding)e2;
                } else if (e2 instanceof SerializableMIBInstance) {
                    stringArray = (String[])e2;
                    valueConverter = stringArray.getValueConverter();
                    object = valueConverter.fromNative(stringArray.getValue());
                    cloneable = null;
                    try {
                        cloneable = new OID(stringArray.getOid().asIntArray());
                        variableBinding = new VariableBinding((OID)cloneable, (Variable)object);
                    }
                    catch (ObjectIDFormatException objectIDFormatException) {
                        // empty catch block
                    }
                }
                if (n2 % 10 == 0) {
                    progressMonitor.setProgress(n2);
                    if (variableBinding != null) {
                        progressMonitor.setNote(variableBinding.getOid().toString());
                    }
                }
                if (variableBinding != null && (oID == null || oID.leftMostCompare(oID.size(), variableBinding.getOid()) == 0) && (stringArray = ValueConverter.toString(this._$438, variableBinding, valueConverter, var13_16)) != null && stringArray[1] != null) {
                    if (stringArray[0] == null) {
                        AttributesPanel.putAttribute(stringArray[2], "value", stringArray[1], this._$436);
                        ++n3;
                    } else {
                        object = stringArray[2].substring(0, stringArray[2].lastIndexOf(46));
                        cloneable = AttributesPanel.getAttributes((String)object, this._$436);
                        String string = (String)cloneable.get("rows");
                        boolean bl = false;
                        if (string != null) {
                            String[] stringArray2 = string.split("\\|");
                            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                                if (!stringArray2[i2].equals(stringArray[0])) continue;
                                bl = true;
                            }
                        }
                        if (!bl) {
                            if (string == null || string.trim().length() == 0) {
                                AttributesPanel.putAttribute((String)object, "rows", stringArray[0], this._$436);
                            } else {
                                AttributesPanel.putAttribute((String)object, "rows", string + "|" + stringArray[0], this._$436);
                            }
                        }
                        AttributesPanel.putAttribute(stringArray[2], "value." + stringArray[0], stringArray[1], this._$436);
                        ++n3;
                    }
                }
                ++n2;
            }
            progressMonitor.close();
            JOptionPane.showMessageDialog(this, new String[]{"Successfully imported " + n3 + " values from", "snapshot '" + file.getName() + "'."}, "Import Complete", 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this._$436.setDisableChangeEvents(false);
            this._$12699.updateNavigationButtons();
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (progressMonitor != null) {
                progressMonitor.close();
            }
        }
    }

    @Override
    public String getNotifyObjectIndex(String string, MIBObjectType mIBObjectType) {
        MIBObjectType mIBObjectType2;
        Hashtable hashtable;
        String string2;
        MIBObject mIBObject = this._$438.getParent(mIBObjectType);
        if (mIBObject instanceof MIBObjectType && (string2 = (String)(hashtable = AttributesPanel.getAttributes(((Object)(mIBObjectType2 = (MIBObjectType)mIBObject).getObjectID()).toString(), this._$436)).get("rows")) != null) {
            String[] stringArray = string2.split("\\|");
            SimAgentIndexPanel simAgentIndexPanel = new SimAgentIndexPanel();
            simAgentIndexPanel.setIndexes(stringArray);
            simAgentIndexPanel.setTrapName(string);
            simAgentIndexPanel.setObjectName(mIBObjectType.getName());
            simAgentIndexPanel.setPreferredSize(new Dimension(350, 200));
            if (JOptionPane.showOptionDialog(this, simAgentIndexPanel, "Select Notification Object Index", 0, -1, null, new String[]{"OK", "Cancel"}, "OK") == 0) {
                String string3 = simAgentIndexPanel.getSelectedIndex();
                return string3;
            }
        }
        return null;
    }

    class SnapshotLoader
    extends Thread {
        private File _$16518;
        private OID _$688;

        public SnapshotLoader(File file, OID oID) {
            this._$16518 = file;
            this._$688 = oID;
        }

        public void run() {
            SimAgentPanel.this._$19014(this._$16518, this._$688);
            if (SimAgentPanel.this._$12699 != null) {
                SimAgentPanel.this._$12699.refresh();
            }
        }
    }
}

