/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.agenpro;

import com.agentpp.agenpro.AttributesPanel;
import com.agentpp.agenpro.SimAgentFactory;
import com.agentpp.agenpro.SimAgentLogFactory;
import com.agentpp.agenpro.SimTable;
import com.agentpp.agenpro.agent.MIBConfigXML;
import com.agentpp.agenpro.agent.SimAgentNotifyCallback;
import com.agentpp.agenpro.agent.SimMOFilter;
import com.agentpp.agenpro.util.AgenUtils;
import com.agentpp.agenpro.util.IndexConverter;
import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.smi.IObjectID;
import com.agentpp.smiparser.SMI;
import com.agentpp.snmp.ValueConverter;
import com.agentpp.util.UserConfigFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.AgentConfigManager;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DefaultMOQuery;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.cfg.EngineBootsCounterFile;
import org.snmp4j.agent.io.DefaultMOPersistenceProvider;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOInputFactory;
import org.snmp4j.agent.io.prop.PropertyMOInput;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PCFactory;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOMutableTableRow;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.ext.AgentppSimulationMib;
import org.snmp4j.agent.mo.util.VariableProvider;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.request.SubRequestIterator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.TransportMappings;
import org.snmp4j.util.ArgumentParser;
import org.snmp4j.util.SimpleOIDTextFormat;
import org.snmp4j.util.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimAgent
implements VariableProvider {
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_ROWS = "rows";
    public static final String ATTR_CONTEXTS = "contexts";
    public static final String ATTR_TRAPS = "traps";
    private LogAdapter _$1229 = LogFactory.getLogger(SimAgent.class);
    protected AgentConfigManager agent;
    protected MOServer server;
    private String _$2380;
    private File _$21175;
    private UserConfigFile _$436;
    private MIBRepository _$438;
    MIBObjectType[] objects;
    SimAgentFactory simFactory = new SimAgentFactory();
    private AgenUtils _$21177;
    private Timer _$21178 = new Timer(true);
    private AgentppSimulationMib _$21179;
    private boolean _$21180;

    public SimAgent(UserConfigFile userConfigFile) {
        this._$436 = userConfigFile;
    }

    public void stop() {
        if (this._$21178 != null) {
            this._$21178.cancel();
            this._$21178 = new Timer(true);
            this._$21180 = false;
        }
        if (this.agent != null) {
            this.agent.shutdown();
            this._$21179 = null;
        }
    }

    public MOServer getServer() {
        return this.server;
    }

    public static Map parseCommandLine(String string) throws ParseException {
        ArgumentParser argumentParser = new ArgumentParser("-c[s{=~Sim.cfg}] -bc[s{=~Sim.bc}] +e[x] +ts[s] +tls-version[s{=TLSv1}<TLSv1[\\.1|\\.2]?[,TLSv1[\\.1|\\.2]?]*>] ", "#address[s{=udp:0.0.0.0/161}<((udp|tcp|tls):)?.*[/[0-9]+]?>] ..");
        Map<String, List<?>> map = null;
        String[] stringArray = string.trim().split(" ");
        if (stringArray == null || stringArray.length == 0 || stringArray.length == 1 && "".equals(stringArray[0])) {
            stringArray = new String[]{"udp:0.0.0.0/161"};
        }
        map = argumentParser.parse(stringArray);
        return map;
    }

    public boolean start(ProgressMonitor progressMonitor, String string, String string2, String string3, int n2, MIBRepository mIBRepository, List<MIBObjectType> list, List<MIBObjectType> list2, Map<MIBObjectType, List<MIBObjectType>> map, Map<MIBObjectType, List<MIBObjectType>> map2, boolean bl) {
        this._$438 = mIBRepository;
        this._$21177 = new AgenUtils(mIBRepository, this._$436, null);
        Map map3 = null;
        try {
            map3 = SimAgent.parseCommandLine(string);
            progressMonitor.setProgress(10);
            this._$10030(map3, string2, bl);
            progressMonitor.setProgress(20);
            SecurityProtocols.getInstance().addDefaultProtocols();
            this.agent.initialize();
            progressMonitor.setProgress(30);
            this.agent.getSysDescr().setValue("AgenPro 4.1.1 Simulation Agent - " + System.getProperty("os.name", "") + " - " + System.getProperty("os.arch") + " - " + System.getProperty("os.version"));
            this._$21179 = new AgentppSimulationMib();
            this._$21179.registerMOs(this.server, new OctetString());
            progressMonitor.setProgress(40);
            if (progressMonitor.isCanceled()) {
                return false;
            }
            this._$21191(mIBRepository, list, list2, map, map2);
            progressMonitor.setProgress(50);
            if (progressMonitor.isCanceled()) {
                return false;
            }
            this.agent.setupProxyForwarder();
            progressMonitor.setProgress(60);
            this.agent.configure();
            if (progressMonitor.isCanceled()) {
                return false;
            }
            progressMonitor.setProgress(70);
            if (!bl) {
                this.agent.restoreState();
            }
            if (progressMonitor.isCanceled()) {
                return false;
            }
            progressMonitor.setProgress(80);
            this.agent.run();
            progressMonitor.setProgress(90);
            if (progressMonitor.isCanceled()) {
                return false;
            }
            if (string3 != null && string3.length() > 0) {
                MIBConfigXML mIBConfigXML = new MIBConfigXML(mIBRepository, new MOServer[]{this.server});
                try {
                    FileInputStream fileInputStream = new FileInputStream(string3);
                    mIBConfigXML.readConfig(fileInputStream, new SimMOFilter());
                    fileInputStream.close();
                    if (n2 > 0) {
                        this._$21178.scheduleAtFixedRate((TimerTask)new RefreshTask(string3), n2 * 1000, (long)(n2 * 1000));
                        this._$21180 = true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            progressMonitor.setProgress(100);
            return true;
        }
        catch (Exception exception) {
            this._$1229.error("Failed to start simulation agent: " + exception.getMessage(), exception);
            return false;
        }
    }

    public boolean isConfigXmlRefreshActive() {
        return this._$21180;
    }

    public static String getConfigFilePath(String string) {
        String string2 = SimAgent._$21199();
        if (string.startsWith("~")) {
            string = string2 + string.substring(1);
        }
        return string;
    }

    private static String _$21199() {
        String string = "" + System.getProperty("user.home") + System.getProperty("file.separator") + "AgenPro";
        return string;
    }

    private boolean _$10030(Map<String, List> map, String string, final boolean bl) {
        InputStream inputStream;
        String string2;
        this._$2380 = (String)map.get("c").get(0);
        String string3 = (String)map.get("bc").get(0);
        this._$2380 = SimAgent.getConfigFilePath(this._$2380);
        if (string3.startsWith("~")) {
            string3 = SimAgent._$21199() + string3.substring(1);
        }
        String string4 = string2 = map.get("tls-version") != null ? (String)map.get("tls-version").get(0) : null;
        if (string2 != null) {
            System.setProperty("org.snmp4j.arg.tlsVersion", string2);
        }
        this._$21175 = new File(string3);
        this.server = new DefaultMOServer();
        MOServer[] mOServerArray = new MOServer[]{this.server};
        if (!(string != null && new File(string).canRead() || this._$2380.toLowerCase().endsWith(".xml"))) {
            inputStream = SimAgentNotifyCallback.class.getResourceAsStream("AgentConfig.properties");
        } else {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                return false;
            }
        }
        final Properties properties = new Properties();
        try {
            if (!this._$2380.toLowerCase().endsWith(".xml")) {
                properties.load(inputStream);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        MOInputFactory mOInputFactory = new MOInputFactory(){

            public MOInput createMOInput() {
                PropertyMOInput propertyMOInput = new PropertyMOInput(properties, SimAgent.this, new SimpleOIDTextFormat());
                return propertyMOInput;
            }
        };
        FileInputStream fileInputStream = null;
        if (map.containsKey("ts")) {
            try {
                fileInputStream = new FileInputStream((String)ArgumentParser.getValue(map, "ts", 0));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        Properties properties2 = new Properties();
        if (fileInputStream != null) {
            try {
                properties2.load(fileInputStream);
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        MessageDispatcherImpl messageDispatcherImpl = new MessageDispatcherImpl();
        try {
            this.addListenAddresses(messageDispatcherImpl, map.get("address"));
        }
        catch (Exception exception) {
            this._$1229.error((Serializable)((Object)("Could not bind listen addresses " + map.get("address") + ": " + exception.getMessage())));
            throw new RuntimeException(exception);
        }
        OctetString octetString = null;
        if (map.containsKey("e")) {
            octetString = OctetString.fromHexString((String)ArgumentParser.getValue(map, "e", 0));
        }
        this.agent = new AgentConfigManager(octetString != null ? octetString : new OctetString(MPv3.createLocalEngineID()), messageDispatcherImpl, null, mOServerArray, ThreadPool.create("SampleAgent", 3), mOInputFactory, new DefaultMOPersistenceProvider(mOServerArray, this._$2380), new EngineBootsCounterFile(this._$21175)){

            public void configure() {
                if (SimAgent.this._$2380.toLowerCase().endsWith(".xml")) {
                    MIBConfigXML mIBConfigXML = new MIBConfigXML(SimAgent.this._$438, new MOServer[]{SimAgent.this.server});
                    mIBConfigXML.readConfig(inputStream, new SimMOFilter());
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                super.configure();
            }

            public boolean restoreState() {
                if (bl) {
                    this.runState.advanceState(30);
                    return true;
                }
                return super.restoreState();
            }
        };
        this.agent.setTableSizeLimits(properties2);
        this.agent.setPersistenceImportMode(2);
        return true;
    }

    protected void addListenAddresses(MessageDispatcher messageDispatcher, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Address address = GenericAddress.parse((String)iterator.next());
            TransportMapping<? extends Address> transportMapping = TransportMappings.getInstance().createTransportMapping(address);
            if (transportMapping != null) {
                messageDispatcher.addTransportMapping(transportMapping);
                continue;
            }
            this._$1229.warn((Serializable)((Object)("No transport mapping available for address '" + address + "'.")));
        }
    }

    @Override
    public Variable getVariable(String string) {
        OID oID;
        OctetString octetString = null;
        int n2 = string.indexOf(58);
        if (n2 >= 0) {
            octetString = new OctetString(string.substring(0, n2));
            oID = new OID(string.substring(n2 + 1, string.length()));
        } else {
            oID = new OID(string);
        }
        final DefaultMOContextScope defaultMOContextScope = new DefaultMOContextScope(octetString, oID, true, oID, true);
        DefaultMOQuery defaultMOQuery = new DefaultMOQuery(defaultMOContextScope, false);
        ManagedObject managedObject = this.server.lookup(defaultMOQuery);
        if (managedObject != null) {
            final VariableBinding variableBinding = new VariableBinding(oID);
            final RequestStatus requestStatus = new RequestStatus();
            SubRequest subRequest = new SubRequest(){
                private boolean _$3101;
                private MOQuery _$3094;

                public boolean hasError() {
                    return false;
                }

                public void setErrorStatus(int n2) {
                    requestStatus.setErrorStatus(n2);
                }

                public int getErrorStatus() {
                    return requestStatus.getErrorStatus();
                }

                public RequestStatus getStatus() {
                    return requestStatus;
                }

                public MOScope getScope() {
                    return defaultMOContextScope;
                }

                public VariableBinding getVariableBinding() {
                    return variableBinding;
                }

                public Request getRequest() {
                    return null;
                }

                public Object getUndoValue() {
                    return null;
                }

                public void setUndoValue(Object object) {
                }

                public void completed() {
                    this._$3101 = true;
                }

                public boolean isComplete() {
                    return this._$3101;
                }

                public void setTargetMO(ManagedObject managedObject) {
                }

                public ManagedObject getTargetMO() {
                    return null;
                }

                public int getIndex() {
                    return 0;
                }

                public void setQuery(MOQuery mOQuery) {
                    this._$3094 = mOQuery;
                }

                public MOQuery getQuery() {
                    return this._$3094;
                }

                public SubRequestIterator repetitions() {
                    return null;
                }

                public void updateNextRepetition() {
                }

                public Object getUserObject() {
                    return null;
                }

                public void setUserObject(Object object) {
                }
            };
            managedObject.get(subRequest);
            return variableBinding.getVariable();
        }
        return null;
    }

    private void _$21191(MIBRepository mIBRepository, List<MIBObjectType> list, List<MIBObjectType> list2, Map<MIBObjectType, List<MIBObjectType>> map, Map<MIBObjectType, List<MIBObjectType>> map2) {
        Object object;
        Object object2;
        for (MIBObjectType mIBObjectType : list) {
            try {
                object2 = this._$18323(mIBObjectType.getOid().asIntArray());
                for (int i2 = 0; i2 < ((OctetString[])object2).length; ++i2) {
                    object = new SimMOScalar(mIBObjectType);
                    this._$21230((ManagedObject)object, ((MOScalar)object).getOid(), object2[i2]);
                    if (this.server.isContextSupported(object2[i2])) continue;
                    this.server.addContext(object2[i2]);
                }
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                this._$1229.warn((Serializable)((Object)objectIDFormatException.getMessage()));
            }
        }
        for (MIBObjectType mIBObjectType : list2) {
            try {
                Object object3;
                Comparable comparable;
                Comparable<Variable> comparable2;
                Object object4;
                object2 = new OID(mIBObjectType.getOid().asIntArray());
                List<MIBObjectType> list3 = map.get(mIBObjectType);
                object = map2.get(mIBObjectType);
                MOTableSubIndex[] mOTableSubIndexArray = new MOTableSubIndex[object.size()];
                for (int i3 = 0; i3 < mOTableSubIndexArray.length; ++i3) {
                    object4 = (MIBObjectType)object.get(i3);
                    comparable2 = new OID(((MIBObject)object4).getOid().asIntArray());
                    comparable = mIBRepository.getEffectiveSyntax(((MIBObjectType)object4).getSyntax());
                    object3 = new ValueConverter((MIBObjectType)object4, ((MIBTextualConvention)comparable).getSyntax(), ((MIBTextualConvention)comparable).getDisplayHint());
                    int n2 = ((ValueConverter)object3).getSMISyntax();
                    mOTableSubIndexArray[i3] = SMI.isNumeric(((MIBTextualConvention)comparable).getSyntax().getSyntax()) ? this.simFactory.createSubIndex((OID)comparable2, ValueConverter.getSnmpSyntax(n2), 1, 1) : ("IpAddress".equals(((MIBTextualConvention)comparable).getSyntax().getSyntax()) ? this.simFactory.createSubIndex((OID)comparable2, 64, 4, 4) : ("NetworkAddress".equals(((MIBTextualConvention)comparable).getSyntax().getSyntax()) ? this.simFactory.createSubIndex((OID)comparable2, 64, 5, 5) : (((MIBTextualConvention)comparable).getSyntax().hasRanges() ? this.simFactory.createSubIndex((OID)comparable2, ValueConverter.getSnmpSyntax(n2), (int)((MIBObjectType)object4).getSyntax().getMinOfRanges(), (int)((MIBObjectType)object4).getSyntax().getMaxOfRanges()) : this.simFactory.createSubIndex((OID)comparable2, ValueConverter.getSnmpSyntax(n2), 0, 128))));
                }
                MOColumn[] mOColumnArray = new MOColumn[list3.size()];
                for (int i4 = 0; i4 < mOColumnArray.length; ++i4) {
                    comparable2 = list3.get(i4);
                    comparable = new OID(((MIBObject)comparable2).getOid().asIntArray());
                    object3 = mIBRepository.getEffectiveSyntax(((MIBObjectType)comparable2).getSyntax());
                    ValueConverter valueConverter = new ValueConverter((MIBObjectType)comparable2, ((MIBTextualConvention)object3).getSyntax(), ((MIBTextualConvention)object3).getDisplayHint());
                    mOColumnArray[i4] = ((MIBObjectType)comparable2).getSyntax().getType() == 3 ? this.simFactory.createColumn(((OID)comparable).last(), ValueConverter.getSnmpSyntax(valueConverter.getSMISyntax()), this.simFactory.createAccess(SimAgent._$812(comparable2)), this._$19087((MIBObjectType)comparable2), true, mIBRepository.getModuleName(object3), ((MIBObject)object3).getName()) : this.simFactory.createColumn(((OID)comparable).last(), ValueConverter.getSnmpSyntax(valueConverter.getSMISyntax()), this.simFactory.createAccess(SimAgent._$812(comparable2)), this._$19087((MIBObjectType)comparable2), true);
                }
                object4 = this.simFactory.createIndex(mOTableSubIndexArray, mIBObjectType.getIndexPart().isImplied());
                comparable2 = this._$18323(((OID)object2).getValue());
                for (int i5 = 0; i5 < ((Comparable<Variable>)comparable2).length; ++i5) {
                    object3 = this.simFactory.createTable((OID)object2, (MOTableIndex)object4, mOColumnArray);
                    ((MOMutableTableModel)object3.getModel()).setRowFactory(new DefaultMOMutableRow2PCFactory());
                    this._$21245((MOTable)object3);
                    this._$21230((ManagedObject)object3, (OID)object2, (OctetString)comparable2[i5]);
                    if (this.server.isContextSupported((OctetString)comparable2[i5])) continue;
                    this.server.addContext((OctetString)comparable2[i5]);
                }
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                this._$1229.error((Serializable)((Object)objectIDFormatException.getMessage()));
            }
        }
    }

    private OctetString[] _$18323(int[] nArray) {
        Hashtable hashtable = AttributesPanel.getAllAttributes(new ObjectID(nArray), this._$436);
        String string = (String)hashtable.get(ATTR_CONTEXTS);
        if (string != null) {
            String[] stringArray = string.split("\\|");
            OctetString[] octetStringArray = new OctetString[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2] == null || "*".equals(stringArray[i2])) continue;
                octetStringArray[i2] = new OctetString(stringArray[i2]);
            }
            return octetStringArray;
        }
        return new OctetString[1];
    }

    private void _$21230(ManagedObject managedObject, OID oID, OctetString octetString) {
        try {
            this.server.register(managedObject, octetString);
        }
        catch (DuplicateRegistrationException duplicateRegistrationException) {
            this._$1229.warn((Serializable)((Object)("Duplicate registration of OID '" + oID + "'")));
        }
    }

    private void _$21245(MOTable mOTable) {
        String string;
        ObjectID objectID = new ObjectID(mOTable.getOID().toIntArray());
        Hashtable hashtable = AttributesPanel.getAllAttributes(objectID, this._$436);
        if (hashtable != null && hashtable.containsKey(ATTR_ROWS) && (string = (String)hashtable.get(ATTR_ROWS)) != null) {
            MIBObject mIBObject = this._$438.getObject(objectID);
            if (!(mIBObject instanceof MIBObjectType)) {
                return;
            }
            MIBObjectType mIBObjectType = (MIBObjectType)mIBObject;
            if (mIBObjectType == null || !mIBObjectType.isTable()) {
                return;
            }
            Set<OID> set = this._$16366(mOTable, objectID, string, mIBObjectType);
            for (OID oID : ((SimTable)mOTable).getConfiguredRowIndexes()) {
                if (set.contains(oID)) continue;
                mOTable.removeRow(oID);
            }
            ((SimTable)mOTable).setConfiguredRowIndexes(set);
        }
    }

    private Set<OID> _$16366(MOTable mOTable, ObjectID objectID, String string, MIBObjectType mIBObjectType) {
        MIBIndexPart mIBIndexPart = mIBObjectType.getIndexPart();
        IndexStruct[] indexStructArray = mIBIndexPart.getIndexStruct(this._$438);
        ValueConverter[] valueConverterArray = IndexConverter.getIndexValueConverter(this._$438, mIBObjectType);
        String[] stringArray = string.split("\\|");
        HashSet<OID> hashSet = new HashSet<OID>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            OID oID = null;
            ObjectID objectID2 = new ObjectID(string2);
            if (!objectID2.isValid()) {
                String[] stringArray2 = objectID2.toString().split(";");
                if (stringArray2.length == valueConverterArray.length) {
                    oID = SimAgent.getIndexOID(stringArray2, valueConverterArray, indexStructArray);
                } else {
                    this._$1229.error((Serializable)((Object)("The number of sub-index values for table '" + objectID + "' is " + stringArray2.length + " which does " + "not match required " + valueConverterArray.length + " with the value '" + objectID2 + "' in rows '" + string + "'")));
                }
            } else {
                try {
                    oID = new OID(objectID2.asIntArray());
                }
                catch (ObjectIDFormatException objectIDFormatException) {
                    objectIDFormatException.printStackTrace();
                }
            }
            if (oID == null) continue;
            hashSet.add(oID);
            this._$21251(mOTable, oID, mIBObjectType, string2);
        }
        return hashSet;
    }

    private void _$21251(MOTable mOTable, OID oID, MIBObjectType mIBObjectType, String string) {
        Object r2;
        if (!mOTable.getModel().containsRow(oID)) {
            r2 = mOTable.createRow(oID);
            mOTable.addRow(r2);
        } else {
            r2 = mOTable.getModel().getRow(oID);
        }
        if (r2 != null && r2 instanceof MOMutableTableRow) {
            OctetString[] octetStringArray = this.server.getRegisteredContexts(mOTable);
            MOMutableTableRow mOMutableTableRow = (MOMutableTableRow)r2;
            Vector<? extends MIBObjectType> vector = this._$438.getColumnarObjectsOfTable(mIBObjectType, false, true);
            if (vector != null && vector.size() > 0) {
                for (int i2 = 0; i2 < vector.size(); ++i2) {
                    Variable variable = this._$21254((MIBObjectType)vector.get(i2), string, octetStringArray);
                    if (variable == null) continue;
                    mOMutableTableRow.setValue(i2, variable);
                }
            }
        }
    }

    public static OID getIndexOID(String[] stringArray, ValueConverter[] valueConverterArray, IndexStruct[] indexStructArray) {
        String string = new String();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Comparable comparable;
            Variable variable;
            if (valueConverterArray[i2].getDisplayHint() != null) {
                variable = valueConverterArray[i2].fromString(stringArray[i2]);
                if (variable instanceof OctetString) {
                    if (indexStructArray[i2].impliedLength) {
                        string = string + "." + ObjectID.asOID(((OctetString)variable).getValue());
                        continue;
                    }
                    comparable = ObjectID.asOID(((OctetString)variable).getValue());
                    if (((ObjectID)comparable).size() > 0) {
                        string = string + "." + ((ObjectID)comparable).size() + "." + ((ObjectID)comparable).toString();
                        continue;
                    }
                    string = string + ".0";
                    continue;
                }
                if (variable instanceof OID) {
                    if (indexStructArray[i2].impliedLength) {
                        string = string + "." + ((Object)variable).toString();
                        continue;
                    }
                    comparable = (OID)variable;
                    if (((OID)comparable).size() > 0) {
                        string = string + "." + ((OID)comparable).size() + "." + ((OID)comparable).toString();
                        continue;
                    }
                    string = string + ".0";
                    continue;
                }
                string = string + "." + stringArray[i2];
                continue;
            }
            if (indexStructArray[i2].baseType == 1) {
                variable = (OctetString)valueConverterArray[i2].fromNative(stringArray[i2]);
                if (indexStructArray[i2].impliedLength) {
                    string = string + "." + ObjectID.asOID(((OctetString)variable).getValue());
                    continue;
                }
                comparable = ObjectID.asOID(((OctetString)variable).getValue());
                if (((ObjectID)comparable).size() > 0) {
                    string = string + "." + ((ObjectID)comparable).size() + "." + ((ObjectID)comparable).toString();
                    continue;
                }
                string = string + ".0";
                continue;
            }
            if (indexStructArray[i2].baseType == 3) {
                variable = (OID)valueConverterArray[i2].fromNative(stringArray[i2]);
                if (indexStructArray[i2].impliedLength) {
                    string = string + "." + ((OID)variable).toString();
                    continue;
                }
                if (((OID)variable).size() > 0) {
                    string = string + "." + ((OID)variable).size() + "." + ((OID)variable).toString();
                    continue;
                }
                string = string + ".0";
                continue;
            }
            string = string + "." + stringArray[i2];
        }
        if (string.length() > 0) {
            return new OID(string.substring(1));
        }
        return new OID();
    }

    private static int _$812(MIBObjectType mIBObjectType) {
        int n2 = SMI.accessType(mIBObjectType.getAccess());
        switch (n2) {
            case 5: {
                return 8;
            }
            case 3: {
                return 15;
            }
            case 2: {
                return 11;
            }
        }
        return 11;
    }

    private Variable _$21262(MIBObjectType mIBObjectType) {
        MIBTextualConvention mIBTextualConvention = this._$438.getEffectiveSyntax(mIBObjectType.getSyntax());
        ValueConverter valueConverter = new ValueConverter(mIBObjectType, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
        Hashtable hashtable = AttributesPanel.getAllAttributes(mIBObjectType.getOid(), this._$436);
        String string = (String)hashtable.get(ATTR_VALUE);
        Variable variable = null;
        variable = string != null ? valueConverter.fromString(string) : ValueConverter.getDefaultValue(this._$438, mIBObjectType, mIBTextualConvention.getSyntax());
        if (variable == null) {
            variable = valueConverter.fromNative(valueConverter.getNativeExample());
        }
        return variable;
    }

    private Variable _$19087(MIBObjectType mIBObjectType) {
        MIBTextualConvention mIBTextualConvention = this._$438.getEffectiveSyntax(mIBObjectType.getSyntax());
        ValueConverter valueConverter = new ValueConverter(mIBObjectType, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
        Variable variable = ValueConverter.getDefaultValue(this._$438, mIBObjectType, mIBTextualConvention.getSyntax());
        if (variable == null) {
            variable = valueConverter.fromNative(valueConverter.getNativeExample());
        }
        return variable;
    }

    private Variable _$21254(MIBObjectType mIBObjectType, String string, OctetString[] octetStringArray) {
        Hashtable hashtable = AttributesPanel.getAllAttributes(mIBObjectType.getOid(), this._$436);
        for (int i2 = 0; i2 < octetStringArray.length; ++i2) {
            String string2 = ATTR_VALUE;
            if (octetStringArray[i2] != null) {
                string2 = string2 + "[" + octetStringArray[i2] + "]";
            }
            if (string != null) {
                string2 = string2 + "." + string;
            }
            if (hashtable == null || !hashtable.containsKey(string2)) continue;
            MIBTextualConvention mIBTextualConvention = this._$438.getEffectiveSyntax(mIBObjectType.getSyntax());
            ValueConverter valueConverter = new ValueConverter(mIBObjectType, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
            String string3 = (String)hashtable.get(string2);
            if (string3 == null) continue;
            return valueConverter.fromString(string3);
        }
        return null;
    }

    public void updateTables(OID oID) {
        for (SimTable simTable : this.simFactory.getTables()) {
            if (!oID.startsWith(simTable.getOID().trim()) || !this._$436.getBoolean("agenpro.simAgent.data.properties.sync", true)) continue;
            this._$21245(simTable);
        }
    }

    public void sendNotification(MIBNotifyType mIBNotifyType, String string, SimAgentNotifyCallback simAgentNotifyCallback) {
        List<IObjectID> list = this._$21177.getNotificationObjects(mIBNotifyType, string);
        VariableBinding[] variableBindingArray = new VariableBinding[list.size()];
        int n2 = 0;
        for (IObjectID iObjectID : list) {
            Variable variable;
            if (iObjectID == null) {
                this._$1229.error((Serializable)((Object)("Instance OID for trap '" + string + "' is not specified," + " failed to sent notification " + mIBNotifyType.getName())));
                return;
            }
            OID oID = null;
            boolean bl = iObjectID.isValid();
            Variable variable2 = variable = !bl ? null : this.getVariable(((Object)iObjectID).toString());
            if (variable == null) {
                MIBObject mIBObject;
                if (!bl && "?".equals(iObjectID.getLastSubIdentifier())) {
                    iObjectID = new ObjectID(iObjectID.trim());
                }
                if ((mIBObject = this._$438.getObject(new ObjectID(iObjectID))) != null) {
                    MIBObject mIBObject2 = this._$438.getParent(mIBObject);
                    if (simAgentNotifyCallback != null && mIBObject instanceof MIBObjectType && mIBObject2 instanceof MIBObjectType) {
                        String string2 = simAgentNotifyCallback.getNotifyObjectIndex(string, (MIBObjectType)mIBObject);
                        oID = this._$21177.getIndexOID((MIBObjectType)this._$438.getParent(mIBObject), string2);
                        try {
                            oID = new OID(mIBObject.getOid().asIntArray(), oID.getValue());
                        }
                        catch (ObjectIDFormatException objectIDFormatException) {
                            oID = null;
                        }
                    }
                    if (oID == null) {
                        this._$1229.warn((Serializable)((Object)("Instance OID for trap '" + string + "' not entered by user," + " sending notification " + mIBNotifyType.getName() + " canceled")));
                        return;
                    }
                    variable = this.getVariable(oID.toString());
                }
            } else {
                oID = new OID(((Object)iObjectID).toString());
            }
            variableBindingArray[n2] = variable != null ? new VariableBinding(oID, variable) : new VariableBinding(oID, new Null());
            ++n2;
        }
        try {
            this.agent.getNotificationOriginator().notify(new OctetString(), new OID(mIBNotifyType.getOid().asIntArray()), variableBindingArray);
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            objectIDFormatException.printStackTrace();
        }
    }

    public AgentConfigManager getAgent() {
        return this.agent;
    }

    static {
        LogFactory.setLogFactory(new SimAgentLogFactory());
    }

    class RefreshTask
    extends TimerTask {
        private long _$21267 = 0L;
        private String _$645;
        private SimMOFilter _$18785 = new SimMOFilter();

        public RefreshTask(String string) {
            this._$645 = string;
        }

        public void run() {
            MIBConfigXML mIBConfigXML = new MIBConfigXML(SimAgent.this._$438, new MOServer[]{SimAgent.this.server});
            try {
                File file = new File(this._$645);
                if (file.canRead() && file.isFile() && file.lastModified() > this._$21267) {
                    SimAgent.this._$1229.info("Updating simulation data from '" + this._$645 + "'");
                    FileInputStream fileInputStream = new FileInputStream(this._$645);
                    mIBConfigXML.readConfig(fileInputStream, this._$18785);
                    fileInputStream.close();
                    this._$21267 = System.currentTimeMillis();
                } else if (SimAgent.this._$1229.isDebugEnabled()) {
                    SimAgent.this._$1229.debug((Serializable)((Object)("No simulation data update available from '" + this._$645 + "'")));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public class SimMOScalar
    extends MOScalar {
        private MIBObjectType _$21229;

        SimMOScalar(MIBObjectType mIBObjectType) throws ObjectIDFormatException {
            super(new OID(mIBObjectType.getOid().asIntArray()).append(0), SimAgent.this.simFactory.createAccess(SimAgent._$812(mIBObjectType)), SimAgent.this._$21262(mIBObjectType));
            this._$21229 = mIBObjectType;
        }

        public Variable getValue() {
            if (SimAgent.this._$436.getBoolean("agenpro.simAgent.data.properties.sync", true)) {
                OctetString[] octetStringArray = SimAgent.this.server.getRegisteredContexts(this);
                Variable variable = SimAgent.this._$21254(this._$21229, null, octetStringArray);
                if (variable == null) {
                    return super.getValue();
                }
                return variable;
            }
            return super.getValue();
        }
    }
}

