/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.agenpro;

import com.agentpp.agenpro.AgenProFrame;
import com.agentpp.common.TableSorter;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.PopupListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.commons.util.UserCodeParser;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.event.MIBObjectEvent;
import com.agentpp.mib.event.MIBObjectListener;
import com.agentpp.util.UserConfigFile;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCEditCellEvent;
import com.klg.jclass.table.JCEditCellListener;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.TablePopupMenu;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class AttributesPanel
extends JPanel
implements MIBObjectListener,
JCEditCellListener,
JCSelectListener,
JCCellDisplayListener,
ActionListener {
    private static final Logger _$417 = Logger.getLogger("Attributes");
    public static final String[] COLUMNS = new String[]{"Root", "Key", "Value", "Description"};
    public static final int COL_OID = 0;
    public static final int COL_NAME = 1;
    public static final int COL_VALUE = 2;
    public static final int COL_DESCR = 3;
    public static final int[] COLUMN_WIDTHS = new int[]{50, 50, 50, 100};
    public static final String POPUP_DESCR = "Description";
    public static final String POPUP_DUPLICATE = "Duplicate";
    public static final String POPUP_ENABLE = "Enable";
    public static final String POPUP_DISABLE = "Disable";
    BorderLayout borderLayout1 = new BorderLayout();
    private JCEditableVectorDataSource _$432 = new JCEditableVectorDataSource();
    private TableSorter _$15278;
    private UserConfigFile _$436;
    private MIBRepository _$438;
    private JCCellStyle _$18668;
    private ObjectID _$16590;
    private JPanel _$20301 = new JPanel();
    private JButton _$20302 = new JButton();
    private JButton _$12231 = new JButton();
    private VerticalFlowLayout _$14011 = new VerticalFlowLayout();
    Border border1;
    Border border2;
    JPanel jPanelCenter = new JPanel();
    private JButton _$16171 = new JButton();
    private JButton _$16170 = new JButton();
    private PopupListTable _$399 = new ExtendedListTable(){

        public boolean isPopupAllowed(int n2, int n3) {
            TablePopupMenu tablePopupMenu = super.getPopupMenu();
            int n4 = TableUtils.getFirstSelectedRow(AttributesPanel.this._$399);
            if (n4 >= 0 && AttributesPanel.this._$399.getDataView().getTableDataItem(n4, 3) != null) {
                tablePopupMenu.getComponent(0).setEnabled(true);
            } else {
                tablePopupMenu.getComponent(0).setEnabled(false);
            }
            return true;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            JCCellPosition jCCellPosition = this.XYToCell(mouseEvent.getX(), mouseEvent.getY());
            if (jCCellPosition.column == -1) {
                try {
                    if (jCCellPosition.row >= 0) {
                        return AttributesPanel.this._$432.getTableRowLabel(jCCellPosition.row).toString();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (jCCellPosition.column < 0 || jCCellPosition.row < 0) {
                return null;
            }
            try {
                return AttributesPanel.this._$432.getTableDataItem(jCCellPosition.row, jCCellPosition.column).toString();
            }
            catch (Exception exception) {
                return null;
            }
        }
    };
    BorderLayout borderLayout2 = new BorderLayout();
    JButton jButtonRemoveAll = new JButton();
    private boolean _$13934 = false;
    private JButton _$20303 = new JButton();

    public AttributesPanel(UserConfigFile userConfigFile, MIBRepository mIBRepository) {
        this._$436 = userConfigFile;
        this._$438 = mIBRepository;
        this._$432.setNumColumns(COLUMNS.length);
        this._$432.setColumnLabels(COLUMNS);
        this._$432.setNumRows(0);
        this._$399.setDataSource(this._$432);
        this._$399.setRowLabelDisplay(true);
        this._$399.setSelectionPolicy(2);
        this._$399.setColumnHidden(3, true);
        this._$399.setFrozenRowPlacement(3);
        this._$399.setRowLabelDisplay(false);
        this._$399.setPopupMenuEnabled(true);
        TablePopupMenu tablePopupMenu = this._$399.getPopupMenu();
        tablePopupMenu.addItem(POPUP_DESCR, this);
        tablePopupMenu.add(new JSeparator());
        tablePopupMenu.addItem(POPUP_ENABLE, this);
        tablePopupMenu.addItem(POPUP_DISABLE, this);
        this._$15278 = new TableSorter(this._$399, this._$432);
        this._$15278.setFrozenColumn(1);
        this._$15278.addSortColumn(0);
        this._$15278.addSortColumn(1);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$20304();
        ToolTipManager.sharedInstance().registerComponent(this._$399);
        this._$399.addSelectListener(this);
        this._$399.addCellDisplayListener(this);
        this._$399.addEditCellListener(this);
        this.updateButtons();
    }

    public AttributesPanel() {
        this(null, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block6: {
            block7: {
                block5: {
                    int n2 = TableUtils.getFirstSelectedRow(this._$399);
                    if (n2 < 0) {
                        return;
                    }
                    if (!actionEvent.getActionCommand().equals(POPUP_DESCR)) break block5;
                    String string = (String)this._$432.getTableDataItem(n2, 1);
                    String string2 = (String)this._$432.getTableDataItem(n2, 3);
                    if (string2 == null) {
                        JOptionPane.showMessageDialog(this, "There is no description for '" + string + "' available!", "Description Not Found", 0);
                    } else {
                        JOptionPane.showMessageDialog(this, string2, string + " Description", 1);
                    }
                    break block6;
                }
                if (!actionEvent.getActionCommand().equals(POPUP_ENABLE)) break block7;
                int[] nArray = TableUtils.getSelectedRows(this._$399);
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    this._$432.setTableDataItem("yes", nArray[i2], 2);
                }
                break block6;
            }
            if (!actionEvent.getActionCommand().equals(POPUP_DISABLE)) break block6;
            int[] nArray = TableUtils.getSelectedRows(this._$399);
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                this._$432.setTableDataItem("no", nArray[i3], 2);
            }
        }
    }

    private void _$20304() {
        this._$18668 = new JCCellStyle(this._$399.getDefaultCellStyle());
        this._$18668.setEditable(false);
        this._$18668.setBackground(Color.lightGray);
        this._$399.setCellStyle(-997, 0, this._$18668);
        for (int i2 = 0; i2 < COLUMNS.length; ++i2) {
            int n2 = this._$436.getInteger("agenpro.properties.column.size." + i2, 33002);
            this._$399.setPixelWidth(i2, n2);
        }
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.border2 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setLayout(this.borderLayout1);
        this._$20301.setLayout(this._$14011);
        this._$20302.setIcon(AgenProFrame.imageAdd16);
        this._$20302.setToolTipText("Add a new attribute to this MIB object");
        this._$20302.setHorizontalAlignment(2);
        this._$20302.setText("Add");
        this._$20302.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributesPanel.this.jButtonAdd_actionPerformed(actionEvent);
            }
        });
        this._$12231.setIcon(AgenProFrame.imageRemove16);
        this._$12231.setToolTipText("Remove selected properties from this MIB object");
        this._$12231.setHorizontalAlignment(2);
        this._$12231.setText("Remove");
        this._$12231.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributesPanel.this.jButtonRemove_actionPerformed(actionEvent);
            }
        });
        this._$20301.setBorder(this.border2);
        this.jPanelCenter.setLayout(this.borderLayout2);
        this._$16171.setIcon(AgenProFrame.imageImport16);
        this._$16171.setToolTipText("Import properties from a properties file");
        this._$16171.setHorizontalAlignment(2);
        this._$16171.setText("Import");
        this._$16171.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributesPanel.this.jButtonImport_actionPerformed(actionEvent);
            }
        });
        this._$16170.setIcon(AgenProFrame.imageExport16);
        this._$16170.setToolTipText("Export properties defined for this node to a properties file");
        this._$16170.setHorizontalAlignment(2);
        this._$16170.setText("Export");
        this._$16170.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributesPanel.this.jButtonExport_actionPerformed(actionEvent);
            }
        });
        this._$399.setBorder(this.border1);
        this.jButtonRemoveAll.setToolTipText("Removes all properties defined for this node");
        this.jButtonRemoveAll.setIcon(AgenProFrame.imageDelete16);
        this.jButtonRemoveAll.setText("Remove All");
        this.jButtonRemoveAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributesPanel.this.jButtonRemoveAll_actionPerformed(actionEvent);
            }
        });
        this._$20303.setIcon(AgenProFrame.imageProperties16);
        this._$20303.setToolTipText("Read properties from an existing source (implementation) file");
        this._$20303.setText("From Source");
        this._$20303.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributesPanel.this.jButtonFromSource_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this._$20301, "West");
        this._$20301.add((Component)this._$20302, null);
        this._$20301.add((Component)this._$12231, null);
        this._$20301.add((Component)this.jButtonRemoveAll, null);
        this._$20301.add((Component)this._$16171, null);
        this._$20301.add((Component)this._$16170, null);
        this._$20301.add((Component)this._$20303, null);
        this.add((Component)this.jPanelCenter, "Center");
        this.jPanelCenter.add((Component)this._$399, "Center");
    }

    public void loadAttributes(ObjectID objectID) {
        this._$432.setNumRows(0);
        this._$399.setRepaintEnabled(false);
        this._$399.setCellStyle(-997, -997, this._$399.getDefaultCellStyle());
        this._$399.setCellStyle(-997, 0, this._$18668);
        if (objectID != null) {
            this._$20311(objectID, false);
            this._$20312(objectID);
        }
        this._$15278.sort();
        this._$399.setRepaintEnabled(true);
        for (int i2 = this._$399.getDataView().getNumRows() - 1; i2 >= 0; --i2) {
            if (i2 != 0 && (this._$399.getCellStyle(i2 - 1, 1).isEditable() || !this._$399.getCellStyle(i2, 1).isEditable())) continue;
            this._$399.traverse(i2, 1, false, true);
            break;
        }
        this._$13934 = true;
    }

    private boolean _$20313(String string) {
        for (int i2 = 0; i2 < this._$432.getNumRows(); ++i2) {
            if (!string.equals(this._$432.getTableDataItem(i2, 1))) continue;
            return true;
        }
        return false;
    }

    public static Hashtable getAllAttributes(ObjectID objectID, UserConfigFile userConfigFile) {
        if (objectID == null) {
            return new Hashtable();
        }
        String string = objectID.toString();
        Hashtable hashtable = new Hashtable();
        ObjectID objectID2 = new ObjectID("");
        try {
            for (int i2 = 0; i2 < objectID.size(); ++i2) {
                hashtable.putAll(AttributesPanel.getAttributes(objectID2.toString(), userConfigFile));
                objectID2.append(objectID.getSubIDAsLong(i2));
            }
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            // empty catch block
        }
        hashtable.putAll(AttributesPanel.getAttributes(string, userConfigFile));
        return hashtable;
    }

    public static boolean hasAttributes(String string, UserConfigFile userConfigFile) {
        Vector vector = userConfigFile.getArray("agenpro.attributes.key." + string + ".");
        return vector.size() > 0;
    }

    public static boolean isSkipped(String string, UserConfigFile userConfigFile, MIBRepository mIBRepository) {
        ObjectID objectID = new ObjectID(string);
        if ((objectID = mIBRepository.resolveOID(objectID)) == null || !objectID.isValid()) {
            return false;
        }
        Hashtable hashtable = AttributesPanel.getAllAttributes(objectID, userConfigFile);
        String string2 = (String)hashtable.get("skip");
        return "TRUE".equalsIgnoreCase(string2) || "YES".equalsIgnoreCase(string2);
    }

    public static Hashtable getAttributes(String string, UserConfigFile userConfigFile) {
        Vector vector = userConfigFile.getArray("agenpro.attributes.key." + string + ".");
        Vector vector2 = userConfigFile.getArray("agenpro.attributes.value." + string + ".");
        int n2 = Math.min(vector.size(), vector2.size());
        Hashtable hashtable = new Hashtable();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = (String)vector.get(i2);
            Object e2 = vector2.get(i2);
            if (e2 == null) continue;
            hashtable.put(string2, e2);
        }
        return hashtable;
    }

    public static void putAttribute(String string, String string2, String string3, UserConfigFile userConfigFile) {
        Vector vector = userConfigFile.getArray("agenpro.attributes.key." + string + ".");
        Vector vector2 = userConfigFile.getArray("agenpro.attributes.value." + string + ".");
        int n2 = Math.min(vector.size(), vector2.size());
        while (vector.size() > n2) {
            vector.remove(vector.size() - 1);
        }
        while (vector2.size() > n2) {
            vector2.remove(vector2.size() - 1);
        }
        int n3 = vector.indexOf(string2);
        if (n3 >= 0) {
            vector2.set(n3, string3);
        } else {
            vector.add(string2);
            vector2.add(string3);
        }
        userConfigFile.putArray("agenpro.attributes.key." + string + ".", vector);
        userConfigFile.putArray("agenpro.attributes.value." + string + ".", vector2);
    }

    private void _$20311(ObjectID objectID, boolean bl) {
        String string = objectID.toString();
        Vector vector = this._$436.getArray("agenpro.attributes.key." + string + ".");
        Vector vector2 = this._$436.getArray("agenpro.attributes.value." + string + ".");
        int n2 = Math.min(vector.size(), vector2.size());
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = (String)vector.get(i2);
            if (this._$20313(string2)) continue;
            Vector<Object> vector3 = new Vector<Object>(4);
            vector3.add(objectID);
            vector3.add(vector.elementAt(i2));
            vector3.add(vector2.elementAt(i2));
            vector3.add(this._$436.get("agenpro.attributes.descr." + vector.get(i2).toString(), null));
            if (bl) {
                this._$432.addRow(0, null, vector3);
                this._$399.setCellStyle(0, -997, this._$18668);
                continue;
            }
            this._$432.addRow(Integer.MAX_VALUE, null, vector3);
        }
        if (n2 == 0) {
            this._$399.clearSelection();
        }
    }

    private void _$20312(ObjectID objectID) {
        while (objectID.size() > 0) {
            objectID = ObjectID.trim(objectID);
            this._$20311(objectID, true);
        }
    }

    private int _$20316() {
        for (int i2 = 0; i2 < this._$432.getNumRows(); ++i2) {
            if (!this._$432.getTableDataItem(i2, 0).equals(this._$16590)) continue;
            return i2;
        }
        return this._$432.getNumRows();
    }

    public void update() {
        this._$432.deleteRows(0, this._$432.getNumRows());
        if (this._$16590 == null) {
            this._$13934 = false;
        } else {
            this.setCurrentOID(this._$16590);
        }
    }

    public void saveColSizes() {
        for (int i2 = 0; i2 < COLUMNS.length; ++i2) {
            this._$436.putInteger("agenpro.properties.column.size." + i2, this._$399.getPixelWidth(i2));
        }
    }

    public void saveAttributes() {
        if (!this._$13934 || this._$16590 == null) {
            return;
        }
        String string = this._$16590.toString();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        for (int i2 = 0; i2 < this._$432.getNumRows(); ++i2) {
            if (!this._$432.getTableDataItem(i2, 0).equals(this._$16590)) continue;
            String string2 = (String)this._$432.getTableDataItem(i2, 1);
            String string3 = (String)this._$432.getTableDataItem(i2, 2);
            if (string3 == null) {
                string3 = "";
            }
            if (string2 == null || string2.trim().length() <= 0) continue;
            vector.add(string2);
            vector2.add(string3);
            if (this._$432.getTableDataItem(i2, 3) == null) continue;
            this._$436.put("agenpro.attributes.descr." + string2, (String)this._$432.getTableDataItem(i2, 3));
        }
        this._$436.putArray("agenpro.attributes.key." + string + ".", vector);
        this._$436.putArray("agenpro.attributes.value." + string + ".", vector2);
    }

    public void changedMIBObject(MIBObjectEvent mIBObjectEvent) {
        if (mIBObjectEvent.getType() == 0) {
            if (this._$16590 != null) {
                this.saveAttributes();
            }
            if (mIBObjectEvent.getObject() == null) {
                this._$432.deleteRows(0, this._$432.getNumRows());
                this._$16590 = null;
                this._$13934 = false;
            } else {
                this.setCurrentOID(mIBObjectEvent.getObject().getOid());
            }
            this.updateButtons();
        }
    }

    public void setCurrentOID(ObjectID objectID) {
        this._$16590 = objectID;
        this.loadAttributes(objectID);
    }

    public ObjectID getCurrentOID() {
        return this._$16590;
    }

    public boolean addAttribute(String string, String string2, String string3) {
        if (string == null) {
            return false;
        }
        for (int i2 = this._$20316(); i2 < this._$432.getNumRows(); ++i2) {
            if (!string.equals(this._$432.getTableDataItem(i2, 1))) continue;
            return false;
        }
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(this._$16590);
        vector.add(string);
        vector.add(string2);
        vector.add(string3);
        this._$432.addRow(Integer.MAX_VALUE, null, vector);
        return true;
    }

    void jButtonAdd_actionPerformed(ActionEvent actionEvent) {
        this.addAttribute("<name>", "<value>", null);
        this._$399.traverse(this._$432.getNumRows() - 1, 1, true, true);
        this.updateButtons();
    }

    void jButtonRemove_actionPerformed(ActionEvent actionEvent) {
        TableUtils.removeSelectedRows(this._$399, this._$432);
        this.updateButtons();
    }

    public void afterEditCell(JCEditCellEvent jCEditCellEvent) {
    }

    public void beforeEditCell(JCEditCellEvent jCEditCellEvent) {
    }

    public void editCell(JCEditCellEvent jCEditCellEvent) {
        ((JTextField)jCEditCellEvent.getEditingComponent()).selectAll();
    }

    public void afterSelect(JCSelectEvent jCSelectEvent) {
        this.updateButtons();
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
        int n2 = Math.min(jCSelectEvent.getStartRow(), jCSelectEvent.getEndRow());
        if (n2 < this._$20316()) {
            jCSelectEvent.setCancelled(true);
        }
    }

    public void select(JCSelectEvent jCSelectEvent) {
        int n2;
        if (jCSelectEvent.getAction() == 2 && (n2 = Math.min(jCSelectEvent.getStartRow(), jCSelectEvent.getEndRow())) < this._$20316()) {
            jCSelectEvent.setCancelled(true);
        }
        this.updateButtons();
    }

    public void updateButtons() {
        if (this._$16590 == null) {
            this._$20302.setEnabled(false);
            this._$12231.setEnabled(false);
            this.jButtonRemoveAll.setEnabled(false);
            this._$16171.setEnabled(false);
            this._$16170.setEnabled(false);
        } else {
            this._$20302.setEnabled(true);
            this._$16171.setEnabled(true);
            this._$12231.setEnabled(TableUtils.getFirstSelectedRow(this._$399) >= 0);
            this.jButtonRemoveAll.setEnabled(this._$432.getNumRows() > 0);
            this._$16170.setEnabled(this._$432.getNumRows() > 0);
        }
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        if (jCCellDisplayEvent.getCellData() instanceof ObjectID) {
            ObjectID objectID = (ObjectID)jCCellDisplayEvent.getCellData();
            String string = this._$438.getObjectName(objectID);
            if (string == null) {
                string = this._$438.getPathSuffix(objectID);
            }
            if (string != null) {
                jCCellDisplayEvent.setDisplayData(string);
            }
        }
    }

    public void importAttributes(String string) {
        UserConfigFile userConfigFile = new UserConfigFile();
        userConfigFile.setConfigFile(string);
        userConfigFile.read();
        Enumeration<?> enumeration = userConfigFile.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.startsWith("agenpro.")) continue;
            String string3 = userConfigFile.properties.getProperty(string2);
            String string4 = userConfigFile.properties.getProperty("agenpro.attributes.descr." + string2);
            this.addAttribute(string2, string3, string4);
        }
    }

    public void exportAttributes(String string) {
        UserConfigFile userConfigFile = new UserConfigFile();
        userConfigFile.setConfigFile(string);
        for (int i2 = 0; i2 < this._$432.getNumRows(); ++i2) {
            String string2 = (String)this._$432.getTableDataItem(i2, 1);
            String string3 = (String)this._$432.getTableDataItem(i2, 2);
            userConfigFile.properties.setProperty(string2, string3);
            if (this._$432.getTableDataItem(i2, 3) == null) continue;
            userConfigFile.properties.setProperty("agenpro.attributes.descr." + string2, (String)this._$432.getTableDataItem(i2, 3));
        }
        userConfigFile.write();
    }

    void jButtonImport_actionPerformed(ActionEvent actionEvent) {
        if (this._$16590 == null) {
            JOptionPane.showMessageDialog(this, "Please select a MIB node where to import the properties first!", "MIB Node Not Selected", 0);
            return;
        }
        JFileChooser jFileChooser = new JFileChooser(this._$436.get("agenpro.PropertiesDirectory", ""));
        jFileChooser.setFileSelectionMode(0);
        if (jFileChooser.showOpenDialog(this) == 0) {
            this._$436.put("agenpro.PropertiesDirectory", jFileChooser.getSelectedFile().getParent());
            this.importAttributes(jFileChooser.getSelectedFile().getPath());
        }
    }

    void jButtonExport_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this._$436.get("agenpro.PropertiesDirectory", ""));
        jFileChooser.setFileSelectionMode(0);
        if (jFileChooser.showSaveDialog(this) == 0) {
            this._$436.put("agenpro.PropertiesDirectory", jFileChooser.getSelectedFile().getParent());
            this.exportAttributes(jFileChooser.getSelectedFile().getPath());
        }
    }

    void jButtonRemoveAll_actionPerformed(ActionEvent actionEvent) {
        int n2 = this._$20316();
        while (this._$432.getNumRows() > n2) {
            this._$432.deleteRows(n2, 1);
        }
    }

    public void setInitialized(boolean bl) {
        this._$13934 = bl;
    }

    public boolean isInitialized() {
        return this._$13934;
    }

    void jButtonFromSource_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this._$436.get("agenpro.InputDir", ""));
        jFileChooser.setFileSelectionMode(0);
        if (jFileChooser.showOpenDialog(this) == 0) {
            try {
                int n2 = 0;
                FileInputStream fileInputStream = new FileInputStream(jFileChooser.getSelectedFile());
                UserCodeParser userCodeParser = new UserCodeParser();
                Map<String, String> map = userCodeParser.extractUserCode(fileInputStream);
                for (String string : map.keySet()) {
                    int n3 = string.indexOf("::");
                    if (n3 <= 0) continue;
                    String string2 = string.substring(0, n3);
                    String string3 = string.substring(n3 + 2);
                    ObjectID objectID = this._$438.getObjectID(string2);
                    if (objectID == null) {
                        ++n2;
                        _$417.error("Object name '" + string2 + "' could not be resolved with loaded MIB modules");
                        continue;
                    }
                    Vector vector = this._$436.getArray("agenpro.attributes.key." + objectID + ".");
                    vector.add(string3);
                    Vector vector2 = this._$436.getArray("agenpro.attributes.value." + objectID + ".");
                    vector2.add("yes");
                    this._$436.putArray("agenpro.attributes.key." + objectID + ".", vector);
                    this._$436.putArray("agenpro.attributes.value." + objectID + ".", vector2);
                }
                fileInputStream.close();
                if (n2 > 0) {
                    String[] stringArray = new String[]{"" + n2 + " warnings were encountered during property extraction from", jFileChooser.getSelectedFile().getPath() + "!" + "Please see the warnings in the category 'Properties' of the log for details."};
                    JOptionPane.showMessageDialog(this, stringArray, "Property Extraction Warnings", 2);
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "File not found: " + jFileChooser.getSelectedFile().getPath(), "File Open Error", 0);
            }
        }
    }

    public static void removeAllAttributes(String string, UserConfigFile userConfigFile) {
        String string2 = "agenpro.attributes.key." + string + ".";
        Iterator<Map.Entry<Object, Object>> iterator = userConfigFile.properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string3 = (String)entry.getKey();
            if (!string3.startsWith(string2)) continue;
            iterator.remove();
        }
    }
}

