/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.AbstractSnmpUtility;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableListener;

public class TableUtils
extends AbstractSnmpUtility {
    private static final LogAdapter logger = LogFactory.getLogger(TableUtils.class);
    public static final int ROWSTATUS_ACTIVE = 1;
    public static final int ROWSTATUS_NOTINSERVICE = 2;
    public static final int ROWSTATUS_NOTREADY = 3;
    public static final int ROWSTATUS_CREATEANDGO = 4;
    public static final int ROWSTATUS_CREATEANDWAIT = 5;
    public static final int ROWSTATUS_DESTROY = 6;
    private int maxNumOfRowsPerPDU = 10;
    private int maxNumColumnsPerPDU = 10;

    public TableUtils(Session snmpSession, PDUFactory pduFactory) {
        super(snmpSession, pduFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableEvent> getTable(Target target, OID[] columnOIDs, OID lowerBoundIndex, OID upperBoundIndex) {
        if (columnOIDs == null || columnOIDs.length == 0) {
            throw new IllegalArgumentException("No column OIDs specified");
        }
        InternalTableListener listener = new InternalTableListener();
        TableRequest req = this.createTableRequest(target, columnOIDs, listener, null, lowerBoundIndex, upperBoundIndex);
        InternalTableListener internalTableListener = listener;
        synchronized (internalTableListener) {
            if (req.sendNextChunk()) {
                try {
                    while (!listener.isFinished()) {
                        listener.wait();
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return listener.getRows();
    }

    protected TableRequest createTableRequest(Target target, OID[] columnOIDs, TableListener listener, Object userObject, OID lowerBoundIndex, OID upperBoundIndex) {
        return new TableRequest(target, columnOIDs, listener, userObject, lowerBoundIndex, upperBoundIndex);
    }

    public void getTable(Target target, OID[] columnOIDs, TableListener listener, Object userObject, OID lowerBoundIndex, OID upperBoundIndex) {
        if (columnOIDs == null || columnOIDs.length == 0) {
            throw new IllegalArgumentException("No column OIDs specified");
        }
        TableRequest req = new TableRequest(target, columnOIDs, listener, userObject, lowerBoundIndex, upperBoundIndex);
        req.sendNextChunk();
    }

    public void getDenseTable(Target target, OID[] columnOIDs, TableListener listener, Object userObject, OID lowerBoundIndex, OID upperBoundIndex) {
        if (columnOIDs == null || columnOIDs.length == 0) {
            throw new IllegalArgumentException("No column OIDs specified");
        }
        TableRequest req = new TableRequest(target, columnOIDs, listener, userObject, lowerBoundIndex, upperBoundIndex);
        req.sendNextChunk();
    }

    public int getMaxNumRowsPerPDU() {
        return this.maxNumOfRowsPerPDU;
    }

    public void setMaxNumRowsPerPDU(int numberOfRowsPerChunk) {
        if (numberOfRowsPerChunk < 1) {
            throw new IllegalArgumentException("The number of rows per PDU must be > 0");
        }
        this.maxNumOfRowsPerPDU = numberOfRowsPerChunk;
    }

    public int getMaxNumColumnsPerPDU() {
        return this.maxNumColumnsPerPDU;
    }

    public void setMaxNumColumnsPerPDU(int numberOfColumnsPerChunk) {
        if (numberOfColumnsPerChunk < 1) {
            throw new IllegalArgumentException("The number of columns per PDU must be > 0");
        }
        this.maxNumColumnsPerPDU = numberOfColumnsPerChunk;
    }

    public ResponseEvent createRow(Target target, OID rowStatusColumnOID, OID rowIndex, VariableBinding[] values) {
        PDU pdu = this.pduFactory.createPDU(target);
        OID rowStatusID = new OID(rowStatusColumnOID);
        rowStatusID.append(rowIndex);
        VariableBinding rowStatus = new VariableBinding(rowStatusID);
        if (values != null) {
            rowStatus.setVariable(new Integer32(4));
        } else {
            rowStatus.setVariable(new Integer32(5));
        }
        pdu.add(rowStatus);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                OID columnOID = new OID(values[i].getOid());
                columnOID.append(rowIndex);
                values[i].setOid(columnOID);
            }
            pdu.addAll(values);
        }
        pdu.setType(-93);
        try {
            ResponseEvent responseEvent = this.session.send(pdu, target);
            return responseEvent;
        }
        catch (IOException ex) {
            logger.error(ex);
            return null;
        }
    }

    public ResponseEvent destroyRow(Target target, OID rowStatusColumnOID, OID rowIndex) {
        PDU pdu = this.pduFactory.createPDU(target);
        OID rowStatusID = new OID(rowStatusColumnOID);
        rowStatusID.append(rowIndex);
        VariableBinding rowStatus = new VariableBinding(rowStatusID);
        rowStatus.setVariable(new Integer32(6));
        pdu.add(rowStatus);
        pdu.setType(-93);
        try {
            ResponseEvent responseEvent = this.session.send(pdu, target);
            return responseEvent;
        }
        catch (IOException ex) {
            logger.error(ex);
            return null;
        }
    }

    class InternalTableListener
    implements TableListener {
        private List<TableEvent> rows = new LinkedList<TableEvent>();
        private volatile boolean finished = false;

        InternalTableListener() {
        }

        @Override
        public boolean next(TableEvent event) {
            this.rows.add(event);
            return true;
        }

        @Override
        public synchronized void finished(TableEvent event) {
            if (event.getStatus() != 0 || event.getIndex() != null) {
                this.rows.add(event);
            }
            this.finished = true;
            this.notify();
        }

        public List<TableEvent> getRows() {
            return this.rows;
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }
    }

    class Row
    extends Vector {
        private static final long serialVersionUID = -2297277440117636627L;
        private OID index;

        public Row(OID index) {
            this.index = index;
        }

        public OID getRowIndex() {
            return this.index;
        }

        public int getNumComplete() {
            return super.size();
        }

        public boolean setNumComplete(int numberOfColumnsComplete) {
            int sz = numberOfColumnsComplete - this.getNumComplete();
            for (int i = 0; i < sz; ++i) {
                super.add(null);
            }
            return sz >= 0;
        }
    }

    class DenseTableRequest
    extends TableRequest {
        protected DenseTableRequest(Target target, OID[] columnOIDs, TableListener listener, Object userObject, OID lowerBoundIndex, OID upperBoundIndex) {
            super(target, columnOIDs, listener, userObject, lowerBoundIndex, upperBoundIndex);
        }

        @Override
        public synchronized void onResponse(ResponseEvent event) {
            TableUtils.this.session.cancel(event.getRequest(), this);
            if (this.finished) {
                return;
            }
            if (this.checkResponse(event)) {
                int startCol = (Integer)event.getUserObject();
                PDU request = event.getRequest();
                PDU response = event.getResponse();
                int cols = request.size();
                int rows = response.size() / cols;
                OID lastMinIndex = null;
                for (int r = 0; r < rows; ++r) {
                    Row row = null;
                    for (int c = 0; c < request.size(); ++c) {
                        OID col;
                        OID id;
                        int pos = startCol + c;
                        VariableBinding vb = response.get(r * cols + c);
                        if (vb.isException() || !(id = vb.getOid()).startsWith(col = this.columnOIDs[pos])) continue;
                        OID index = new OID(id.getValue(), col.size(), id.size() - col.size());
                        if (this.upperBoundIndex != null && index.compareTo(this.upperBoundIndex) > 0) continue;
                        if (lastMinIndex == null || index.compareTo(lastMinIndex) < 0) {
                            lastMinIndex = index;
                        }
                        if (row == null) {
                            row = new Row(index);
                        }
                        row.setNumComplete(pos);
                        if (pos < row.getNumComplete()) {
                            row.set(pos, vb);
                        } else {
                            row.add(vb);
                        }
                        this.lastReceived.set(pos, vb.getOid());
                    }
                    if (row == null || this.listener.next(new TableEvent(this, this.userObject, row.getRowIndex(), row.toArray(new VariableBinding[0])))) continue;
                    this.finished = true;
                    this.listener.finished(new TableEvent(this, this.userObject));
                    return;
                }
                if (!this.sendNextChunk()) {
                    this.finished = true;
                    this.listener.finished(new TableEvent(this, this.userObject));
                }
            }
        }
    }

    public class TableRequest
    implements ResponseListener {
        Target target;
        OID[] columnOIDs;
        TableListener listener;
        Object userObject;
        OID lowerBoundIndex;
        OID upperBoundIndex;
        private int sent = 0;
        private boolean anyMatch = false;
        private Vector<OID> lastSent = null;
        private LinkedList<Row> rowCache = new LinkedList();
        protected Vector<OID> lastReceived;
        volatile boolean finished = false;

        public TableRequest(Target target, OID[] columnOIDs, TableListener listener, Object userObject, OID lowerBoundIndex, OID upperBoundIndex) {
            this.target = target;
            this.columnOIDs = columnOIDs;
            this.listener = listener;
            this.userObject = userObject;
            this.lastReceived = new Vector<OID>(Arrays.asList(columnOIDs));
            this.upperBoundIndex = upperBoundIndex;
            this.lowerBoundIndex = lowerBoundIndex;
            if (lowerBoundIndex != null) {
                for (int i = 0; i < this.lastReceived.size(); ++i) {
                    OID oid = new OID(this.lastReceived.get(i));
                    oid.append(lowerBoundIndex);
                    this.lastReceived.set(i, oid);
                }
            }
        }

        public boolean sendNextChunk() {
            if (this.sent >= this.lastReceived.size()) {
                return false;
            }
            PDU pdu = TableUtils.this.pduFactory.createPDU(this.target);
            if (this.target.getVersion() == 0) {
                pdu.setType(-95);
            } else if (pdu.getType() != -95) {
                pdu.setType(-91);
            }
            int sz = Math.min(this.lastReceived.size() - this.sent, TableUtils.this.maxNumColumnsPerPDU);
            if (pdu.getType() == -91) {
                if (TableUtils.this.maxNumOfRowsPerPDU > 0) {
                    pdu.setMaxRepetitions(TableUtils.this.maxNumOfRowsPerPDU);
                    pdu.setNonRepeaters(0);
                } else {
                    pdu.setNonRepeaters(sz);
                    pdu.setMaxRepetitions(0);
                }
            }
            this.lastSent = new Vector(sz + 1);
            for (int i = this.sent; i < this.sent + sz; ++i) {
                OID col = this.lastReceived.get(i);
                VariableBinding vb = new VariableBinding(col);
                pdu.add(vb);
                if (pdu.getBERLength() > this.target.getMaxSizeRequestPDU()) {
                    pdu.trim();
                    break;
                }
                this.lastSent.add(this.lastReceived.get(i));
            }
            try {
                Integer startCol = new Integer(this.sent);
                this.sent += pdu.size();
                this.sendRequest(pdu, this.target, startCol);
            }
            catch (Exception ex) {
                logger.error(ex);
                if (logger.isDebugEnabled()) {
                    ex.printStackTrace();
                }
                this.listener.finished(new TableEvent(this, this.userObject, ex));
                return false;
            }
            return true;
        }

        protected void sendRequest(PDU pdu, Target target, Integer startCol) throws IOException {
            TableUtils.this.session.send(pdu, target, startCol, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResponse(ResponseEvent event) {
            TableUtils.this.session.cancel(event.getRequest(), this);
            if (this.finished) {
                return;
            }
            TableRequest tableRequest = this;
            synchronized (tableRequest) {
                if (this.checkResponse(event)) {
                    boolean anyMatchInChunk = false;
                    int startCol = (Integer)event.getUserObject();
                    PDU request = event.getRequest();
                    PDU response = event.getResponse();
                    int cols = request.size();
                    int rows = response.size() / cols;
                    OID lastMinIndex = null;
                    for (int r = 0; r < rows; ++r) {
                        Row row = null;
                        anyMatchInChunk = false;
                        for (int c = 0; c < request.size(); ++c) {
                            Row lastRow;
                            ListIterator<Row> it;
                            OID col;
                            OID id;
                            int pos = startCol + c;
                            VariableBinding vb = response.get(r * cols + c);
                            if (vb.isException() || !(id = vb.getOid()).startsWith(col = this.columnOIDs[pos])) continue;
                            OID index = new OID(id.getValue(), col.size(), id.size() - col.size());
                            if (this.upperBoundIndex != null && index.compareTo(this.upperBoundIndex) > 0) continue;
                            if (lastMinIndex == null || index.compareTo(lastMinIndex) < 0) {
                                lastMinIndex = index;
                            }
                            anyMatchInChunk = true;
                            if (row == null || !row.getRowIndex().equals(index)) {
                                row = null;
                                it = this.rowCache.listIterator(this.rowCache.size());
                                while (it.hasPrevious()) {
                                    lastRow = it.previous();
                                    int compareResult = index.compareTo(lastRow.getRowIndex());
                                    if (compareResult == 0) {
                                        row = lastRow;
                                        break;
                                    }
                                    if (compareResult <= 0) continue;
                                    break;
                                }
                            }
                            if (row == null) {
                                row = new Row(index);
                                if (this.rowCache.size() == 0) {
                                    this.rowCache.add(row);
                                } else if (this.rowCache.getFirst().getRowIndex().compareTo(index) >= 0) {
                                    this.rowCache.addFirst(row);
                                } else {
                                    it = this.rowCache.listIterator(this.rowCache.size());
                                    while (it.hasPrevious()) {
                                        lastRow = it.previous();
                                        if (index.compareTo(lastRow.index) < 0) continue;
                                        it.set(row);
                                        it.add(lastRow);
                                        break;
                                    }
                                }
                            }
                            if (!(row.setNumComplete(pos) && row.size() <= pos || row.get(pos) == null)) {
                                this.finished = true;
                                this.listener.finished(new TableEvent(this, this.userObject, -2));
                                return;
                            }
                            row.setNumComplete(pos);
                            if (pos < row.getNumComplete()) {
                                row.set(pos, vb);
                            } else {
                                row.add(vb);
                            }
                            this.lastReceived.set(pos, vb.getOid());
                        }
                    }
                    this.anyMatch |= anyMatchInChunk;
                    while (this.rowCache.size() > 0 && this.rowCache.getFirst().getNumComplete() == this.columnOIDs.length && (lastMinIndex == null || this.rowCache.getFirst().getRowIndex().compareTo(lastMinIndex) < 0)) {
                        if (this.listener.next(this.getTableEvent())) continue;
                        this.finished = true;
                        this.listener.finished(new TableEvent(this, this.userObject));
                        return;
                    }
                    if (!this.sendNextChunk()) {
                        if (this.anyMatch) {
                            this.sent = 0;
                            this.anyMatch = false;
                            this.sendNextChunk();
                        } else {
                            this.emptyCache();
                            this.finished = true;
                            this.listener.finished(new TableEvent(this, this.userObject));
                        }
                    }
                }
            }
        }

        protected boolean checkResponse(ResponseEvent event) {
            if (event.getError() != null) {
                this.finished = true;
                this.emptyCache();
                this.listener.finished(new TableEvent(this, this.userObject, event.getError()));
            } else if (event.getResponse() == null) {
                this.finished = true;
                this.emptyCache();
                this.listener.finished(new TableEvent(this, this.userObject, -1));
            } else if (event.getResponse().getType() == -88) {
                this.finished = true;
                this.emptyCache();
                this.listener.finished(new TableEvent(this, this.userObject, event.getResponse()));
            } else if (event.getResponse().getErrorStatus() != 0) {
                this.finished = true;
                this.emptyCache();
                this.listener.finished(new TableEvent(this, this.userObject, event.getResponse().getErrorStatus()));
            } else {
                return true;
            }
            return false;
        }

        private void emptyCache() {
            while (this.rowCache.size() > 0 && this.listener.next(this.getTableEvent())) {
            }
        }

        private TableEvent getTableEvent() {
            Row r = this.rowCache.removeFirst();
            r.setNumComplete(this.columnOIDs.length);
            Object[] vbs = new VariableBinding[r.size()];
            r.copyInto(vbs);
            return new TableEvent(this, this.userObject, r.getRowIndex(), (VariableBinding[])vbs);
        }

        public Row getRow(OID index) {
            ListIterator<Row> it = this.rowCache.listIterator(this.rowCache.size() + 1);
            while (it.hasPrevious()) {
                Row r = it.previous();
                if (!index.equals(r.getRowIndex())) continue;
                return r;
            }
            return null;
        }
    }
}

