/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.text.ParseException;
import java.util.StringTokenizer;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.util.OIDTextFormat;

public class SimpleOIDTextFormat
implements OIDTextFormat {
    @Override
    public String format(int[] value) {
        StringBuffer buf = new StringBuffer(10 * value.length);
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                buf.append('.');
            }
            buf.append((long)value[i] & 0xFFFFFFFFL);
        }
        return buf.toString();
    }

    @Override
    public int[] parse(String text) throws ParseException {
        StringTokenizer st = new StringTokenizer(text, ".", true);
        int size = st.countTokens();
        int[] value = new int[size];
        size = 0;
        StringBuffer buf = null;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (buf == null && t.startsWith("'")) {
                buf = new StringBuffer();
                t = t.substring(1);
            }
            if (buf != null && t.endsWith("'")) {
                buf.append(t.substring(0, t.length() - 1));
                OID o = new OctetString(buf.toString()).toSubIndex(true);
                int[] h = value;
                value = new int[st.countTokens() + h.length + o.size()];
                System.arraycopy(h, 0, value, 0, size);
                System.arraycopy(o.getValue(), 0, value, size, o.size());
                size += o.size();
                buf = null;
                continue;
            }
            if (buf != null) {
                buf.append(t);
                continue;
            }
            if (".".equals(t)) continue;
            value[size++] = (int)Long.parseLong(t.trim());
        }
        if (size < value.length) {
            int[] h = value;
            value = new int[size];
            System.arraycopy(h, 0, value, 0, size);
        }
        return value;
    }
}

