/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogLevel;

public class ConsoleLogAdapter
implements LogAdapter {
    private static boolean debugEnabled = false;
    private static boolean infoEnabled = true;
    private static boolean warnEnabled = true;

    @Override
    public void debug(Serializable message) {
        if (debugEnabled) {
            System.out.println(message.toString());
        }
    }

    @Override
    public void error(Serializable message) {
        System.err.println(message.toString());
    }

    @Override
    public void error(CharSequence message, Throwable throwable) {
        System.err.println(((Object)message).toString());
    }

    @Override
    public void fatal(Object message) {
        System.err.println(message.toString());
    }

    @Override
    public void fatal(CharSequence message, Throwable throwable) {
        System.err.println(((Object)message).toString());
    }

    @Override
    public void info(CharSequence message) {
        if (infoEnabled) {
            System.out.println(((Object)message).toString());
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return debugEnabled;
    }

    @Override
    public boolean isInfoEnabled() {
        return infoEnabled;
    }

    @Override
    public boolean isWarnEnabled() {
        return warnEnabled;
    }

    @Override
    public void warn(Serializable message) {
        if (warnEnabled) {
            System.out.println(message.toString());
        }
    }

    public static void setDebugEnabled(boolean isDebugEnabled) {
        debugEnabled = isDebugEnabled;
    }

    public static void setWarnEnabled(boolean isWarnEnabled) {
        warnEnabled = isWarnEnabled;
    }

    public static void setInfoEnabled(boolean isInfoEnabled) {
        infoEnabled = isInfoEnabled;
    }

    @Override
    public void setLogLevel(LogLevel level) {
        debugEnabled = false;
        warnEnabled = false;
        infoEnabled = false;
        switch (level.getLevel()) {
            case 2: {
                debugEnabled = true;
                warnEnabled = true;
                infoEnabled = true;
                break;
            }
            case 3: 
            case 4: {
                debugEnabled = true;
                break;
            }
            case 5: {
                infoEnabled = true;
                break;
            }
            case 6: {
                warnEnabled = true;
                break;
            }
        }
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public LogLevel getLogLevel() {
        if (debugEnabled) {
            return LogLevel.DEBUG;
        }
        if (infoEnabled) {
            return LogLevel.INFO;
        }
        if (warnEnabled) {
            return LogLevel.WARN;
        }
        return LogLevel.OFF;
    }

    @Override
    public LogLevel getEffectiveLogLevel() {
        return this.getLogLevel();
    }

    @Override
    public Iterator getLogHandler() {
        return Collections.EMPTY_LIST.iterator();
    }
}

