/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.smi.OID;

public class MOTableRelation {
    private MOTable baseTable;
    private MOTable dependentTable;

    public MOTableRelation(MOTable baseTable, MOTable dependentTable) {
        this.baseTable = baseTable;
        this.dependentTable = dependentTable;
    }

    public void createRelationShip() {
        this.baseTable.addMOTableRowListener(this.createRelationShipListener());
    }

    protected MOTableRowListener createRelationShipListener() {
        return new RelationShipListener();
    }

    public boolean hasDependentRow(MOTableRow baseTableRow) {
        return true;
    }

    public OID[] getDependentIndexes(MOTableRow baseRow) {
        return new OID[]{baseRow.getIndex()};
    }

    protected void addDependentRows(MOTableRow baseTableRow) {
        OID[] indexes;
        for (OID index : indexes = this.getDependentIndexes(baseTableRow)) {
            Object depRow = this.dependentTable.createRow(index, this.dependentTable.getDefaultValues());
            depRow.setBaseRow(baseTableRow);
            this.dependentTable.addRow(depRow);
        }
    }

    protected MOTableRow[] removeDependentRows(MOTableRow baseTableRow) {
        OID[] indexes = this.getDependentIndexes(baseTableRow);
        MOTableRow[] removedRows = new MOTableRow[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            removedRows[i] = this.dependentTable.removeRow(indexes[i]);
        }
        return removedRows;
    }

    protected class RelationShipListener
    implements MOTableRowListener {
        protected RelationShipListener() {
        }

        @Override
        public void rowChanged(MOTableRowEvent event) {
            switch (event.getType()) {
                case 2: {
                    if (!MOTableRelation.this.hasDependentRow(event.getRow())) break;
                    MOTableRelation.this.addDependentRows(event.getRow());
                    break;
                }
                case 3: {
                    MOTableRelation.this.removeDependentRows(event.getRow());
                }
            }
        }
    }
}

